#---------------------------------------------------------------------
# Function: AskQuestions Debian 12
#	Ask for all needed user input
#---------------------------------------------------------------------
AskQuestions() {
    CFG_SETUP_WEB=true  #Needed for Multiserver setup compatibility
    CFG_SETUP_MAIL=true #Needed for Multiserver setup compatibility
    CFG_SETUP_NS=true   #Needed for Multiserver setup compatibility

    # Common window dimensions
    WT_HEIGHT=20
    WT_WIDTH=60
    WT_LIST_HEIGHT=10
    
    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Gathering informations about softwares and versions:${NC} "
    echo

    if [[ ! "$CFG_SSL_NEW" =~ $RE ]]; then
	if (whiptail --title "SSL" --backtitle "$WT_BACKTITLE" --yesno --defaultno "Generate new ssl or used last gerated ssl?" $WT_HEIGHT $WT_WIDTH) then
	    CFG_SSL_NEW=yes
	else
	    CFG_SSL_NEW=no
	fi
    fi

    while [[ ! "$CFG_SQLSERVER" =~ $RE ]]; do
        CFG_SQLSERVER=$(whiptail --title "SQL Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select SQL Server type" $WT_HEIGHT $WT_WIDTH 2 "MariaDB" "(default)" ON "MySQL" "" OFF 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve $CFG_SQLSERVER root password${NC}: "
    CFG_MYSQL_ROOT_PWD=$(whiptail --title "$CFG_SQLSERVER" --backtitle "$WT_BACKTITLE" --inputbox "Please specify a $CFG_SQLSERVER Root Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

    if [[ -z $CFG_MYSQL_ROOT_PWD ]]; then
        CFG_MYSQL_ROOT_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
    fi

    while [[ ! "$CFG_WEBSERVER" =~ $RE ]]; do
        CFG_WEBSERVER=$(whiptail --title "Web server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select Web server type" $WT_HEIGHT $WT_WIDTH 2 "Nginx" "(default)" ON "Apache" "" OFF 3>&1 1>&2 2>&3)
    done
    CFG_WEBSERVER=${CFG_WEBSERVER,,}

    while [ "x$CFG_FTP" == "x" ]; do
        CFG_FTP=$(whiptail --title "FTP Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Install and configure FTP SERVER?" $WT_HEIGHT $WT_WIDTH 4 "onlyTLS" "Yes, only with TLS" ON "onlyFTP" "Yes, only with FTP" OFF "FTPandTLS" "Yes, with FTP and TLS" OFF "none" "No, don't install it" OFF 3>&1 1>&2 2>&3)
    done

    CFG_FTP_KEY_SIZE=$(whiptail --title "Key Size" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select RSA key size for TLS?" $WT_HEIGHT $WT_WIDTH 4 "2048" "2048-bit key size" ON "4096" "4096-bit key size" OFF 3>&1 1>&2 2>&3)

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install and Configure FTP Server${NC}: ${green}$CFG_FTP${NC} "
    echo

    while [[ ! "$CFG_MTA" =~ $RE ]]; do
        CFG_MTA=$(whiptail --title "Mail Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select mailserver type" $WT_HEIGHT $WT_WIDTH 3 "Dovecot" "(default)" ON "Courier" "" OFF "None" "" OFF 3>&1 1>&2 2>&3)
    done

    CFG_MTA=${CFG_MTA,,}
    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Mail Server${NC}: ${green}$CFG_MTA${NC} "
    echo

    if [ $CFG_MTA == "none" ]; then
        CFG_WEBMAIL="none"
        CFG_SETUP_MAIL=false
    else
        CFG_SETUP_MAIL=true
        while [[ ! "$CFG_WEBMAIL" =~ $RE ]]; do
            CFG_WEBMAIL=$(whiptail --title "Webmail client" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select which Web Mail client you want" $WT_HEIGHT $WT_WIDTH 6 "Roundcube-latest" "latest available" ON "Roundcube" "(default)" OFF "RainLoop" "" OFF "SOGo" "" OFF "Squirrelmail" "" OFF "None" "No Web Mail Client" OFF 3>&1 1>&2 2>&3)
        done

        if [ $CFG_WEBMAIL != "none" ] || [ $CFG_WEBMAIL != "squirrelmail" ]; then
            while [[ ! "$CFG_ROUNDCUBE_DB" =~ $RE ]]; do
                CFG_ROUNDCUBE_DB=$(whiptail --title "Roundcube database name" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Roundcube database name" --nocancel $WT_HEIGHT $WT_WIDTH "wt_roundcube" 3>&1 1>&2 2>&3)
            done

            while [[ ! "$CFG_ROUNDCUBE_USR" =~ $RE ]]; do
                CFG_ROUNDCUBE_USR=$(whiptail --title "Roundcube database username" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Roundcube database username" --nocancel $WT_HEIGHT $WT_WIDTH "wt_roundcube" 3>&1 1>&2 2>&3)
            done

            echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Roundcube database password${NC}: "
            CFG_ROUNDCUBE_PWD=$(whiptail --title "Roundcube Database Password" --backtitle "$WT_BACKTITLE" --inputbox "Please specify a Roundcube Database Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

            if [[ -z $CFG_ROUNDCUBE_PWD ]]; then
                CFG_ROUNDCUBE_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
            fi

            while [[ ! "$CFG_ROUNDCUBE_SOAP_USR" =~ $RE ]]; do
                CFG_ROUNDCUBE_SOAP_USR=$(whiptail --title "Roundcube Ispconfig3 Soap Username" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Roundcube Ispconfig3 Soap Username" --nocancel $WT_HEIGHT $WT_WIDTH "roundcube_soap" 3>&1 1>&2 2>&3)
            done

            echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Roundcube Ispconfig3 Soap Password${NC}: "
            CFG_ROUNDCUBE_SOAP_PWD=$(whiptail --title "Roundcube Ispconfig3 Soap Password" --backtitle "$WT_BACKTITLE" --inputbox "Please specify a Roundcube Ispconfig3 Soap Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

            if [[ -z $CFG_ROUNDCUBE_SOAP_PWD ]]; then
                CFG_ROUNDCUBE_SOAP_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
            fi
        fi
    fi

    CFG_WEBMAIL=${CFG_WEBMAIL,,}

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}WebMail client${NC}: ${green}$CFG_WEBMAIL${NC} "
    echo

    if [[ ! "$CFG_MAILMAN" =~ $RE ]]; then
        if (whiptail --title "Mailman" --backtitle "$WT_BACKTITLE" --yesno --defaultno "Would you like to install Mailman?" $WT_HEIGHT $WT_WIDTH); then
            CFG_MAILMAN=yes

            echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Mailman site password${NC}: "
            MMSITEPASS=$(whiptail --title "Mailman Site Password" --backtitle "$WT_BACKTITLE" --inputbox "Please specify a Mailman Site Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

            if [[ -z $MMSITEPASS ]]; then
                MMSITEPASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
            fi

            while [[ ! "$MMLISTOWNER" =~ $RE ]]; do
                MMLISTOWNER=$(whiptail --title "Mailman Site List Owner" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Mailman site list owner" --nocancel $WT_HEIGHT $WT_WIDTH "$USER" 3>&1 1>&2 2>&3)
            done

            while [[ ! "$MMADMINEMAIL" =~ $RE ]]; do
                MMADMINEMAIL=$(whiptail --title "Mailman Admin e-mail" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Mailman site list owner" --nocancel $WT_HEIGHT $WT_WIDTH "mailman@$CFG_HOSTNAME_DOMAIN" 3>&1 1>&2 2>&3)
            done

            echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Mailman site list password${NC}: "
            MMLISTPASS=$(whiptail --title "Mailman Site List Password" --backtitle "$WT_BACKTITLE" --inputbox "Please specify a Mailman Site List Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

            if [[ -z $MMLISTPASS ]]; then
                MMLISTPASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
            fi
        else
            CFG_MAILMAN=no
        fi
    fi

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Mailman${NC}: ${green}$CFG_MAILMAN${NC} "
    echo

    if (whiptail --title "Update Freshclam DB" --backtitle "$WT_BACKTITLE" --yesno "You want to update Antivirus Database during install?" $WT_HEIGHT $WT_WIDTH); then
        CFG_AVUPDATE="yes"
    else
        CFG_AVUPDATE="no"
    fi

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Update Antivirus Database${NC}: ${green}$CFG_AVUPDATE${NC} "
    echo

    while [[ ! "$CFG_ANTISPAM" =~ $RE ]]; do
        CFG_ANTISPAM=$(whiptail --title "Spam detection" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select the spam detection software" $WT_HEIGHT $WT_WIDTH 2 "rspamd" "(default)" ON "amavisd" "(Amavisd+SpamAssassin)" OFF 3>&1 1>&2 2>&3)
    done

    while [ "x$CFG_PHP_VERSION" == "x" ]; do
	CFG_PHP_VERSION=$(whiptail --title "Choose PHP Version(s)" --backtitle "$WT_BACKTITLE" --nocancel --separate-output --checklist \
      	    "Choose PHP Version do you want to install" $WT_HEIGHT $WT_WIDTH 13 \
      	    "php5.5" "Latest Available from 5.5" OFF \
      	    "php5.6" "Latest Available from 5.6" OFF \
      	    "php7.0" "Latest Available from 7.0" OFF \
      	    "php7.1" "Latest Available from 7.1" OFF \
      	    "php7.2" "Latest Available from 7.2" OFF \
      	    "php7.3" "Latest Available from 7.3" OFF \
      	    "php7.4" "Latest Available from 7.4" OFF \
      	    "php8.0" "Latest Available from 8.0" OFF \
      	    "php8.1" "Latest Available from 8.1" OFF \
      	    "php8.2" "Latest Available from 8.2" OFF \
      	    "php8.3" "Latest Available from 8.3" OFF \
      	    "php8.4" "Latest Available from 8.4" OFF \
      	    "none" "No install" ON 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}PHP Version(s)${NC}: ${green}" $CFG_PHP_VERSION "${NC} "
    echo

    while [ -z "$CFG_CERTBOT_VERSION" ]; do
	CFG_CERTBOT_VERSION=$(whiptail --title "Install LetsEncrypt CertBot" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select CertBot Version" $WT_HEIGHT $WT_WIDTH 3 \
	"Acme.sh" "Acme.sh" ON \
	"Certbot" "Certbot" OFF \
	"None" "No installation" OFF 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}LetsEncrypt CertBot Version${NC}: ${green}$CFG_CERTBOT_VERSION${NC} "
    echo

    if whiptail --title "Install phpMyAdmin" --backtitle "$WT_BACKTITLE" --yesno "Do you want to install phpMyAdmin?" $WT_HEIGHT $WT_WIDTH; then
	CFG_PHPMYADMIN="yes"
    else
	CFG_PHPMYADMIN="no"
    fi

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install PhpMyAdmin${NC}: ${green}$CFG_PHPMYADMIN${NC} "
    echo

    if [ $CFG_PHPMYADMIN == "yes" ]; then
        while [ "x$CFG_PHPMYADMIN_VERSION" == "x" ]; do
            CFG_PHPMYADMIN_VERSION=$(whiptail --title "phpMyAdmin Version" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "What version of phpMyAdmin do you want to install?" $WT_HEIGHT $WT_WIDTH 4 "Latest-stable" "from phpMyAdmin.net" ON "Default" "Current OS Version" OFF "Buster" "From buster backports - newer" OFF "Bullseye" "From bullseye backports - newer" OFF 3>&1 1>&2 2>&3)
        done

        echo -n -e "$IDENTATION_LVL_2 ${BBlack}Version${NC}: ${green}$CFG_PHPMYADMIN_VERSION${NC} "
        echo
    else
        CFG_PHPMYADMIN_VERSION='none'
    fi

    while [[ ! "$CFG_METRONOME" =~ $RE ]]; do
        CFG_METRONOME=$(whiptail --title "Metronome IM" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Metronome XMPP Chat server?" $WT_HEIGHT $WT_WIDTH 2 "No" "(default)" ON "Yes" "" OFF 3>&1 1>&2 2>&3)
    done

    if (whiptail --title "Quota" --backtitle "$WT_BACKTITLE" --yesno "Setup user quota?" $WT_HEIGHT $WT_WIDTH); then
        CFG_QUOTA="yes"
    else
        CFG_QUOTA="no"
    fi

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Setup Quota${NC}: ${green}$CFG_QUOTA${NC} "
    echo

    if (whiptail --title "Jailkit" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install Jailkit?" $WT_HEIGHT $WT_WIDTH); then
        CFG_JKIT="yes"
    else
        CFG_JKIT="no"
    fi

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install Jailkit${NC}: ${green}$CFG_JKIT${NC} "
    echo

    if (whiptail --title "WebStats" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install WebStats?" $WT_HEIGHT $WT_WIDTH); then
        CFG_WEBSTATS="yes"
    else
        CFG_WEBSTATS="no"
    fi

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install WebStats${NC}: ${green}$CFG_WEBSTATS${NC} "
    echo

    #if (whiptail --title "DNS (bind9)" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install DNS server (bind9)?" --defaultno 10 60); then
	#CFG_BIND=true
    #else
    	#CFG_BIND=false
    	#CFG_SETUP_NS=false
    #fi

    #echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install DNS server (bind9)${NC}: ${green}$CFG_JKIT${NC} "
    #echo

    #while [ "x$CFG_JOOMLA" == "x" ]
	#do
	#	CFG_JOOMLA=$(whiptail --title "Install CMS" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select the default CMS" 10 50 2 "joomla" "(default)" ON "drupal" "" OFF 3>&1 1>&2 2>&3)
    #done

    if whiptail --title "Install GitLab Server" --backtitle "$WT_BACKTITLE" --yesno "Do you want to install GitLab Server?" $WT_HEIGHT $WT_WIDTH; then
	CFG_GITLABINSTALL="yes"
    else
	CFG_GITLABINSTALL="no"
    fi

    if [ "$CFG_GITLABINSTALL" == "yes" ]; then
	CFG_GITLAB_VERSION=$(whiptail --title "GitLab Version" --backtitle "$WT_BACKTITLE" --menu "Choose GitLab version to install:" $WT_HEIGHT $WT_WIDTH 2 \
	    "1" "GitLab Community Edition (CE)" \
	    "2" "GitLab Enterprise Edition (EE)" \
	    3>&1 1>&2 2>&3)

    	if [ "$CFG_GITLAB_VERSION" == "1" ]; then
	   CFG_GITLAB_VERSION="ce"
	elif [ "$CFG_GITLAB_VERSION" == "2" ]; then
	   CFG_GITLAB_VERSION="ee"
	fi
    
        echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Gitlab Admin password${NC}: "
        CFG_GITLAB_ADMIN_PWD=$(whiptail --title "Gitlab" --backtitle "$WT_BACKTITLE" --inputbox "Please specify a Gitlab Admin Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

        if [[ -z $CFG_GITLAB_ADMIN_PWD ]]; then
            CFG_GITLAB_ADMIN_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
        fi
    fi

    if whiptail --title "Install Cloud Server" --backtitle "$WT_BACKTITLE" --yesno "Do you want to install a Cloud Server?" $WT_HEIGHT $WT_WIDTH; then
	CFG_CLOUDINSTALL="yes"
    else
	CFG_CLOUDINSTALL="no"
    fi

    if [ "$CFG_CLOUDINSTALL" == "yes" ]; then
        while [ "x$CFG_CLOUDTYPE" == "x" ]; do
            CFG_CLOUDTYPE=$(whiptail --title "Select Cloud Server Type" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Which cloud server would you like to install?" $WT_HEIGHT $WT_WIDTH 2 "nextcloud" "Nextcloud Server" ON "seafile" "Seafile Server" OFF 3>&1 1>&2 2>&3)
        done

        if [ "$CFG_CLOUDTYPE" == "nextcloud" ]; then
            while [ "x$CFG_CLOUDUPGRADE" == "x" ]; do
                CFG_CLOUDUPGRADE=$(whiptail --title "Install Or Upgrade Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to upgrade Owncloud to Nextcloud Server or Fresh install?" $WT_HEIGHT $WT_WIDTH 2 "no" "(Fresh install)" ON "yes" "(Upgrade)" OFF 3>&1 1>&2 2>&3)
            done
        fi		

        if [ "$CFG_CLOUDTYPE" == "seafile" ]; then
            while [ "x$CFG_SEAFILEVERSION" == "x" ]; do
                CFG_SEAFILEVERSION=$(whiptail --title "Seafile Version" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Which Seafile version would you like to install?" $WT_HEIGHT $WT_WIDTH 2 "pro" "Seafile Pro" OFF "community" "Seafile Community Edition" ON 3>&1 1>&2 2>&3)
            done
        fi		

        while [ "x$CFG_CLOUDDBTYPE" == "x" ]; do
            CFG_CLOUDDBTYPE=$(whiptail --title "$CFG_CLOUDTYPE Database Type" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select database type for $CFG_CLOUDTYPE:" $WT_HEIGHT $WT_WIDTH 2 "mysql/mariadb" "(default)" ON "sqlite" "" OFF 3>&1 1>&2 2>&3)
        done		

        while [[ ! "$CFG_CLOUDDBHOST" =~ $RE ]]; do
            CFG_CLOUDDBHOST=$(whiptail --title "$CFG_CLOUDTYPE DB host" --backtitle "$WT_BACKTITLE" --inputbox "$CFG_CLOUDTYPE database host - (default localhost) or (ext. host)" --nocancel $WT_HEIGHT $WT_WIDTH "localhost" 3>&1 1>&2 2>&3)
        done
    fi		

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install cloud server ${NC}: ${green}$CFG_CLOUDINSTALL${NC} "
    echo

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}ISPConfig Configuration: ${NC}"
    echo

    while [[ ! "$CFG_ISPC" =~ $RE ]]; do
        CFG_ISPC=$(whiptail --title "ISPConfig Setup" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Would you like full unattended setup of expert mode for ISPConfig?" $WT_HEIGHT $WT_WIDTH 2 "standard" "Yes (default)" ON "expert" "No, I want to configure" OFF 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Install Mode${NC}: ${green}" $CFG_ISPC "${NC} "
    echo

    CFG_ISPONCFIG_PORT=$(whiptail --title "ISPConfig" --backtitle "$WT_BACKTITLE" --inputbox "Please specify an ISPConfig Port (leave empty for use 8888 port)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

    if [[ -z $CFG_ISPONCFIG_PORT ]]; then
        CFG_ISPONCFIG_PORT=8888
    fi

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}ISPConfig Port${NC}: ${green}" $CFG_ISPONCFIG_PORT "${NC} "
    echo

    CFG_ISPONCFIG_APPS_PORT=$(whiptail --title "ISPConfig" --backtitle "$WT_BACKTITLE" --inputbox "Please specify an ISPConfig Apps Port (leave empty for use 8083 port)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

    if [[ -z $CFG_ISPONCFIG_APPS_PORT ]]; then
        CFG_ISPONCFIG_APPS_PORT=8083
    fi

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}ISPConfig Apps Port${NC}: ${green}" $CFG_ISPONCFIG_APPS_PORT "${NC} "
    echo

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve ISPConfig Admin password${NC}: "
    CFG_ISPONCFIG_ADMIN_PASS=$(whiptail --title "ISPConfig" --backtitle "$WT_BACKTITLE" --inputbox "Please specify an ISPConfig Admin Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

    if [[ -z $CFG_ISPONCFIG_ADMIN_PASS ]]; then
        CFG_ISPONCFIG_ADMIN_PASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
    fi

    echo -e " [${green}DONE${NC}]"
    
    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve ISPConfig DB password${NC}: "
    CFG_ISPCONFIG_DB_PASS=$(whiptail --title "ISPConfig DB Password" --backtitle "$WT_BACKTITLE" --inputbox "Please specify an ISPConfig DB Password (leave empty for autogenerate)" --nocancel $WT_HEIGHT $WT_WIDTH 3>&1 1>&2 2>&3)

    if [[ -z $CFG_ISPONCFIG_ADMIN_PASS ]]; then
        CFG_ISPCONFIG_DB_PASS_AUTO=true
        CFG_ISPCONFIG_DB_PASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9~!@#^*_=-' | head -c${1:-29})
    else
        CFG_ISPCONFIG_DB_PASS_AUTO=false
    fi

    echo -e " [${green}DONE${NC}]"

    echo -n -e "$IDENTATION_LVL_1 ${BBlack}SSL Configuration:${NC} "
    echo

    while [[ ! "$SSL_COUNTRY" =~ $RE ]]; do
        SSL_COUNTRY=$(whiptail --title "SSL Country Code" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Country Code (2 letter code - ex. HU)" --nocancel $WT_HEIGHT $WT_WIDTH "HU" 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Country${NC}: ${green}" $SSL_COUNTRY "${NC} "
    echo


    while [[ ! "$SSL_STATE" =~ $RE ]]; do
        SSL_STATE=$(whiptail --title "SSL State or Province Name" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - STATE or Province Name (full name - ex. Hungary)" --nocancel $WT_HEIGHT $WT_WIDTH "Hungary" 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}State${NC}: ${green}" $SSL_STATE "${NC} "
    echo

    while [[ ! "$SSL_LOCALITY" =~ $RE ]]; do
        SSL_LOCALITY=$(whiptail --title "SSL Locality" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Locality (ex. Bekescsaba)" --nocancel $WT_HEIGHT $WT_WIDTH "Bekescsaba" 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Locality${NC}: ${green}" $SSL_LOCALITY "${NC} "
    echo

    while [[ ! "$SSL_ORGANIZATION" =~ $RE ]]; do
        SSL_ORGANIZATION=$(whiptail --title "SSL Organization" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization (ex. Company L.t.d.)" --nocancel $WT_HEIGHT $WT_WIDTH "Wolftronics L.t.d" 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Organization${NC}: ${green}" $SSL_ORGANIZATION "${NC} "
    echo

    while [[ ! "$SSL_ORGUNIT" =~ $RE ]]; do
        SSL_ORGUNIT=$(whiptail --title "SSL Organization Unit" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization Unit (ex. IT)" --nocancel $WT_HEIGHT $WT_WIDTH "IT" 3>&1 1>&2 2>&3)
    done

    echo -n -e "$IDENTATION_LVL_2 ${BBlack}Unit${NC}: ${green}" $SSL_ORGUNIT "${NC} "
    echo
}
