#---------------------------------------------------------------------
# Function: AskQuestions Ubuntu 18.04
#	Ask for all needed user input
#---------------------------------------------------------------------
AskQuestions() {
	CFG_SETUP_WEB=yes #Needed for Multiserver setup compatibility
	CFG_SETUP_MAIL=yes #Needed for Multiserver setup compatibility
	CFG_SETUP_NS=yes #Needed for Multiserver setup compatibility
	if ! command -v whiptail >/dev/null; then
		echo -n "Installing whiptail... "
		apt_install whiptail
		echo -e "[${green}DONE${NC}]\n"
	fi

	if [[ ! "$CFG_SSL_NEW" =~ $RE ]]; then
		if (whiptail --title "Quota" --backtitle "$WT_BACKTITLE" --yesno "Generate new ssl or last gerated ssl?" 10 50) then
			CFG_SSL_NEW=yes
		else
			CFG_SSL_NEW=no
		fi
	fi
	
	while [[ ! "$CFG_SQLSERVER" =~ $RE ]]
	do
		CFG_SQLSERVER=$(whiptail --title "SQL Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select SQL Server type" 10 50 2 "MySQL" "(default)" ON "MariaDB" "" OFF 3>&1 1>&2 2>&3)
	done
		
	while [[ ! "$CFG_MYSQL_ROOT_PWD" =~ $RE ]]
	do
		CFG_MYSQL_ROOT_PWD=$(whiptail --title "$CFG_SQLSERVER" --backtitle "$WT_BACKTITLE" --passwordbox "Please specify a root password" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$CFG_WEBSERVER" =~ $RE ]]
	do
		CFG_WEBSERVER=$(whiptail --title "Web server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select Web server type" 10 50 2 "Apache" "(default)" ON "nginx" "" OFF 3>&1 1>&2 2>&3)
	done
	CFG_WEBSERVER=${CFG_WEBSERVER,,}

	while [[ ! "$CFG_XCACHE" =~ $RE ]]
	do
		CFG_XCACHE=$(whiptail --title "Install XCache" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install XCache (PHP opcode cacher)? ATTENTION: If XCache is installed, Ioncube Loaders will not work !!" 20 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	while [[ ! "$CFG_PHPMYADMIN" =~ $RE ]]
	do
		CFG_PHPMYADMIN=$(whiptail --title "Install phpMyAdmin" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install phpMyAdmin?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	while [[ ! "$CFG_MTA" =~ $RE ]]
	do
		CFG_MTA=$(whiptail --title "Mail Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select Mail server type" 10 50 2 "Dovecot" "(default)" ON "Courier" "" OFF 3>&1 1>&2 2>&3)
	done
	CFG_MTA=${CFG_MTA,,}
	
	while [[ ! "$CFG_HHVMINSTALL" =~ $RE ]]
	do
		CFG_HHVMINSTALL=$(whiptail --title "Install HHVM" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install HHVM (Hip Hop Virtual Machine) as PHP engine?" 10 50 2 "yes" "" OFF "no""(default)" ON 3>&1 1>&2 2>&3)
	done
	
	while [[ ! "$CFG_METRONOME" =~ $RE ]]
	do
		CFG_METRONOME=$(whiptail --title "Install Metronome XMPP Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Metronome XMPP Chat Server?" 10 50 2 "yes" "" OFF "no""(default)" ON 3>&1 1>&2 2>&3)
	done
	
	while [[ ! "$CFG_AVUPDATE" =~ $RE ]]
	do
		CFG_AVUPDATE=$(whiptail --title "Update Freshclam DB" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to update Antivirus Database?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done
	
	if [[ ! "$CFG_QUOTA" =~ $RE ]]; then
		if (whiptail --title "Quota" --backtitle "$WT_BACKTITLE" --yesno "Setup user quota?" 10 50) then
			CFG_QUOTA=yes
		else
			CFG_QUOTA=no
		fi
	fi

      	#while [ "x$CFG_JOOMLA" == "x" ]
	#do
	#	CFG_JOOMLA=$(whiptail --title "Install CMS" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select the default CMS" 10 50 2 "joomla" "(default)" ON "drupal" "" OFF 3>&1 1>&2 2>&3)
	#done

	while [ "x$CFG_CLOUDINSTALL" == "x" ]
	do
		CFG_CLOUDINSTALL=$(whiptail --title "Install Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Nextcloud Server?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	if [ "$CFG_CLOUDINSTALL" == "yes" ]; then
		while [ "x$CFG_CLOUDUPGRADE" == "x" ]
		do
		  CFG_CLOUDUPGRADE=$(whiptail --title "Install Or Upgrade Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to upgrade Owncloud to Nextcloud Server or Fresh install?" 10 50 2 "yes" "(Upgrade)" OFF "no" "(Fresh install)" ON 3>&1 1>&2 2>&3)
		done

		while [ "x$CFG_CLOUDDBTYPE" == "x" ]
		do
		  CFG_CLOUDDBTYPE=$(whiptail --title "Nextcloud Server mysql or sqlite" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to Nextcloud Server mysql or sqlite?" 10 50 2 "mysql" "(default)" ON "sqlite" "" OFF 3>&1 1>&2 2>&3)
		done

		while [ "x$CFG_CLOUDDBHOST" == "x" ]
	  	do
		  CFG_CLOUDDBHOST=$(whiptail --title "Nextcloud DB host" --backtitle "$WT_BACKTITLE" --inputbox "Nextcloud database host - (default localhost) or (ext. host)" --nocancel 10 50 3>&1 1>&2 2>&3)
	  	done
	fi

	while [[ ! "$CFG_ISPC" =~ $RE ]]
	do
		CFG_ISPC=$(whiptail --title "ISPConfig Setup" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Would you like full unattended setup of expert mode for ISPConfig?" 10 50 2 "standard" "(default)" ON "expert" "" OFF 3>&1 1>&2 2>&3)
	done

	if [[ ! "$CFG_JKIT" =~ $RE ]]; then
		if (whiptail --title "Jailkit" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install Jailkit (it must be installed before ISPConfig)?" 10 50) then
			CFG_JKIT=yes
		else
			CFG_JKIT=no
		fi
	fi
	
	CFG_WEBMAIL=roundcube
	
	while [[ ! "$SSL_COUNTRY" =~ $RE ]]
	do
		SSL_COUNTRY=$(whiptail --title "SSL Country" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Country Name (2 letter code) (ex. HU)" --nocancel 10 50 "${LANG:3:2}" 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_STATE" =~ $RE ]]
	do
		SSL_STATE=$(whiptail --title "SSL State" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - State or Province Name (full name) (ex. Hungary)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_LOCALITY" =~ $RE ]]
	do
		SSL_LOCALITY=$(whiptail --title "SSL Locality" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Locality Name (eg, city) (ex. Bekescsaba)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_ORGANIZATION" =~ $RE ]]
	do
		SSL_ORGANIZATION=$(whiptail --title "SSL Organization" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization Name (eg, Wolftronics) (ex. Company L.t.d.)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_ORGUNIT" =~ $RE ]]
	do
		SSL_ORGUNIT=$(whiptail --title "SSL Organization Unit" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organizational Unit Name (eg, section) (ex. IT Department)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

}

