#---------------------------------------------------------------------
# Function: Install Postfix
#    Install and configure postfix
#---------------------------------------------------------------------
InstallPostfix() {
  echo "Checking and disabling Sendmail... "
  if [ -f /etc/init.d/sendmail ]; then
	stop_service sendmail
	hide_output update-rc.d -f sendmail remove
	apt_get_quiet remove sendmail
  fi
  
  echo -n "Installing Postfix... "
  echo "postfix postfix/main_mailer_type select Internet Site" | debconf-set-selections
  echo "postfix postfix/mailname string $CFG_HOSTNAME_FQDN" | debconf-set-selections
  apt_install postfix postfix-mysql postfix-doc getmail4
  #apt_install postfix-pcre postgrey ca-certificates
  sed -i "s/#submission inet n       -       y       -       -       smtpd/submission inet n       -       -       -       -       smtpd/" /etc/postfix/master.cf
  sed -i "s/#  -o syslog_name=postfix\/submission/  -o syslog_name=postfix\/submission/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_tls_security_level=encrypt/  -o smtpd_tls_security_level=encrypt/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_sasl_auth_enable=yes/  -o smtpd_sasl_auth_enable=yes\\`echo -e '\n\r'`  -o smtpd_client_restrictions=permit_sasl_authenticated,reject/" /etc/postfix/master.cf
  sed -i "s/#smtps     inet  n       -       y       -       -       smtpd/smtps     inet  n       -       -       -       -       smtpd/" /etc/postfix/master.cf
  sed -i "s/#  -o syslog_name=postfix\/smtps/  -o syslog_name=postfix\/smtps/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_tls_wrappermode=yes/  -o smtpd_tls_wrappermode=yes/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_sasl_auth_enable=yes/  -o smtpd_sasl_auth_enable=yes\\`echo -e '\n\r'`  -o smtpd_client_restrictions=permit_sasl_authenticated,reject/" /etc/postfix/master.cf
  sed -i "s/#tlsproxy  unix  -       -       y       -       0       tlsproxy/tlsproxy  unix  -       -       y       -       0       tlsproxy/" /etc/postfix/master.cf
  # Tweak some queue settings:
  # * Inform users when their e-mail delivery is delayed more than 3 hours (default is not to warn).
  # * Stop trying to send an undeliverable e-mail after 2 days (instead of 5), and for bounce messages just try for 1 day.
  sed -i -e"s/#delay_warning_time = 4h/delay_warning_time = 3h/" /etc/postfix/main.cf
  sed -i -e"s/delay_warning_time = 3h/delay_warning_time = 3h\nmaximal_queue_lifetime=2d\nbounce_queue_lifetime=1d/" /etc/postfix/main.cf

#  python tools/editconf.py /etc/postfix/main.cf \
#      delay_warning_time=3h \
#      maximal_queue_lifetime=2d \
#      bounce_queue_lifetime=1d

  # Who can send mail to us? Some basic filters.
  #
  # * `reject_non_fqdn_sender`: Reject not-nice-looking return paths.
  # * `reject_unknown_sender_domain`: Reject return paths with invalid domains.
  # * `reject_authenticated_sender_login_mismatch`: Reject if mail FROM address does not match the client SASL login
  # * `reject_rhsbl_sender`: Reject return paths that use blacklisted domains.
  # * `permit_sasl_authenticated`: Authenticated users (i.e. on port 587) can skip further checks.
  # * `permit_mynetworks`: Mail that originates locally can skip further checks.
  # * `reject_rbl_client`: Reject connections from IP addresses blacklisted in zen.spamhaus.org
  # * `reject_unlisted_recipient`: Although Postfix will reject mail to unknown recipients, it's nicer to reject such mail ahead of greylisting rather than after.
  # * `check_policy_service`: Apply greylisting using postgrey.
  #
  # Notes: #NODOC
  # permit_dnswl_client can pass through mail from whitelisted IP addresses, which would be good to put before greylisting #NODOC
  # so these IPs get mail delivered quickly. But when an IP is not listed in the permit_dnswl_client list (i.e. it is not #NODOC
  # whitelisted) then postfix does a DEFER_IF_REJECT, which results in all "unknown user" sorts of messages turning into #NODOC
  # "450 4.7.1 Client host rejected: Service unavailable". This is a retry code, so the mail doesn't properly bounce. #NODOC
  
#  python tools/editconf.py /etc/postfix/main.cf \
#      smtpd_sender_restrictions="reject_non_fqdn_sender,reject_unknown_sender_domain,reject_authenticated_sender_login_mismatch,reject_rhsbl_sender dbl.spamhaus.org" \
#      smtpd_recipient_restrictions=permit_sasl_authenticated,permit_mynetworks,"reject_rbl_client zen.spamhaus.org",reject_unlisted_recipient,"check_policy_service inet:127.0.0.1:10023"

  # Increase the message size limit from 10MB to 128MB.
  # The same limit is specified in nginx.conf for mail submitted via webmail and Z-Push.
  echo "message_size_limit=134217728" >> /etc/postfix/main.cf
  #python tools/editconf.py /etc/postfix/main.cf \
  #message_size_limit=134217728

  # Allow the two SMTP ports in the firewall.
#  ufw_allow smtp
#  ufw_allow submission

  # Restart services
  restart_service postfix
  #restart_service postgrey
  echo -e "[${green}DONE${NC}]\n"
}
