#---------------------------------------------------------------------
# Function: InstallWebServer Debian 9
#    Install and configure Apache2, php + modules
#---------------------------------------------------------------------
InstallWebServer() {
  
  if [ $CFG_WEBSERVER == "apache" ]; then
  CFG_NGINX=n
  CFG_APACHE=y
	echo -n "Installing Apache and Modules... "
	echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect apache2" | debconf-set-selections
	# - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
	echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
	apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libruby libapache2-mod-python php-memcache php-imagick php-gettext libapache2-mod-passenger
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP and Modules... "
	# Need to check if soemthing is asked before suppress messages
	apt_install php7.0 php7.0-common php7.0-gd php7.0-mysql php7.0-imap php7.0-cli php7.0-cgi php-pear php7.0-mcrypt php7.0-curl php7.0-intl php7.0-pspell php7.0-recode php7.0-sqlite3 php7.0-tidy php7.0-xmlrpc php7.0-zip php7.0-mbstring php7.0-imap php7.0-mcrypt php7.0-snmp php7.0-xmlrpc php7.0-xsl
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP-FPM"
	#Need to check if soemthing is asked before suppress messages
	apt_install php7.0-fpm
	#Need to check if soemthing is asked before suppress messages
	a2enmod actions > /dev/null 2>&1
	a2enmod proxy_fcgi > /dev/null 2>&1
	a2enmod alias > /dev/null 2>&1
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing needed Programs for PHP and Apache... "
	apt_install mcrypt imagemagick memcached curl tidy snmp
	echo -e "[${green}DONE${NC}]\n"
	
  if [ $CFG_PHPMYADMIN == "yes" ]; then
	echo -n "Installing phpMyAdmin... "
	apt_install phpmyadmin
	echo -e "[${green}DONE${NC}]\n"
  fi
	
  if [ $CFG_PHP56 == "yes" ]; then
	echo "Installing PHP 5.6"
	apt_install apt-transport-https
	curl https://packages.sury.org/php/apt.gpg | apt-key add -  > /dev/null 2>&1
	echo 'deb https://packages.sury.org/php/ stretch main' > /etc/apt/sources.list.d/deb.sury.org.list
	hide_output apt-get update
	apt_install php5.6 php5.6-common php5.6-gd php5.6-mysql php5.6-imap php5.6-cli php5.6-cgi php5.6-mcrypt php5.6-curl php5.6-intl php5.6-pspell php5.6-recode php5.6-sqlite3 php5.6-tidy php5.6-xmlrpc php5.6-xsl php5.6-zip php5.6-mbstring php5.6-fpm
	echo -e "Package: *\nPin: origin packages.sury.org\nPin-Priority: 100" > /etc/apt/preferences.d/deb-sury-org
  fi  
	
	echo -n "Activating Apache2 Modules... "
	a2enmod suexec > /dev/null 2>&1
	a2enmod rewrite > /dev/null 2>&1
	a2enmod ssl > /dev/null 2>&1
	a2enmod actions > /dev/null 2>&1
	a2enmod include > /dev/null 2>&1
	a2enmod dav_fs > /dev/null 2>&1
	a2enmod dav > /dev/null 2>&1
	a2enmod auth_digest > /dev/null 2>&1
	a2enmod fastcgi > /dev/null 2>&1
	a2enmod alias > /dev/null 2>&1
	a2enmod fcgid > /dev/null 2>&1
	a2enmod cgi > /dev/null 2>&1
	a2enmod headers > /dev/null 2>&1
	a2enmod http2 > /dev/null 2>&1

	echo -n "Disable HTTP_PROXY"
	echo "<IfModule mod_headers.c>" >> /etc/apache2/conf-available/httpoxy.conf
	echo "     RequestHeader unset Proxy early" >> /etc/apache2/conf-available/httpoxy.conf
	echo "</IfModule>" >> /etc/apache2/conf-available/httpoxy.conf
	a2enconf httpoxy > /dev/null 2>&1
	service apache2 restart > /dev/null 2>&1
	echo -e "[${green}DONE${NC}]\n"
	
	echo -n "Installing Lets Encrypt... "
	apt_install certbot
	echo -e "[${green}DONE${NC}]\n"
  
	echo -n "Install PHP Opcode Cache "
	apt_install php7.0-opcache php-apcu
	service apache2 restart > /dev/null 2>&1
	echo -e "[${green}DONE${NC}]\n"
  else
	
  CFG_NGINX=y
  CFG_APACHE=n
	echo -n "Installing NGINX and Modules... "
	wget http://nginx.org/keys/nginx_signing.key
	apt-key add nginx_signing.key
	echo 'deb http://nginx.org/packages/mainline/debian/ stretch nginx' >> /etc/apt/sources.list
	echo 'deb-src http://nginx.org/packages/mainline/debian/ stretch nginx' >> /etc/apt/sources.list
	apt-get update
	apt_install nginx-extras
	echo 'fastcgi_param HTTP_PROXY "";' >> /etc/nginx/fastcgi_params
	service nginx start 
	apt_install php7.0 php7.0-common php7.0-gd php7.0-mysql php7.0-imap php7.0-cli php7.0-cgi php-pear php7.0-mcrypt php7.0-curl php7.0-intl php7.0-pspell php7.0-recode php7.0-sqlite3 php7.0-tidy php7.0-zip php7.0-mbstring php7.0-imap php7.0-mcrypt php7.0-snmp php7.0-xmlrpc php7.0-xsl
	#Need to check if soemthing is asked before suppress messages
	apt_install php7.0-fpm
	sed -i "s/;cgi.fix_pathinfo=1/cgi.fix_pathinfo=0/" /etc/php/7.0/fpm/php.ini
	sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/7.0/fpm/php.ini
	sed -i 's/max_execution_time = 30/max_execution_time = 120/' /etc/php/7.0/fpm/php.ini
	sed -i 's/; max_input_vars = 1000/max_input_vars = 3000/' /etc/php/7.0/fpm/php.ini
	sed -i 's/upload_max_filesize = 2M/upload_max_filesize = 50M/' /etc/php/7.0/fpm/php.ini
	sed -i 's/max_input_time = 60/max_input_time = 120/' /etc/php/7.0/fpm/php.ini
	sed -i 's/post_max_size = 8M/post_max_size = 50M/' /etc/php/7.0/fpm/php.ini
	sed -i 's/expose_php = On/expose_php = Off/' /etc/php/7.0/fpm/php.ini
	sed -i 's/;realpath_cache_size = 16k/realpath_cache_size = 512k/' /etc/php/7.0/fpm/php.ini
	sed -i 's/;realpath_cache_ttl = 120/realpath_cache_ttl = 86400/' /etc/php/7.0/fpm/php.ini
	sed -i 's/short_open_tag = Off/short_open_tag = On/' /etc/php/7.0/fpm/php.ini
	sed -i 's/session.gc_maxlifetime = 1440/session.gc_maxlifetime = 86400/' /etc/php/7.0/fpm/php.ini
	cp /etc/php/7.0/fpm/pool.d/www.conf /etc/php/7.0/fpm/pool.d/www.conf.BACK
	sed -i 's/;catch_workers_output = yes/catch_workers_output = yes/' /etc/php/7.0/fpm/pool.d/www.conf
	sed -i 's/;request_terminate_timeout = 0/request_terminate_timeout = 120s/' /etc/php/7.0/fpm/pool.d/www.conf
	sed -i 's/;rlimit_files = 1024/rlimit_files = 200000/' /etc/php/7.0/fpm/pool.d/www.conf
	sed -i 's/;rlimit_core = 0/rlimit_core = unlimited/' /etc/php/7.0/fpm/pool.d/www.conf
	#sed -i 's/;slowlog = log/$pool.log.slow/slowlog = /var/log/slowlog-site.log/' /etc/php/7.0/fpm/pool.d/www.conf
	#sed -i 's/;request_slowlog_timeout = 0/request_slowlog_timeout = 5s/' /etc/php/7.0/fpm/pool.d/www.conf
	#sed -i 's/;pm.status_path = /status/pm.status_path = /status/' /etc/php/7.0/fpm/pool.d/www.conf
	sed -i 's/;listen.backlog = 65535/listen.backlog = -1/' /etc/php/7.0/fpm/pool.d/www.conf
	cp /etc/php/7.0/fpm/php-fpm.conf /etc/php/7.0/fpm/php-fpm.conf.BACK
	sed -i 's/;emergency_restart_threshold = 0/emergency_restart_threshold = 10/' /etc/php/7.0/fpm/php-fpm.conf
	sed -i 's/;emergency_restart_interval = 0/emergency_restart_interval = 1m/' /etc/php/7.0/fpm/php-fpm.conf
	sed -i 's/;process_control_timeout = 0/process_control_timeout = 10s/' /etc/php/7.0/fpm/php-fpm.conf
	/etc/init.d/php7.0-fpm restart
	echo -n "Installing needed Programs for PHP and NGINX... "
	apt_install mcrypt imagemagick memcached curl tidy snmp
	service php7.0-fpm reload
	apt_install fcgiwrap
  
  if [ $CFG_PHPMYADMIN == "yes" ]; then
	echo -n "Installing phpMyAdmin... "
	apt_install phpmyadmin
	echo -e "[${green}DONE${NC}]\n"
  fi

   
    if [ $CFG_PHP56 == "yes" ]; then
		echo "Installing PHP 7.2"
		apt_install apt-transport-https
		curl https://packages.sury.org/php/apt.gpg | apt-key add -  > /dev/null 2>&1
		echo 'deb https://packages.sury.org/php/ stretch main' > /etc/apt/sources.list.d/deb.sury.org.list
		hide_output apt-get update
		apt_install php-memcache php-memcached php-apcu php-apcu-bc php7.2 php7.2-cli php7.2-cgi php7.2-common php7.2-curl php7.2-fpm php7.2-gd php7.2-json php7.2-mbstring php7.2-opcache php7.2-readline php7.2-snmp php7.2-xml php7.2-xmlrpc
		echo -e "Package: *\nPin: origin packages.sury.org\nPin-Priority: 100" > /etc/apt/preferences.d/deb-sury-org
		cp /etc/php/7.2/fpm/php.ini /etc/php/7.2/fpm/php.ini.BACK
		sed -i "s/;cgi.fix_pathinfo=1/cgi.fix_pathinfo=0/" /etc/php/7.2/fpm/php.ini
		sed -i "s/;date.timezone =/date.timezone=\"Europe\/Zurich\"/" /etc/php/7.2/fpm/php.ini
		sed -i 's/max_execution_time = 30/max_execution_time = 120/' /etc/php/7.2/fpm/php.ini
		sed -i 's/; max_input_vars = 1000/max_input_vars = 3000/' /etc/php/7.2/fpm/php.ini
		sed -i 's/upload_max_filesize = 2M/upload_max_filesize = 50M/' /etc/php/7.2/fpm/php.ini
		sed -i 's/max_input_time = 60/max_input_time = 120/' /etc/php/7.2/fpm/php.ini
		sed -i 's/post_max_size = 8M/post_max_size = 50M/' /etc/php/7.2/fpm/php.ini
		sed -i 's/expose_php = On/expose_php = Off/' /etc/php/7.2/fpm/php.ini
		sed -i 's/;realpath_cache_size = 16k/realpath_cache_size = 512k/' /etc/php/7.2/fpm/php.ini
		sed -i 's/;realpath_cache_ttl = 120/realpath_cache_ttl = 86400/' /etc/php/7.2/fpm/php.ini
		sed -i 's/short_open_tag = Off/short_open_tag = On/' /etc/php/7.2/fpm/php.ini
		sed -i 's/session.gc_maxlifetime = 1440/session.gc_maxlifetime = 86400/' /etc/php/7.2/fpm/php.ini
		cp /etc/php/7.2/fpm/pool.d/www.conf /etc/php/7.2/fpm/pool.d/www.conf.BACK
		sed -i 's/;catch_workers_output = yes/catch_workers_output = yes/' /etc/php/7.2/fpm/pool.d/www.conf
		sed -i 's/;request_terminate_timeout = 0/request_terminate_timeout = 120s/' /etc/php/7.2/fpm/pool.d/www.conf
		sed -i 's/;rlimit_files = 1024/rlimit_files = 200000/' /etc/php/7.2/fpm/pool.d/www.conf
		sed -i 's/;rlimit_core = 0/rlimit_core = unlimited/' /etc/php/7.2/fpm/pool.d/www.conf
		#sed -i 's/;slowlog = log/$pool.log.slow/slowlog = /var/log/slowlog-site.log/' /etc/php/7.2/fpm/pool.d/www.conf
		#sed -i 's/;request_slowlog_timeout = 0/request_slowlog_timeout = 5s/' /etc/php/7.2/fpm/pool.d/www.conf
		#sed -i 's/;pm.status_path = /status/pm.status_path = /status/' /etc/php/7.2/fpm/pool.d/www.conf
		sed -i 's/;listen.backlog = 65535/listen.backlog = -1/' /etc/php/7.2/fpm/pool.d/www.conf
		cp /etc/php/7.2/fpm/php-fpm.conf /etc/php/7.2/fpm/php-fpm.conf.BACK
		sed -i 's/;emergency_restart_threshold = 0/emergency_restart_threshold = 10/' /etc/php/7.2/fpm/php-fpm.conf
		sed -i 's/;emergency_restart_interval = 0/emergency_restart_interval = 1m/' /etc/php/7.2/fpm/php-fpm.conf
		sed -i 's/;process_control_timeout = 0/process_control_timeout = 10s/' /etc/php/7.2/fpm/php-fpm.conf
		/etc/init.d/php7.2-fpm restart
	fi  
	echo -n "Installing Lets Encrypt... "
	apt_install certbot
	echo -e "[${green}DONE${NC}]\n"
	
	echo -n "Install PHP Opcode Cache "
	apt_install php7.0-opcache php-apcu
	echo -e "[${green}DONE${NC}]\n"
  
  fi
  echo -e "[${green}DONE${NC}]\n"
  if [ $CFG_PHP56 == "yes" ]; then
	echo -e "${red}Attention!!! You had installed php7 and php 7.2, to make php 7.2 work you had to configure the following in ISPConfig ${NC}"
	echo -e "${red}Path for PHP FastCGI binary: /usr/bin/php-cgi7.2 ${NC}"
	echo -e "${red}Path for php.ini directory: /etc/php/7.2/cgi ${NC}"
	echo -e "${red}Path for PHP-FPM init script: /etc/init.d/php7.2-fpm ${NC}"
	echo -e "${red}Path for php.ini directory: /etc/php/7.2/fpm ${NC}"
	echo -e "${red}Path for PHP-FPM pool directory: /etc/php/7.2/fpm/pool.d ${NC}"
  fi
}
