#---------------------------------------------------------------------
# Function: InstallMailman
#    Install the Mailman list manager
#---------------------------------------------------------------------
InstallMailman() {
    START_TIME=$SECONDS

    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing Mailman..."
    echo "mailman mailman/default_server_language select en" | debconf-set-selections
    echo "mailman mailman/site_languages  multiselect en" | debconf-set-selections
    echo "mailman mailman/create_site_list select " | debconf-set-selections
    apt_install mailman
    mmsitepass "${MMSITEPASS}"
    newlist -a  mailman "${MMLISTOWNER}" "${MMADMINEMAIL}" "${MMLISTPASS}" | grep "/var/lib/mailman" >> /etc/aliases
    newaliases
    postalias /etc/mailman/aliases
    # Get mailman in the path so that the ISPConfig installer detects it   
    ln -s /usr/lib/mailman/mail/mailman /usr/bin/mailman

    if [ $CFG_WEBSERVER == "nginx" ]; then
	mkdir /etc/nginx/sites-available/
  	touch /etc/nginx/sites-available/mailman.vhost
  	cat > /etc/nginx/sites-available/mailman.vhost << EOF
##
# You should look at the following URL's in order to grasp a solid understanding
# of Nginx configuration files in order to fully unleash the power of Nginx.
# https://www.nginx.com/resources/wiki/start/
# https://www.nginx.com/resources/wiki/start/topics/tutorials/config_pitfalls/
# https://wiki.debian.org/Nginx/DirectoryStructure
#
# In most cases, administrators will remove this file from sites-enabled/ and
# leave it as reference inside of sites-available where it will continue to be
# updated by the nginx packaging team.
#
# This file will automatically load configuration files provided by other
# applications, such as Drupal or Wordpress. These applications will be made
# available underneath a path with that package name, such as /drupal8.
#
# Please see /usr/share/doc/nginx-doc/examples/ for more detailed examples.
##
# Default server configuration
#
server {
	listen 80 default_server;
	listen [::]:80 default_server;
	# SSL configuration
	#
	# listen 443 ssl default_server;
	# listen [::]:443 ssl default_server;
	#
	# Note: You should disable gzip for SSL traffic.
	# See: https://bugs.debian.org/773332
	#
	# Read up on ssl_ciphers to ensure a secure configuration.
	# See: https://bugs.debian.org/765782
	#
	# Self signed certs generated by the ssl-cert package
	# Don't use them in a production server!
	#
	# include snippets/snakeoil.conf;
	root /var/www/html;
	# Add index.php to the list if you are using PHP
	index index.html index.htm index.nginx-debian.html;
	server_name _;
	location / {
		# First attempt to serve request as file, then
		# as directory, then fall back to displaying a 404.
		try_files $uri $uri/ =404;
	}
	# pass PHP scripts to FastCGI server
	#
	#location ~ \.php$ {
	#	include snippets/fastcgi-php.conf;
	#
	#	# With php-fpm (or other unix sockets):
	#	fastcgi_pass unix:/run/php/php7.3-fpm.sock;
	#	# With php-cgi (or other tcp sockets):
	#	fastcgi_pass 127.0.0.1:9000;
	#}
	# deny access to .htaccess files, if Apache's document root
	# concurs with nginx's one
	#
	#location ~ /\.ht {
	#	deny all;
	#}
}
# Virtual Host configuration for example.com
#
# You can move that to a different file under sites-available/ and symlink that
# to sites-enabled/ to enable it.
#
#server {
#	listen 80;
#	listen [::]:80;
#
#	server_name example.com;
#
#	root /var/www/example.com;
#	index index.html;
#
#	location / {
#		try_files $uri $uri/ =404;
#	}
#}
EOF
    fi

    systemctl restart postfix.service
    systemctl enable mailman.service
    systemctl start mailman.service
    	    
    cat >> /home/administrator/wtlinux_server_setup/wtserver_configuration.txt <<EOF
# Mailman Store the passwords
#----------------------------
Mailman site password		: $MMSITEPASS
Mailman site list user		: $MMLISTOWNER
Mailman site list password	: $MMLISTPASS
#----------------------------

EOF
    MeasureTimeDuration $START_TIME
#    echo -e "[${green}DONE${NC}]\n"
}
