#---------------------------------------------------------------------
# Function: InstallphpMyAdmin
#    Install and configure phpMyAdmin
#---------------------------------------------------------------------	    
#echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect none" | debconf-set-selections
# - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
#echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
InstallphpMyAdmin() {
    # Define phpMyAdmin version and Blowfish secret
    phpMyAdmin="5.2.2" #phpMyAdmin version
    blowfish="hu67jty85Fgh6TRfcjiw50720fghTyjT" # blowfish 32 char secret maybe it can be autogenerated
    
    echo -n -e "$IDENTATION_LVL_2 Creating necessary directories... "
    # Create necessary directories
    mkdir /usr/share/phpmyadmin
    mkdir /etc/phpmyadmin
    mkdir -p /var/lib/phpmyadmin/tmp
    chown -R www-data:www-data /var/lib/phpmyadmin
    touch /etc/phpmyadmin/htpasswd.setup
    echo -e "[${green}DONE${NC}]"

    echo -n -e "$IDENTATION_LVL_2 Downloading phpMyAdmin... "
    # Download and extract phpMyAdmin
    cd /tmp
    wget https://files.phpmyadmin.net/phpMyAdmin/$phpMyAdmin/phpMyAdmin-$phpMyAdmin-all-languages.tar.gz > /dev/null 2>&1
    tar xfz phpMyAdmin-$phpMyAdmin-all-languages.tar.gz > /dev/null 2>&1
    mv phpMyAdmin-$phpMyAdmin-all-languages/* /usr/share/phpmyadmin/
    rm phpMyAdmin-$phpMyAdmin-all-languages.tar.gz
    rm -rf phpMyAdmin-$phpMyAdmin-all-languages
    echo -e "[${green}DONE${NC}]"

    echo -n -e "$IDENTATION_LVL_2 Configuring phpMyAdmin... "
    # Configure phpMyAdmin
    cp /usr/share/phpmyadmin/config.sample.inc.php  /usr/share/phpmyadmin/config.inc.php
    sed -i "s|\$cfg\['blowfish_secret'\]\s=\s'';|\$cfg['blowfish_secret'] = '$blowfish';|" /usr/share/phpmyadmin/config.inc.php
    sed -i "$ a\$cfg['TempDir'] = '/var/lib/phpmyadmin/tmp';" /usr/share/phpmyadmin/config.inc.php
    echo -e "[${green}DONE${NC}]"

    if [ "$CFG_WEBSERVER" == "apache" ]; then
        echo -n -e "$IDENTATION_LVL_2 Configuring Apache for phpMyAdmin... "
        # Apache configuration for phpMyAdmin
        cat > /etc/apache2/conf-available/phpmyadmin.conf <<EOF
# phpMyAdmin default Apache configuration

Alias /phpmyadmin /usr/share/phpmyadmin

<Directory /usr/share/phpmyadmin>
    Options FollowSymLinks
    DirectoryIndex index.php

    <IfModule mod_php7.c>
        AddType application/x-httpd-php .php

        php_flag magic_quotes_gpc Off
        php_flag track_vars On
        php_flag register_globals Off
        php_value include_path .
    </IfModule>
</Directory>

# Authorize for setup

<Directory /usr/share/phpmyadmin/setup>
    <IfModule mod_authn_file.c>
        AuthType Basic
        AuthName "phpMyAdmin Setup"
        AuthUserFile /etc/phpmyadmin/htpasswd.setup
    </IfModule>
    Require valid-user
</Directory>

# Disallow web access to directories that don't need it

<Directory /usr/share/phpmyadmin/libraries>
    Order Deny,Allow
    Deny from All
</Directory>
<Directory /usr/share/phpmyadmin/setup/lib>
    Order Deny,Allow
    Deny from All
</Directory>
EOF

        a2enconf phpmyadmin > /dev/null 2>&1
        systemctl reload apache2
        echo -e "[${green}DONE${NC}]"
        
    elif [ "$CFG_WEBSERVER" == "nginx" ]; then
        echo -n -e "$IDENTATION_LVL_2 Configuring Nginx for phpMyAdmin...\n"
        # Nginx configuration for phpMyAdmin
	cat > /etc/nginx/conf.d/phpmyadmin.conf <<'EOF'
## phpMyAdmin default nginx configuration

server {
    listen 80;
    server_name "";
    root /usr/share/phpmyadmin;

    index index.php index.html index.htm;

    # phpMyAdmin main path
    location /phpmyadmin {
        root /usr/share/;
        index index.php index.html index.htm;

        # Manage PHP files in phpMyAdmin
        location ~ ^/phpmyadmin/(.+\.php)$ {
            try_files $uri =404;
            fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
            fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
            fastcgi_index index.php;
            include fastcgi_params;
            fastcgi_param PATH_INFO $fastcgi_path_info;
            fastcgi_buffer_size 128k;
            fastcgi_buffers 256 4k;
            fastcgi_busy_buffers_size 256k;
            fastcgi_temp_file_write_size 256k;
            fastcgi_intercept_errors on;
        }

        # Manage static content in phpMyAdmin
        location ~* ^/phpmyadmin/(.+\.(jpg|jpeg|gif|css|png|js|ico|html|xml|txt))$ {
            root /usr/share/;
        }
    }

    # Upper and lower case redirection
    location /phpMyAdmin {
        rewrite ^/* /phpmyadmin last;
    }

    # Root path management
    location / {
        try_files $uri $uri/ /index.php?$args;
        index index.php;
    }

    # Static content management
    location ~* \.(jpg|jpeg|gif|css|png|js|ico|xml)$ {
        access_log off;
        expires 30d;
    }

    # Protect hidden files
    location ~ /\.ht {
        deny all;
    }

    # Secure libraries
    location ~ /(libraries|setup/frames|setup/libs) {
        deny all;
        return 404;
    }

    # Manage PHP files in the main directory
    location ~ \.php$ {
        try_files $uri =404;
        fastcgi_split_path_info ^(.+\.php)(/.+)$;
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
EOF

        echo -n -e "$IDENTATION_LVL_2 Disabling IPv6 if not enabled... "
        # Disable IPv6 if not enabled
	if [ $IPV6_ENABLED == false ]; then
	    sed -i "s/listen \[::\]:80/###-No IPV6### listen [::]:80/" /etc/nginx/sites-available/default
	fi
	echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_2 Ensuring sites-enabled loading... "
        # Ensure sites-enabled loading
	if [ $IPV6_ENABLED == false ]; then
	    grep -q "sites-enabled\/\*\.vhost" /etc/nginx/nginx.conf || sed -i "/include \/etc\/nginx\/conf.d\/\*\.conf;/ a \    include \/etc\/nginx\/sites-enabled\/\*\.vhost;" /etc/nginx/nginx.conf
	fi
	echo -e "[${green}DONE${NC}]"

	#write vhost nginx phpmyadmin file for ISPConfig vhost
	# uncommmenting the phpmyadmin section
	# sed '/start/,/stop/ s/^#//' serach between the start stop patterns removing #. 
	# includes stop stop patterns so stop pattern needs recommenting out
	#sed -i '/location\s\/phpmyadmin\s{/,/location\s\/squirrelmail\s{/ s/^#//' /etc/nginx/sites-available/ispconfig.vhost
	#sed -i '/location\s\/squirrelmail\s{/ s/^/#/' /etc/nginx/sites-available/ispconfig.vhost


        echo -n -e "$IDENTATION_LVL_2 Restarting Nginx and PHP-FPM... "
        # Restart Nginx and PHP-FPM
	systemctl restart nginx
	systemctl restart php8.2-fpm
	echo -e "[${green}DONE${NC}]"
    fi

    echo -n -e "$IDENTATION_LVL_2 Configuring phpMyAdmin database... "
    if [ "$CFG_SQLSERVER" == "MariaDB" ]; then
	SQL_COMMAND="mariadb"
    else
	SQL_COMMAND="mysql"
    fi

    # Configure phpMyAdmin database
    #$SQL_COMMAND -u root -p"$CFG_MYSQL_ROOT_PWD" -e "CREATE DATABASE phpmyadmin;"
    #$SQL_COMMAND -u root -p"$CFG_MYSQL_ROOT_PWD" -e "CREATE USER 'pma'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD';"
    #$SQL_COMMAND -u root -p"$CFG_MYSQL_ROOT_PWD" -e "GRANT ALL PRIVILEGES ON phpmyadmin.* TO 'pma'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD' WITH GRANT OPTION;"
    #$SQL_COMMAND -u root -p"$CFG_MYSQL_ROOT_PWD" -e "FLUSH PRIVILEGES;"
    echo "CREATE DATABASE phpmyadmin;" > $PROGRAMS_INSTALL_SQLS/phpmyadmin.sql
    echo "CREATE USER 'pma'@'localhost' IDENTIFIED BY $CFG_MYSQL_ROOT_PWD;" >> $PROGRAMS_INSTALL_SQLS/phpmyadmin.sql
    echo "GRANT ALL PRIVILEGES ON phpmyadmin.* TO 'pma'@'localhost' IDENTIFIED BY $CFG_MYSQL_ROOT_PWD WITH GRANT OPTION;" >> $PROGRAMS_INSTALL_SQLS/phpmyadmin.sql
    echo "FLUSH PRIVILEGES;" >> $PROGRAMS_INSTALL_SQLS/phpmyadmin.sql
    $SQL_COMMAND -uroot -p"$CFG_MYSQL_ROOT_PWD" < $PROGRAMS_INSTALL_SQLS/phpmyadmin.sql >> $PROGRAMS_INSTALL_LOG_FILES 2>&1	
    $SQL_COMMAND -uroot -p"$CFG_MYSQL_ROOT_PWD" phpmyadmin < /usr/share/phpmyadmin/sql/create_tables.sql >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    echo -e "[${green}DONE${NC}]"
    
    echo -n -e "$IDENTATION_LVL_2 Updating phpMyAdmin storage configuration... "
    # Update phpMyAdmin configuration for storage
    sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlhost'\]\s=\s'';|\$cfg['Servers'][\$i]['controlhost'] = 'localhost';|" /usr/share/phpmyadmin/config.inc.php
    sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlport'\]\s=\s'';|\$cfg['Servers'][\$i]['controlport'] = '';|" /usr/share/phpmyadmin/config.inc.php
    sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controluser'\]\s=\s'pma';|\$cfg['Servers'][\$i]['controluser'] = 'pma';|" /usr/share/phpmyadmin/config.inc.php
    sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlpass'\]\s=\s'pmapass';|\$cfg['Servers'][\$i]['controlpass'] = '$CFG_MYSQL_ROOT_PWD';|" /usr/share/phpmyadmin/config.inc.php
    # uncomment the Storage database and tables section
    sed -i '/\*\sStorage\sdatabase\sand\stables\s\*/,/\*\*/ s|^//||' /usr/share/phpmyadmin/config.inc.php
    echo -e "[${green}DONE${NC}]"
    
    # Print access information
    echo -e "$IDENTATION_LVL_1 phpMyAdmin is accessible at:"
    echo -e "$IDENTATION_LVL_2 http://$CFG_HOSTNAME_FQDN:$CFG_ISPONCFIG_APPS_PORT/phpmyadmin"
    echo -e "$IDENTATION_LVL_2 http://${IP_ADDRESS[0]}:$CFG_ISPONCFIG_APPS_PORT/phpmyadmin"
}



