#---------------------------------------------------------------------
# Function: Install Gitlab-ce
#    Install and configure of Gitlab-ce
#---------------------------------------------------------------------

InstallGitlabCE() {
    echo -n "Installed Gitlab-ce packages... "

    apt_install curl openssh-server ca-certificates postfix apt-transport-https gnupg2 software-properties-common tzdata perl
    
    cd /tmp
    #curl -sS https://packages.gitlab.com/install/repositories/gitlab/gitlab-ce/script.deb.sh | sudo bash
    #apt_install gitlab-ce

    curl -sS https://packages.gitlab.com/install/repositories/gitlab/gitlab-ee/script.deb.sh | sudo bash
    apt_install gitlab-ee

    #external_url 'https://Your_Domain_Name' /etc/gitlab/gitlab.rb
    #letsencrypt[‘contact_emails’] = [‘admin@lx.x’]
    
    # Unbundle nginx from Omnibus GitLab
    #sed -i "s/'http:\/\/gitlab.example.com'/'http:\/\/gitlab.wolftronics.hu'/g" /etc/gitlab/gitlab.rb
    #sed -i "s/'http:\/\/gitlab.example.com'/'https:\/\/gitlab.arbajnok.hu'/g" /etc/gitlab/gitlab.rb
    sed -i "s/'http:\/\/gitlab.example.com'/'https:\/\/gitlab.$CFG_HOSTNAME_DOMAIN'/g" /etc/gitlab/gitlab.rb

    #External nginx options
    sed -i "s/# nginx\['enable'\] = true/nginx\['enable'\] = false/g" /etc/gitlab/gitlab.rb
    sed -i "s/# web_server\['external_users'\] = \[\]/web_server\['external_users'\] = \['www-data'\]/g" /etc/gitlab/gitlab.rb

    #admin password
    sed -i "s/# gitlab_rails\['initial_root_password'\] =.*/gitlab_rails\['initial_root_password'\] = \"$CFG_GITLAB_ADMIN_PWD\"/g" /etc/gitlab/gitlab.rb

    #Bunded nginx options
    #sed -i "s/# nginx\['redirect_http_to_https'\] = false/nginx\['redirect_http_to_https'\] = true/g" /etc/gitlab/gitlab.rb
    #sed -i "s/# nginx\['ssl_certificate'\] = .*/nginx['ssl_certificate'] = \"\/etc\/letsencrypt\/live\/gitlab.arbajnok.hu\/fullchain.pem\"/g" /etc/gitlab/gitlab.rb
    #sed -i "s/# nginx\['ssl_certificate_key'\] = .*/nginx['ssl_certificate_key'] = \"\/etc\/letsencrypt\/live\/gitlab.arbajnok.hu\/privkey.pem\"/g" /etc/gitlab/gitlab.rb
    #sed -i "s/# nginx\['ssl_dhparam'\] = .*/nginx['ssl_dhparam'] = \"\/etc\/gitlab\/ssl\/dhparams.pem\"/g" /etc/gitlab/gitlab.rb

    #certbot certonly --agree-tos --non-interactive --renew-by-default --standalone --email wolftronics@arbajnok.hu -d gitlab.arbajnok.hu

    mkdir -p /etc/gitlab/ssl/
    openssl dhparam -out /etc/gitlab/ssl/dhparams.pem 2048

    #gitlab-rake gitlab:setup #esetleg kell az admin jelszóhoz
    gitlab-ctl reconfigure

    #apt_install ruby
    #gem install rubygems-update
    #gem pristine rake
    #update_rubygems

    #Phusion Passenger
    #apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 561F9B9CAC40B2F7
    #echo "deb https://oss-binaries.phusionpassenger.com/apt/passenger xenial main" > /etc/apt/sources.list.d/passenger.list
    #sudo sed -i 's/http:\/\/lt\./http:\/\//g' /etc/apt/sources.list.d/passenger.list
    #hide_output apt-get update
    #deleted etc/nginx!!!!! backup!!!!!
    #apt_purge_remove nginx nginx-full nginx-light nginx-naxsi nginx-common
    #apt_install nginx-extras passenger
    #sed -i "s|^\(http {\).*$|\1\\ninclude \/etc\/nginx\/passenger.conf;|" /etc/nginx/nginx.conf

    #systemctl restart nginx

    case $CFG_WEBSERVER in
	"apache")
	    #vi /etc/gitlab/gitlab.rb
	    #web_server['username'] = 'apache'
	    #web_server['group'] = 'apache'

	    cat > /etc/nginx/sites-available/gitlab.$CFG_HOSTNAME_DOMAIN <<EOF
<VirtualHost *:80>
  ServerName gitlab.$CFG_HOSTNAME_DOMAIN
  DocumentRoot /opt/gitlab/embedded/service/gitlab-rails/public
  
  ProxyPreserveHost On
  AllowEncodedSlashes Off
  
  <Location />
    Order deny,allow
    Allow from all
    ProxyPassReverse http://127.0.0.1:8080
    ProxyPassReverse http://gitlab.$CFG_HOSTNAME_DOMAIN/
  </Location>
  
  RewriteEngine on
  RewriteCond %{DOCUMENT_ROOT}/%{REQUEST_FILENAME} !-f
  RewriteRule .* http://127.0.0.1:8080%{REQUEST_URI} [P,QSA]
</VirtualHost>
EOF

	    AllowEncodedSlashes NoDecode
	    systemctl reload httpd
	    ;;
	"nginx")
	    cat > /etc/nginx/sites-available/gitlab.$CFG_HOSTNAME_DOMAIN.vhost <<EOF
upstream gitlab-workhorse {
  server unix://var/opt/gitlab/gitlab-workhorse/sockets/socket fail_timeout=0;
}

server {
  listen 80;
  server_name   gitlab.$CFG_HOSTNAME_DOMAIN;
  rewrite       ^ https://\$server_name\$request_uri? permanent;
}

server {
#   listen 80;
    listen        443 ssl;
    http2 on;
    server_name gitlab.$CFG_HOSTNAME_DOMAIN;
    server_tokens off; # don't show the version number, a security best practice
    root /opt/gitlab/embedded/service/gitlab-rails/public;

    ssl_certificate       /root/.acme.sh/gitlab.$CFG_HOSTNAME_DOMAIN/fullchain.cer;
    ssl_certificate_key   /root/.acme.sh/gitlab.$CFG_HOSTNAME_DOMAIN/gitlab.$CFG_HOSTNAME_DOMAIN.key;

    ssl_prefer_server_ciphers on;
    ssl_protocols         TLSv1.2 TLSv1.3;
    ssl_ciphers           ALL:!aNULL:!ADH:!eNULL:!LOW:!EXP:RC4+RSA:+HIGH:+MEDIUM;
    ssl_dhparam           /etc/gitlab/ssl/dhparams.pem;

    # Increase this if you want to upload large attachments
    # Or if you want to accept large git objects over http
    client_max_body_size 250m;

    # individual nginx logs for this gitlab vhost
    access_log  /var/log/nginx/gitlab_access.log;
    error_log   /var/log/nginx/gitlab_error.log;


    location ~ ^/[\w\.-]+/[\w\.-]+/(info/refs|git-upload-pack|git-receive-pack)$ {
      # 'Error' 418 is a hack to re-use the @gitlab-workhorse block
      error_page 418 = @gitlab-workhorse;
      return 418;
    }

    location ~ ^/[\w\.-]+/[\w\.-]+/repository/archive {
      # 'Error' 418 is a hack to re-use the @gitlab-workhorse block
      error_page 418 = @gitlab-workhorse;
      return 418;
    }

    location ~ ^/api/v3/projects/.*/repository/archive {
      # 'Error' 418 is a hack to re-use the @gitlab-workhorse block
      error_page 418 = @gitlab-workhorse;
      return 418;
    }

    # Build artifacts should be submitted to this location
    location ~ ^/[\w\.-]+/[\w\.-]+/builds/download {
      client_max_body_size 0;
      # 'Error' 418 is a hack to re-use the @gitlab-workhorse block
      error_page 418 = @gitlab-workhorse;
      return 418;
    }

    # Build artifacts should be submitted to this location
    location ~ /ci/api/v1/builds/[0-9]+/artifacts {
      client_max_body_size 0;
      # 'Error' 418 is a hack to re-use the @gitlab-workhorse block
      error_page 418 = @gitlab-workhorse;
      return 418;
    }

    # Build artifacts should be submitted to this location
    location ~ /api/v4/jobs/[0-9]+/artifacts {
      client_max_body_size 0;
      # 'Error' 418 is a hack to re-use the @gitlab-workhorse block
      error_page 418 = @gitlab-workhorse;
      return 418;
    }

  # For protocol upgrades from HTTP/1.0 to HTTP/1.1 we need to provide Host header if its missing
  if (\$http_host = "") {
  # use one of values defined in server_name
    set \$http_host_with_default "gitlab.$CFG_HOSTNAME_DOMAIN";
  }

  if (\$http_host != "") {
    set \$http_host_with_default \$http_host;
  }

  location / {
     gzip off;
     ## https://github.com/gitlabhq/gitlabhq/issues/694
     ## Some requests take more than 30 seconds.
     proxy_read_timeout      300;
     proxy_connect_timeout   300;
     proxy_redirect          off;

     # Do not buffer Git HTTP responses
     proxy_buffering off;

     proxy_set_header    Host                \$http_host_with_default;
     proxy_set_header    X-Real-IP           \$remote_addr;
     proxy_set_header    X-Forwarded-For     \$proxy_add_x_forwarded_for;
     proxy_set_header    X-Forwarded-Proto   \$scheme;
     proxy_pass http://gitlab-workhorse;

     ## The following settings only work with NGINX 1.7.11 or newer
     #
     ## Pass chunked request bodies to gitlab-workhorse as-is
     # proxy_request_buffering off;
     proxy_http_version 1.1;
   }

  ## Enable gzip compression as per rails guide:
  ## http://guides.rubyonrails.org/asset_pipeline.html#gzip-compression
  ## WARNING: If you are using relative urls remove the block below
  ## See config/application.rb under "Relative url support" for the list of
  ## other files that need to be changed for relative url support
  location ~ ^/(assets)/ {
    root /opt/gitlab/embedded/service/gitlab-rails/public;
    gzip_static on; # to serve pre-gzipped version
    expires max;
    add_header Cache-Control public;
  }

  ## To access Grafana
  location /-/grafana/ {
    proxy_pass http://localhost:3000/;
  }

  error_page 502 /502.html;
}
EOF

	    ln -s /etc/nginx/sites-available/gitlab.$CFG_HOSTNAME_DOMAIN.vhost /etc/nginx/sites-enabled/gitlab.$CFG_HOSTNAME_DOMAIN.vhost
	    ;;
    esac

    usermod -aG gitlab-www www-data

    #ssl cert generated
    systemctl stop nginx
    if [ "$CFG_SSL_NEW" == "yes" ]; then
	sh /root/.acme.sh/acme.sh --issue --standalone -d gitlab.$CFG_HOSTNAME_DOMAIN --force
    else
	#cp -av /home/administrator/wtlinux_server_setup/acme_ssl/arbajnok/gitlab.$CFG_HOSTNAME_DOMAIN /home/administrator/.acme.sh/
	cp -av /home/administrator/wtlinux_server_setup/acme_ssl/$CFG_HOSTNAME_DOMAIN/gitlab.$CFG_HOSTNAME_DOMAIN /root/.acme.sh/
    fi

    systemctl restart nginx

    cat >> /home/administrator/wtlinux_server_setup/wtserver_configuration.txt <<EOF
# Gitlab sever root admin passwords
#----------------------------
Mysql root password		: $CFG_GITLAB_ADMIN_PWD
#----------------------------
EOF

echo -e "[${green}DONE${NC}]\n"
}
