#---------------------------------------------------------------------
# Function: InstallWebStats
#    Install and configure web stats
#---------------------------------------------------------------------
InstallWebStats() {
    local start_time=$SECONDS
    echo -e "$IDENTATION_LVL_0 ${BWhite}Installing Web Statistics Tools${NC}"

    echo -n -e "$IDENTATION_LVL_1 Installing Required Components... "
    if apt_install vlogger geoip-database libclass-dbi-mysql-perl libtimedate-perl; then
        echo -e "[${green}DONE${NC}]"
    else
        echo -e "[${red}FAILED${NC}]"
        echo -e "$IDENTATION_LVL_1 ${red}Error: Failed to install required components.${NC}"
        return 1
    fi
    
    if [ "$CFG_WEBSTATS" == "yes" ]; then
        echo -n -e "$IDENTATION_LVL_1 Installing AWFFull... "
        if apt_install awffull; then
            echo -e "[${green}DONE${NC}]"
        else
            echo -e "[${red}FAILED${NC}]"
            echo -e "$IDENTATION_LVL_1 ${red}Error: Failed to install AWFFull.${NC}"
            return 1
        fi

        echo -n -e "$IDENTATION_LVL_1 Configuring AWFFull... "
        mkdir -p /etc/webalizer
        chmod 0755 /etc/webalizer
        ln -sf /etc/awffull/awffull.conf /etc/webalizer/webalizer.conf
        ln -sf /usr/bin/awffull /usr/bin/webalizer
        echo -e "[${green}DONE${NC}]"
        
        echo -n -e "$IDENTATION_LVL_1 Installing AWStats... "
        if apt_install awstats; then
            echo -e "[${green}DONE${NC}]"
        else
            echo -e "[${red}FAILED${NC}]"
            echo -e "$IDENTATION_LVL_1 ${red}Error: Failed to install AWStats.${NC}"
            return 1
        fi

        echo -n -e "$IDENTATION_LVL_1 Enabling AWStats Cron Job... "
        if sed -i 's/^/#/' /etc/cron.d/awstats; then
            echo -e "[${green}DONE${NC}]"
        else
            echo -e "[${red}FAILED${NC}]"
            echo -e "$IDENTATION_LVL_1 ${red}Error: Failed to enable AWStats cron job.${NC}"
            return 1
        fi
        
        # Install GoAccess
	echo -n -e "$IDENTATION_LVL_1 Installing GoAccess... "
	if wget -O - https://deb.goaccess.io/gnugpg.key | gpg --dearmor | tee /usr/share/keyrings/goaccess.gpg >>$PROGRAMS_INSTALL_LOG_FILES 2>&1 && \
	    echo "deb [signed-by=/usr/share/keyrings/goaccess.gpg arch=$(dpkg --print-architecture)] https://deb.goaccess.io/ $(lsb_release -cs) main" | tee /etc/apt/sources.list.d/goaccess.list && \
	    hide_output apt-get update && \
	    apt_install goaccess; then
	    echo -e "[${green}DONE${NC}]"
	else
	    echo -e "[${red}FAILED${NC}]"
	    echo -e "$IDENTATION_LVL_1 ${red}Error: Failed to install GoAccess.${NC}"
	    return 1
	fi
    fi

    MeasureTimeDuration $START_TIME
}

