#---------------------------------------------------------------------
# Function: InstallISPConfig
#    Start the ISPConfig3 installation script
#PHP 7.1 is supported by ISPConfig as additional PHP version, but not as main PHP version
#php 7.0 only install ISPConfig
#---------------------------------------------------------------------
InstallISPConfig() {
  echo "Installing ISPConfig3... "
  cd /tmp
  if [ "$CFG_ISPCVERSION" == "Beta" ]; then
	wget -O ISPConfig-3.1-beta.tar.gz  https://www.ispconfig.org/downloads/ISPConfig-3.1b2.tar.gz
	tar xfz ISPConfig-3.1-beta.tar.gz
	cd ispconfig3_install*
	cd install
  else
	wget https://www.ispconfig.org/downloads/ISPConfig-3-stable.tar.gz
	tar xfz ISPConfig-3-stable.tar.gz
	cd ispconfig3_install/install/
  fi
  if [ "$CFG_ISPC" == "standard" ]; then
  	echo "Create INI file"
	touch autoinstall.ini
	echo "[install]" > autoinstall.ini
	echo "language=en" >> autoinstall.ini
	echo "install_mode=$CFG_ISPC" >> autoinstall.ini
	echo "hostname=$CFG_HOSTNAME_FQDN" >> autoinstall.ini
	echo "mysql_hostname=localhost" >> autoinstall.ini
	echo "mysql_root_user=root" >> autoinstall.ini
	echo "mysql_root_password=$CFG_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_database=dbispconfig" >> autoinstall.ini
	echo "mysql_port=3306" >> autoinstall.ini
	echo "mysql_charset=utf8" >> autoinstall.ini
	if [ "$CFG_WEBSERVER" == "apache" ]; then
		echo "http_server=apache" >> autoinstall.ini
	elif [ "$CFG_WEBSERVER" == "nginx" ]; then
		echo "http_server=nginx" >> autoinstall.ini
	else
		echo "http_server=" >> autoinstall.ini
	fi
	echo "ispconfig_port=8888" >> autoinstall.ini
	echo "ispconfig_use_ssl=y" >> autoinstall.ini
	echo "ispconfig_admin_password=admin" >> autoinstall.ini
	echo
	echo "[ssl_cert]" >> autoinstall.ini
	echo "ssl_cert_country=$SSL_COUNTRY" >> autoinstall.ini
	echo "ssl_cert_state=$SSL_STATE" >> autoinstall.ini
	echo "ssl_cert_locality=$SSL_LOCALITY" >> autoinstall.ini
	echo "ssl_cert_organisation=$SSL_ORGANIZATION" >> autoinstall.ini
	echo "ssl_cert_organisation_unit=$SSL_ORGUNIT" >> autoinstall.ini
	echo "ssl_cert_common_name=$CFG_HOSTNAME_FQDN" >> autoinstall.ini
	echo
	echo "[expert]" >> autoinstall.ini
	echo "mysql_ispconfig_user=ispconfig" >> autoinstall.ini
	echo "mysql_ispconfig_password=bfSt3ratX8sgatBtxa52CadwfQ" >> autoinstall.ini
	echo "join_multiserver_setup=$MULTISERVER" >> autoinstall.ini
	echo "mysql_master_hostname=$CFG_MASTER_FQDN" >> autoinstall.ini
	echo "mysql_master_root_user=root" >> autoinstall.ini
	echo "mysql_master_root_password=$CFG_MASTER_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_database=dbispconfig" >> autoinstall.ini
	echo "configure_mail=$CFG_SETUP_MAIL" >> autoinstall.ini
	if [ "$CFG_SETUP_WEB" == "yes" ]; then
		echo "configure_jailkit=$CFG_JKIT" >> autoinstall.ini
	else
		echo "configure_jailkit=n" >> autoinstall.ini
	fi
	echo "configure_ftp=$CFG_SETUP_WEB" >> autoinstall.ini
	echo "configure_dns=$CFG_SETUP_NS" >> autoinstall.ini
	echo "configure_apache=$CFG_APACHE" >> autoinstall.ini
	echo "configure_nginx=$CFG_NGINX" >> autoinstall.ini
	echo "configure_firewall=y" >> autoinstall.ini
	echo "install_ispconfig_web_interface=$CFG_SETUP_MASTER" >> autoinstall.ini
	echo
	echo "[update]" >> autoinstall.ini
	echo "do_backup=yes" >> autoinstall.ini
	echo "mysql_root_password=$CFG_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_hostname=$CFG_MASTER_FQDN" >> autoinstall.ini
	echo "mysql_master_root_user=root" >> autoinstall.ini
	echo "mysql_master_root_password=$CFG_MASTER_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_database=dbispconfig" >> autoinstall.ini
	echo "reconfigure_permissions_in_master_database=no" >> autoinstall.ini
	echo "reconfigure_services=yes" >> autoinstall.ini
	echo "ispconfig_port=8888" >> autoinstall.ini
	echo "create_new_ispconfig_ssl_cert=no" >> autoinstall.ini
	echo "reconfigure_crontab=yes" >> autoinstall.ini
	echo | php -q install.php --autoinstall=autoinstall.ini
  elif [ "$CFG_MIRRORSERVER" = "yes" ] && [ "$CFG_SETUP_MASTER" = "n" ]; then
  	echo "Create INI file"
	touch autoinstall.ini
	echo "[install]" > autoinstall.ini
	echo "language=en" >> autoinstall.ini
	echo "install_mode=expert" >> autoinstall.ini
	echo "hostname=$CFG_HOSTNAME_FQDN" >> autoinstall.ini
	echo "mysql_hostname=localhost" >> autoinstall.ini
	echo "mysql_root_user=root" >> autoinstall.ini
	echo "mysql_root_password=$CFG_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_database=dbispconfig2" >> autoinstall.ini
	echo "mysql_port=3306" >> autoinstall.ini
	echo "mysql_charset=utf8" >> autoinstall.ini
	if [ $CFG_WEBSERVER == "apache" ]; then
		echo "http_server=apache" >> autoinstall.ini
	elif [ $CFG_WEBSERVER == "nginx" ]; then
		echo "http_server=nginx" >> autoinstall.ini
	else
		echo "http_server=" >> autoinstall.ini
	fi
	echo "ispconfig_port=8888" >> autoinstall.ini
	echo "ispconfig_use_ssl=y" >> autoinstall.ini
	echo
	echo "[ssl_cert]" >> autoinstall.ini
	echo "ssl_cert_country=$SSL_COUNTRY" >> autoinstall.ini
	echo "ssl_cert_state=$SSL_STATE" >> autoinstall.ini
	echo "ssl_cert_locality=$SSL_LOCALITY" >> autoinstall.ini
	echo "ssl_cert_organisation=$SSL_ORGANIZATION" >> autoinstall.ini
	echo "ssl_cert_organisation_unit=$SSL_ORGUNIT" >> autoinstall.ini
	echo "ssl_cert_common_name=$CFG_HOSTNAME_FQDN" >> autoinstall.ini
	echo
	echo "[expert]" >> autoinstall.ini
	echo "mysql_ispconfig_user=ispconfig2" >> autoinstall.ini
	echo "mysql_ispconfig_password=bfSt3ratX8sgatBtxa52CadwfQ" >> autoinstall.ini
	echo "join_multiserver_setup=y" >> autoinstall.ini
	echo "mysql_master_hostname=$CFG_MASTER_FQDN" >> autoinstall.ini
	echo "mysql_master_root_user=root" >> autoinstall.ini
	echo "mysql_master_root_password=$CFG_MASTER_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_database=dbispconfig" >> autoinstall.ini
	echo "configure_mail=$CFG_SETUP_MAIL" >> autoinstall.ini
	if [ $CFG_SETUP_WEB == "yes" ]; then
		echo "configure_jailkit=$CFG_JKIT" >> autoinstall.ini
	else
		echo "configure_jailkit=n" >> autoinstall.ini
	fi
	echo "configure_ftp=$CFG_SETUP_WEB" >> autoinstall.ini
	echo "configure_dns=$CFG_SETUP_NS" >> autoinstall.ini
	echo "configure_apache=$CFG_APACHE" >> autoinstall.ini
	echo "configure_nginx=$CFG_NGINX" >> autoinstall.ini
	echo "configure_firewall=y" >> autoinstall.ini
	echo "install_ispconfig_web_interface=$CFG_SETUP_MASTER" >> autoinstall.ini
	echo
	echo "[update]" >> autoinstall.ini
	echo "do_backup=yes" >> autoinstall.ini
	echo "mysql_root_password=$CFG_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_hostname=$CFG_MASTER_FQDN" >> autoinstall.ini
	echo "mysql_master_root_user=root" >> autoinstall.ini
	echo "mysql_master_root_password=$CFG_MASTER_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_database=dbispconfig" >> autoinstall.ini
	echo "reconfigure_permissions_in_master_database=no" >> autoinstall.ini
	echo "reconfigure_services=yes" >> autoinstall.ini
	echo "ispconfig_port=8888" >> autoinstall.ini
	echo "create_new_ispconfig_ssl_cert=no" >> autoinstall.ini
	echo "reconfigure_crontab=yes" >> autoinstall.ini
	echo | php -q install.php --autoinstall=autoinstall.ini
  else
	php -q install.php
  fi

## change app vhost port 8081 to 8083
# gitlab used 8081 port not work gitlab port change why?
sed -i "s/listen 8081;/listen 8083;/g" /etc/nginx/sites-available/apps.vhost
sed -i "s/listen \[::\]:8081 ipv6only=on;/listen \[::\]:8083 ipv6only=on;/" /etc/nginx/sites-available/apps.vhost

#ssl cert generated
#certbot certonly --agree-tos --non-interactive --renew-by-default --standalone --email wolftronics@wolftronics.hu -d cloud.wolftronics.hu
service nginx stop
#sh /home/administrator/.acme.sh/acme.sh --issue --standalone -d server1.wolftronics.hu

mkdir /usr/local/ispconfig/interface/ssl/self-signed_originals
mv /usr/local/ispconfig/interface/ssl/isp* /usr/local/ispconfig/interface/ssl/self-signed_originals
#ln -s /etc/letsencrypt/live/server1.wolftronics.hu/fullchain.pem /usr/local/ispconfig/interface/ssl/ispserver.crt
#ln -s /etc/letsencrypt/live/server1.wolftronics.hu/privkey.pem /usr/local/ispconfig/interface/ssl/ispserver.key
ln -s /root/.acme.sh/server1.wolftronics.hu/fullchain.cer /usr/local/ispconfig/interface/ssl/ispserver.crt
ln -s /root/.acme.sh/server1.wolftronics.hu/server1.wolftronics.hu.key /usr/local/ispconfig/interface/ssl/ispserver.key


  if [ $CFG_SETUP_WEB == "yes" ]; then
	if [ "$CFG_WEBSERVER" == "nginx" ]; then
	        echo -n "Restarting nginx... "
		restart_service nginx
	elif [ "$CFG_WEBSERVER" == "apache" ]; then
	echo -n "Restarting Apache... "
		restart_service apache2
	fi
        echo -e "[${green}DONE${NC}]\n"
  fi

cat >> /root/wtserver_configuration.txt <<EOF
# Ispconfig Store the passwords
Database user		 : root
Database password	 : $CFG_MYSQL_ROOT_PWD
Database master password : $CFG_MASTER_MYSQL_ROOT_PWD
Ispconfig port		 : 8888
Ispconfig app port	 : 8083

EOF
}
