#!/usr/bin/env bash
WT_BACKTITLE="ISPConfig 3 System Installer from Wolftronics"

# Bash Colour
red='\033[0;31m'
green='\033[0;32m'
NC='\033[0m' # No Color

#---------------------------------------------------------------------
# Load needed functions
#---------------------------------------------------------------------

#source $PWD/functions/functions.sh
source $PWD/functions/01_check_linux.sh
echo "Checking your system, please wait..."
CheckLinux

#---------------------------------------------------------------------
# Main program [ main() ]
#    Run the installer
#---------------------------------------------------------------------
clear

if [ -n "$PRETTY_NAME" ]; then
    echo -e "The detected Linux Distribution is: " $PRETTY_NAME
else
    echo -e "The detected Linux Distribution is: " $ID-$VERSION_ID
fi
echo
if [ -n "$DISTRO" ]; then
    read -p "Is this correct? (y/n)" -n 1 -r
    echo    # (optional) move to a new line
    if [[ ! $REPLY =~ ^[Yy]$ ]]
	then
	exit 1
    fi
else
    echo -e "Sorry but your System is not supported by this script, if you want your system supported "
    echo -e "open an issue on GitHub: https://gitlab.wolftronics.hu/wolftronics-linux/ispconfig_setup"
    exit 1
fi

while [ "x$CFG_SERVER_IP_DEF" == "x" ]
do
    CFG_SERVER_IP_DEF=$(whiptail --title "MULTISERVER SETUP" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Would you like to Server ip default?" 10 50 2 "yes" "(default ip)" ON "no" "(manual ip)" OFF 3>&1 1>&2 2>&3)
done

if [ "$CFG_SERVER_IP_DEF" == "yes" ]; then
    while [ "x$CFG_SERVER_MASTER_SLAVE" == "x" ]
    do
	CFG_SERVER_MASTER_SLAVE=$(whiptail --title "MULTISERVER SETUP Master slave ip settigs" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Server1 master or Server2 slave ip settings?" 10 50 2 "server1" "(default)" ON "server2" "" OFF 3>&1 1>&2 2>&3)
    done

    if [ "$CFG_SERVER_MASTER_SLAVE" == "server1" ]; then
	CFG_SERVER_IP_ADDRESS="192.168.0.240"
	CFG_SERVER_IP_NETMASK="255.255.0.0"
	CFG_SERVER_IP_NETWORK="192.168.0.0"
	CFG_SERVER_IP_GATEWAY="192.168.0.1"
	CFG_SERVER_IP_BROADCAST="192.168.0.255"
	CFG_SERVER_IP_DNS="8.8.8.8 8.8.4.4 192.168.0.1"
    else
	CFG_SERVER_IP_ADDRESS="192.168.0.106"
	CFG_SERVER_IP_NETMASK="255.255.0.0"
	CFG_SERVER_IP_NETWORK="192.168.0.0"
	CFG_SERVER_IP_GATEWAY="192.168.0.1"
	CFG_SERVER_IP_BROADCAST="192.168.0.255"
	CFG_SERVER_IP_DNS="8.8.8.8 8.8.4.4 192.168.0.1"
    fi
#else
#Manual ip setting feature
#    while [ "x$CFG_SERVER_IP_ADDRESS" == "x" ]
#    do
#	CFG_SERVER_IP_ADDRESS=$(whiptail --title "MULTISERVER SETUP Master slave ip settigs" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Server1 master or Server2 slave ip settings?" 10 50 2 "server1" "(default)" ON "server2" "" OFF 3>&1 1>&2 2>&3)
#    done
fi

hide_output apt-get update
apt_get_quiet upgrade

cat > /etc/network/interfaces <<EOF
auto lo
iface lo inet loopback
auto enp0s3
#ipv4 configuration
iface enp0s3 inet static
    address         $CFG_SERVER_IP_ADDRESS
    netmask         $CFG_SERVER_IP_NETMASK
    network         $CFG_SERVER_IP_NETWORK
    broadcast       $CFG_SERVER_IP_BROADCAST
    gateway         $CFG_SERVER_IP_GATEWAY
    dns-nameservers $CFG_SERVER_IP_DNS
#ipv6 configuration
#iface eth0 inet6 static
    #address 2000:da8:203:612:0:3:0:12
    #netmask 96
    #gateway 2000:da8:203:612:0:3:0:1

EOF

reboot