#---------------------------------------------------------------------
# Function: InstallMTA
#    Install chosen MTA (Courier or Dovecot)
#---------------------------------------------------------------------
InstallMTA() {
    local START_TIME=$SECONDS

    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing MTA${NC}\n"
    case $CFG_MTA in
	"courier")
	    echo -n -e "$IDENTATION_LVL_1 Installing ${red}Courier${NC}...\n"
	    echo -n -e "$IDENTATION_LVL_2 Preconfigure... "
	    echo "courier-base courier-base/webadmin-configmode boolean false" | debconf-set-selections
	    echo "courier-ssl courier-ssl/certnotice note" | debconf-set-selections
	    echo -e "[${green}DONE${NC}]"

	    echo -n -e "$IDENTATION_LVL_2 Installing Courier and dependecies... "
	    apt_install courier-authdaemon courier-authlib-mysql courier-pop courier-pop-ssl courier-imap courier-imap-ssl libsasl2-2 libsasl2-modules libsasl2-modules-sql sasl2-bin libpam-mysql courier-maildrop opendkim opendkim-tools
	    echo -e "[${green}DONE${NC}]"

	    echo -n -e "$IDENTATION_LVL_2 Config saslauthd... "
	    sed -i 's/START=no/START=yes/' /etc/default/saslauthd
	    echo -e "[${green}DONE${NC}]"

	    echo -n -e "$IDENTATION_LVL_2 Regenerate Certificates... "
	    cd /etc/courier
	    rm -f /etc/courier/imapd.pem
	    rm -f /etc/courier/pop3d.pem
	    rm -f /usr/lib/courier/imapd.pem
	    rm -f /usr/lib/courier/pop3d.pem
	    sed -i "s/CN=localhost/CN=${CFG_HOSTNAME_FQDN}/" /etc/courier/imapd.cnf
	    sed -i "s/CN=localhost/CN=${CFG_HOSTNAME_FQDN}/" /etc/courier/pop3d.cnf
	    mkimapdcert >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    mkpop3dcert >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    ln -s /usr/lib/courier/imapd.pem /etc/courier/imapd.pem
	    ln -s /usr/lib/courier/pop3d.pem /etc/courier/pop3d.pem
	    echo -e "[${green}DONE${NC}]"

	    echo -n -e "$IDENTATION_LVL_2 Restart MTA Services... "
	    service courier-imap-ssl restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    service courier-pop-ssl restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    service courier-authdaemon restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    service saslauthd restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    echo -e "[${green}DONE${NC}]"
	;;
	"dovecot")
	    echo -n -e "$IDENTATION_LVL_1 Installing POP3/IMAP Mail server ${red}Dovecot${NC} and Mail signing (OpenDKIM)...\n"
	    echo -n -e "$IDENTATION_LVL_2 Installing Dovecot and dependecies... "
	    apt_install dovecot-imapd dovecot-pop3d dovecot-mysql dovecot-sieve dovecot-lmtpd dovecot-managesieved dovecot-antispam opendkim opendkim-tools

	    # The `default_process_limit` is 100, which constrains the total number
	    # of active IMAP connections (at, say, 5 open connections per user that
	    # would be 20 users). Set it to 250 times the number of cores this
	    # machine has, so on a two-core machine that's 500 processes/100 users).
	    # The `default_vsz_limit` is the maximum amount of virtual memory that
	    # can be allocated. It should be set *reasonably high* to avoid allocation
	    # issues with larger mailboxes. We're setting it to 1/3 of the total
	    # available memory (physical mem + swap) to be sure.
	    # See here for discussion:
	    # - https://www.dovecot.org/list/dovecot/2012-August/137569.html
	    # - https://www.dovecot.org/list/dovecot/2011-December/132455.html
	    sed -i \
		-e "s/^#default_process_limit = .*/default_process_limit = $(($(nproc) * 250))/" \
		-e "s/^#default_client_limit = .*/default_client_limit = 1250/" \
		-e "s/^#default_vsz_limit = .*/default_vsz_limit = $(($(free -tm | tail -1 | awk '{print $2}') / 3))M/" \
		-e "/^#default_login_user =/a log_path = /var/log/mail.log" \
		"/etc/dovecot/conf.d/10-master.conf"
  
  	    sed -i 's/    #user =/    user = postfix/' /etc/dovecot/conf.d/10-master.conf
	    sed -i 's/    #group =/    group = postfix/' /etc/dovecot/conf.d/10-master.conf
	    
	    # The inotify `max_user_instances` default is 128, which constrains
	    # the total number of watched (IMAP IDLE push) folders by open connections.
	    # See http://www.dovecot.org/pipermail/dovecot/2013-March/088834.html.
	    # A reboot is required for this to take effect (which we don't do as
	    # as a part of setup). Test with `cat /proc/sys/fs/inotify/max_user_instances`.
	    sed -i '/^#*\s*fs\.inotify\.max_user_instances\s*=/d; $a\fs.inotify.max_user_instances=1024' /etc/sysctl.conf

	    # Set the location where we'll store user mailboxes. '%d' is the domain name and '%n' is the
	    # username part of the user's email address. We'll ensure that no bad domains or email addresses
	    # are created within the management daemon.
	    sed -i -E \
		-e 's/^mail_location\s*=\s*.*/mail_location = maildir:$STORAGE_ROOT\/mail\/mailboxes\/%d\/%n/' \
		-e 's/^mail_privileged_group\s*=\s*.*/mail_privileged_group = mail/' \
		-e 's/^#first_valid_uid\s*=\s*.*/first_valid_uid = 0/' \
		/etc/dovecot/conf.d/10-mail.conf
  
	    # Create, subscribe, and mark as special folders: INBOX, Drafts, Sent, Trash, Spam and Archive.
	    cp conf/dovecot-mailboxes.conf /etc/dovecot/conf.d/15-mailboxes.conf
	    sed -i "s/#mail_plugins =\(.*\)/mail_plugins =\1 \$mail_plugins quota/" /etc/dovecot/conf.d/10-mail.conf
	    if ! grep -q "mail_plugins.* imap_quota" /etc/dovecot/conf.d/20-imap.conf; then
		sed -i "s/\(mail_plugins =.*\)/\1\n  mail_plugins = \$mail_plugins imap_quota/" /etc/dovecot/conf.d/20-imap.conf
	    fi

	    # configure stuff for quota support
	    if ! grep -q "quota_status_success = DUNNO" /etc/dovecot/conf.d/90-quota.conf; then
		cat > /etc/dovecot/conf.d/90-quota.conf << EOF;
plugin {
  quota = maildir

  quota_grace = 10%%

  quota_status_success = DUNNO
  quota_status_nouser = DUNNO
  quota_status_overquota = "522 5.2.2 Mailbox is full"
}

service quota-status {
  executable = quota-status -p postfix
  inet_listener {
  port = 12340
  }
}
EOF
	    fi

	    # ### IMAP/POP

	    # Require that passwords are sent over SSL only, and allow the usual IMAP authentication mechanisms.
	    # The LOGIN mechanism is supposedly for Microsoft products like Outlook to do SMTP login (I guess
	    # since we're using Dovecot to handle SMTP authentication?).
	    sed -i -E \
		-e 's/^#?disable_plaintext_auth\s*=\s*.*/disable_plaintext_auth = yes/' \
		-e 's/^auth_mechanisms\s*=\s*.*/auth_mechanisms = plain login/' \
		/etc/dovecot/conf.d/10-auth.conf
    
	    # Enable SSL, specify the location of the SSL certificate and private key files.
	    # Use Mozilla's "Intermediate" recommendations at https://ssl-config.mozilla.org/#server=dovecot&server-version=2.3.7.2&config=intermediate&openssl-version=1.1.1,
	    # except that the current version of Dovecot does not have a TLSv1.3 setting, so we only use TLSv1.2.
	    sed -i -E \
		-e 's/^ssl\s*=\s*.*/ssl = required/' \
		-e 's|^ssl_cert\s*=\s*<.*|ssl_cert = <$STORAGE_ROOT/ssl/ssl_certificate.pem|' \
		-e 's|^ssl_key\s*=\s*<.*|ssl_key = <$STORAGE_ROOT/ssl/ssl_private_key.pem|' \
		-e 's/^#?ssl_min_protocol\s*=\s*.*/ssl_min_protocol = TLSv1.2/' \
		-e 's/^#?ssl_cipher_list\s*=\s*.*/ssl_cipher_list = ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384/' \
		-e 's/^#?ssl_prefer_server_ciphers\s*=\s*.*/ssl_prefer_server_ciphers = yes/' \
		-e 's|^#?ssl_dh\s*=\s*<.*|ssl_dh = <$STORAGE_ROOT/ssl/dh4096.pem|' \
		/etc/dovecot/conf.d/10-ssl.conf

	    # Disable in-the-clear IMAP/POP because there is no reason for a user to transmit
	    # login credentials outside of an encrypted connection. Only the over-TLS versions
	    # are made available (IMAPS on port 993; POP3S on port 995).
	    sed -i "s/#port = 143/port = 0/" /etc/dovecot/conf.d/10-master.conf
	    sed -i "s/#port = 110/port = 0/" /etc/dovecot/conf.d/10-master.conf   


	    # Make IMAP IDLE slightly more efficient. By default, Dovecot says "still here"
	    # every two minutes. With K-9 mail, the bandwidth and battery usage due to
	    # this are minimal. But for good measure, let's go to 4 minutes to halve the
	    # bandwidth and number of times the device's networking might be woken up.
	    # The risk is that if the connection is silent for too long it might be reset
	    # by a peer. See [#129](https://github.com/mail-in-a-box/mailinabox/issues/129)
	    # and [How bad is IMAP IDLE](http://razor.occams.info/blog/2014/08/09/how-bad-is-imap-idle/).
	    sed -i -E 's/^#?imap_idle_notify_interval\s*=\s*.*/imap_idle_notify_interval = 4 mins/' /etc/dovecot/conf.d/20-imap.conf

	    # Set POP3 UIDL.
	    # UIDLs are used by POP3 clients to keep track of what messages they've downloaded.
	    # For new POP3 servers, the easiest way to set up UIDLs is to use IMAP's UIDVALIDITY
	    # and UID values, the default in Dovecot.
	    sed -i -E 's/^#?pop3_uidl_format\s*=\s*.*/pop3_uidl_format = %08Xu%08Xv/' /etc/dovecot/conf.d/20-pop3.conf

	    # ### LDA (LMTP)

	    # Enable Dovecot's LDA service with the LMTP protocol. It will listen
	    # on port 10026, and Spamassassin will be configured to pass mail there.
	    #
	    # The disabled unix socket listener is normally how Postfix and Dovecot
	    # would communicate (see the Postfix setup script for the corresponding
	    # setting also commented out).
	    #
	    # Also increase the number of allowed IMAP connections per mailbox because
	    # we all have so many devices lately.
	    cat > /etc/dovecot/conf.d/99-local.conf << EOF;
service lmtp {
  #unix_listener /var/spool/postfix/private/dovecot-lmtp {
  #  user = postfix
  #  group = postfix
  #}
  inet_listener lmtp {
    address = 127.0.0.1
    port = 10026
  }
}

# Enable imap-login on localhost to allow the user_external plugin
# for Nextcloud to do imap authentication. (See #1577)
service imap-login {
  inet_listener imap {
    address = 127.0.0.1
    port = 143
  }
}
protocol imap {
  mail_max_userip_connections = 40
}
EOF
		
	    # Setting a `postmaster_address` is required or LMTP won't start. An alias
	    # will be created automatically by our management daemon.
	    sed -i -E 's/^#?postmaster_address\s*=\s*.*/postmaster_address = postmaster@$CFG_HOSTNAME_DOMAIN/' /etc/dovecot/conf.d/15-lda.conf

	    # ### Sieve

	    # Enable the Dovecot sieve plugin which let's users run scripts that process
	    # mail as it comes in.
	    sed -i "s/#mail_plugins = .*/mail_plugins = \$mail_plugins sieve/" /etc/dovecot/conf.d/20-lmtp.conf

	    # Configure sieve. We'll create a global script that moves mail marked
	    # as spam by Spamassassin into the user's Spam folder.
	    #
	    # * `sieve_before`: The path to our global sieve which handles moving spam to the Spam folder.
	    #
	    # * `sieve_before2`: The path to our global sieve directory for sieve which can contain .sieve files
	    # to run globally for every user before their own sieve files run.
	    #
	    # * `sieve_after`: The path to our global sieve directory which can contain .sieve files
	    # to run globally for every user after their own sieve files run.
	    #
	    # * `sieve`: The path to the user's main active script. ManageSieve will create a symbolic
	    # link here to the actual sieve script. It should not be in the mailbox directory
	    # (because then it might appear as a folder) and it should not be in the sieve_dir
	    # (because then I suppose it might appear to the user as one of their scripts).
	    #
	    # * `sieve_dir`: Directory for :personal include scripts for the include extension. This
	    # is also where the ManageSieve service stores the user's scripts.
	    cat > /etc/dovecot/conf.d/99-local-sieve.conf << EOF;
plugin {
  sieve_max_redirects = 25
  sieve_extensions = +notify +imapflags +editheader
  sieve_before = $STORAGE_ROOT/mail/sieve/global_before
  sieve_after = /etc/dovecot/sieve-spam.sieve
  sieve_after2 = $STORAGE_ROOT/mail/sieve/global_after
  sieve = $STORAGE_ROOT/mail/sieve/%d/%n.sieve
  sieve_dir = $STORAGE_ROOT/mail/sieve/%d/%n
  sieve_redirect_envelope_from = recipient
}
EOF

	    # Copy the global sieve script into where we've told Dovecot to look for it. Then
	    # compile it. Global scripts must be compiled now because Dovecot won't have
	    # permission later.
	    cp conf/sieve-spam.txt /etc/dovecot/sieve-spam.sieve
	    sievec /etc/dovecot/sieve-spam.sieve

	    # ### Permissions

	    # Ensure configuration files are owned by dovecot and not world readable.
	    chown -R mail:dovecot /etc/dovecot
	    chmod -R o-rwx /etc/dovecot

	    # Ensure mailbox files have a directory that exists and are owned by the mail user.
	    mkdir -p "$STORAGE_ROOT/mail/mailboxes"
	    mkdir -p "$STORAGE_ROOT/mail/homes"
	    chown -R mail:mail "$STORAGE_ROOT/mail/mailboxes"
	    chown -R mail:mail "$STORAGE_ROOT/mail/homes"

	    # Same for the sieve scripts.
	    mkdir -p "$STORAGE_ROOT/mail/sieve"
	    mkdir -p "$STORAGE_ROOT/mail/sieve/global_before"
	    mkdir -p "$STORAGE_ROOT/mail/sieve/global_after"
	    chown -R mail:mail "$STORAGE_ROOT/mail/sieve"

	    # Allow the IMAP/POP ports in the firewall.
	    #ufw_allow imaps
	    #ufw_allow pop3s
	    ufw allow imaps > /dev/null;
	    ufw allow pop3s > /dev/null;
	    # Allow the Sieve port in the firewall.
	    #ufw_allow sieve
	    ufw allow pop3s > /dev/null;

	    # Restart services
	    restart_service dovecot	
	    echo -e "[${green}DONE${NC}]"
	    
	    # IMAP search with xapian
	    # --------------------------------
	    #
	    # By default dovecot uses its own Squat search index that has awful performance
	    # on large mailboxes and is obsolete. Dovecot 2.1+ has support for using Lucene 
	    # internally. Solr uses too much memory. Same goes for elasticsearch.
	    # fts xapian might be a good match. See https://github.com/grosjo/fts-xapian

	    # Install and configure fts-xapian for better search performance
	    echo -n -e "$IDENTATION_LVL_2 Installing fts-xapian... "
	    apt_install dovecot-fts-xapian

	    # Update the dovecot plugin configuration
	    #sed -i "s/#mail_plugins =\(.*\)/mail_plugins =\1 \$mail_plugins quota/" /etc/dovecot/conf.d/10-mail.conf

	    if ! grep -q "mail_plugins.* fts fts_xapian" /etc/dovecot/conf.d/10-mail.conf; then
	       sed -i "s/\(mail_plugins =.*\)/\1\n  mail_plugins = \$mail_plugins fts fts_xapian/" /etc/dovecot/conf.d/10-mail.conf
	    fi

	    # Install cronjobs to keep FTS up to date
	    hide_output install -m 755 conf/cron/miab_dovecot /etc/cron.daily/

	    # Install files
	    if [ ! -f /usr/lib/dovecot/decode2text.sh ]; then
		cp -f /usr/share/doc/dovecot-core/examples/decode2text.sh /usr/lib/dovecot
	    fi

	    # Install text decoder utilities
	    apt_install poppler-utils catdoc unzip

	    # Create configuration file
	    cat > /etc/dovecot/conf.d/90-plugin-fts.conf << EOF;
plugin {
  plugin = fts fts_xapian
  
  fts = xapian
  fts_xapian = partial=3 full=20 verbose=0

  fts_autoindex = yes
  fts_enforced = yes

  fts_autoindex_exclude = \Trash
  fts_autoindex_exclude2 = \Junk
  fts_autoindex_exclude3 = \Spam
  
  fts_decoder = decode2text
}

service indexer-worker {
	vsz_limit = 2G
}

service decode2text {
   executable = script /usr/lib/dovecot/decode2text.sh
   user = dovecot
   unix_listener decode2text {
     mode = 0666
   }
}
EOF

	    restart_service dovecot

	    # Kickoff building the index

	    # Per doveadm-fts manpage: Scan what mails exist in the full text search index
	    # and compare those to what actually exist in mailboxes.
	    # This removes mails from the index that have already been expunged and makes
	    # sure that the next doveadm index will index all the missing mails (if any).
	    hide_output doveadm fts rescan -A

	    # Adds unindexed files to the fts database
	    #
	    # * `-q`: Queues the indexing to be run by indexer process. (will background the indexing)
	    # * `-A`: All users
	    # * `'*'`: All folders
	    doveadm index -A -q \*

	;;
    esac

    MeasureTimeDuration $START_TIME
}
