InstallPhp55() {
### Install PHP 5.5.38 on Ubuntu 16.04 64Bits
### https://www.howtoforge.com/tutorial/how-to-install-php-5-6-on-ubuntu-16-04/
echo -n "Installing Php 5.5.38... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-5.5.38
mkdir /usr/local/src/php5-build
cd /usr/local/src/php5-build
wget http://br1.php.net/get/php-5.5.38.tar.bz2/from/this/mirror -O php-5.5.38.tar.bz2
tar jxf php-5.5.38.tar.bz2

cd php-5.5.38/
./configure --prefix=/opt/php-5.5.38 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-intl --enable-calendar --with-curl --with-mcrypt --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-mysql --with-pdo-mysql --with-mysqli --with-jpeg-dir=/usr --with-png-dir=/usr \
--enable-gd-native-ttf --with-openssl --with-fpm-user=www-data --with-fpm-group=www-data \
--with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl --with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php5-build/php-5.5.38/php.ini-production /opt/php-5.5.38/lib/php.ini
cp /opt/php-5.5.38/etc/php-fpm.conf.default /opt/php-5.5.38/etc/php-fpm.conf
mkdir /opt/php-5.5.38/etc/php-fpm.d

echo "[Unit]
Description=The PHP 5.5.38 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-5.5.38/var/run/php-fpm.pid
ExecStart=/opt/php-5.5.38/sbin/php-fpm --nodaemonize --fpm-config /opt/php-5.5.38/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-5.5.38-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-5.5.38/lib/php.ini

## Modified ini do PHP
for i in /opt/php-5.5.38/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'America\/Sao_Paulo'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-5.5.38/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8996|" /opt/php-5.5.38/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-5.5.38/etc/php-fpm.d/\*.conf|" /opt/php-5.5.38/etc/php-fpm.conf

systemctl enable php-5.5.38-fpm.service
systemctl daemon-reload
systemctl start php-5.5.38-fpm.service

#/opt/php-5.5.38/bin/php-cgi
#/opt/php-5.5.38/lib
#php-5.5.38-fpm
#/opt/php-5.5.38/lib
#/opt/php-5.5.38/etc/php-fpm.d

echo -e "[${green}DONE${NC}]"
}

InstallPhp56() {
### Install PHP 5.6.40
### https://www.howtoforge.com/tutorial/how-to-install-php-5-6-on-ubuntu-16-04/
echo -n "Installing Php 5.6.40... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev 
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-5.6.40
mkdir /usr/local/src/php5-build
cd /usr/local/src/php5-build
wget http://us1.php.net/get/php-5.6.40.tar.bz2/from/this/mirror -O php-5.6.40.tar.bz2
tar jxf php-5.6.40.tar.bz2

cd php-5.6.40/
./configure --prefix=/opt/php-5.6.40 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-intl --enable-calendar --with-curl --with-mcrypt --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-mysql --with-pdo-mysql --with-mysqli --with-jpeg-dir=/usr --with-png-dir=/usr \
--enable-gd-native-ttf --with-openssl --with-fpm-user=www-data --with-fpm-group=www-data \
--with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl --with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php5-build/php-5.6.40/php.ini-production /opt/php-5.6.40/lib/php.ini
cp /opt/php-5.6.40/etc/php-fpm.conf.default /opt/php-5.6.40/etc/php-fpm.conf
mkdir /opt/php-5.6.40/etc/php-fpm.d

echo "[Unit]
Description=The PHP 5.6 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-5.6.40/var/run/php-fpm.pid
ExecStart=/opt/php-5.6.40/sbin/php-fpm --nodaemonize --fpm-config /opt/php-5.6.31/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-5.6.40-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-5.6.40/lib/php.ini

## Modified ini do PHP
for i in /opt/php-5.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-5.6.40/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8997|" /opt/php-5.6.40/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-5.6.40/etc/php-fpm.d/\*.conf|" /opt/php-5.6.40/etc/php-fpm.conf

systemctl enable php-5.6.40-fpm.service
systemctl daemon-reload
systemctl start php-5.6.40-fpm.service

echo -e "[${green}DONE${NC}]\n"
}

InstallPhp70() {
### Install PHP 7.0.33
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
echo -n "Installing Php 7.0.33... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-7.0.33
mkdir /usr/local/src/php7-build
cd /usr/local/src/php7-build
wget http://us1.php.net/get/php-7.0.33.tar.bz2/from/this/mirror -O php-7.0.33.tar.bz2
tar jxf php-7.0.33.tar.bz2

cd php-7.0.33/
./configure --prefix=/opt/php-7.0.33 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-calendar --with-curl --with-mcrypt --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-pdo-mysql --with-mysqli -with-mysql-sock=/var/run/mysqld/mysqld.sock \
--with-jpeg-dir=/usr --with-png-dir=/usr --enable-gd-native-ttf --with-openssl --with-fpm-user=www-data \
--with-fpm-group=www-data --with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl \
--with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-opcache --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php7-build/php-7.0.33/php.ini-production /opt/php-7.0.33/lib/php.ini
cp /opt/php-7.0.33/etc/php-fpm.conf.default /opt/php-7.0.33/etc/php-fpm.conf
mkdir /opt/php-7.0.33/etc/php-fpm.d

echo "[Unit]
Description=The PHP 7.0 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-7.0.33/var/run/php-fpm.pid
ExecStart=/opt/php-7.0.33/sbin/php-fpm --nodaemonize --fpm-config /opt/php-7.0.33/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-7.0.33-fpm.service


echo 'zend_extension=opcache.so' >> /opt/php-7.0.33/lib/php.ini

## Modified ini do PHP
for i in /opt/php-7.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-7.0.33/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8998|" /opt/php-7.0.33/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-7.0.33/etc/php-fpm.d/\*.conf|" /opt/php-7.0.33/etc/php-fpm.conf

systemctl enable php-7.0.33-fpm.service
systemctl daemon-reload
systemctl start php-7.0.33-fpm.service

echo -e "[${green}DONE${NC}]\n"
}

InstallPhp71() {
### Install PHP 7.1.33
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
echo -n "Installing Php 7.1.33... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev 
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-7.1.33
mkdir /usr/local/src/php7-build
cd /usr/local/src/php7-build
wget http://us1.php.net/get/php-7.1.33.tar.bz2/from/this/mirror -O php-7.1.33.tar.bz2
tar jxf php-7.1.33.tar.bz2

cd php-7.1.33/
./configure --prefix=/opt/php-7.1.33 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-calendar --with-curl --with-mcrypt --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-pdo-mysql --with-mysqli -with-mysql-sock=/var/run/mysqld/mysqld.sock \
--with-jpeg-dir=/usr --with-png-dir=/usr --enable-gd-native-ttf --with-openssl --with-fpm-user=www-data \
--with-fpm-group=www-data --with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl \
--with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-opcache --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php7-build/php-7.1.33/php.ini-production /opt/php-7.1.33/lib/php.ini
cp /opt/php-7.1.33/etc/php-fpm.conf.default /opt/php-7.1.33/etc/php-fpm.conf
mkdir /opt/php-7.1.33/etc/php-fpm.d

echo "[Unit]
Description=The PHP 7.1 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-7.1.33/var/run/php-fpm.pid
ExecStart=/opt/php-7.1.33/sbin/php-fpm --nodaemonize --fpm-config /opt/php-7.1.33/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-7.1.33-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-7.1.33/lib/php.ini

## Modified ini do PHP
for i in /opt/php-7.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-7.1.33/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8998|" /opt/php-7.1.33/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-7.1.33/etc/php-fpm.d/\*.conf|" /opt/php-7.1.33/etc/php-fpm.conf

systemctl enable php-7.1.33-fpm.service
systemctl daemon-reload
systemctl start php-7.1.33-fpm.service

echo -e "[${green}DONE${NC}]\n"
}

InstallPhp72() {
### Install PHP 7.2.34
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
echo -n "Installing Php 7.2.34... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-7.2.34
mkdir /usr/local/src/php7-build
cd /usr/local/src/php7-build
wget http://us1.php.net/get/php-7.2.34.tar.bz2/from/this/mirror -O php-7.2.34.tar.bz2
tar jxf php-7.2.34.tar.bz2

cd php-7.2.34/
./configure --prefix=/opt/php-7.2.34 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-calendar --with-curl --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-pdo-mysql --with-mysqli -with-mysql-sock=/var/run/mysqld/mysqld.sock \
--with-jpeg-dir=/usr --with-png-dir=/usr --with-openssl --with-fpm-user=www-data \
--with-fpm-group=www-data --with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl \
--with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-opcache --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php7-build/php-7.2.34/php.ini-production /opt/php-7.2.34/lib/php.ini
cp /opt/php-7.2.34/etc/php-fpm.conf.default /opt/php-7.2.34/etc/php-fpm.conf
mkdir /opt/php-7.2.34/etc/php-fpm.d

echo "[Unit]
Description=The PHP 7.2 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-7.2.34/var/run/php-fpm.pid
ExecStart=/opt/php-7.2.34/sbin/php-fpm --nodaemonize --fpm-config /opt/php-7.2.34/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-7.2.34-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-7.2.34/lib/php.ini

## Modified ini do PHP
for i in /opt/php-7.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-7.2.34/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8999|" /opt/php-7.2.34/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-7.2.14/etc/php-fpm.d/\*.conf|" /opt/php-7.2.34/etc/php-fpm.conf

systemctl enable php-7.2.34-fpm.service
systemctl daemon-reload
systemctl start php-7.2.34-fpm.service

echo -e "[${green}DONE${NC}]\n"
}

InstallPhp73() {
### Install PHP 7.3.33
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
echo -n "Installing Php 7.3.33... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev re2c libbison-dev libzip-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-7.3.33
mkdir /usr/local/src/php7-build
cd /usr/local/src/php7-build
wget http://us1.php.net/get/php-7.3.33.tar.bz2/from/this/mirror -O php-7.3.33.tar.bz2
tar jxf php-7.3.33.tar.bz2

cd php-7.3.33/
./configure --prefix=/opt/php-7.3.33 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-calendar --with-curl --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-pdo-mysql --with-mysqli -with-mysql-sock=/var/run/mysqld/mysqld.sock \
--with-jpeg-dir=/usr --with-png-dir=/usr --with-openssl --with-fpm-user=www-data \
--with-fpm-group=www-data --with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl \
--with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-opcache --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php7-build/php-7.3.33/php.ini-production /opt/php-7.3.33/lib/php.ini
cp /opt/php-7.3.33/etc/php-fpm.conf.default /opt/php-7.3.33/etc/php-fpm.conf
mkdir /opt/php-7.3.33/etc/php-fpm.d

echo "[Unit]
Description=The PHP 7.3 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-7.3.33/var/run/php-fpm.pid
ExecStart=/opt/php-7.3.33/sbin/php-fpm --nodaemonize --fpm-config /opt/php-7.3.33/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-7.3.33-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-7.3.33/lib/php.ini

## Modified ini do PHP
for i in /opt/php-7.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-7.3.33/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8999|" /opt/php-7.3.33/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-7.3.1/etc/php-fpm.d/\*.conf|" /opt/php-7.3.33/etc/php-fpm.conf

systemctl enable php-7.3.33-fpm.service
systemctl daemon-reload
systemctl start php-7.3.33-fpm.service

echo -e "[${green}DONE${NC}]\n"

InstallPhp74() {
### Install PHP 7.4.33
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
echo -n "Installing Php 7.4.33... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev re2c libbison-dev libzip-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-7.4.33
mkdir /usr/local/src/php7-build
cd /usr/local/src/php7-build
wget http://us1.php.net/get/php-7.4.33.tar.bz2/from/this/mirror -O php-7.4.33.tar.bz2
tar jxf php-7.4.33.tar.bz2

cd php-7.4.33/
./configure --prefix=/opt/php-7.4.33 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-calendar --with-curl --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-pdo-mysql --with-mysqli -with-mysql-sock=/var/run/mysqld/mysqld.sock \
--with-jpeg-dir=/usr --with-png-dir=/usr --with-openssl --with-fpm-user=www-data \
--with-fpm-group=www-data --with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl \
--with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-opcache --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php7-build/php-7.4.33/php.ini-production /opt/php-7.4.33/lib/php.ini
cp /opt/php-7.4.33/etc/php-fpm.conf.default /opt/php-7.4.33/etc/php-fpm.conf
mkdir /opt/php-7.4.33/etc/php-fpm.d

echo "[Unit]
Description=The PHP 7.4 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-7.4.33/var/run/php-fpm.pid
ExecStart=/opt/php-7.4.33/sbin/php-fpm --nodaemonize --fpm-config /opt/php-7.4.33/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-7.4.33-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-7.4.33/lib/php.ini

## Modified ini do PHP
for i in /opt/php-7.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-7.4.33/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8999|" /opt/php-7.4.33/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-7.3.1/etc/php-fpm.d/\*.conf|" /opt/php-7.4.33/etc/php-fpm.conf

systemctl enable php-7.4.33-fpm.service
systemctl daemon-reload
systemctl start php-7.4.33-fpm.service

echo -e "[${green}DONE${NC}]\n"

InstallPhp81() {
### Install PHP 8.1.31
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
echo -n "Installing Php 8.1.31... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev re2c libbison-dev libzip-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-8.1.31
mkdir /usr/local/src/php8-build
cd /usr/local/src/php8-build
wget http://us1.php.net/get/php-8.1.31.tar.bz2/from/this/mirror -O php-8.1.31.tar.bz2
tar jxf php-8.1.31.tar.bz2

cd php-8.1.31/
./configure --prefix=/opt/php-8.1.31 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-calendar --with-curl --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-pdo-mysql --with-mysqli -with-mysql-sock=/var/run/mysqld/mysqld.sock \
--with-jpeg-dir=/usr --with-png-dir=/usr --with-openssl --with-fpm-user=www-data \
--with-fpm-group=www-data --with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl \
--with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-opcache --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php7-build/php-8.1.31/php.ini-production /opt/php-8.1.31/lib/php.ini
cp /opt/php-8.1.31/etc/php-fpm.conf.default /opt/php-8.1.31/etc/php-fpm.conf
mkdir /opt/php-8.1.31/etc/php-fpm.d

echo "[Unit]
Description=The PHP 8.1 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-8.1.31/var/run/php-fpm.pid
ExecStart=/opt/php-8.1.31/sbin/php-fpm --nodaemonize --fpm-config /opt/php-8.1.31/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-8.1.31-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-8.1.31/lib/php.ini

## Modified ini do PHP
for i in /opt/php-8.*/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'Europe\/Budapest'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-8.1.31/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8999|" /opt/php-8.1.31/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-7.3.1/etc/php-fpm.d/\*.conf|" /opt/php-8.1.31/etc/php-fpm.conf

systemctl enable php-8.1.31-fpm.service
systemctl daemon-reload
systemctl start php-8.1.31-fpm.service

echo -e "[${green}DONE${NC}]\n"
}
