#---------------------------------------------------------------------
# Function: PreInstallCheck
#	Do some pre-install checks
#---------------------------------------------------------------------
PreInstallCheck() {
  START_TIME=$SECONDS

  echo -n -e "$IDENTATION_LVL_0 ${BWhite}Check the stuffs before install ${NC} \n"

#if [[ "$#" -ne 0 ]]; then
#	echo -e "Usage: sudo $0" >&2
#	exit 1
#fi
  echo -n -e "$IDENTATION_LVL_1 Check if current user is root"
# Check if user is root
  if [[ $(id -u) -ne 0 ]]; then # $EUID
	#echo -e "${red}Error: This script must be run as root, please run this script again with the root user or sudo.${NC}" >&2
	echo -e " [ ${red}Error${NC}: You must be root to run this script, please use the root user to install the software ]"
	exit 1
  fi

# Check if on Linux
#if ! echo "$OSTYPE" | grep -iq "linux"; then
#	echo -e "${red}Error: This script must be run on Linux.${NC}" >&2
#	exit 1
#fi
  echo -e " [ ${green}OK${NC} ]"

  # Check memory
  echo -n -e "$IDENTATION_LVL_1 Check Available RAM Memory"

  # Check memory
  TOTAL_PHYSICAL_MEM=$(awk '/^MemTotal:/ {print $2}' /proc/meminfo)
  TOTAL_SWAP=$(awk '/^SwapTotal:/ {print $2}' /proc/meminfo)

  if [ "$TOTAL_PHYSICAL_MEM" -lt 524288 ]; then
	echo "This machine has: $(printf "%'d" $((TOTAL_PHYSICAL_MEM / 1024))) MiB ($(printf "%'d" $((((TOTAL_PHYSICAL_MEM * 1024) / 1000) / 1000))) MB) memory (RAM)."
	echo -e "\n${red}Error: ISPConfig needs more memory to function properly. Please run this script on a machine with at least 512 MiB memory, 1 GiB (1024 MiB) recommended.${NC}" >&2
	exit 1
  fi

  # Check connectivity
  echo -n "$IDENTATION_LVL_1 Check if we can reach the ISPConfig servers..."
  ping -q -c 3 www.ispconfig.org >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
  if [ ! "$?" -eq 0 ]; then
    echo -e "[ ${red}ERROR ${NC} : Couldn't reach www.ispconfig.org, please check your internet connection and run this script again. ${NC} ]"
    exit 1
  else
    echo -e " [ ${green}OK${NC} ]"
  fi

  echo -n "$IDENTATION_LVL_1 Check if a previous version of ISPConfig is installed ... "
  # Check for already installed ispconfig version
  if [ -f /usr/local/ispconfig/interface/lib/config.inc.php ]; then
    echo -e "[ ${red}ERROR ${NC} : ISPConfig is already installed, can't go on${NC} ]"
    exit 1
  else
    echo -e " [ ${green}OK${NC} ]"
  fi

#	echo -n "Preparing to install... "
	# Check source.list
#	contrib=$(grep 'contrib' /etc/apt/sources.list | grep -v "cdrom")
#	nonfree=$(grep 'non-free' /etc/apt/sources.list | grep -v "cdrom")
#	if [ -z "$contrib" ]; then
#		if [ -z "$nonfree" ]; then
#			sed -i 's/main/main contrib non-free/' /etc/apt/sources.list;
#		else
#			sed -i 's/main/main contrib/' /etc/apt/sources.list;
#		fi
#	else
#		if [ -z "$nonfree" ]; then
#			sed -i 's/main/main non-free/' /etc/apt/sources.list;
#		fi
#	fi
#	echo -e "[${green}DONE${NC}]\n"

  MeasureTimeDuration $START_TIME
}


