#---------------------------------------------------------------------
# Function: InstallSQLServer
#    Install and configure SQL Server (MySQL or MariaDB)
#---------------------------------------------------------------------
InstallSQLServer() {
    local START_TIME=$SECONDS

    if [ $CFG_SQLSERVER == "MySQL" ]; then
	echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing MySQL${NC}\n"	
	echo -n -e "$IDENTATION_LVL_1 Selected version: ${BBlack}$CFG_MYSQL_VERSION${NC}\n"

	SHOULD_INSTALL_MYSQL=true
	export DEBIAN_FRONTEND=noninteractive

        case "$CFG_MYSQL_VERSION" in
            "default")
		echo -n -e "$IDENTATION_LVL_1 Setting debconf selections... "
		echo "mysql-server-5.5 mysql-server/root_password password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
		echo "mysql-server-5.5 mysql-server/root_password_again password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
		echo -e "[${green}DONE${NC}]"
		;;

            "5.6")
		echo -n -e "$IDENTATION_LVL_1 Downloading MySQL APT Config [${BBlack}Version 0.8.14-1_all ${NC}]... "
		wget -q -O "$PROGRAMS_INSTALL_DOWNLOAD/mysql-apt-config-all.deb" "https://repo.mysql.com/mysql-apt-config_0.8.14-1_all.deb"
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 Setting debconf selections... "
		#echo "mysql-apt-config mysql-apt-config/select-product select Ok" | debconf-set-selections
		echo "mysql-apt-config mysql-apt-config/select-tools select  Enabled" | debconf-set-selections
		echo "mysql-apt-config mysql-apt-config/select-server select mysql-5.6" | debconf-set-selections
		echo "mysql-apt-config mysql-apt-config/select-preview select Disabled" | debconf-set-selections
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 Running MySQL APT Config... "
		dpkg -i $PROGRAMS_INSTALL_DOWNLOAD/mysql-apt-config-all.deb >> $PROGRAMS_INSTALL_LOG_FILES 2>&1	
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 Updating package list... "
		apt_update
		echo -e "[${green}DONE${NC}]"

		echo "mysql-community-server mysql-community-server/root-pass password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
		echo "mysql-community-server mysql-community-server/re-root-pass password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
		;;

            "5.7" | "8.0")
		MYSQLAPTVER="`wget -q -O - https://repo.mysql.com/|grep -E -o 'mysql-apt-config_([0-9]|[\.-])+_all\.deb' | tail -1`"

		echo -n -e "$IDENTATION_LVL_1 Downloading MySQL APT Config [${BBlack}Version $MYSQLAPTVER ${NC}]... "
		wget -q -O "$PROGRAMS_INSTALL_DOWNLOAD/mysql-apt-config-all.deb" "https://repo.mysql.com/$MYSQLAPTVER"
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 Setting debconf selections... "
		echo "mysql-apt-config mysql-apt-config/select-preview select Disabled" | debconf-set-selections
		echo "mysql-apt-config mysql-apt-config/select-tools select  Enabled" | debconf-set-selections
		echo "mysql-apt-config mysql-apt-config/select-server select mysql-$CFG_MYSQL_VERSION" | debconf-set-selections
		#echo "mysql-apt-config mysql-apt-config/select-product select Ok" | debconf-set-selections
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 Running MySQL APT Config... "
		dpkg -i $PROGRAMS_INSTALL_DOWNLOAD/mysql-apt-config-all.deb >> $PROGRAMS_INSTALL_LOG_FILES 2>&1	
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 Updating package list... "
		apt_update
		echo -e "[${green}DONE${NC}]"

		echo -n -e "$IDENTATION_LVL_1 SSetting MySQL root password... "
		echo "mysql-community-server mysql-community-server/root-pass password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
		echo "mysql-community-server mysql-community-server/re-root-pass password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
		echo -e "[${green}DONE${NC}]"
		;;
            *)
                echo -n "$IDENTATION_LVL_0 MySQL version NOT SUPPORTED"
                SHOULD_INSTALL_MYSQL=false
                ;;
        esac
		
	if [ $SHOULD_INSTALL_MYSQL == true ]; then
	    echo -n -e "$IDENTATION_LVL_1 Installing MySQL Server & Client... "
	    apt_install mysql-client mysql-server
	    echo -e "[${green}DONE${NC}]"

	    echo -n -e "$IDENTATION_LVL_1 Configuring MySQL... "
	    if [ -d /etc/mysql/mysql.conf.d ]; then
		CNF_DEST="/etc/mysql/mysql.conf.d"
	    else
		CNF_DEST="/etc/mysql/conf.d"
	    fi

	    echo "
# Instead of skip-networking the default is now to listen only on
# localhost which is more compatible and is not less secure.
[mysqld]
bind-address = 127.0.0.1" >> "$CNF_DEST/mysqld_bind_address.cnf"

	    echo "
# This is neccesary for ISPConfig installation
[mysqld]
sql-mode='NO_ENGINE_SUBSTITUTION'
" >> "$CNF_DEST/mysqld_sql_mode.cnf"

	    if [ $CFG_MYSQL_VERSION == "8.0" ]; then
		echo "
# This is neccesary to connect to mysql 8+ from php.
# On 8.0(4) the default-authentication-plugin is caching_sha2_password
# mysqli doens't support yet the caching_sha2_password
# !!! IMPORTANT !!! this should be removed once mysqli will support it !!!
[mysqld]
default-authentication-plugin=mysql_native_password
" >> "$CNF_DEST/mysqld_def_auth_plugin.cnf"
	    fi

            # Backup existing MySQL configuration files
	    if [ -f /usr/my-new.cnf ]; then
		mv /usr/my-new.cnf /etc/mysql/my-new.cnf.usr.back >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    fi

	    if [ -f /usr/my.cnf ]; then
		mv /usr/my.cnf /etc/mysql/my.cnf.usr.back >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    fi

	    if [ -f /usr/local/mysql/my-new.cnf ]; then
		mv /usr/local/mysql/my-new.cnf /etc/mysql/my-new.cnf.usr.local.back >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    fi

	    if [ -f /usr/local/mysql/my.cnf ]; then
		mv /usr/local/mysql/my.cnf /etc/mysql/my.cnf.usr.local.back >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    fi

	    echo -e "[${green}DONE${NC}]"

	    echo -n -e "$IDENTATION_LVL_1 Restart the MySQL Service... "
	    service mysql restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	    echo -e "[${green}DONE${NC}]"
	fi

	if [ $CFG_MYSQL_VERSION == "8.0" ]; then
	    echo "CREATE USER 'root'@'127.0.0.1' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD';" > $PROGRAMS_INSTALL_SQLS/rootIP.sql
            echo "GRANT ALL PRIVILEGES ON *.* TO 'root'@'127.0.0.1';" >> $PROGRAMS_INSTALL_SQLS/rootIP.sql
	    echo "FLUSH PRIVILEGES;" >> $PROGRAMS_INSTALL_SQLS/rootIP.sql
	    mysql -u root -p$CFG_MYSQL_ROOT_PWD < $PROGRAMS_INSTALL_SQLS/rootIP.sql >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	fi

	unset DEBIAN_FRONTEND
  
    elif [ $CFG_SQLSERVER == "MariaDB" ]; then
	echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing MariaDB...${NC}\n"

	echo -n -e "$IDENTATION_LVL_1 Setting debconf selections... "
	echo "maria-server-11.8.1 mysql-server/root_password password '$CFG_MYSQL_ROOT_PWD'" | debconf-set-selections
	echo "maria-server-11.8.1 mysql-server/root_password_again password '$CFG_MYSQL_ROOT_PWD'" | debconf-set-selections
	echo -e "[${green}DONE${NC}]"

	echo -n -e "$IDENTATION_LVL_1 Installing MariaDB Server & Client... "
	apt_install software-properties-common dirmngr apt-transport-https	
	curl -fsSL 'https://mariadb.org/mariadb_release_signing_key.asc' | gpg --dearmor | tee /usr/share/keyrings/mariadb-archive-keyring.gpg > /dev/null
	echo "deb [arch=amd64 signed-by=/usr/share/keyrings/mariadb-archive-keyring.gpg] http://mariadb.mirrors.ovh.net/MariaDB/repo/11.8.1/debian $(lsb_release -c -s) main" | tee /etc/apt/sources.list.d/mariadb.list > /dev/null
	apt_update
	apt_install mariadb-client mariadb-server
	echo -e "[${green}DONE${NC}]"

	echo -n -e "$IDENTATION_LVL_1 Set password authentication for the root user... "
	echo "ALTER USER 'root'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD';" > $PROGRAMS_INSTALL_SQLS/mariadbroot.sql
	echo "FLUSH PRIVILEGES;" >> $PROGRAMS_INSTALL_SQLS/mariadbroot.sql
	mariadb -uroot -p"$CFG_MYSQL_ROOT_PWD" < $PROGRAMS_INSTALL_SQLS/mariadbroot.sql >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo -e "[${green}DONE${NC}]"

	#Galera cluster
	#apt_install mariadb-backup galera-4

	echo -n -e "$IDENTATION_LVL_1 Configuring MariaDB... "
	sed -i 's/bind-address.* = 127.0.0.1/#bind-address		= 127.0.0.1/' /etc/mysql/my.cnf >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo "[mysqld]" >> /etc/mysql/my.cnf >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo "sql-mode="NO_ENGINE_SUBSTITUTION"" >> /etc/mysql/my.cnf >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo -e "[${green}DONE${NC}]"

	#Enable Binary Logging in MariaDB
	#log_error=/var/log/mariadb.log
	#touch /var/log/mariadb.log
	#chown mysql:mysql /var/log/mariadb.log
	#cat << "EOF" > /etc/mysql/mariadb.conf.d/50-server.cnf
#[mysqld]
#log-bin        = /var/log/mysql/mariadb-bin
#log-bin-index  = /var/log/mysql/mariadb-bin.index
#binlog_format  = mixed
#EOF

	echo -n -e "$IDENTATION_LVL_1 Securing MariaDB installation... "
	apt_install expect
	SECURE_MYSQL=$(expect -c "
	    set timeout 10
	    spawn mysql_secure_installation
	    expect \"Enter current password for root (enter for none):\"
	    send \"$CFG_MYSQL_ROOT_PWD\r\"
	    expect \"Change the root password?\"
	    send \"n\r\"
	    expect \"Remove anonymous users?\"
	    send \"y\r\"
	    expect \"Disallow root login remotely?\"
	    send \"y\r\"
	    expect \"Remove test database and access to it?\"
	    send \"y\r\"
	    expect \"Reload privilege tables now?\"
	    send \"y\r\"
	    expect eof
	")
	echo "$SECURE_MYSQL" > /dev/null 2>&1
	apt_purge_remove expect
	echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Increasing file limits for MariaDB... "
	#To prevent the error 'Error in accept: Too many open files' we will set higher open file limits for MariaDB now.
	echo "mysql soft nofile 65535" >> /etc/security/limits.conf
	echo "mysql hard nofile 65535" >> /etc/security/limits.conf
	mkdir -p /etc/systemd/system/mysql.service.d/
	echo "[Service]" >> /etc/systemd/system/mysql.service.d/limits.conf
	echo "LimitNOFILE=infinity" >> /etc/systemd/system/mysql.service.d/limits.conf
	echo -e "[${green}DONE${NC}]"

	#cat >> /etc/mysql/mariadb.conf.d/60-galera.cnf <<EOF
#[galera]
#wsrep_on=OFF
##wsrep_on=ON
#wsrep_provider=/usr/lib/galera/libgalera_smm.so
#wsrep_cluster_address="gcomm://$IP_ADDRESS,szerver2_ip,szerver3_ip"
#wsrep_cluster_name="mariadb_klaszter"
#wsrep_node_address=$IP_ADDRESS
#wsrep_node_name="node1"
#wsrep_sst_method=mariabackup
#wsrep_sst_auth=mariabackup:mariabackup_jelszó
#EOF

	# Start galera cluter
	#galera_new_cluster >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
      
	echo -n -e "$IDENTATION_LVL_1 Restarting MariaDB service... "
	systemctl is-enabled mariadb >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	systemctl daemon-reload >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	service mariadb restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Installing dbconfig-common and fixing RoundCube... "
	apt_install dbconfig-common dbconfig-mysql
	#There is currently a problem with the Debian dbconfig-common system which prevents the installation of RoundCube later, fix it by running this command:
	sed -i -r 's/_dbc_nodb="yes" dbc_mysql_exec/_dbc_nodb="yes"; dbc_mysql_exec/g' /usr/share/dbconfig-common/internal/mysql
	systemctl daemon-reload >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	service mariadb restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Saving database configuration... "
	cat >> /home/$SUDO_USER/wtlinux_server_setup/wtserver_configuration.txt <<EOF
#------------------------------
Database type			: $CFG_SQLSERVER
MySQL root password		: $CFG_MYSQL_ROOT_PWD
#------------------------------
EOF
        echo -e "[${green}DONE${NC}]"
    else
	echo -n "${red}No database server installation selected... ${NC}"
    fi

    MeasureTimeDuration $START_TIME
}
