#---------------------------------------------------------------------
# Function: InstallWebServer Debian 10
#    Install and configure Apache2, php + modules
#---------------------------------------------------------------------
InstallWebServer() {
phpMyAdmin=5.1.0-rc1
#PHPMYADMINHASH=3eb8d49578ac9d4a984330b1be6e903e01540012
blowfish="w4t84ty85Fgh6TRfcjiw21720fzhTcjT" # blowfish 32 char secret maybe it can be autogenerated

  if [ "$CFG_WEBSERVER" == "apache" ]; then
	CFG_NGINX=n
	CFG_APACHE=y
	echo -n "Installing Web server (Apache) and modules... "
	echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect apache2" | debconf-set-selections
	# - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
	echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
	# apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libapache2-mod-passenger libapache2-mod-python libexpat1 ssl-cert libruby
	apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libruby libapache2-mod-python
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP and Modules... "
	#apt_install php7.3 php7.3-common php-bcmath php7.3-gd php7.3-mysql php7.3-imap php7.3-cli php7.3-cgi php-pear mcrypt imagemagick libruby php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php7.3-soap php7.3-fpm php7.3-opcache php-apcu
	apt_install php7.3 php7.3-common php-bcmath php7.3-gd php7.3-mysql php7.3-imap php7.3-cli php7.3-cgi php-pear imagemagick libruby php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php7.3-soap php7.3-fpm php7.3-opcache php-apcu
	#apt-get_install php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php-soap php7.3-soap memcached imagemagick libruby php-pear mcrypt php7.3-pdo-odbc php7.3-imagick php7.3-redis php7.3-bz2 php7.3-mongodb php7.3-common php7.3-cgi php7.3-cli php7.3-dba php7.3-smbclient php7.3-dom php7.3-bcmath php7.3-oauth php7.3-memcached php7.3-pinba php7.3-fpm php7.3-ftp php7.3-igbinary php7.3-gmp php7.3-mysql php7.3-memcache php7.3-uuid php7.3-sockets  php7.3-mailparse php7.3 php7.3-sysvmsg php7.3-wddx  php7.3-pdo-pgsql php7.3-calendar php7.3-fileinfo php7.3-pdo php7.3-xmlwriter php7.3-json php7.3-opcache php7.3-mysqli php7.3-sass php7.3-sysvsem php7.3-sysvshm php7.3-phar php7.3-rrd php7.3-sybase php7.3-curl php7.3-stomp php7.3-msgpack php7.3-ldap php7.3-gearman php7.3-raphf php7.3-phpdbg php7.3-xmlreader php7.3-imap php7.3-gnupg php7.3-radius php7.3-uploadprogress php7.3-posix php7.3-iconv php7.3-xml   php7.3-zip php7.3-tokenizer php7.3-zmq php7.3-odbc php7.3-mbstring php7.3-readline php7.3-ds php7.3-gd php7.3-ps php7.3-interbase php7.3-yaml php7.3-snmp php7.3-pdo-mysql php7.3-mysqlnd  php7.3-soap php7.3-solr php7.3-simplexml php7.3-ssh2 php7.3-pdo-sqlite php7.3-pdo-dblib  php7.3-amqp php7.3-gmagick php7.3-pgsql php7.3-enchant  php7.3-tideways php7.3-shmop php7.3-libsodium php7.3-propro php7.3-gettext php7.3-pdo-firebird php7.3-exif php7.3-ctype php7.3-http php7.3-geoip php7.3-xdebug php7.3-common php7.3-mysql php7.3-odbc php7.3-pgsql  php7.3-xml php-amqp php-ds php-gearman php-geoip php-gmagick php-gnupg php-http php-igbinary php-imagick php-libsodium php-mailparse php-memcache php-memcached php-mongodb php-msgpack php-oauth php-pinba php-propro php-ps php-radius php-raphf php-redis php-rrd php-sass php-smbclient php-solr php-ssh2 php-stomp php-tideways php-uploadprogress php-uuid php-xdebug php-yac php-yaml php-zmq php7.3-interbase php7.3-sybase > /dev/null 2>&1

	#php.ini settings roundcube and other
	sed -i "s/;extension=php_mbstring.dll/extension=php_mbstring.dll/" /etc/php/7.3/apache2/php.ini
	sed -i "s/;extension=php_xmlrpc.dll/extension=php_xmlrpc.dll/" /etc/php/7.3/apache2/php.ini
	sed -i "s/;extension=php_xsl.dll/;extension=php_xsl.dll\\`echo -e '\n\r'`extension=dom.so/" /etc/php/7.3/apache2/php.ini
	sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/7.3/apache2/php.ini
	sed -i "s/post_max_size =.*/post_max_size = 18M/g" /etc/php/7.3/apache2/php.ini
	sed -i "s/upload_max_filesize =.*/upload_max_filesize = 12M/g" /etc/php/7.3/apache2/php.ini
	sed -i "s/;mbstring.func_overload = 0/mbstring.func_overload = 0/" /etc/php/7.3/apache2/php.ini
	systemctl reload php7.3-fpm
	systemctl restart apache2
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing Opcache and APCu... "
	apt_install php7.3-opcache php-apcu
	#PHP OPcache
	echo -n "Enabled and Configuration PHP OPcache..."
	sed -i "s/;opcache.enable=0/opcache.enable=1/" /etc/php/7.0/apache2/php.ini
	sed -i "s/;opcache.memory_consumption=64/opcache.memory_consumption=128/" /etc/php/7.0/apache2/php.ini
	sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=4000/" /etc/php/7.0/apache2/php.ini
	sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=240/" /etc/php/7.0/apache2/php.ini
	phpenmod opcache
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP-FPM... "
	apt_install php7.3-fpm
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing needed programs for PHP and Apache (mcrypt, etc.)... "
	apt_install mcrypt imagemagick memcached curl tidy snmp
	echo -e "[${green}DONE${NC}]\n"

	echo "<IfModule mod_headers.c>
    RequestHeader unset Proxy early
	</IfModule>" | tee /etc/apache2/conf-available/httpoxy.conf > /dev/null 2>&1
	
	if [ "$CFG_PHPMYADMIN" == "yes" ]; then
	    mkdir /usr/share/phpmyadmin
	    mkdir /etc/phpmyadmin
	    mkdir -p /var/lib/phpmyadmin/tmp
	    chown -R www-data:www-data /var/lib/phpmyadmin
	    touch /etc/phpmyadmin/htpasswd.setup
	    cd /tmp
	    wget https://files.phpmyadmin.net/phpMyAdmin/$phpMyAdmin/phpMyAdmin-$phpMyAdmin-all-languages.tar.gz > /dev/null 2>&1
	    tar xfz phpMyAdmin-$phpMyAdmin-all-languages.tar.gz > /dev/null 2>&1
	    mv phpMyAdmin-$phpMyAdmin-all-languages/* /usr/share/phpmyadmin/
	    rm phpMyAdmin-$phpMyAdmin-all-languages.tar.gz
	    rm -rf phpMyAdmin-$phpMyAdmin-all-languages
	    cp /usr/share/phpmyadmin/config.sample.inc.php  /usr/share/phpmyadmin/config.inc.php
	    sed -i "s|\$cfg\['blowfish_secret'\]\s=\s'';|\$cfg['blowfish_secret'] = '$blowfish';|" /usr/share/phpmyadmin/config.inc.php
	    sed -i "$ a\$cfg['TempDir'] = '/var/lib/phpmyadmin/tmp';" /usr/share/phpmyadmin/config.inc.php

	    touch /etc/apache2/conf-available/phpmyadmin.conf
	    cat > /etc/apache2/conf-available/phpmyadmin.conf <<EOF
# phpMyAdmin default Apache configuration

Alias /phpmyadmin /usr/share/phpmyadmin 

<Directory /usr/share/phpmyadmin>
    Options FollowSymLinks
    DirectoryIndex index.php

    <IfModule mod_php7.c>
        AddType application/x-httpd-php .php

        php_flag magic_quotes_gpc Off
        php_flag track_vars On
        php_flag register_globals Off
        php_value include_path .
    </IfModule>
</Directory>

# Authorize for setup 

<Directory /usr/share/phpmyadmin/setup>
    <IfModule mod_authn_file.c>
        AuthType Basic
        AuthName "phpMyAdmin Setup"
        AuthUserFile /etc/phpmyadmin/htpasswd.setup
    </IfModule> 
    Require valid-user
</Directory>

# Disallow web access to directories that don't need it

<Directory /usr/share/phpmyadmin/libraries>
    Order Deny,Allow
    Deny from All
</Directory>
<Directory /usr/share/phpmyadmin/setup/lib>
    Order Deny,Allow
    Deny from All 
</Directory>

EOF

        	a2enconf phpmyadmin > /dev/null 2>&1
        	systemctl reload apache2 

    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"CREATE DATABASE phpmyadmin;"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"CREATE USER 'pma'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD';"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"GRANT ALL PRIVILEGES ON phpmyadmin.* TO 'pma'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD' WITH GRANT OPTION;"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"FLUSH PRIVILEGES;"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" phpmyadmin < /usr/share/phpmyadmin/sql/create_tables.sql
    		# used to manipulate storage uncommented and values set
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlhost'\]\s=\s'';|\$cfg['Servers'][\$i]['controlhost'] = 'localhost';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlport'\]\s=\s'';|\$cfg['Servers'][\$i]['controlport'] = '';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controluser'\]\s=\s'pma';|\$cfg['Servers'][\$i]['controluser'] = 'pma';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlpass'\]\s=\s'pmapass';|\$cfg['Servers'][\$i]['controlpass'] = '$CFG_MYSQL_ROOT_PWD';|" /usr/share/phpmyadmin/config.inc.php
    		# uncomment the Storage database and tables section
    		sed -i '/\*\sStorage\sdatabase\sand\stables\s\*/,/\*\*/ s|^//||' /usr/share/phpmyadmin/config.inc.php

		echo -e "[${green}DONE${NC}]\n"
	fi
	
	# if [ "$CFG_XCACHE" == "yes" ]; then
		# echo -n "Installing XCache... "
		# apt_install php7-xcache
		# echo -e "[${green}DONE${NC}]\n"
	# fi

	echo -n "Activating Apache modules... "
	a2enmod suexec > /dev/null 2>&1
	a2enmod rewrite > /dev/null 2>&1
	a2enmod ssl > /dev/null 2>&1
	a2enmod actions > /dev/null 2>&1
	a2enmod include > /dev/null 2>&1
	a2enmod cgi > /dev/null 2>&1
	a2enmod dav_fs > /dev/null 2>&1
	a2enmod dav > /dev/null 2>&1
	a2enmod auth_digest > /dev/null 2>&1
	a2enmod headers > /dev/null 2>&1
	a2enmod fastcgi > /dev/null 2>&1
	a2enmod proxy_fcgi > /dev/null 2>&1
	a2enmod alias > /dev/null 2>&1
	# a2enmod fcgid > /dev/null 2>&1
	a2enconf httpoxy > /dev/null 2>&1
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Restarting Apache... "
	systemctl restart apache2
	echo -e "[${green}DONE${NC}]\n"

	echo -n "Installing needed programs for PHP and Apache (mcrypt, etc.)... "
	apt_install mcrypt imagemagick memcached curl tidy snmp redis-server
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Block Exploits, SQL Injections, File Injections, Spam, User Agents, Etc. Apache2 Modules... "
	# This mitigation has been assigned the identifier CVE-2016-5387
	# Please refer to:
	# https://httpoxy.org/#fix-now
	# https://www.nginx.com/blog/mitigating-the-httpoxy-vulnerability-with-nginx/
	echo -n "Removing the HTTP Proxy Header with Apache2..."
	sed -i '$ a\\nRequestHeader unset Proxy early' /etc/apache2/apache2.conf
	systemctl restart apache2 > /dev/null 2>&1
	
  elif [ "$CFG_WEBSERVER" == "nginx" ]; then
	CFG_NGINX=y
	CFG_APACHE=n
	echo -n "Installing Web server (nginx) and modules... "
	systemctl stop apache2 > /dev/null 2>&1
	systemctl disable apache2 > /dev/null 2>&1

	echo "deb http://nginx.org/packages/mainline/debian/ buster nginx" >> /etc/apt/sources.list
	curl -O https://nginx.org/keys/nginx_signing.key && apt-key add ./nginx_signing.key

	hide_output apt-get update
	#apt_install nginx nginx-module-geoip nginx-module-image-filter nginx-module-njs nginx-module-perl nginx-module-xslt
	apt_install nginx
	systemctl start nginx
	systemctl enable nginx

	#nginx mainline stable repo
	mkdir -p /etc/nginx/sites-available
	mkdir -p /etc/nginx/sites-enabled
	rm /etc/nginx/conf.d/default.conf
	mv /etc/nginx/nginx.conf /etc/nginx/nginx.conf_old
	cp -rp $PWD/distros/debian10/nginx_conf/* /etc/nginx
	
	## jelesek kellenek a stabil nem mainline-hoz
	##sed -i -e"s/keepalive_timeout\s*65/keepalive_timeout 2/" /etc/nginx/nginx.conf
	##sed -i -e"s/keepalive_timeout 2/keepalive_timeout 2;\n\tclient_max_body_size 18m/" /etc/nginx/nginx.conf
	#sed -i 's/client_max_body_size *[0-9]\+[kKmM]\?/client_max_body_size '"${POST_MAX_SIZE}"'/' /etc/nginx/conf.d/default.conf
	#wordpress
	#sed -i 's/upload_max_filesize *= *[0-9]\+[kKmMgG]\?/upload_max_filesize='"64m"'/' /etc/nginx/global/wordpress.conf
	#sed -i 's/post_max_size *= *[0-9]\+[kKmMgG]\?/post_max_size='"64m"'/' /etc/nginx/global/wordpress.conf
	#sed -i 's/fastcgi_pass .*;/fastcgi_pass '"$(escape_sed "wordpress")"':9000;/' /etc/nginx/global/wordpress.conf
	
	echo -e "Block Exploits, SQL Injections, File Injections, Spam, User Agents, Etc. Apache2 Modules...\n"
	# This mitigation has been assigned the identifier CVE-2016-5387
	# Please refer to:
	# https://httpoxy.org/#fix-now
	# https://www.nginx.com/blog/mitigating-the-httpoxy-vulnerability-with-nginx/
	echo -e "Removing the HTTP Proxy Header with Nginx...\n"
	sed -i '/SERVER_NAME/ a\\nfastcgi_param HTTP_PROXY \"\";' /etc/nginx/fastcgi_params
	##sed -i '/types_hash_max_size/ a\ proxy_set_header Proxy \"\";' /etc/nginx/nginx.conf
	#Block Exploits, SQL Injections & attacks with Nginx
	#Include it in your vhost configuration with :
	#include /etc/nginx/common/protect.conf;
	mkdir -p /etc/nginx/common
	cat << "EOF" > /etc/nginx/common/protect.conf
    location ~* "(eval\()"  { deny all; }
    location ~* "(127\.0\.0\.1)"  { deny all; }
    location ~* "([a-z0-9]{2000})"  { deny all; }
    location ~* "(javascript\:)(.*)(\;)"  { deny all; }
    location ~* "(base64_encode)(.*)(\()"  { deny all; }
    location ~* "(GLOBALS|REQUEST)(=|\[|%)"  { deny all; }
    location ~* "(<|%3C).*script.*(>|%3)" { deny all; }
    location ~ "(\\|\.\.\.|\.\./|~|`|<|>|\|)" { deny all; }
    location ~* "(boot\.ini|etc/passwd|self/environ)" { deny all; }
    location ~* "(thumbs?(_editor|open)?|tim(thumb)?)\.php" { deny all; }
    location ~* "(\'|\")(.*)(drop|insert|md5|select|union)" { deny all; }
    location ~* "(https?|ftp|php):/" { deny all; }
    location ~* "(=\\\'|=\\%27|/\\\'/?)\." { deny all; }
    location ~* "/(\$(\&)?|\*|\"|\.|,|&|&?)/?$" { deny all; }
    location ~ "(\{0\}|\(/\(|\.\.\.|\+\+\+|\\\"\\\")" { deny all; }
    location ~ "(~|`|<|>|:|;|%|\\|\s|\{|\}|\[|\]|\|)" { deny all; }
    location ~* "/(=|\$&|_mm|(wp-)?config\.|cgi-|etc/passwd|muieblack)" { deny all; }
    location ~* "(&pws=0|_vti_|\(null\)|\{\$itemURL\}|echo(.*)kae|etc/passwd|eval\(|self/environ)" { deny all; }
    location ~* "\.(aspx?|bash|bak?|cfg|cgi|dll|exe|git|hg|ini|jsp|log|mdb|out|sql|svn|swp|tar|rdf)$" { deny all; }
    location ~* "/(^$|mobiquo|phpinfo|shell|sqlpatch|thumb|thumb_editor|thumbopen|timthumb|webshell)\.php" { deny all; }
EOF

    	echo -e "Nginx Bad Bot Blocker 223 (and growing) Nginx rules to block bad bots...\n"
    	# Block bad bots V1	
    	#git clone https://github.com/mariusv/nginx-badbot-blocker.git /etc/nginx
    	#sed -i "s|^\(\$config\['default_host'\] =\).*$|\1 \ array(\n##\n# Nginx Bad Bot Blocker\n##\ninclude nginx-badbot-blocker/blacklist.conf;\ninclude nginx-badbot-blocker/blockips.conf;\n\);|" /usr/share/roundcube/config/config.inc.php

    	# Block bad bots V2
    	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/conf.d/blacklist.conf -O /etc/nginx/conf.d/blacklist.conf
	#mkdir /etc/nginx/bots.d
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/blockbots.conf -O /etc/nginx/bots.d/blockbots.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/ddos.conf -O /etc/nginx/bots.d/ddos.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/whitelist-domains.conf -O /etc/nginx/bots.d/whitelist-domains.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/whitelist-ips.conf -O /etc/nginx/bots.d/whitelist-ips.conf

    	#mcedit /etc/nginx/nginx.conf
	#####Add the following settings and rate limiting zones near the top of your nginx.conf file. This is both for the Anti DDOS rate limiting filter and for allowing Nginx to load this very large set of domain names into memory.
    	#server_names_hash_bucket_size 64;
    	#server_names_hash_max_size 4096;
    	#limit_req_zone $binary_remote_addr zone=flood:50m rate=90r/s;
    	#limit_conn_zone $binary_remote_addr zone=addr:50m;

    	#Make sure that your nginx.conf file contains the following include directive. If it's commented out make sure to uncomment it.
    	#include /etc/nginx/conf.d/*

	#VHOST
	#These includes MUST be added within a server {} block of a vhost otherwise you will get EMERG errors from Nginx.
    	#include /etc/nginx/bots.d/blockbots.conf;
    	#include /etc/nginx/bots.d/ddos.conf;
	#sudo nginx -t
	#sudo systemctl reload nginx

	#curl -A "googlebot" http://wolftronics.hu
	#Should respond with 200 OK
	#curl -A "80legs" http://wolftronics.hu
	#curl -A "masscan" http://wolftronics.hu
	#Should respond with: curl: (52) Empty reply from server
	#curl -I http://yourdomain.com -e http://100dollars-seo.com
	#curl -I http://wolftronics.hu -e http://zx6.ru
	#Should respond with: curl: (52) Empty reply from server
	#The Nginx BadBot Blocker is now working and protecting your web sites !!!

	#UPDATING THE NGINX BADBOT BLOCKER
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/conf.d/blacklist.conf -O /etc/nginx/conf.d/blacklist.conf
	#sudo nginx -t
	#sudo systemctl reload nginx

	#AUTO UPDATING:
	#https://raw.githubusercontent.com/mariusv/nginx-badbot-blocker/master/VERSION_2/updatenginxblocker.sh


	#nginx-ultimate-bad-bot-blocker
	#wget https://raw.githubusercontent.com/mitchellkrogza/nginx-ultimate-bad-bot-blocker/master/install-ngxblocker -O /usr/local/sbin/install-ngxblocker
	#chmod +x /usr/local/sbin/install-ngxblocker
	#sh /usr/local/sbin/install-ngxblocker
	#sh /usr/local/sbin/install-ngxblocker -x

	##chmod +x /usr/local/sbin/setup-ngxblocker
	##chmod +x /usr/local/sbin/update-ngxblocker
	##sh /usr/local/sbin/setup-ngxblocker
	
	#sh /usr/local/sbin/setup-ngxblocker -x -e conf
	systemctl start nginx
	#sudo nginx -t
	echo -e "[${green}DONE${NC}]\n"

	#00 22 * * * sudo /usr/sbin/update-ngxblocker -e yourname@youremail.com
	#This will update the blocker every night for you at 10 PM.
	#If you want it to update more frequently (as sometimes I push out 3-4 updates a day) you can set it as follows to run the cron every 8 hours, although just once a day is more than enough.
	#00 */8 * * * sudo /usr/sbin/update-ngxblocker -e yourname@youremail.com
	#If you don't want any email notification after an update (not advisable in case Nginx ever has an EMERG when reloading), then simply run your cron as follows.
	#00 */8 * * * sudo /usr/sbin/update-ngxblocker -n
	echo "00 */8 * * * sudo /usr/sbin/update-ngxblocker -n" >> /etc/crontab

	# apt_install php7.3 php7.3-common php7.3-gd php7.3-mysql php7.3-imap php7.3-cli php7.3-cgi php-pear php-auth php7.3-mcrypt mcrypt imagemagick libruby php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php7.3-fpm php7.3-opcache php-apcu
	#apt_install php7.3 php7.3-common php7.3-gd php7.3-mysql php7.3-imap php7.3-cli php7.3-cgi php-pear mcrypt imagemagick libruby php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php-soap php7.3-soap

  	#hide_output add-apt-repository -y ppa:ondrej/php
  	#apt_add_repository_to_unattended_upgrades LP-PPA-ondrej-php:trusty
  	#hide_output apt-get update
	echo -n "Installing PHP-FPM... "
	apt_install php7.3-fpm
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP and modules... "
	#apt_install php7.3 php7.3-common php7.3-dev php-bcmath php7.3-gd php7.3-mysql php7.3-imap php7.3-cli php7.3-cgi php-pear mcrypt libruby php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php-soap php7.3-soap php7.3-snmp php7.3-xml > /dev/null 2>&1
	apt_install php7.3 php7.3-common php7.3-dev php-bcmath php7.3-gd php7.3-mysql php7.3-imap php7.3-cli php7.3-cgi php-pear libruby php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php-soap php7.3-soap php7.3-snmp php7.3-xml > /dev/null 2>&1

	#apt_install php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl memcached php-memcache php-imagick php-gettext php7.3-zip php7.3-mbstring php-soap php7.3-soap memcached imagemagick libruby php-pear mcrypt php7.3-pdo-odbc php7.3-imagick php7.3-redis php7.3-bz2 php7.3-mongodb php7.3-common php7.3-cgi php7.3-cli php7.3-dba php7.3-smbclient php7.3-dom php7.3-bcmath php7.3-oauth php7.3-memcached php7.3-pinba php7.3-fpm php7.3-ftp php7.3-igbinary php7.3-gmp php7.3-mysql php7.3-memcache php7.3-uuid php7.3-sockets  php7.3-mailparse php7.3 php7.3-sysvmsg php7.3-wddx  php7.3-pdo-pgsql php7.3-calendar php7.3-fileinfo php7.3-pdo php7.3-xmlwriter php7.3-json php7.3-opcache php7.3-mysqli php7.3-sass php7.3-sysvsem php7.3-sysvshm php7.3-phar php7.3-rrd php7.3-sybase php7.3-curl php7.3-stomp php7.3-msgpack php7.3-ldap php7.3-gearman php7.3-raphf php7.3-phpdbg php7.3-xmlreader php7.3-imap php7.3-gnupg php7.3-radius php7.3-uploadprogress php7.3-posix php7.3-iconv php7.3-xml   php7.3-zip php7.3-tokenizer php7.3-zmq php7.3-odbc php7.3-mbstring php7.3-readline php7.3-ds php7.3-gd php7.3-ps php7.3-interbase php7.3-yaml php7.3-snmp php7.3-pdo-mysql php7.3-mysqlnd  php7.3-soap php7.3-solr php7.3-simplexml php7.3-ssh2 php7.3-pdo-sqlite php7.3-pdo-dblib  php7.3-amqp php7.3-gmagick php7.3-pgsql php7.3-enchant  php7.3-tideways php7.3-shmop php7.3-libsodium php7.3-propro php7.3-gettext php7.3-pdo-firebird php7.3-exif php7.3-ctype php7.3-http php7.3-geoip php7.3-xdebug php7.3-common php7.3-mysql php7.3-odbc php7.3-pgsql  php7.3-xml php-amqp php-ds php-gearman php-geoip php-gmagick php-gnupg php-http php-igbinary php-imagick php-libsodium php-mailparse php-memcache php-memcached php-mongodb php-msgpack php-oauth php-pinba php-propro php-ps php-radius php-raphf php-redis php-rrd php-sass php-smbclient php-solr php-ssh2 php-stomp php-tideways php-uploadprogress php-uuid php-xdebug php-yac php-yaml php-zmq php7.3-interbase php7.3-sybase  > /dev/null 2>&1

	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing Opcache and APCu... "
	apt_install php7.3-opcache php-apcu

	sed -i "s/;cgi.fix_pathinfo=1/cgi.fix_pathinfo=0/" /etc/php/7.3/fpm/php.ini
	TIME_ZONE=$(echo "$TIME_ZONE" | sed -n 's/ (.*)$//p')
	sed -i "s/;date.timezone =/date.timezone=\"${TIME_ZONE//\//\\/}\"/" /etc/php/7.3/fpm/php.ini
	#sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/7.3/fpm/php.ini
	sed -i "s/post_max_size =.*/post_max_size = 18M/g" /etc/php/7.3/fpm/php.ini
	#sed -i "s/upload_max_filesize =.*/upload_max_filesize = 12M/g" /etc/php/7.3/fpm/php.ini
	sed -i "s/upload_max_filesize =.*/upload_max_filesize = 128M/g" /etc/php/7.3/fpm/php.ini
	sed -i "s/;mbstring.func_overload = 0/mbstring.func_overload = 0/" /etc/php/7.3/fpm/php.ini
	sed -i -e "s/;daemonize\s*=\s*yes/daemonize = no/g" /etc/php/7.3/fpm/php-fpm.conf
	sed -i -e "s/;catch_workers_output\s*=\s*yes/catch_workers_output = yes/g" /etc/php/7.3/fpm/pool.d/www.conf
	find /etc/php/7.3/cli/conf.d/ -name "*.ini" -exec sed -i -re 's/^(\s*)#(.*)/\1;\2/g' {} \;
	#PHP OPcache
	echo -e "Enabled and Configuration PHP OPcache...\n"
	sed -i "s/;opcache.enable=0/opcache.enable=1/" /etc/php/7.3/fpm/php.ini
	sed -i "s/;opcache.memory_consumption=64/opcache.memory_consumption=128/" /etc/php/7.3/fpm/php.ini
	sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=4000/" /etc/php/7.3/fpm/php.ini
	sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=240/" /etc/php/7.3/fpm/php.ini
	#phpenmod opcache
	# Set worker_processes = num cpu cores
	#procs=$(cat /proc/cpuinfo |grep processor | wc -l)
	#if [[ "$procs" > "${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES}" ]]; then
	    # number of available processor cores exceeds the maximum permitted, limit to maximum
	#    echo " * nginx:  Using max ${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES} of $procs available cores"
	#    procs=${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES}
	#fi
	#echo " * nginx:  worker_processes = $procs"
	#sed -i -r "s/worker_processes\s+[0-9]+/worker_processes $procs/" /etc/nginx/nginx.conf
	#sed -i -e '/worker_processes/c\worker_processes  5;' /etc/nginx/nginx.conf
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Reloading PHP-FPM... "
	#systemctl reload php7-fpm 
	hide_output systemctl reload php7.3-fpm
	systemctl restart nginx

	#echo -n "Installing 5.5.38 and 5.6.31 PHP and Modules... "
	#InstallPhp55
	#InstallPhp56
	#InstallPhp70
	#InstallPhp71
	#InstallPhp73
	echo -e "[${green}DONE${NC}]\n"

	echo -n "Installing fcgiwrap... "
	apt_install fcgiwrap
	echo -e "[${green}DONE${NC}]\n"
	#echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect none" | debconf-set-selections
        # - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
    	#echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
	if [ "$CFG_PHPMYADMIN" == "yes" ]; then
		echo -n "Installing phpMyAdmin... "
    		mkdir /usr/share/phpmyadmin
    		mkdir /etc/phpmyadmin
    		mkdir -p /var/lib/phpmyadmin/tmp
    		chown -R www-data:www-data /var/lib/phpmyadmin
    		touch /etc/phpmyadmin/htpasswd.setup
    		cd /tmp
    		wget https://files.phpmyadmin.net/phpMyAdmin/$phpMyAdmin/phpMyAdmin-$phpMyAdmin-all-languages.tar.gz > /dev/null 2>&1
    		tar xfz phpMyAdmin-$phpMyAdmin-all-languages.tar.gz > /dev/null 2>&1
    		mv phpMyAdmin-$phpMyAdmin-all-languages/* /usr/share/phpmyadmin/
    		rm phpMyAdmin-$phpMyAdmin-all-languages.tar.gz
    		rm -rf phpMyAdmin-$phpMyAdmin-all-languages
    		cp /usr/share/phpmyadmin/config.sample.inc.php  /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|\$cfg\['blowfish_secret'\]\s=\s'';|\$cfg['blowfish_secret'] = '$blowfish';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "$ a\$cfg['TempDir'] = '/var/lib/phpmyadmin/tmp';" /usr/share/phpmyadmin/config.inc.php

    		touch /etc/nginx/conf.d/phpmyadmin.conf
    		# Write default ngnix  vhost configuration file for phpmyadmin - to be included in all other hosts
    		cat /etc/nginx/conf.d/phpmyadmin.conf <<EOF

## phpMyAdmin default nginx configuration

server {
   listen 80;
   server_name "";
   root /usr/share/phpmyadmin;

   location /phpmyadmin {
               root /usr/share/;
               index index.php index.html index.htm;
               location ~ ^/phpmyadmin/(.+\.php)$ {
                       try_files $uri =404;
                       root /usr/share/;
                       fastcgi_pass unix:/var/run/php/php7.0-fpm.sock;
                       fast_cgi_param HTTPS $https;
                       fastcgi_index index.php;
                       fastcgi_param SCRIPT_FILENAME $request_filename;
                       include /etc/nginx/fastcgi_params;
                       fastcgi_param PATH_INFO $fastcgi_script_name;
                       fastcgi_buffer_size 128k;
                       fastcgi_buffers 256 4k;
                       fastcgi_busy_buffers_size 256k;
                       fastcgi_temp_file_write_size 256k;
                       fastcgi_intercept_errors on;
               }
               ## Images and static content is treated different
               location ~* ^/phpmyadmin/(.+\.(jpg|jpeg|gif|css|png|js|ico|html|xml|txt))$ {
                       root /usr/share/;
               }
        }
        location /phpMyAdmin {
               rewrite ^/* /phpmyadmin last;
        }
   location / {
      index index.php;
   }

## Images and static content is treated different
   location ~* ^.+.(jpg|jpeg|gif|css|png|js|ico|xml)$ {
      access_log off;
      expires 30d;
   }

   location ~ /\.ht {
      deny all;
   }

   location ~ /(libraries|setup/frames|setup/libs) {
      deny all;
      return 404;
   }

   location ~ \.php$ {
      include /etc/nginx/fastcgi_params;
      fastcgi_pass 127.0.0.1:9000;
      fastcgi_index index.php;
      fastcgi_param SCRIPT_FILENAME /usr/share/phpMyAdmin$fastcgi_script_name;
   }
}

EOF

    		systemctl restart nginx
    		systemctl restart php7.3-fpm

    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"CREATE DATABASE phpmyadmin;"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"CREATE USER 'pma'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD';"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"GRANT ALL PRIVILEGES ON phpmyadmin.* TO 'pma'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ROOT_PWD' WITH GRANT OPTION;"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e"FLUSH PRIVILEGES;"
    		mysql -u root -p"$CFG_MYSQL_ROOT_PWD" phpmyadmin < /usr/share/phpmyadmin/sql/create_tables.sql
    		# used to manipulate storage uncommented and values set
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlhost'\]\s=\s'';|\$cfg['Servers'][\$i]['controlhost'] = 'localhost';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlport'\]\s=\s'';|\$cfg['Servers'][\$i]['controlport'] = '';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controluser'\]\s=\s'pma';|\$cfg['Servers'][\$i]['controluser'] = 'pma';|" /usr/share/phpmyadmin/config.inc.php
    		sed -i "s|//\s\$cfg\['Servers'\]\[\$i\]\['controlpass'\]\s=\s'pmapass';|\$cfg['Servers'][\$i]['controlpass'] = '$CFG_MYSQL_ROOT_PWD';|" /usr/share/phpmyadmin/config.inc.php
    		# uncomment the Storage database and tables section
    		sed -i '/\*\sStorage\sdatabase\sand\stables\s\*/,/\*\*/ s|^//||' /usr/share/phpmyadmin/config.inc.php

		echo "With nginx phpMyAdmin is accessibile at  http://$CFG_HOSTNAME_FQDN:$CFG_ISPONCFIG_APPS_PORT/phpmyadmin or http://${IP_ADDRESS[0]}:$CFG_ISPONCFIG_APPS_PORT/phpmyadmin"
		echo -e "[${green}DONE${NC}]\n"
	fi
	
  fi

	if [ "$CFG_XCACHE" == "yes" ]; then  
		echo -n "Installing XCache not work ubuntu 16.04 and php 7... "
		#apt_install php7-xcache
		echo -e "[${green}DONE${NC}]\n"
	fi

	echo -n "Installing needed programs for PHP and nginx (mcrypt, etc.)... "
	  #apt_install mcrypt imagemagick memcached curl tidy snmp redis-server
	  apt_install imagemagick memcached curl tidy snmp redis-server
	  #apt_install gcc make autoconf libc-dev pkg-config
	  #apt_install libmcrypt-dev
	  #pecl install mcrypt-1.0.1
	  #echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/7.3/cli/conf.d/mcrypt.ini
	  #echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/7.3/mods-available/mcrypt.ini
	  ######echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/7.3/apache2/conf.d/mcrypt.ini
	  echo -e "[${green}DONE${NC}]\n"
	
	#phpenmod mcrypt
	phpenmod mbstring

	echo -n "Installing Lets Encrypt... "
	#hide_output add-apt-repository ppa:certbot/certbot -y
	#hide_output apt-get update
	if [ "$CFG_WEBSERVER" == "apache" ]; then
		#apt_install certbot python3-certbot-apache
		apt_install certbot
		#certbot register
	else
		#apt_install certbot python3-certbot-nginx
		apt_install certbot
		#certbot register
	fi

#Advanced installation
#git clone https://github.com/Neilpang/acme.sh.git
#cd acme.sh
#./acme.sh --install  \
#--home ~/myacme \
#--config-home ~/myacme/data \
#--certhome  ~/mycerts \
#--accountemail  "hi@acme.sh" \
#--accountkey  ~/myaccount.key \
#--accountconf ~/myaccount.conf \
#--useragent  "this is my client."

wget -O -  https://raw.githubusercontent.com/Neilpang/acme.sh/master/acme.sh | INSTALLONLINE=1 sh
#cp -rp /root/.acme.sh/* /home/administrator/.acme.sh
#rm -d -r /root/.acme.sh/

#cron-d
#0 0 * * * "/home/user/.acme.sh"/acme.sh --cron --home "/home/user/.acme.sh" > /dev/null
#echo "0 0 * * * "/home/administrator/.acme.sh"/acme.sh --cron --home "/home/administrator/.acme.sh" > /dev/null" >> /etc/crontab

  echo -e "[${green}DONE${NC}]\n"
}
