#---------------------------------------------------------------------
# Function: InstallMailman
#    Install the Mailman list manager
#---------------------------------------------------------------------
InstallMailman() {
    START_TIME=$SECONDS

    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing Mailman..."
    echo "mailman mailman/default_server_language select en" | debconf-set-selections
    echo "mailman mailman/site_languages  multiselect en" | debconf-set-selections
    echo "mailman mailman/create_site_list select " | debconf-set-selections
    apt_install mailman
    mmsitepass "${MMSITEPASS}"
    newlist -a  mailman "${MMLISTOWNER}" "${MMADMINEMAIL}" "${MMLISTPASS}" | grep "/var/lib/mailman" >> /etc/aliases
    newaliases
    ln -s /usr/lib/mailman/mail/mailman /usr/bin/mailman
    systemctl restart postfix.service
    systemctl enable mailman.service
    systemctl start mailman.service

    cat >> /home/administrator/wtlinux_server_setup/wtserver_configuration.txt <<EOF
# Mailman Store the passwords
#----------------------------
Mailman site password		: $MMSITEPASS
Mailman site list user		: $MMLISTOWNER
Mailman site list password	: $MMLISTPASS
#----------------------------

EOF
    MeasureTimeDuration $START_TIME
#    echo -e "[${green}DONE${NC}]\n"
}
