#---------------------------------------------------------------------
# Function: InstallLetsEncrypt
#    Install and configure Let's Encrypt
#---------------------------------------------------------------------
InstallLetsEncrypt() {
    local START_TIME=$SECONDS

    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing LetsEncrypt Certbot${NC}"

    if [ $CFG_CERTBOT_VERSION == "certbot" ]; then
	if [ $CFG_WEBSERVER == "apache" ]; then
	    echo -n -e "$IDENTATION_LVL_1 Installing certbot for Apache... "
	    apt_install certbot python3-certbot-apache
	    certbot --apache >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	    echo -e "[${green}DONE${NC}]"
	elif [ $CFG_WEBSERVER == "nginx" ]; then
	    echo -n -e "$IDENTATION_LVL_1 Installing certbot for Nginx... "
	    apt_install certbot python3-certbot-nginx
	    echo -e "[${green}DONE${NC}]"
	fi

	# Example commands for reference:
	#sudo certbot --apache -d your_domain -d www.your_domain
	#certbot certificates
	#systemctl status certbot.timer
	#certbot renew --dry-run

    elif [ $CFG_CERTBOT_VERSION == "acme.sh" ]; then
 	echo -n -e "$IDENTATION_LVL_1 Installing acme.sh... "
	#Advanced installation
	#git clone https://github.com/Neilpang/acme.sh.git
	#git clone https://github.com/acmesh-official/acme.sh.git
	#cd acme.sh
	#./acme.sh --install  \
	#--home ~/myacme \
	#--config-home ~/myacme/data \
	#--certhome  ~/mycerts \
	#--accountemail  "hi@acme.sh" \
	#--accountkey  ~/myaccount.key \
	#--accountconf ~/myaccount.conf \
	#--useragent  "this is my client."

	#wget -O -  https://raw.githubusercontent.com/acmesh-official/acme.sh/master/acme.sh | INSTALLONLINE=1 sh
	#wget -O -  https://raw.githubusercontent.com/acmesh-official/acme.sh/master/acme.sh | sh -s -- --install-online -m  wolftronics@wolftronics.hu
	curl https://get.acme.sh | sh -s
	acme.sh --set-default-ca --server letsencrypt

	USER_HOME="/home/$SUDO_USER/"
	if [ ! -d "$USER_HOME/.acme.sh" ]; then
	    echo -n -e "$IDENTATION_LVL_2 Copying .acme.sh from root to $SUDO_USER... "
	    cp -r /root/.acme.sh "$USER_HOME/.acme.sh"
	    chown -R "$SUDO_USER:$SUDO_USER" "$USER_HOME/.acme.sh"
	    echo -e "[${green}DONE${NC}]"
	else
	    echo -e "$IDENTATION_LVL_2 .acme.sh already exists in $USER_NAME's home directory. [${yellow}SKIPPED${NC}]"
	fi
    
	# Create alias for acme.sh
	if ! grep -q "alias acme.sh" ~/.bashrc; then
	    echo "alias acme.sh='~/.acme.sh/acme.sh'" >> ~/.bashrc
	    source ~/.bashrc
	fi

	# Cron job configuration
	#echo "0 0 * * * /home/$SUDO_USER/.acme.sh/acme.sh --cron --home /home/$SUDO_USER/.acme.sh > /dev/null" >> /etc/crontab
	echo -e "[${green}DONE${NC}]"
    else
	echo -n -e "$IDENTATION_LVL_1 SKIP INSTALL - Reason: ${red}Your Choice ${NC}\n"
    fi

    MeasureTimeDuration $START_TIME
}
