#---------------------------------------------------------------------
# Function: InstallBind
#    Install and configure Bind DNS Server
#---------------------------------------------------------------------
InstallBind() {
    local START_TIME=$SECONDS
    
    echo -e "$IDENTATION_LVL_0 ${BWhite}Installing and Configuring Bind DNS Server${NC}"
    echo -n -e "$IDENTATION_LVL_1 Installing Bind9 and Haveged... "
    # If your server is a virtual machine, it is highly recommended to install the haveged daemon 
    # to increase entropy for DNSSEC signing. It is also safe to install haveged on non-virtual servers.			
    if ! apt_install bind9 dnsutils haveged; then
        echo -e "[${red}FAILED${NC}]"
        echo -e "$IDENTATION_LVL_2 ${red}Failed to install packages. Check the log file for more details.${NC}"
        exit 1
    fi
    echo -e "[${green}DONE${NC}]"
    
    echo -n -e "$IDENTATION_LVL_1 Securing Bind9... "
    # Backup the original configuration file
    cp /etc/bind/named.conf.options /etc/bind/named.conf.options.bak

    # Apply security settings
    sed -i '0,/};/{s/\};/\}; \n\n        \/\/ Settings added by ispconfig_install script\n        fetch-glue no; \n        recursion no; \n        allow-query-cache { none; }; \n        version "[Not Available]"; /}' /etc/bind/named.conf.options
    if [ $? -ne 0 ]; then
        echo -e "[${red}FAILED${NC}]"
        echo -e "$IDENTATION_LVL_2 ${red}Failed to secure Bind9. Restoring backup...${NC}"
        mv /etc/bind/named.conf.options.bak /etc/bind/named.conf.options
        exit 1
    fi
    echo -e "[${green}DONE${NC}]"

    echo -n -e "$IDENTATION_LVL_1 Enabling Logging for Bind9... "
    # Create log directory and set permissions
    if ! mkdir -p /var/log/named >> $PROGRAMS_INSTALL_LOG_FILES 2>&1 || ! chown bind /var/log/named >> $PROGRAMS_INSTALL_LOG_FILES 2>&1; then
        echo -e "[${red}FAILED${NC}]"
        echo -e "$IDENTATION_LVL_2 ${red}Failed to create log directory or set permissions.${NC}"
        exit 1
    fi

    # Append logging configuration to named.conf.options
    cat << "EOF" >> /etc/bind/named.conf.options
# Enable Logging
logging {
  channel security_file {
        file "/var/log/named/security.log" versions 3 size 30m;
        severity dynamic;
        print-time yes;
  };
  category security {
        security_file;
  };
};
EOF

    if [ $? -ne 0 ]; then
        echo -e "[${red}FAILED${NC}]"
        echo -e "$IDENTATION_LVL_2 ${red}Failed to enable logging for Bind9.${NC}"
        exit 1
    fi
    echo -e "[${green}DONE${NC}]"

    MeasureTimeDuration $START_TIME
}
