#---------------------------------------------------------------------
# Function: InstallMetronome
#    Install and configure Metronome IM server
#---------------------------------------------------------------------
InstallMetronome() {
  local START_TIME=$SECONDS

  echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing Metronome IM Server${NC}"

  # Install required packages
  echo -e "$IDENTATION_LVL_1 ${BWhite}Installing dependencies...${NC}"
  package_install git lua5.1 liblua5.1-0-dev lua-filesystem libidn11-dev libssl-dev lua-zlib lua-expat lua-event lua-bitop lua-socket lua-sec luarocks
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Failed to install dependencies. Aborting.${NC}"
    return 1
  fi
  
  # Install Lua LPC library
  echo -e "$IDENTATION_LVL_1 ${BWhite}Installing Lua LPC library...${NC}"
  luarocks install lpc
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Failed to install Lua LPC. Aborting.${NC}"
    return 1
  fi  
  
  # Create Metronome user
  echo -e "$IDENTATION_LVL_1 ${BWhite}Creating Metronome user...${NC}"
  adduser --no-create-home --disabled-login --gecos 'Metronome' metronome
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Failed to create Metronome user. Aborting.${NC}"
    return 1
  fi

  # Clone Metronome repository
  echo -e "$IDENTATION_LVL_1 ${BWhite}Cloning Metronome repository...${NC}"
  cd /opt
  git clone https://github.com/maranda/metronome.git metronome
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Failed to clone Metronome repository. Aborting.${NC}"
    return 1
  fi
  
  # Configure and install Metronome
  echo -e "$IDENTATION_LVL_1 ${BWhite}Configuring and installing Metronome...${NC}"
  cd /opt/metronome
  ./configure --ostype=debian --prefix=/usr
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Configuration failed. Aborting.${NC}"
    return 1
  fi
  
  make
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Build failed. Aborting.${NC}"
    return 1
  fi

  make install
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Installation failed. Aborting.${NC}"
    return 1
  fi  

  # Generate SSL certificates
  echo -e "$IDENTATION_LVL_1 ${BWhite}Generating SSL certificates...${NC}"
  mkdir -p /etc/metronome/certs
  cd /etc/metronome/certs
  make localhost.key && make localhost.csr && make localhost.cert
  if [ $? -ne 0 ]; then
    echo -e "$IDENTATION_LVL_1 ${red}Failed to generate SSL certificates. Aborting.${NC}"
    return 1
  fi

  # Set permissions for SSL certificates
  chmod 0400 localhost.key
  chown metronome:metronome localhost.key

  # Create systemd service for Metronome
#  echo -e "$IDENTATION_LVL_1 ${BWhite}Creating systemd service for Metronome...${NC}"
#  cat <<EOF > /etc/systemd/system/metronome.service
#[Unit]
#Description=Metronome IM Server
#After=network.target

#[Service]
#User=metronome
#ExecStart=/usr/bin/metronome
#Restart=on-failure

#[Install]
#WantedBy=multi-user.target
#EOF

#  systemctl daemon-reload
#  systemctl enable metronome
#  systemctl start metronome

#  if [ $? -ne 0 ]; then
#    echo -e "$IDENTATION_LVL_1 ${red}Failed to start Metronome service. Aborting.${NC}"
#    return 1
#  fi

#  echo -e "$IDENTATION_LVL_1 ${green}Metronome IM Server installed successfully!${NC}"

  MeasureTimeDuration $START_TIME
}
