#---------------------------------------------------------------------
# Function: InstallFail2ban
#   Install and configure Fail2Ban and Rootkit detection (rkhunter)
#---------------------------------------------------------------------
InstallFail2ban() {
  local START_TIME=$SECONDS
  
  echo -e "$IDENTATION_LVL_0 ${BWhite}Installing Fail2Ban and Rootkit detection (rkhunter)${NC}"
  echo -n -e "$IDENTATION_LVL_1 Installing required components... "
  package_install fail2ban rkhunter
  echo -e "[${green}DONE${NC}]"

  # Configure Fail2Ban based on the selected MTA
  echo -n -e "$IDENTATION_LVL_1 Configuring Fail2Ban rules... "
  case $CFG_MTA in
    "courier")
      # Courier MTA configuration
      cat > /etc/fail2ban/jail.local <<EOF
[courierpop3]
enabled = true
port = pop3
filter = courierpop3
logpath = /var/log/mail.log
maxretry = 5

[courierpop3s]
enabled = true
port = pop3s
filter = courierpop3s
logpath = /var/log/mail.log
maxretry = 5

[courierimap]
enabled = true
port = imap2
filter = courierimap
logpath = /var/log/mail.log
maxretry = 5

[courierimaps]
enabled = true
port = imaps
filter = courierimaps
logpath = /var/log/mail.log
maxretry = 5
EOF

      # Courier filter configurations
      for service in pop3 pop3s imap imaps; do
        cat > /etc/fail2ban/filter.d/courier${service}.conf <<EOF
[Definition]
failregex = ${service}d(-ssl)?: LOGIN FAILED.*ip=\[.*:<HOST>\]
ignoreregex =
EOF
      done
      ;;

    "dovecot")
      # Dovecot MTA configuration
      cat > /etc/fail2ban/jail.local <<EOF
[dovecot]
enabled = true
filter = dovecot
logpath = /var/log/mail.log
maxretry = 5

[dovecot-pop3imap]
enabled = true
filter = dovecot-pop3imap
action = iptables-multiport[name=dovecot-pop3imap, port="pop3,pop3s,imap,imaps", protocol=tcp]
logpath = /var/log/mail.log
maxretry = 5
EOF

      cat > /etc/fail2ban/filter.d/dovecot-pop3imap.conf <<EOF
[Definition]
failregex = (?: pop3-login|imap-login): .*(?:Authentication failure|Aborted login \(auth failed|Aborted login \(tried to use disabled|Disconnected \(auth failed|Aborted login \(\d+ authentication attempts).*rip=(?P<host>\S*),.*
ignoreregex =
EOF
      ;;
  esac

  # Common Fail2Ban configurations
  cat >> /etc/fail2ban/jail.local <<EOF
[pure-ftpd]
enabled = true
port = ftp
filter = pureftpd
logpath = /var/log/syslog
maxretry = 3

[postfix-sasl]
enabled = true
port = smtp
filter = postfix[mode=auth]
logpath = /var/log/mail.log
maxretry = 5
EOF

  cat > /etc/fail2ban/filter.d/pureftpd.conf <<EOF
[Definition]
failregex = .*pure-ftpd: \(.*@<HOST>\) \[WARNING\] Authentication failed for user.*
ignoreregex =
EOF

  echo "ignoreregex =" >> /etc/fail2ban/filter.d/postfix-sasl.conf

  # Additional Fail2Ban rules for web server
  cat >> /etc/fail2ban/jail.local <<EOF
#block direct access to wp-config.php*
[nginx-wp-config]
enabled  = false
port     = http,https
filter   = nginx-wp-config
logpath  = /var/www/clients/client*/web*/log/access.log
maxretry = 1
bantime  = 2635200

#block access to /.jpg|/.txt etc
[nginx-wp-dot-access]
enabled  = false
port     = http,https
filter   = nginx-wp-dot-access
logpath  = /var/www/clients/client*/web*/log/access.log
maxretry = 1
bantime  = 2635200

#block errors like "access forbidden by rule"
[nginx-wp-access-denied-by-rule]
enabled  = false
port     = http,https
filter   = nginx-wp-access-denied-by-rule
logpath  = /var/www/clients/client*/web*/log/access.log
maxretry = 1
bantime  = 2635200

#block bad bots from apache
[nginx-badbots]
enabled  = false
port     = http,https
filter   = apache-badbots
logpath  = /var/www/clients/client*/web*/log/access.log
maxretry = 1
bantime  = 86400
EOF

  # Additional Fail2Ban filters for web server
  cat > /etc/fail2ban/filter.d/nginx-wp-config.conf <<EOF
[Definition]
failregex = client: <HOST>,.* "(GET|POST) /wp-config.*
ignoreregex =
EOF

  cat > /etc/fail2ban/filter.d/nginx-wp-dot-access.conf <<EOF
[Definition]
failregex = client: <HOST>,.* "(GET|POST).*(/\.php|/\.asp|/\.exe|/\.pl|/\.cgi|/\scgi|/\.txt|/\.jpg|/\.html)
ignoreregex =
EOF

  cat > /etc/fail2ban/filter.d/nginx-wp-access-denied-by-rule.conf <<EOF
[Definition]
failregex = access forbidden by rule, client: <HOST>.*
ignoreregex =
EOF

  echo -e "[${green}DONE${NC}]"
  
  # Restart Fail2Ban service
  echo -n -e "$IDENTATION_LVL_1 Restarting Fail2Ban service... "
  service fail2ban restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  echo -e "[${green}DONE${NC}]"

  # Install and configure UFW firewall
  echo -n -e "$IDENTATION_LVL_1 Installing Firewall (UFW)... "
  package_install ufw
  echo -e "[${green}DONE${NC}]"

  # Measure and display the time taken for the installation
  MeasureTimeDuration $START_TIME
}

