#---------------------------------------------------------------------
# Function: InstallFTP
#    Install and configure PureFTPd
#---------------------------------------------------------------------
InstallFTP() {
  local START_TIME=$SECONDS

  echo -e "$IDENTATION_LVL_0 ${BWhite}Installing PureFTPd${NC}"

  if [ "$CFG_FTP" == "none" ]; then
    echo -e "$IDENTATION_LVL_1 SKIP INSTALL - Reason: ${red}Not Selected${NC}"
    return
  fi

  echo -e "$IDENTATION_LVL_1 Setting Virtual Chroot to ${BBlack}true${NC}... "
  echo "pure-ftpd-common pure-ftpd/virtualchroot boolean true" | debconf-set-selections
  echo -e "[${green}DONE${NC}]"

  echo -e "$IDENTATION_LVL_1 Installing PureFTPd... "
  package_install pure-ftpd-common pure-ftpd-mysql
  sed -i 's/ftp/\#ftp/' /etc/inetd.conf >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  echo -e " [${green}DONE${NC}]"

  echo -e "$IDENTATION_LVL_1 Configuring PureFTPd to accept "
  case "$CFG_FTP" in
    "onlyFTP") echo -e "${red}FTP Only${NC}"; echo 0 >/etc/pure-ftpd/conf/TLS ;;
    "onlyTLS") echo -e "${red}TLS Only${NC}"; echo 2 >/etc/pure-ftpd/conf/TLS ;;
    *) echo -e "${red}Both FTP and TLS${NC}"; echo 1 >/etc/pure-ftpd/conf/TLS ;;
  esac
  echo -e "connections [${green}DONE${NC}]"

  echo -e "$IDENTATION_LVL_1 Generating and Installing SSL Certificate for FTP Server... "
  mkdir -p /etc/ssl/private/ >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  openssl dhparam -out /etc/ssl/private/pure-ftpd-dhparams.pem 4096 >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  openssl req -x509 -nodes -days 7300 -newkey rsa:4096 -keyout /etc/ssl/private/pure-ftpd.pem -out /etc/ssl/private/pure-ftpd.pem -subj "/C=$SSL_COUNTRY/ST=$SSL_STATE/L=$SSL_LOCALITY/O=$SSL_ORGANIZATION/OU=$SSL_ORGUNIT/CN=$CFG_HOSTNAME_FQDN" >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  chmod 600 /etc/ssl/private/pure-ftpd.pem >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  echo -e "[${green}DONE${NC}]"

  echo -e "$IDENTATION_LVL_1 Restarting FTP Server... "
  service openbsd-inetd restart >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  service pure-ftpd-mysql restart >>"$PROGRAMS_INSTALL_LOG_FILES" 2>&1
  echo -e "[${green}DONE${NC}]"  

  MeasureTimeDuration $START_TIME
}

