#---------------------------------------------------------------------
# Function: AskQuestions Ubuntu 16.04
#	Ask for all needed user input
#---------------------------------------------------------------------
AskQuestions() {
	  CFG_SETUP_WEB=yes #Needed for Multiserver setup compatibility
	  CFG_SETUP_MAIL=yes #Needed for Multiserver setup compatibility
	  CFG_SETUP_NS=yes #Needed for Multiserver setup compatibility
	if ! command -v whiptail >/dev/null; then
		echo -n "Installing whiptail... "
		apt_install whiptail
		echo -e "[${green}DONE${NC}]\n"
	fi
	
	while [[ ! "$CFG_SQLSERVER" =~ $RE ]]
	do
                CFG_SQLSERVER=$(whiptail --title "SQL Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select SQL Server type" 10 50 2 "MariaDB" "(default)" ON "MySQL" "" OFF 3>&1 1>&2 2>&3)
	done
	
	while [[ ! "$CFG_MYSQL_ROOT_PWD" =~ $RE ]]
	do
		CFG_MYSQL_ROOT_PWD=$(whiptail --title "$CFG_SQLSERVER" --backtitle "$WT_BACKTITLE" --passwordbox "Please specify a root password" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$CFG_WEBSERVER" =~ $RE ]]
	do
                CFG_WEBSERVER=$(whiptail --title "Web server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select Web server type" 10 50 2 "Nginx" "(default)" ON "Apache" "" OFF 3>&1 1>&2 2>&3)
	done
	CFG_WEBSERVER=${CFG_WEBSERVER,,}

	while [[ ! "$CFG_XCACHE" =~ $RE ]]
	do
		CFG_XCACHE=$(whiptail --title "Install XCache" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install XCache (PHP opcode cacher)? ATTENTION: If XCache is installed, Ioncube Loaders will not work !!" 20 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	while [[ ! "$CFG_PHPMYADMIN" =~ $RE ]]
	do
		CFG_PHPMYADMIN=$(whiptail --title "Install phpMyAdmin" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install phpMyAdmin?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	while [[ ! "$CFG_MTA" =~ $RE ]]
	do
		CFG_MTA=$(whiptail --title "Mail Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select Mail server type" 10 50 2 "Dovecot" "(default)" ON "Courier" "" OFF 3>&1 1>&2 2>&3)
	done
	CFG_MTA=${CFG_MTA,,}

	while [[ ! "$CFG_WEBMAIL" =~ $RE ]]
	do
		CFG_WEBMAIL=$(whiptail --title "Webmail client" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select your webmail client" 10 50 2 "roundcube" "(default)" ON "squirrelmail" "" OFF 3>&1 1>&2 2>&3)
	done
	CFG_WEBMAIL=${CFG_WEBMAIL,,}

	while [[ ! "$CFG_HHVMINSTALL" =~ $RE ]]
	do
		CFG_HHVMINSTALL=$(whiptail --title "Install HHVM" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install HHVM? (Hip Hop Virtual Machine) as PHP engine?" 10 50 2 "no" "(default)" ON "yes" "" OFF 3>&1 1>&2 2>&3)
	done
	
	while [[ ! "$CFG_METRONOME" =~ $RE ]]
	do
		CFG_METRONOME=$(whiptail --title "Install Metronome XMPP Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Metronome XMPP Chat Server?" 10 50 2 "yes" "" OFF "no""(default)" ON 3>&1 1>&2 2>&3)
	done
	
	while [[ ! "$CFG_AVUPDATE" =~ $RE ]]
	do
		CFG_AVUPDATE=$(whiptail --title "Update Freshclam DB" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to update Antivirus Database?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	if [[ ! "$CFG_QUOTA" =~ $RE ]]; then
		if (whiptail --title "Quota" --backtitle "$WT_BACKTITLE" --yesno "Setup user quota?" 10 50) then
			CFG_QUOTA=yes
		else
			CFG_QUOTA=no
		fi
	fi

	while [ "x$CFG_CLOUDINSTALL" == "x" ]
	do
		CFG_CLOUDINSTALL=$(whiptail --title "Install Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Nextcloud Server?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	if [ "$CFG_CLOUDINSTALL" == "yes" ]; then
		while [ "x$CFG_CLOUDUPGRADE" == "x" ]
		do
		  CFG_CLOUDUPGRADE=$(whiptail --title "Install Or Upgrade Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to upgrade Owncloud to Nextcloud Server or Fresh install?" 10 50 2 "yes" "(Upgrade)" OFF "no" "(Fresh install)" ON 3>&1 1>&2 2>&3)
		done

		while [ "x$CFG_CLOUDDBTYPE" == "x" ]
		do
		  CFG_CLOUDDBTYPE=$(whiptail --title "Nextcloud Server mysql or sqlite" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to Nextcloud Server mysql or sqlite?" 10 50 2 "mysql" "(default)" ON "sqlite" "" OFF 3>&1 1>&2 2>&3)
		done

		while [ "x$CFG_CLOUDDBHOST" == "x" ]
	  	do
		  CFG_CLOUDDBHOST=$(whiptail --title "Nextcloud DB host" --backtitle "$WT_BACKTITLE" --inputbox "Nextcloud database host - (default localhost) or (ext. host)" --nocancel 10 50 3>&1 1>&2 2>&3)
	  	done
	fi

	while [[ ! "$CFG_ISPC" =~ $RE ]]
	do
		CFG_ISPC=$(whiptail --title "ISPConfig Setup" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Would you like full unattended setup of expert mode for ISPConfig?" 10 50 2 "standard" "(default)" ON "expert" "" OFF 3>&1 1>&2 2>&3)
	done

	if [[ ! "$CFG_JKIT" =~ $RE ]]; then
		if (whiptail --title "Jailkit" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install Jailkit (it must be installed before ISPConfig)?" 10 50) then
			CFG_JKIT=yes
		else
			CFG_JKIT=no
		fi
	fi

	if (whiptail --title "Last kernel" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install 4.11.2 kernel?" 10 50) then
		CFG_LASTKERNEL=yes
	else
		CFG_LASTKERNEL=no
	fi
	
	while [[ ! "$SSL_COUNTRY" =~ $RE ]]
	do
		SSL_COUNTRY=$(whiptail --title "SSL Country" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Country (ex. HU)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_STATE" =~ $RE ]]
	do
		SSL_STATE=$(whiptail --title "SSL State" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - STATE (ex. Hungary)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_LOCALITY" =~ $RE ]]
	do
		SSL_LOCALITY=$(whiptail --title "SSL Locality" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Locality (ex. Bekescsaba)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_ORGANIZATION" =~ $RE ]]
	do
		SSL_ORGANIZATION=$(whiptail --title "SSL Organization" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization (ex. Wolftronics L.t.d.)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

	while [[ ! "$SSL_ORGUNIT" =~ $RE ]]
	do
		SSL_ORGUNIT=$(whiptail --title "SSL Organization Unit" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization Unit (ex. IT Department)" --nocancel 10 50 3>&1 1>&2 2>&3)
	done

cat > /root/wtserver_configuration.txt <<EOF
# Store the passwords
SERVER_TYPE=standard
CFG_MIRRORSERVER=$CFG_MIRRORSERVER
CFG_SETUP_MASTER=$CFG_SETUP_MASTER
CFG_SQLSERVER=$CFG_SQLSERVER
CFG_SQLSERVER_CLUSTER=$CFG_SQLSERVER_CLUSTER
CFG_MYSQL_ROOT_PWD=$CFG_MYSQL_ROOT_PWD
CFG_MASTER_MYSQL_ROOT_PWD=$CFG_MASTER_MYSQL_ROOT_PWD
CFG_WEBSERVER=$CFG_WEBSERVER
CFG_QUOTA=$CFG_QUOTA
CFG_JKIT=$CFG_JKIT
CFG_PHPMYADMIN=$CFG_PHPMYADMIN
CFG_CLOUDINSTALL=$CFG_CLOUDINSTALL
CFG_WEBMAIL=$CFG_WEBMAIL
CFG_ROUNDCUBE_DB=$CFG_ROUNDCUBE_DB
CFG_ROUNDCUBE_USR=$CFG_ROUNDCUBE_USR
CFG_ROUNDCUBE_PWD=$CFG_ROUNDCUBE_PWD
CFG_MTA=$CFG_MTA
SSL_COUNTRY=$SSL_COUNTRY
SSL_STATE=$SSL_STATE
SSL_LOCALITY=$SSL_LOCALITY
SSL_ORGANIZATION=$SSL_ORGANIZATION
SSL_ORGUNIT=$SSL_ORGUNIT
INSTALL_STAGE=1

EOF

}

