OS_default_PHP_back() {
    update-alternatives --set php /usr/bin/php8.2
    update-alternatives --set php-cgi /usr/bin/php-cgi8.2
    update-alternatives --set php-fpm.sock /run/php/php8.2-fpm.sock
}

InstallPhp55() {
### Install PHP 5.5.38
### https://www.howtoforge.com/tutorial/how-to-install-php-5-6-on-ubuntu-16-04/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 5.5.38 and Modules... "

apt_install build-essential libxml2-dev libxslt1-dev 
apt_install libfcgi-dev libfcgi0ldbl libjpeg9-dbg libxml2-dev
apt_install libmcrypt-dev libssl-dev libc-client2007e libc-client2007e-dev
apt_install libbz2-dev libcurl4-openssl-dev libjpeg-dev libpng-dev
apt_install libfreetype6-dev libkrb5-dev libpq-dev libicu-dev

ln -s /usr/lib/libc-client.a /usr/lib/x86_64-linux-gnu/libc-client.a

mkdir /opt/php-5.5.38
mkdir /usr/local/src/php5-build
cd /usr/local/src/php5-build
wget http://br1.php.net/get/php-5.5.38.tar.bz2/from/this/mirror -O php-5.5.38.tar.bz2
tar jxf php-5.5.38.tar.bz2

cd php-5.5.38/
./configure --prefix=/opt/php-5.5.38 --with-pdo-pgsql --with-zlib-dir --with-freetype-dir --enable-mbstring \
--with-libxml-dir=/usr --enable-soap --enable-intl --enable-calendar --with-curl --with-mcrypt --with-zlib \
--with-gd --with-pgsql --disable-rpath --enable-inline-optimization --with-bz2 --with-zlib --enable-sockets \
--enable-sysvsem --enable-sysvshm --enable-pcntl --enable-mbregex --enable-exif --enable-bcmath --with-mhash \
--enable-zip --with-pcre-regex --with-mysql --with-pdo-mysql --with-mysqli --with-jpeg-dir=/usr --with-png-dir=/usr \
--enable-gd-native-ttf --with-openssl --with-fpm-user=www-data --with-fpm-group=www-data \
--with-libdir=/lib/x86_64-linux-gnu --enable-ftp --with-imap --with-imap-ssl --with-gettext --with-xmlrpc --with-xsl \
--with-kerberos --enable-fpm > /dev/null 2>&1

make > /dev/null 2>&1
make install > /dev/null 2>&1
cp /usr/local/src/php5-build/php-5.5.38/php.ini-production /opt/php-5.5.38/lib/php.ini
cp /opt/php-5.5.38/etc/php-fpm.conf.default /opt/php-5.5.38/etc/php-fpm.conf
mkdir /opt/php-5.5.38/etc/php-fpm.d

echo "[Unit]
Description=The PHP 5.5.38 FastCGI Process Manager
After=network.target
[Service]
Type=simple
PIDFile=/opt/php-5.5.38/var/run/php-fpm.pid
ExecStart=/opt/php-5.5.38/sbin/php-fpm --nodaemonize --fpm-config /opt/php-5.5.38/etc/php-fpm.conf
ExecReload=/bin/kill -USR2 $MAINPID
[Install]
WantedBy=multi-user.target" >> /lib/systemd/system/php-5.5.38-fpm.service

echo 'zend_extension=opcache.so' >> /opt/php-5.5.38/lib/php.ini

## Modified ini do PHP
for i in /opt/php-5.5.38/lib/php.ini;do
sed -i 's|max_execution_time = 30|max_execution_time = 120|' $i
sed -i 's|upload_max_filesize = 2M|upload_max_filesize = 32M|' $i
sed -i 's|post_max_size = 8M|post_max_size = 32M|' $i
sed -i 's|error_reporting = E_ALL & ~E_DEPRECATED|error_reporting =  E_ERROR|' $i
sed -i 's|short_open_tag = Off|short_open_tag = On|' $i
sed -i "s|;date.timezone =|date.timezone = 'America\/Sao_Paulo'|" $i
done

### Modified PHP-FPM Config
sed -i "s|;pid = run/php-fpm.pid|pid = run/php-fpm.pid|" /opt/php-5.5.38/etc/php-fpm.conf
sed -i "s|listen = 127.0.0.1:9000|listen = 127.0.0.1:8996|" /opt/php-5.5.38/etc/php-fpm.conf
sed -i "s|;include=etc/fpm.d/\*.conf|include=/opt/php-5.5.38/etc/php-fpm.d/\*.conf|" /opt/php-5.5.38/etc/php-fpm.conf

systemctl enable php-5.5.38-fpm.service
systemctl daemon-reload
systemctl start php-5.5.38-fpm.service

#/opt/php-5.5.38/bin/php-cgi
#/opt/php-5.5.38/lib
#php-5.5.38-fpm
#/opt/php-5.5.38/lib
#/opt/php-5.5.38/etc/php-fpm.d

echo -e "[${green}DONE${NC}]"
}

InstallPhp56() {
### Install PHP 5.6.40
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 5.6.40 and Modules... "

apt_install php5.6 php5.6-cli php5.6-cgi php5.6-fpm php5.6-gd php5.6-mysql php5.6-imap php5.6-curl php5.6-intl php5.6-pspell php5.6-recode php5.6-sqlite3 php5.6-tidy php5.6-xmlrpc php5.6-xsl php5.6-zip php5.6-mbstring php5.6-soap php5.6-opcache php5.6-common php5.6-json php5.6-readline php5.6-xml
#libicu65

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp70() {
### Install PHP 7.0.33
### https://www.howtoforge.com/tutorial/how-to-install-php-7-on-debian/
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 7.0.33 and Modules... "

apt_install bphp7.0 php7.0-cli php7.0-cgi php7.0-fpm php7.0-gd php7.0-mysql php7.0-imap php7.0-curl php7.0-intl php7.0-pspell php7.0-recode php7.0-sqlite3 php7.0-tidy php7.0-xmlrpc php7.0-xsl php7.0-zip php7.0-mbstring php7.0-soap php7.0-opcache php7.0-common php7.0-json php7.0-readline php7.0-xml

OS_default_PHP_back

#Fast-CGI settings:
#Path to the PHP FastCGI binary: /usr/bin/php-cgi7.0
#Path to the php.ini directory: /etc/php/7.0/cgi/

#PHP-FPM settings:
#Path to the PHP-FPM init script: php7.0-fpm
#Path to the php.ini directory: /etc/php/7.0/fpm/
#Path to the PHP-FPM pool directory: /etc/php/7.0/fpm/pool.d/

echo -e "[${green}DONE${NC}]"
}

InstallPhp71() {
### Install PHP 7.1.33
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 7.1.33 and Modules... "

apt_install php7.1 php7.1-cli php7.1-cgi php7.1-fpm php7.1-gd php7.1-mysql php7.1-imap php7.1-curl php7.1-intl php7.1-pspell php7.1-recode php7.1-sqlite3 php7.1-tidy php7.1-xmlrpc php7.1-xsl php7.1-zip php7.1-mbstring php7.1-soap php7.1-opcache php7.1-common php7.1-json php7.1-readline php7.1-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp72() {
### Install PHP 7.2.34
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 7.2.34 and Modules... "

apt_install php7.2 php7.2-cli php7.2-cgi php7.2-fpm php7.2-gd php7.2-mysql php7.2-imap php7.2-curl php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl php7.2-zip php7.2-mbstring php7.2-soap php7.2-opcache php7.2-common php7.2-json php7.2-readline php7.2-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp73() {
### Install PHP 7.3.33
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 7.3.33 and Modules... "

apt_install php7.3 php7.3-cli php7.3-cgi php7.3-fpm php7.3-gd php7.3-mysql php7.3-imap php7.3-curl php7.3-intl php7.3-pspell php7.3-recode php7.3-sqlite3 php7.3-tidy php7.3-xmlrpc php7.3-xsl php7.3-zip php7.3-mbstring php7.3-soap php7.3-opcache php7.3-common php7.3-json php7.3-readline php7.3-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"

InstallPhp74() {
### Install PHP 7.4.33
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 7.4.33 and Modules... "

apt_install php7.4 php7.4-cli php7.4-cgi php7.4-fpm php7.4-gd php7.4-mysql php7.4-imap php7.4-curl php7.4-intl php7.4-pspell php7.4-sqlite3 php7.4-tidy php7.4-xmlrpc php7.4-xsl php7.4-zip php7.4-mbstring php7.4-soap php7.4-opcache libonig5 php7.4-common php7.4-json php7.4-readline php7.4-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"

InstallPhp80() {
### Install PHP 8.0.30
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 8.0.30 and Modules... "

apt_install php8.0 php8.0-cli php8.0-cgi php8.0-fpm php8.0-gd php8.0-mysql php8.0-imap php8.0-curl php8.0-intl php8.0-pspell php8.0-sqlite3 php8.0-tidy php8.0-xsl php8.0-zip php8.0-mbstring php8.0-soap php8.0-opcache libonig5 php8.0-common php8.0-readline php8.0-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp81() {
### Install PHP 8.1.31
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 8.1.31 and Modules... "

apt_install install php8.1 php8.1-cli php8.1-cgi php8.1-fpm php8.1-gd php8.1-mysql php8.1-imap php8.1-curl php8.1-intl php8.1-pspell php8.1-sqlite3 php8.1-tidy php8.1-xsl php8.1-zip php8.1-mbstring php8.1-soap php8.1-opcache libonig5 php8.1-common php8.1-readline php8.1-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp82() {
### Install PHP 8.2.31
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 8.2.27 and Modules... "

apt_install php8.2 php8.2-cli php8.2-cgi php8.2-fpm php8.2-gd php8.2-mysql php8.2-imap php8.2-curl php8.2-intl php8.2-pspell php8.2-sqlite3 php8.2-tidy php8.2-xsl php8.2-zip php8.2-mbstring php8.2-soap php8.2-opcache libonig5 php8.2-common php8.2-readline php8.2-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp83() {
### Install PHP 8.3.17
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 8.3.17 and Modules... "

apt_install php8.3 php8.3-cli php8.3-cgi php8.3-fpm php8.3-gd php8.3-mysql php8.3-imap php8.3-curl php8.3-intl php8.3-pspell php8.3-sqlite3 php8.3-tidy php8.3-xsl php8.3-zip php8.3-mbstring php8.3-soap php8.3-opcache libonig5 php8.3-common php8.3-readline php8.3-xml

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}

InstallPhp84() {
### Install PHP 8.4.4
### https://www.howtoforge.com/ispconfig-php-debian/
echo -n -e "$IDENTATION_LVL_1 Installing PHP 8.4.4 and Modules... "

apt_install php8.4 php8.4-cli php8.4-cgi php8.4-fpm php8.4-gd php8.4-mysql php8.4-imap php8.4-curl php8.4-intl php8.4-pspell php8.4-sqlite3 php8.4-tidy php8.4-xsl php8.4-zip php8.4-mbstring php8.4-soap php8.4-opcache libonig5 php8.4-common php8.4-readline php8.4-xmlbuild-essential libxml2-dev libxslt1-dev

OS_default_PHP_back
echo -e "[${green}DONE${NC}]"
}


