#---------------------------------------------------------------------
# Function: InstallWebmail
#    Install the chosen webmail client. Squirrelmail or Roundcube
#---------------------------------------------------------------------
InstallWebmail() {
VERSION=1.6-beta
HASH=f09b4d458cec242a08e01bc2a1fe3d07bec2b84c
PERSISTENT_LOGIN_VERSION=bde7b6840c7d91de627ea14e81cf4133cbb3c07a
HTML5_NOTIFIER_VERSION=68d9ca194212e15b3c7225eb6085dbcf02fd13d7
FILTERS_VERSION=764e4d5757cf0726261e365c194ff70a83333158
LOGINSEC_VERSION=5db3d4808477557260fcf0af9e30741379920759
RCM_RECAPTCHA=f1d89d0a3fc954ba595081494b7c664eb6dc1ea7
CARDDAV_VERSION=4.3.0
CARDDAV_HASH=8537c00fa30b620b02f4f8645817e187fc392e76

UPDATE_KEY=$VERSION:$PERSISTENT_LOGIN_VERSION:$HTML5_NOTIFIER_VERSION:$FILTERS_VERSION:$RCM_RECAPTCHA:$CARDDAV_VERSION

START_TIME=$SECONDS


    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing WebMail Client${NC}\n"	
    #case $CFG_WEBMAIL in
    #	"roundcube")
    if [ $CFG_WEBMAIL == "roundcube" ]; then
	    echo -n -e "$IDENTATION_LVL_1 Installing ${red} RoundCube ${NC} WebMail Client...\n"
	    echo -n -e "$IDENTATION_LVL_2 Configure Roundcube..."
	    #CFG_ROUNDCUBE_PWD=$(< /dev/urandom tr -dc A-Z-a-z-0-9 | head -c16)
	    echo "roundcube-core roundcube/dbconfig-install boolean true" | debconf-set-selections
	    echo "roundcube-core roundcube/database-type select mysql" | debconf-set-selections
	    echo "roundcube-core roundcube/mysql/admin-pass password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
	    echo "roundcube-core roundcube/db/dbname string roundcube" | debconf-set-selections
	    echo "roundcube-core roundcube/mysql/app-pass password $CFG_ROUNDCUBE_PWD" | debconf-set-selections
	    echo "roundcube-core roundcube/app-password-confirm password $CFG_ROUNDCUBE_PWD" | debconf-set-selections
	    echo "roundcube-core roundcube/hosts string localhost" | debconf-set-selections
	    echo -e " [ ${green}DONE${NC} ] "

	    #backports=$(cat /etc/apt/sources.list | grep jessie-backports | grep -v "#")

	    # if [ -z "$backports" ]; then
	    # 	echo -e "\n# jessie-backports, previously on backports.debian.org" >> /etc/apt/sources.list
	    # 	echo "deb http://http.debian.net/debian/ jessie-backports main contrib non-free" >> /etc/apt/sources.list
	    # 	echo "deb-src http://http.debian.net/debian/ jessie-backports main contrib non-free" >> /etc/apt/sources.list
	    # fi
	    echo -n -e "$IDENTATION_LVL_2 Installing Roundcube..."		  	
	    package_install -t buster roundcube-core roundcube roundcube-mysql roundcube-plugins
	    echo -e " [ ${green}DONE${NC} ] "

	    echo -n -e "$IDENTATION_LVL_2 Configure RoundCube on WebServer..." 
    #;;
    #"roundcube-lates")
    elif [ $CFG_WEBMAIL == "roundcube-latest" ]; then
	    echo -n -e "$IDENTATION_LVL_1 Installing ${red} RoundCube ${NC} WebMail Client...\n"
	    echo -n -e "$IDENTATION_LVL_2 Configure Roundcube... "
	    #if [ "$CFG_MULTISERVER" == "no" ] && [ "$CFG_MIRRORSERVER" == "no" ]; then
		# Generate a safe 24-character secret key of safe characters.
		#CFG_ROUNDCUBE_PWD=$(< /dev/urandom tr -dc A-Z-a-z-0-9 | head -c12)
		#deskey=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9-_#&!*%?' | fold -w 24 | head -n 1)
		##CFG_ROUNDCUBE_PWD=$(dd if=/dev/urandom bs=1 count=18 2>/dev/null | base64 | fold -w 24 | head -n 1)
		##CFG_ROUNDCUBE_DB="roundcube"
		##CFG_ROUNDCUBE_USR="roundcube"
	    #fi

	    CFG_ROUNDCUBE_PRODUCTNAME="Wolftronics Webmail"

	    hide_output apt-get update
	    #apt_install dbconfig-common \
	    #    javascript-common libjs-jquery-mousewheel php-net-sieve tinymce php-pear php7.0-intl php7.0-mcrypt \
	    #    php7.0-cli php7.0-sqlite php7.0-json php7.0-common php-auth php-net-smtp php-net-socket php-mail-mime \
	    #    php-crypt-gpg php7.0-gd php7.0-pspell libjs-jquery libmagic1 php7.0-mbstring
	    #apt_install dbconfig-common \
	    #    javascript-common libjs-jquery-mousewheel php-net-sieve tinymce php-pear php7.2-intl \
	    #    php7.2-cli php7.2-sqlite3 php7.2-json php7.2-common php-net-smtp php-net-socket php-mail-mime \
	    #    php7.2-gd php7.2-pspell libjs-jquery libmagic1 php7.2-mbstring
	    echo -n -e "$IDENTATION_LVL_2 Installing Roundcube ... "
	    package_install -t php8.1 php8.1-gd php8.1-mysql php8.1-curl php8.1-zip php8.1-ldap php8.1-mbstring php8.1-imagick php8.1-intl php8.1-xml unzip wget curl javascript-common libjs-jquery-mousewheel libjs-jquery libmagic1 tinymce
	    #phpenmod intl mcrypt

	    #apt_get_quiet remove php-mail-mimedecode # no longer needed since Roundcube 1.1.3
	    pear channel-update pear.php.net
	    pear install Mail_Mime
	    #pepear install "channel://pear.php.net/Net_IDNA2-0.2.0"
	    #php pyrus.phar install pear/Net_IDNA2

	    # We used to install Roundcube from Ubuntu, without triggering the dependencies #NODOC
	    # on Apache and MySQL, by downloading the debs and installing them manually. #NODOC
	    # Now that we're beyond that, get rid of those debs before installing from source. #NODOC
	    apt-get purge -qq -y roundcube* #NODOC

	    # paths that are often reused.
	    RCM_DIR=/usr/share/roundcube
	    RCM_PLUGIN_DIR=${RCM_DIR}/plugins
	    RCM_CONFIG=${RCM_DIR}/config/config.inc.php

	    needs_update=0 #NODOC
	    if [ ! -f /usr/local/lib/roundcubemail/version ]; then
		# not installed yet #NODOC
		needs_update=1 #NODOC
	    elif [[ "$UPDATE_KEY" != `cat /usr/local/lib/roundcubemail/version` ]]; then
		# checks if the version is what we want
		needs_update=1 #NODOC
	    fi
	    if [ $needs_update == 1 ]; then
		# install roundcube
		wget_verify \
		    https://github.com/roundcube/roundcubemail/releases/download/$VERSION/roundcubemail-$VERSION-complete.tar.gz \
		    $HASH \
		    /tmp/roundcube.tgz

		tar -C /usr/local/lib --no-same-owner -zxf /tmp/roundcube.tgz
		rm -rf /usr/local/lib/roundcubemail
		mv /usr/local/lib/roundcubemail-$VERSION/ $RCM_DIR
		rm -f /tmp/roundcube.tgz

		mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "CREATE DATABASE ${CFG_ROUNDCUBE_DB}" > /dev/null 2>&1
		mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "GRANT ALL PRIVILEGES ON ${CFG_ROUNDCUBE_DB}.* TO ${CFG_ROUNDCUBE_USR}@localhost IDENTIFIED BY '$CFG_ROUNDCUBE_PWD'" > /dev/null 2>&1
		mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "flush privileges;" > /dev/null 2>&1
		mysql -uroot -p"$CFG_MYSQL_ROOT_PWD" ${CFG_ROUNDCUBE_DB} < /usr/share/roundcube/SQL/mysql.initial.sql
		cp -pf /usr/share/roundcube/config/config.inc.php.sample /usr/share/roundcube/config/config.inc.php

		# Create writable directories.
		mkdir -p /var/log/roundcubemail /tmp/roundcubemail
		chown -R www-data.www-data /var/log/roundcubemail /tmp/roundcubemail

		# Ensure the log file monitored by fail2ban exists, or else fail2ban can't start.
		sudo -u www-data touch /var/log/roundcubemail/errors

		# Password changing plugin settings
		# The config comes empty by default, so we need the settings
		# we're not planning to change in config.inc.dist...
		#cp ${RCM_PLUGIN_DIR}/password/config.inc.php.dist \
		#     ${RCM_PLUGIN_DIR}/password/config.inc.php

		#roundcube extra plugins
		#git clone https://github.com/sjinks/roundcube_recaptcha
		#cp -r /tmp/roundcube_recaptcha /usr/share/roundcube/plugins/

		# install roundcube persistent_login plugin
		git_clone https://github.com/mfreiholz/Roundcube-Persistent-Login-Plugin.git $PERSISTENT_LOGIN_VERSION '' ${RCM_PLUGIN_DIR}/persistent_login
		# install roundcube html5_notifier plugin
		git_clone https://github.com/kitist/html5_notifier.git $HTML5_NOTIFIER_VERSION '' ${RCM_PLUGIN_DIR}/html5_notifier
		# install roundcube filters plugin
		#git_clone https://github.com/6ec123321/filters.git $FILTERS_VERSION '' ${RCM_PLUGIN_DIR}/filters
		# install roundcube Login Security for Roundcube Webmail. TOTP + Brute Force + CAPTCHA
		git_clone https://github.com/dapphp/Roundcube-Plugin-login_security $LOGINSEC_VERSION '' ${RCM_PLUGIN_DIR}/login_security
		# install roundcube reCAPTCHA plugin
		git_clone https://github.com/sjinks/roundcube_recaptcha $RCM_RECAPTCHA '' ${RCM_PLUGIN_DIR}/roundcube_recaptcha
		# download and verify the full release of the carddav plugin
		git_clone https://github.com/blind-coder/rcmcarddav $CARDDAV_HASH '' ${RCM_PLUGIN_DIR}/carddav
		#wget_verify \
		#    https://github.com/blind-coder/rcmcarddav/releases/download/v${CARDDAV_VERSION}/carddav-${CARDDAV_VERSION}.zip \
		#    $CARDDAV_HASH \
		#    /tmp/carddav.zip

		# unzip and cleanup
		#unzip -q /tmp/carddav.zip -d ${RCM_PLUGIN_DIR}
		#rm -f /tmp/carddav.zip
		# Configure CardDav
		echo -e "
<?php
/* Do not edit. Written by Wolftronics. Regenerated on updates. */
\$prefs['_GLOBAL']['hide_preferences'] = true;
\$prefs['_GLOBAL']['suppress_version_warning'] = true;
\$prefs['ownCloud'] = array(
	'name'         =>  'ownCloud',
	'username'     =>  '%u', // login username
	'password'     =>  '%p', // login password
	'url'          =>  'https://cloud.$CFG_HOSTNAME_DOMAIN/cloud/remote.php/carddav/addressbooks/%u/contacts',
	'active'       =>  true,
	'readonly'     =>  false,
	'refresh_time' => '02:00:00',
	'fixed'        =>  array('username','password'),
	'preemptive_auth' => '1',
	'hide'        =>  false,
	);" > ${RCM_PLUGIN_DIR}/carddav/config.inc.php

		# record the version we've installed
		echo $UPDATE_KEY > ${RCM_DIR}/version
	    fi
	    echo -e " [ ${green}DONE${NC} ] "

	    echo -n -e "$IDENTATION_LVL_2 Configure RoundCube on WebServer..."	
	    ln -s /usr/share/roundcube /var/lib/roundcube
	    if [ $CFG_WEBSERVER == "apache" ]; then
	    #case $CFG_WEBSERVER in
	    #"apache")
		mv /etc/roundcube/apache.conf /etc/roundcube/apache.conf.default
		echo -e "
<VirtualHost *:80>
	# Those aliases do not work properly with several hosts on your apache server
	# Uncomment them to use it or adapt them to your configuration
	#    Alias /roundcube /var/lib/roundcube
	Alias /webmail /var/lib/roundcube

	<Directory /var/lib/roundcube/>
	  Options +FollowSymLinks
	  # This is needed to parse /var/lib/roundcube/.htaccess. See its
	  # content before setting AllowOverride to None.
	  AllowOverride All
	  <IfVersion >= 2.3>
		Require all granted
	  </IfVersion>
	  <IfVersion < 2.3>
		Order allow,deny
		Allow from all
	  </IfVersion>
	</Directory>

	# Protecting basic directories:
	<Directory /var/lib/roundcube/config>
			Options -FollowSymLinks
			AllowOverride None
	</Directory>

	<Directory /var/lib/roundcube/temp>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>

	<Directory /var/lib/roundcube/logs>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>
</VirtualHost>

<IfModule mod_ssl.c>
<VirtualHost *:443>
	# Those aliases do not work properly with several hosts on your apache server
	# Uncomment them to use it or adapt them to your configuration
	#    Alias /roundcube /var/lib/roundcube
	Alias /webmail /var/lib/roundcube

	<Directory /var/lib/roundcube/>
	  Options +FollowSymLinks
	  # This is needed to parse /var/lib/roundcube/.htaccess. See its
	  # content before setting AllowOverride to None.
	  AllowOverride All
	  <IfVersion >= 2.3>
		Require all granted
	  </IfVersion>
	  <IfVersion < 2.3>
		Order allow,deny
		Allow from all
	  </IfVersion>
	</Directory>

	# Protecting basic directories:
	<Directory /var/lib/roundcube/config>
			Options -FollowSymLinks
			AllowOverride None
	</Directory>

	<Directory /var/lib/roundcube/temp>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>

	<Directory /var/lib/roundcube/logs>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>

	# SSL Configuration
	SSLEngine On
	SSLProtocol All -SSLv2 -SSLv3
	#SSLCertificateFile    /usr/local/ispconfig/interface/ssl/ispserver.crt
	#SSLCertificateKeyFile /usr/local/ispconfig/interface/ssl/ispserver.key
	SSLCertificateFile     /home/administrator/.acme.sh/webmail.$CFG_HOSTNAME_DOMAIN/fullchain.cer
	SSLCertificateKeyFile  /home/administrator/.acme.sh/webmail.$CFG_HOSTNAME_DOMAIN/webmail.$CFG_HOSTNAME_DOMAIN.key
	#SSLCACertificateFile  /usr/local/ispconfig/interface/ssl/ispserver.bundle
</VirtualHost>
</IfModule>" > /etc/roundcube/apache.conf
	    #else
	    #;;
	    #"nginx")
	    elif [ $CFG_WEBSERVER == "nginx" ]; then
		APPS_SOCKET="/var/lib/php5-fpm/apps.sock"
		if [ -f /var/run/php/php7.0-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php7.0-fpm.sock"
		elif [ -f /var/run/php/php7.1-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php7.1-fpm.sock"
		elif [ -f /var/run/php/php7.2-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php7.2-fpm.sock"
		elif [ -f /var/run/php/php7.3-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php7.3-fpm.sock"
		elif [ -f /var/run/php/php7.4-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php7.4-fpm.sock"
		elif [ -f /var/run/php/php8.0-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php8.0-fpm.sock"
		elif [ -f /var/run/php/php8.1-fpm.sock ]; then
			APPS_SOCKET="/var/run/php/php8.1-fpm.sock"
		fi

		echo -e "
server {
    listen 80;
    server_name webmail.$CFG_HOSTNAME_DOMAIN;
    return 301 https://\$server_name\$request_uri;
}

server {
      #listen 80 http2;
      # SSL configuration
      listen 443 ssl http2;
      ssl_protocols TLSv1.2 TLSv1.3;
      ssl_certificate        /root/.acme.sh/webmail.$CFG_HOSTNAME_DOMAIN/fullchain.cer;
      ssl_certificate_key    /root/.acme.sh/webmail.$CFG_HOSTNAME_DOMAIN/webmail.$CFG_HOSTNAME_DOMAIN.key;

      ssl_ciphers 'ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA256:ECDHE-ECDSA-AES128-SHA:ECDHE-RSA-AES256-SHA384:ECDHE-RSA-AES128-SHA:ECDHE-ECDSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES128-SHA:DHE-RSA-AES256-SHA256:DHE-RSA-AES256-SHA:ECDHE-ECDSA-DES-CBC3-SHA:ECDHE-RSA-DES-CBC3-SHA:EDH-RSA-DES-CBC3-SHA:AES128-GCM-SHA256:AES256-GCM-SHA384:AES128-SHA256:AES256-SHA256:AES128-SHA:AES256-SHA:DES-CBC3-SHA:!DSS';
      ssl_prefer_server_ciphers on;

      server_name webmail.*;
      index index.php index.html;
      root /var/lib/roundcube;
      location ~ ^/favicon.ico$ {
        root /var/lib/roundcube/skins/default/images;
        log_not_found off;
        access_log off;
        expires max;
      }
      location = /robots.txt {
          allow all;
          log_not_found off;
          access_log off;
      }
      location ~ ^/(README|INSTALL|LICENSE|CHANGELOG|UPGRADING)$ {
          deny all;
      }
      location ~ ^/(bin|SQL)/ {
          deny all;
      }
      location ~* /.svn/ {
        deny all;
      }
      location ~ /\. {
          deny all;
          access_log off;
          log_not_found off;
      }
      location ~ \.php$ {
          #try_files $uri =404;
          #root /var/lib/;
          include /etc/nginx/fastcgi_params;
          fastcgi_param   REDIRECT_STATUS         200;
          # To access SquirrelMail, the default user (like www-data on Debian/Ubuntu) must be used
          #fastcgi_pass 127.0.0.1:9000;
          fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
	  #apps_socket hibás!!!
          #fastcgi_pass unix:$APPS_SOCKET;
          fastcgi_index index.php;
          fastcgi_param SCRIPT_FILENAME \$document_root\$fastcgi_script_name;
          fastcgi_buffer_size 128k;
          fastcgi_buffers 256 4k;
          fastcgi_busy_buffers_size 256k;
          fastcgi_temp_file_write_size 256k;
      }
}" > /etc/nginx/sites-available/webmail-roundcube.vhost

		#mkdir -p /etc/nginx/sites-enabled
		ln -s /etc/nginx/sites-available/webmail-roundcube.vhost /etc/nginx/sites-enabled/000-webmail-roundcube.vhost
	    #fi
	    #;;
	    #esac
	    fi

	    echo -e " [ ${green}DONE${NC} ] "

	    echo -n -e "$IDENTATION_LVL_2 Integrate RoundCube with ISPConfig... " 
	    # ISPConfig integration

	    wget -q --no-check-certificate -O $PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_roundcube.tgz https://github.com/w2c/ispconfig3_roundcube/tarball/master
	    mkdir -p $PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_roundcube && tar xzf $PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_roundcube.tgz -C $PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_roundcube
	    cp -r $PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_roundcube/*ispconfig3_roundcube*/ispconfig3_* /usr/share/roundcube/plugins/

	    ln -s /usr/share/roundcube/plugins/ispconfig3_account /var/lib/roundcube/plugins/ispconfig3_account
	    ln -s /usr/share/roundcube/plugins/ispconfig3_autoreply /var/lib/roundcube/plugins/ispconfig3_autoreply
	    ln -s /usr/share/roundcube/plugins/ispconfig3_autoselect /var/lib/roundcube/plugins/ispconfig3_autoselect
	    ln -s /usr/share/roundcube/plugins/ispconfig3_fetchmail /var/lib/roundcube/plugins/ispconfig3_fetchmail
	    ln -s /usr/share/roundcube/plugins/ispconfig3_filter /var/lib/roundcube/plugins/ispconfig3_filter
	    ln -s /usr/share/roundcube/plugins/ispconfig3_forward /var/lib/roundcube/plugins/ispconfig3_forward
	    ln -s /usr/share/roundcube/plugins/ispconfig3_pass /var/lib/roundcube/plugins/ispconfig3_pass
	    ln -s /usr/share/roundcube/plugins/ispconfig3_spam /var/lib/roundcube/plugins/ispconfig3_spam
	    ln -s /usr/share/roundcube/plugins/ispconfig3_wblist /var/lib/roundcube/plugins/ispconfig3_wblist
	    # Create a configuration file.
	    #
	    # For security, temp and log files are not stored in the default locations
	    # which are inside the roundcube sources directory. We put them instead
	    # in normal places.
	    sed -i "s|^\(\$config\['default_host'\] =\).*$|\1 \ array(\n'mail.${CFG_HOSTNAME_DOMAIN}' => 'Default Server',\n'webmail.${CFG_HOSTNAME_FQDN}.hu' => 'Webmail Server',\n'ssl://mail.${CFG_HOSTNAME_DOMAIN}:993' => 'Secure Webmail Server'\n\);|" /usr/share/roundcube/config/config.inc.php
	    sed -i "s|^\(\$config\['db_dsnw'\] =\).*$|\1 \'mysqli://${CFG_ROUNDCUBE_DB}:${CFG_ROUNDCUBE_PWD}@localhost/${CFG_ROUNDCUBE_DB}\';|" /usr/share/roundcube/config/config.inc.php
	    sed -i "s|^\(\$config\['smtp_host'\] =\).*$|\1 \'%h\';|" /usr/share/roundcube/config/config.inc.php
	    #sed -i "s|^\(\$config\['smtp_port'\] =\).*$|\1 \'587\';|" /usr/share/roundcube/config/config.inc.php
	    sed -i "s|^\(\$config\['smtp_user'\] =\).*$|\1 \'%u\';|" /usr/share/roundcube/config/config.inc.php
	    sed -i "s|^\(\$config\['smtp_pass'\] =\).*$|\1 \'%p\';|" /usr/share/roundcube/config/config.inc.php
	    sed -i "s|^\(\$config\['product_name'\] =\).*$|\1 \'${roundcubeproductname}\';|" /usr/share/roundcube/config/config.inc.php
	    #sed -i "s|^\(\$config\['support_url'\] =\).*$|\1 \'mailto:${E}\';|" /usr/share/roundcube/config/config.inc.php
	    #sed -i "s|^\(\$config\['des_key'\] =\).*$|\1 \'${deskey}\';|" /usr/share/roundcube/config/config.inc.php
	    sed -i "/'zipdownload',/a 'jqueryui',\n'filters',\n'html5_notifier',\n'persistent_login',\n'managesieve',\n'emoticons',\n'ispconfig3_account',\n'ispconfig3_autoreply',\n'ispconfig3_autoselect',\n'ispconfig3_pass',\n'ispconfig3_spam',\n'ispconfig3_fetchmail',\n'ispconfig3_filter',\n'ispconfig3_forward',\n'ispconfig3_wblist'," /usr/share/roundcube/config/config.inc.php
	    echo "\$config['login_autocomplete'] = 2;" >> /usr/share/roundcube/config/config.inc.php
	    echo "\$config['password_charset'] = 'UTF-8';" >> /usr/share/roundcube/config/config.inc.php
	    echo "\$config['junk_mbox'] = 'Spam';" >> /usr/share/roundcube/config/config.inc.php
	    echo "\$config['log_dir'] = '/var/log/roundcubemail/';" >> /usr/share/roundcube/config/config.inc.php
	    echo "\$config['temp_dir'] = '/tmp/roundcubemail/';" >> /usr/share/roundcube/config/config.inc.php
	
	    mv /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php.dist /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	    sed -i "s/\(\$config\['remote_soap_user'\] = \)'.*';/\1'$CFG_ROUNDCUBE_SOAP_USR';/g" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	    #sed -i "s/\$config\['remote_soap_pass'\] = '.*';/\$config\['remote_soap_pass'\] = '$CFG_ROUNDCUBE_PWD';/" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	    sed -i "s/\(\$config\['remote_soap_pass'\] = \)'.*';/\1'$CFG_ROUNDCUBE_SOAP_PWD';/g" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	    #sed -i "s/\$config\['soap_url'\] = '.*';/\$config['soap_url'] = 'https\:\/\/$CFG_HOSTNAME_FQDN\:$CFG_ISPONCFIG_PORT\/remote\/';/" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	    sed -i "s/\(\$config\['soap_url'\] = \)'.*';/\1'https\:\/\/$IP_ADDRESS\:$CFG_ISPONCFIG_PORT\/remote\/';/g" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	    mv /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php.dist /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php
	    sed -i "s/\$config\['password_min_length'\] = 6;/\$config\['password_min_length'\] = 8;/" /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php
	    sed -i "s/\$config\['password_check_symbol'\] = TRUE;/\$config\['password_check_symbol'\] = FALSE;/" /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php
	    rm -rf /usr/share/roundcube/installer
	
	    # Fix Carddav permissions:
	    chown -f -R root.www-data ${RCM_PLUGIN_DIR}/carddav
	    # root.www-data need all permissions, others only read
	    chmod -R 774 ${RCM_PLUGIN_DIR}/carddav
	
	    # Run Roundcube database migration script (database is created if it does not exist)
	    ${RCM_DIR}/bin/updatedb.sh --dir ${RCM_DIR}/SQL --package roundcube
	    
	    composer require roundcube/larry
    #;;
    #"squirrelmail")
    elif [ $CFG_WEBMAIL == "squirrelmail" ]; then
	    if [ $CFG_WEBSERVER == "apache" ]; then
		echo "dictionaries-common dictionaries-common/default-wordlist select american (American English)" | debconf-set-selections
		apt_install squirrelmail wamerican
		ln -s /etc/squirrelmail/apache.conf /etc/apache2/conf-available/squirrelmail.conf
		a2enconf squirrelmail
		sed -i 1d /etc/squirrelmail/apache.conf
		sed -i '1iAlias /webmail /usr/share/squirrelmail' /etc/squirrelmail/apache.conf

		case $CFG_MTA in
		    "courier")
			sed -i 's/$imap_server_type       = "other";/$imap_server_type       = "courier";/' /etc/squirrelmail/config.php
			sed -i 's/$optional_delimiter     = "detect";/$optional_delimiter     = ".";/' /etc/squirrelmail/config.php
			sed -i 's/$default_folder_prefix          = "";/$default_folder_prefix          = "INBOX.";/' /etc/squirrelmail/config.php
			sed -i 's/$trash_folder                   = "INBOX.Trash";/$trash_folder                   = "Trash";/' /etc/squirrelmail/config.php
			sed -i 's/$sent_folder                    = "INBOX.Sent";/$sent_folder                    = "Sent";/' /etc/squirrelmail/config.php
			sed -i 's/$draft_folder                   = "INBOX.Drafts";/$draft_folder                   = "Drafts";/' /etc/squirrelmail/config.php
			sed -i 's/$default_sub_of_inbox           = true;/$default_sub_of_inbox           = false;/' /etc/squirrelmail/config.php
			sed -i 's/$delete_folder                  = false;/$delete_folder                  = true;/' /etc/squirrelmail/config.php
		    ;;
		    "dovecot")
			sed -i 's/$imap_server_type       = "other";/$imap_server_type       = "dovecot";/' /etc/squirrelmail/config.php
			sed -i 's/$trash_folder                   = "INBOX.Trash";/$trash_folder                   = "Trash";/' /etc/squirrelmail/config.php
			sed -i 's/$sent_folder                    = "INBOX.Sent";/$sent_folder                    = "Sent";/' /etc/squirrelmail/config.php
			sed -i 's/$draft_folder                   = "INBOX.Drafts";/$draft_folder                   = "Drafts";/' /etc/squirrelmail/config.php
			sed -i 's/$default_sub_of_inbox           = true;/$default_sub_of_inbox           = false;/' /etc/squirrelmail/config.php
			sed -i 's/$delete_folder                  = false;/$delete_folder                  = true;/' /etc/squirrelmail/config.php
		    ;;
		    esac
	    fi
    fi

    # Enable PHP modules.
    #phpenmod -v php7.2 mcrypt imap
    phpenmod -v php8.1 imap
    systemctl restart php8.1-fpm

    #ssl cert generated
    systemctl stop nginx

    if [ "$CFG_SSL_NEW" == "yes" ]; then
	sh /root/.acme.sh/acme.sh --issue --standalone -d webmail.$CFG_HOSTNAME_DOMAIN --force
    else
	#cp -av /home/administrator/wtlinux_server_setup/acme_ssl/$CFG_HOSTNAME_FQDN/webmail.$CFG_HOSTNAME_FQDN.hu /home/administrator/.acme.sh/
	cp -av /home/administrator/wtlinux_server_setup/acme_ssl/$CFG_HOSTNAME_DOMAIN/webmail.$CFG_HOSTNAME_DOMAIN /root/.acme.sh/
    fi

    if [ $CFG_WEBSERVER == "apache" ]; then
	    #acme.sh --install-cert -d webmail.wolftronics.hu \
	    #--cert-file      /path/to/certfile/in/apache/cert.pem  \
	    #--key-file       /path/to/keyfile/in/apache/key.pem  \
	    #--fullchain-file /path/to/fullchain/certfile/apache/fullchain.pem \
	    #--reloadcmd     "service apache2 force-reload"
	    service apache2 restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    else
	    #acme.sh --install-cert -d webmail.wolftronics.hu \
	    #--key-file       /path/to/keyfile/in/nginx/key.pem  \
	    #--fullchain-file /path/to/fullchain/nginx/cert.pem \
	    #--reloadcmd     "service nginx force-reload"
	    service nginx restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    fi

    cat >> /home/administrator/wtlinux_server_setup/wtserver_configuration.txt <<EOF
# $CFG_WEBMAIL Store the passwords
#------------------------------
Webamail software		: $CFG_WEBMAIL
Database type			: $CFG_SQLSERVER
Database name			: $CFG_ROUNDCUBE_DB
Database user			: $CFG_ROUNDCUBE_USR
Database password		: $CFG_ROUNDCUBE_PWD

Ispconfig3 soap user		: $CFG_ROUNDCUBE_SOAP_USR
Ispconfig3 soap password	: $CFG_ROUNDCUBE_SOAP_PWD
#------------------------------

EOF

    MeasureTimeDuration $START_TIME
}
