#---------------------------------------------------------------------
# Function: InstallISPConfig
#    Start the ISPConfig3 installation script
#---------------------------------------------------------------------
InstallISPConfig() {
  START_TIME=$SECONDS
  echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing ISPConfig${NC}\n"

  if [ "$CFG_ISPCVERSION" == "Git stable" ]; then
  	echo -n -e "$IDENTATION_LVL_1 Download Latest ISPConfig git stable-3.1 branch..."
	wget -q -O $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-stable-old-git.tar.gz https://git.ispconfig.org/ispconfig/ispconfig3/-/archive/stable-3.1/ispconfig3-stable-old.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1

	echo -n -e "$IDENTATION_LVL_1 Untar the downloaded package..."
	cd $PROGRAMS_INSTALL_DOWNLOAD
	tar xfz $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-stable-old-git.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	#cd $APWD
	AUTO_INSTALL_INI_LOCATION=$PROGRAMS_INSTALL_DOWNLOAD/ispconfig3-stable-old/install
	cd $AUTO_INSTALL_INI_LOCATION
	echo -e " [ ${green}DONE${NC} ] "
  else
	echo -n -e "$IDENTATION_LVL_1 Download Latest ISPConfig..."
	#https://sourceforge.net/projects/ispconfig/files/latest/download seems that it have 3.1.2 instead of 3.1.3
	#wget -q -O $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-3-stable-latest.tar.gz https://ispconfig.org/downloads/ISPConfig-3.1.15p3.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1

	wget -q -O $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-develop-git.tar.gz https://git.ispconfig.org/ispconfig/ispconfig3/-/archive/develop/ispconfig3-develop.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1

	echo -e " [ ${green}DONE${NC} ] "

	echo -n -e "$IDENTATION_LVL_1 Untar the downloaded package..."
	cd $PROGRAMS_INSTALL_DOWNLOAD
	tar xfz $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-develop-git.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	#cd $APWD
	AUTO_INSTALL_INI_LOCATION=$PROGRAMS_INSTALL_DOWNLOAD/ispconfig3-develop/install
	cd $AUTO_INSTALL_INI_LOCATION
	echo -e " [ ${green}DONE${NC} ] "
  fi
  
  if [ "$CFG_ISPC" == "standard" ]; then
	echo -n -e "$IDENTATION_LVL_1 Create the autoinstall file "
	touch $AUTO_INSTALL_INI_LOCATION/autoinstall.ini
	echo "[install]" >$AUTO_INSTALL_INI_LOCATION/autoinstall.ini
	echo "language=en" >>$AUTO_INSTALL_INI_LOCATION/autoinstall.ini
	echo "install_mode=$CFG_ISPC" >>$AUTO_INSTALL_INI_LOCATION/autoinstall.ini
	echo "hostname=$CFG_HOSTNAME_FQDN" >>$AUTO_INSTALL_INI_LOCATION/autoinstall.ini

	echo "mysql_hostname=localhost" >> autoinstall.ini
	echo "mysql_root_user=root" >> autoinstall.ini
	echo "mysql_root_password=$CFG_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_database=dbispconfig" >> autoinstall.ini
	echo "mysql_port=3306" >> autoinstall.ini
	echo "mysql_charset=utf8" >> autoinstall.ini
	if [ "$CFG_WEBSERVER" == "apache" ]; then
		echo "http_server=apache" >> autoinstall.ini
	elif [ "$CFG_WEBSERVER" == "nginx" ]; then
		echo "http_server=nginx" >> autoinstall.ini
	else
	    echo "http_server=" >> autoinstall.ini
	fi
	echo "ispconfig_port=$CFG_ISPONCFIG_PORT" >> autoinstall.ini
	echo "ispconfig_use_ssl=n" >> autoinstall.ini
	#echo "ispconfig_use_ssl=y" >> autoinstall.ini
	echo "ispconfig_admin_password=$CFG_ISPONCFIG_ADMIN_PASS" >> autoinstall.ini
	echo
	echo "[ssl_cert]" >> autoinstall.ini
	echo "ssl_cert_country=$SSL_COUNTRY" >> autoinstall.ini
	echo "ssl_cert_state=$SSL_STATE" >> autoinstall.ini
	echo "ssl_cert_locality=$SSL_LOCALITY" >> autoinstall.ini
	echo "ssl_cert_organisation=$SSL_ORGANIZATION" >> autoinstall.ini
	echo "ssl_cert_organisation_unit=$SSL_ORGUNIT" >> autoinstall.ini
	echo "ssl_cert_common_name=$CFG_HOSTNAME_FQDN" >> autoinstall.ini
	echo
	echo "[expert]" >> autoinstall.ini
	echo "mysql_ispconfig_user=ispconfig" >> autoinstall.ini
	echo "mysql_ispconfig_password=afStEratXBsgatRtsa42CadwhQ" >> autoinstall.ini
	echo "join_multiserver_setup=$MULTISERVER" >> autoinstall.ini
	echo "mysql_master_hostname=$CFG_MASTER_FQDN" >> autoinstall.ini
	echo "mysql_master_root_user=root" >> autoinstall.ini
	echo "mysql_master_root_password=$CFG_MASTER_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_database=dbispconfig" >> autoinstall.ini
	echo "configure_mail=$CFG_SETUP_MAIL" >> autoinstall.ini
	if [ $CFG_SETUP_WEB == "yes" ]; then
	    echo "configure_jailkit=$CFG_JKIT" >> autoinstall.ini
	else
	    echo "configure_jailkit=n" >> autoinstall.ini
	fi
	echo "configure_ftp=$CFG_SETUP_WEB" >> autoinstall.ini
	echo "configure_dns=$CFG_SETUP_NS" >> autoinstall.ini
	echo "configure_apache=$CFG_APACHE" >> autoinstall.ini
	echo "configure_nginx=$CFG_NGINX" >> autoinstall.ini
	echo "configure_firewall=y" >> autoinstall.ini
	echo "install_ispconfig_web_interface=$CFG_SETUP_MASTER" >> autoinstall.ini
	echo
	echo "[update]" >> autoinstall.ini
	echo "do_backup=yes" >> autoinstall.ini
	echo "mysql_root_password=$CFG_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_hostname=$CFG_MASTER_FQDN" >> autoinstall.ini
	echo "mysql_master_root_user=root" >> autoinstall.ini
	echo "mysql_master_root_password=$CFG_MASTER_MYSQL_ROOT_PWD" >> autoinstall.ini
	echo "mysql_master_database=dbispconfig" >> autoinstall.ini
	echo "reconfigure_permissions_in_master_database=no" >> autoinstall.ini
	echo "reconfigure_services=yes" >> autoinstall.ini
	echo "ispconfig_port=$CFG_ISPONCFIG_PORT" >> autoinstall.ini
	echo "create_new_ispconfig_ssl_cert=no" >> autoinstall.ini
	echo "reconfigure_crontab=yes" >> autoinstall.ini
	echo | php -q install.php --autoinstall=autoinstall.ini
  else
	php -q install.php
  fi

  sed -i "s/listen 8081 ;/listen $CFG_ISPONCFIG_APPS_PORT;/g" /etc/nginx/sites-available/apps.vhost
  sed -i "s/listen \[::\]:8081 ipv6only=on;/listen \[::\]:$CFG_ISPONCFIG_APPS_PORT ipv6only=on;/g" /etc/nginx/sites-available/apps.vhost

  sed -i "s/listen $CFG_ISPONCFIG_PORT;/listen $CFG_ISPONCFIG_PORT ssl http2;/g" /etc/nginx/sites-available/ispconfig.vhost
  sed -i "s/listen \[::\]:$CFG_ISPONCFIG_PORT ipv6only=on;/listen \[::\]:$CFG_ISPONCFIG_PORT ssl ipv6only=on http2;/g" /etc/nginx/sites-available/ispconfig.vhost

  sed "/ssl on;/d" /etc/nginx/sites-available/ispconfig.vhost

  cat >> /home/administrator/wtlinux_server_setup/wtserver_configuration.txt <<EOF
# Ispconfig3 config
#------------------------------
Ispconfig3 Admin   		: admin
Ispconfig3 Password   		: $CFG_ISPONCFIG_ADMIN_PASS

Ispconfig3 ip			: $IP_ADDRESS
Ispconfig3 port			: $CFG_ISPONCFIG_PORT
Ispconfig3 app_port		: $CFG_ISPONCFIG_APPS_PORT
#------------------------------

EOF

  systemctl stop nginx

  if [ "$CFG_SSL_NEW" == "yes" ]; then
	sh /root/.acme.sh/acme.sh --issue --standalone -d server1.$CFG_HOSTNAME_DOMAIN --force
  else
	#cp -av /home/administrator/wtlinux_server_setup/acme_ssl/$CFG_HOSTNAME_FQDN/webmail.$CFG_HOSTNAME_FQDN.hu /home/administrator/.acme.sh/
	cp -av /home/administrator/wtlinux_server_setup/acme_ssl/$CFG_HOSTNAME_DOMAIN/server1.$CFG_HOSTNAME_DOMAIN /root/.acme.sh/
  fi

  ln -sf /root/.acme.sh/server1.$CFG_HOSTNAME_DOMAIN/server1.$CFG_HOSTNAME_DOMAIN.cer /usr/local/ispconfig/interface/ssl/ispserver.crt
  ln -sf /root/.acme.sh/server1.$CFG_HOSTNAME_DOMAIN/server1.$CFG_HOSTNAME_DOMAIN.key /usr/local/ispconfig/interface/ssl/ispserver.key

  if [ $CFG_SETUP_WEB == "yes" ]; then
    if [ "$CFG_WEBSERVER" == "nginx" ]; then
        echo -n "Restarting nginx... "
        #/etc/init.d/nginx restart
	service nginx restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    elif [ "$CFG_WEBSERVER" == "apache" ]; then
        echo -n "Restarting Apache... "
        #/etc/init.d/apache2 restart
	service apache2 restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    fi
	echo -e "[${green}DONE${NC}]\n"
  fi

}
