#---------------------------------------------------------------------
# Function: AskQuestions Debian 10
#	Ask for all needed user input
#---------------------------------------------------------------------
AskQuestions() {
  	START_TIME=$SECONDS
  	CFG_SETUP_WEB=true  #Needed for Multiserver setup compatibility
  	CFG_SETUP_MAIL=true #Needed for Multiserver setup compatibility
  	CFG_SETUP_NS=true   #Needed for Multiserver setup compatibility

  	echo -n -e "$IDENTATION_LVL_0 ${BWhite}Gathering informations about softwares and versions:${NC} "
  	echo

	if [[ ! "$CFG_SSL_NEW" =~ $RE ]]; then
		if (whiptail --title "SSL" --backtitle "$WT_BACKTITLE" --yesno "Generate new ssl or used last gerated ssl?" 10 60) then
			CFG_SSL_NEW=yes
		else
			CFG_SSL_NEW=no
		fi
	fi
	
	while [[ ! "$CFG_SQLSERVER" =~ $RE ]]
	do
		CFG_SQLSERVER=$(whiptail --title "SQL Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select SQL Server type" 10 50 2 "MariaDB" "(default)" ON "MySQL" "" OFF 3>&1 1>&2 2>&3)
	done
		
  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve $CFG_SQLSERVER root password${NC}: "
  	CFG_MYSQL_ROOT_PWD=$(whiptail --title "$CFG_SQLSERVER" --backtitle "$WT_BACKTITLE" --inputbox \
    	  "Please specify a $CFG_SQLSERVER Root Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

  	if [[ -z $CFG_MYSQL_ROOT_PWD ]]; then
    	  CFG_MYSQL_ROOT_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
  	fi

	while [[ ! "$CFG_WEBSERVER" =~ $RE ]]
	do
		CFG_WEBSERVER=$(whiptail --title "Web server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select Web server type" 10 50 2 "Nginx" "(default)" ON "Apache" "" OFF 3>&1 1>&2 2>&3)
	done
	CFG_WEBSERVER=${CFG_WEBSERVER,,}

	while [ "x$CFG_FTP" == "x" ]; do
		CFG_FTP=$(whiptail --title "FTP Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
		    "Install and configure FTP SERVER ?" 10 60 4 \
		    "onlyFTP" "Yes, only with FTP" OFF \
		    "onlyTLS" "Yes, only with TLS" ON \
		    "FTPandTLS" "Yes, with FTP and TLS" OFF \
		    "none" "No, don't install it" OFF 3>&1 1>&2 2>&3)
	done

	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install and Configure FTP Server${NC}: ${green}$CFG_FTP${NC} "
	echo

	while [[ ! "$CFG_MTA" =~ $RE ]]
	do
	    CFG_MTA=$(whiptail --title "Mail Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
		"Select mailserver type" 10 60 3 \
		"None" "" OFF \
		"Dovecot" "(default)" ON \
		"Courier" "" OFF 3>&1 1>&2 2>&3)
	done

	CFG_MTA=${CFG_MTA,,}
	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Mail Server${NC}: ${green}$CFG_MTA${NC} "
	echo

	if [ $CFG_MTA == "none" ]; then
		CFG_WEBMAIL="none"
		CFG_SETUP_MAIL=false
	else
    		CFG_SETUP_MAIL=true
		while [[ ! "$CFG_WEBMAIL" =~ $RE ]]
		do
    		#while [ "x$CFG_WEBMAIL" == "x" ]; do
      			CFG_WEBMAIL=$(whiptail --title "Webmail client" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
        		"Select which Web Mail client you want" 10 60 4 \
        		"Roundcube" "(default)" OFF \
        		"Roundcube-latest" "latest available" ON \
        		"Squirrelmail" "" OFF \
        		"None" "No Web Mail Client" OFF 3>&1 1>&2 2>&3)
    		done
		if [ $CFG_WEBMAIL != "none" ] || [  $CFG_WEBMAIL != "squirrelmail" ]; then
                        while [[ ! "$CFG_ROUNDCUBE_DB" =~ $RE ]]
                        do
                                CFG_ROUNDCUBE_DB=$(whiptail --title "Roundcube database name" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Roundcube database name" --nocancel 10 60 "wt_roundcube" 3>&1 1>&2 2>&3)
                        done

                        while [[ ! "$CFG_ROUNDCUBE_USR" =~ $RE ]]
                        do
                                CFG_ROUNDCUBE_USR=$(whiptail --title "Roundcube database username" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Roundcube database username" --nocancel 10 60 "wt_roundcube" 3>&1 1>&2 2>&3)
                        done

	  		echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Roundcube database password${NC}: "
	  			CFG_ROUNDCUBE_PWD=$(whiptail --title "Roundcube Database Password" --backtitle "$WT_BACKTITLE" --inputbox \
		    	  	  "Please specify a Roundcube Database Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

			if [[ -z $CFG_ROUNDCUBE_PWD ]]; then
		  		CFG_ROUNDCUBE_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
			fi

                        while [[ ! "$CFG_ROUNDCUBE_SOAP_USR" =~ $RE ]]
                        do
                                CFG_ROUNDCUBE_SOAP_USR=$(whiptail --title "Roundcube Ispconfig3 Soap Username" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Roundcube Ispconfig3 Soap Username" --nocancel 10 60 "roundcube_soap" 3>&1 1>&2 2>&3)
                        done

	  		echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Roundcube Ispconfig3 Soap Password${NC}: "
	  			CFG_ROUNDCUBE_SOAP_PWD=$(whiptail --title "Roundcube Ispconfig3 Soap Password" --backtitle "$WT_BACKTITLE" --inputbox \
		    	  	  "Please specify a Roundcube Ispconfig3 Soap Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

			if [[ -z $CFG_ROUNDCUBE_SOAP_PWD ]]; then
		  		CFG_ROUNDCUBE_SOAP_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
			fi

		fi
  	fi
	CFG_WEBMAIL=${CFG_WEBMAIL,,}

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}WebMail client${NC}: ${green}$CFG_WEBMAIL${NC} "
  	echo

	if [[ ! "$CFG_MAILMAN" =~ $RE ]]; then
                if (whiptail --title "Mailman" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install Mailman?" 10 60) then
                        CFG_MAILMAN=yes

		  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Mailman site password${NC}: "
		  	MMSITEPASS=$(whiptail --title "Mailman Site Password" --backtitle "$WT_BACKTITLE" --inputbox \
		    	  "Please specify a Mailman Site Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

		  	if [[ -z $MMSITEPASS ]]; then
		    	  MMSITEPASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
		  	fi

                        while [[ ! "$MMLISTOWNER" =~ $RE ]]
                        do
                                MMLISTOWNER=$(whiptail --title "Mailman Site List Owner" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Mailman site list owner" --nocancel 10 60 "$USER" 3>&1 1>&2 2>&3)
                        done

                        while [[ ! "$MMADMINEMAIL" =~ $RE ]]
                        do
                                MMADMINEMAIL=$(whiptail --title "Mailman Admin e-mail" --backtitle "$WT_BACKTITLE" --inputbox "Please specify the Mailman site list owner" --nocancel 10 60 "mailman@$CFG_HOSTNAME_DOMAIN" 3>&1 1>&2 2>&3)
                        done

		  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Mailman site list password${NC}: "
		  	MMLISTPASS=$(whiptail --title "Mailman Site List Password" --backtitle "$WT_BACKTITLE" --inputbox \
		    	  "Please specify a Mailman Site List Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

		  	if [[ -z $MMLISTPASS ]]; then
		    	  MMLISTPASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
		  	fi
                else
                        CFG_MAILMAN=no
                fi
	fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Mailman${NC}: ${green}$CFG_MAILMAN${NC} "
  	echo

	#while [[ ! "$CFG_AVUPDATE" =~ $RE ]]
	#do
	#	CFG_AVUPDATE=$(whiptail --title "Update Freshclam DB" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to update Antivirus Database?" 10 60 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	#done
  	if (whiptail --title "Update Freshclam DB" --backtitle "$WT_BACKTITLE" --yesno "You want to update Antivirus Database during install?" 10 60); then
    	  CFG_AVUPDATE=true
  	else
    	  CFG_AVUPDATE=false
  	fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Update Antivirus Database${NC}: ${green}$CFG_AVUPDATE${NC} "
  	echo

	while [[ ! "$CFG_ANTISPAM" =~ $RE ]]
	do
		CFG_ANTISPAM=$(whiptail --title "Spam detection" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Please select the spam detection software" 10 60 2 "rspamd" "(default)" ON "amavisd" "(Amavisd+SpamAssassin)" OFF 3>&1 1>&2 2>&3)
	done

  	while [ "x$CFG_PHP_VERSION" == "x" ]; do
    	  CFG_PHP_VERSION=$(whiptail --title "Choose PHP Version(s)" --backtitle "$WT_BACKTITLE" --nocancel --separate-output --checklist \
      	    "Choose PHP Version do you want to install" 20 85 7 \
      	    "php7.0" "Latest Available from 7.0" OFF \
      	    "php7.1" "Latest Available from 7.1" OFF \
      	    "php7.2" "Latest Available from 7.2" OFF \
      	    "php7.3" "Latest Available from 7.3" OFF \
      	    "php7.4" "Latest Available from 7.4" OFF \
      	    "none" "No install" ON 3>&1 1>&2 2>&3)
  	done

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}PHP Version(s)${NC}: ${green}" $CFG_PHP_VERSION "${NC} "
  	echo

  	while [ "x$CFG_PHP_CLI_VERSION" == "x" ]; do
    	  CFG_PHP_CLI_VERSION=$(whiptail --title "Choose PHP Cli Default Version(s)" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
      	    "Choose PHP CLI Version do you want to use" 20 85 7 \
      	    "7.0" "7.0" OFF \
      	    "7.1" "7.1" OFF \
      	    "7.2" "7.2" OFF \
      	    "7.3" "7.3" OFF \
      	    "7.4" "7.4" OFF \
      	    "latest" "Latest Installed" ON 3>&1 1>&2 2>&3)
  	done

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}PHP Version(s)${NC}: ${green}" $CFG_PHP_CLI_VERSION "${NC} "
  	echo

  	while [ "x$CFG_CERTBOT_VERSION" == "x" ]; do
    	  CFG_CERTBOT_VERSION=$(whiptail --title "Install LetsEncrypt CertBot" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
      	    "Select CertBot Version" 10 60 3 \
      	    "None" "No installation" OFF \
      	    "Default" "OS default version" OFF \
      	    "Buster" "Yes, from Buster backports" ON 3>&1 1>&2 2>&3)
  	done

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}LetsEncrypt CertBot Version${NC}: ${green}$CFG_CERTBOT_VERSION${NC} "
  	echo

	#while [[ ! "$CFG_HHVMINSTALL" =~ $RE ]]
	#do
    	#  CFG_HHVM=$(whiptail --title "HHVM" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
      	#    "Do you want to install HHVM (Hip Hop Virtual Machine) as PHP engine?" 10 60 2 \
      	#    "No" "(default)" ON \
      	#    "Yes" "" OFF 3>&1 1>&2 2>&3)
	#done
	
	while [[ ! "$CFG_PHPMYADMIN" =~ $RE ]]
	do
    	  CFG_PHPMYADMIN=$(whiptail --title "Install phpMyAdmin" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
      	    "Do you want to install phpMyAdmin?" 10 60 2 \
      	    "Yes" "(default)" ON \
      	    "No" "" OFF 3>&1 1>&2 2>&3)
  	done

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install PhpMyAdmin${NC}: ${green}$CFG_PHPMYADMIN${NC} "
  	echo

  	if [ $CFG_PHPMYADMIN == "yes" ]; then
    	  while [ "x$CFG_PHPMYADMIN_VERSION" == "x" ]; do
      	    CFG_PHPMYADMIN_VERSION=$(whiptail --title "phpMyAdmin Version" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
              "What version of phpMyAdmin do you want to install?" 15 75 4 \
              "Default" "Current OS Version" OFF \
              "Buster" "From buster backports - newer" OFF \
              "Latest-stable" "from phpMyAdmin.net" ON 3>&1 1>&2 2>&3)
    	  done

    	  echo -n -e "$IDENTATION_LVL_2 ${BBlack}Version${NC}: ${green}$CFG_PHPMYADMIN_VERSION${NC} "
    	  echo
  	else
    	  CFG_PHPMYADMIN_VERSION='none'
  	fi

	while [[ ! "$CFG_METRONOME" =~ $RE ]]
	do
    	  CFG_METRONOME=$(whiptail --title "Metronome IM" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
      	    "Do you want to install Metronome XMPP Chat server?" 10 60 2 \
      	    "No" "(default)" ON \
      	    "Yes" "" OFF 3>&1 1>&2 2>&3)
	done

  	if (whiptail --title "Quota" --backtitle "$WT_BACKTITLE" --yesno "Setup user quota?" 10 60); then
    	  CFG_QUOTA=true
  	else
    	  CFG_QUOTA=false
  	fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Setup Quota${NC}: ${green}$CFG_QUOTA${NC} "
  	echo

	#while [[ ! "$CFG_JKIT" =~ $RE ]]
	#do
	#	CFG_JKIT=$(whiptail --title "Jailkit" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Would you like to install Jailkit (it must be installed before ISPConfig)?" 10 50 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	#done
  	if (whiptail --title "Jailkit" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install Jailkit?" 10 60); then
    	  CFG_JKIT=true
  	else
    	  CFG_JKIT=false
  	fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install Jailkit${NC}: ${green}$CFG_JKIT${NC} "
  	echo

  	#if (whiptail --title "DNS (bind9)" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install DNS server (bind9)?" --defaultno 10 60); then
    	#  CFG_BIND=true
  	#else
    	#  CFG_BIND=false
    	#  CFG_SETUP_NS=false
  	#fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install DNS server (bind9)${NC}: ${green}$CFG_JKIT${NC} "
  	echo

  	if (whiptail --title "WebStats" --backtitle "$WT_BACKTITLE" --yesno "Would you like to install WebStats?" 10 60); then
    	  CFG_WEBSTATS=true
  	else
    	  CFG_WEBSTATS=false
  	fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install DNS server (bind9)${NC}: ${green}$CFG_JKIT${NC} "
  	echo

	#while [ "x$CFG_JOOMLA" == "x" ]
	#do
	#	CFG_JOOMLA=$(whiptail --title "Install CMS" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Select the default CMS" 10 50 2 "joomla" "(default)" ON "drupal" "" OFF 3>&1 1>&2 2>&3)
	#done

	while [ "x$CFG_GITLABINSTALL" == "x" ]
	do
		CFG_GITLABINSTALL=$(whiptail --title "Install Gitlab Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Gitlab Server?" 10 60 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	if [ "$CFG_GITLABINSTALL" == "yes" ]; then
  		echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve Gitlab Admin password${NC}: "
  		CFG_GITLAB_ADMIN_PWD=$(whiptail --title "Gitlab" --backtitle "$WT_BACKTITLE" --inputbox \
    	  	  "Please specify a Gitlab Admin Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

  		if [[ -z $CFG_GITLAB_ADMIN_PWD ]]; then
    	  		CFG_GITLAB_ADMIN_PWD=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
  		fi
	fi

	while [ "x$CFG_CLOUDINSTALL" == "x" ]
	do
		CFG_CLOUDINSTALL=$(whiptail --title "Install Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to install Nextcloud Server?" 10 60 2 "yes" "(default)" ON "no" "" OFF 3>&1 1>&2 2>&3)
	done

	if [ "$CFG_CLOUDINSTALL" == "yes" ]; then
		while [ "x$CFG_CLOUDUPGRADE" == "x" ]
		do
		  CFG_CLOUDUPGRADE=$(whiptail --title "Install Or Upgrade Nextcloud Server" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to upgrade Owncloud to Nextcloud Server or Fresh install?" 10 60 2 "yes" "(Upgrade)" OFF "no" "(Fresh install)" ON 3>&1 1>&2 2>&3)
		done

		while [ "x$CFG_CLOUDDBTYPE" == "x" ]
		do
		  CFG_CLOUDDBTYPE=$(whiptail --title "Nextcloud Server mysql or sqlite" --backtitle "$WT_BACKTITLE" --nocancel --radiolist "Do you want to Nextcloud Server mysql or sqlite?" 10 60 2 "mysql" "(default)" ON "sqlite" "" OFF 3>&1 1>&2 2>&3)
		done

	  	#CFG_CLOUDDBHOST=$(whiptail --title "Nextcloud DB host" --backtitle "$WT_BACKTITLE" \
    	  	#  --inputbox "Nextcloud database host - (default localhost) or (ext. host)" "localhost" --nocancel 10 60  3>&1 1>&2 2>&3)
  		#if [[ -z $SSL_COUNTRY ]]; then
    	  	#  SSL_COUNTRY="localhost"
  		#fi

                while [[ ! "$CFG_CLOUDDBHOST" =~ $RE ]]
                do
	                CFG_CLOUDDBHOST=$(whiptail --title "Nextcloud DB host" --backtitle "$WT_BACKTITLE" --inputbox "Nextcloud database host - (default localhost) or (ext. host)" --nocancel 10 60 "localhost" 3>&1 1>&2 2>&3)
                done
	fi

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}Install Nextcloud server ${NC}: ${green}$CFG_CLOUDINSTALL${NC} "
  	echo

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}ISPConfig Configuration: ${NC}"
  	echo

	while [[ ! "$CFG_ISPC" =~ $RE ]]
	do
    	  CFG_ISPC=$(whiptail --title "ISPConfig Setup" --backtitle "$WT_BACKTITLE" --nocancel --radiolist \
      	    "Would you like full unattended setup of expert mode for ISPConfig?" 10 60 2 \
      	    "standard" "Yes (default)" ON \
      	    "expert" "No, i want to configure" OFF 3>&1 1>&2 2>&3)

	done

	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Install Mode${NC}: ${green}" $CFG_ISPC "${NC} "
	echo

	CFG_ISPONCFIG_PORT=$(whiptail --title "ISPConfig" --backtitle "$WT_BACKTITLE" --inputbox \
	  "Please specify a ISPConfig Port (leave empty for use 8888 port)" --nocancel 10 60 3>&1 1>&2 2>&3)

	if [[ -z $CFG_ISPONCFIG_PORT ]]; then
		CFG_ISPONCFIG_PORT=8888
	fi

	echo -n -e "$IDENTATION_LVL_2 ${BBlack}ISPConfig Port${NC}: ${green}" $CFG_ISPONCFIG_PORT "${NC} "
	echo

  	CFG_ISPONCFIG_APPS_PORT=$(whiptail --title "ISPConfig" --backtitle "$WT_BACKTITLE" --inputbox \
	  "Please specify a ISPConfig Apps Port (leave empty for use 8083 port)" --nocancel 10 60 3>&1 1>&2 2>&3)

	if [[ -z $CFG_ISPONCFIG_APPS_PORT ]]; then
		CFG_ISPONCFIG_APPS_PORT=8083
	fi

	echo -n -e "$IDENTATION_LVL_2 ${BBlack}ISPConfig Apps Port${NC}: ${green}" $CFG_ISPONCFIG_APPS_PORT "${NC} "
	echo

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve ISPConfig Admin password${NC}: "
  	CFG_ISPONCFIG_ADMIN_PASS=$(whiptail --title "ISPConfig" --backtitle "$WT_BACKTITLE" --inputbox \
    	  "Please specify a ISPConfig Admin Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

  	if [[ -z $CFG_ISPONCFIG_ADMIN_PASS ]]; then
    	  CFG_ISPONCFIG_ADMIN_PASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9' | head -c${1:-29})
  	fi

  	echo -e " [ ${green}DONE${NC} ] "

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Retrieve ISPConfig DB password${NC}: "
  	CFG_ISPCONFIG_DB_PASS=$(whiptail --title "ISPConfig DB Password" --backtitle "$WT_BACKTITLE" --inputbox \
    	  "Please specify a ISPConfig DB Password (leave empty for autogenerate)" --nocancel 10 60 3>&1 1>&2 2>&3)

  	if [[ -z $CFG_ISPONCFIG_ADMIN_PASS ]]; then
    	  CFG_ISPCONFIG_DB_PASS_AUTO=true
    	  CFG_ISPCONFIG_DB_PASS=$(tr </dev/urandom -dc 'A-Z-a-z-0-9~!@#^*_=-' | head -c${1:-29})
  	else
    	  CFG_ISPCONFIG_DB_PASS_AUTO=false
  	fi

  	echo -e " [ ${green}DONE${NC} ] "

  	echo -n -e "$IDENTATION_LVL_1 ${BBlack}SSL Configuration:${NC} "
  	echo

  	#SSL_COUNTRY=$(whiptail --title "SSL Country Code" --backtitle "$WT_BACKTITLE" \
    	#  --inputbox "SSL Configuration - Country Code (2 letter code - ex. HU)" --nocancel 10 60 3>&1 1>&2 2>&3)
  	#if [[ -z $SSL_COUNTRY ]]; then
    	#  SSL_COUNTRY="HU"
  	#fi
        while [[ ! "$SSL_COUNTRY" =~ $RE ]]
        do
		SSL_COUNTRY=$(whiptail --title "SSL Country Code" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Country Code (2 letter code - ex. HU)" --nocancel 10 60 "HU" 3>&1 1>&2 2>&3)
	done

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Country${NC}: ${green}" $SSL_COUNTRY "${NC} "
  	echo

  	#SSL_STATE=$(whiptail --title "SSL State or Province Name" --backtitle "$WT_BACKTITLE" \
    	#  --inputbox "SSL Configuration - STATE or Province Name (full name - ex. Hungary)" --nocancel 10 60 3>&1 1>&2 2>&3)
  	#if [[ -z $SSL_STATE ]]; then
    	#  SSL_STATE="Hungary"
  	#fi
        while [[ ! "$SSL_STATE" =~ $RE ]]
        do
		SSL_STATE=$(whiptail --title "SSL State or Province Name" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - STATE or Province Name (full name - ex. Hungary)" --nocancel 10 60 "Hungary" 3>&1 1>&2 2>&3)
	done

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}State${NC}: ${green}" $SSL_STATE "${NC} "
  	echo

  	#SSL_LOCALITY=$(whiptail --title "SSL Locality" --backtitle "$WT_BACKTITLE" \
    	#  --inputbox "SSL Configuration - Locality (ex. Bekescsaba)" --nocancel 10 60 3>&1 1>&2 2>&3)
  	#if [[ -z $SSL_LOCALITY ]]; then
    	#  SSL_LOCALITY="Bekescsaba"
  	#fi
        while [[ ! "$SSL_LOCALITY" =~ $RE ]]
        do
		SSL_LOCALITY=$(whiptail --title "SSL Locality" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Locality (ex. Bekescsaba)" --nocancel 10 60 "Bekescsaba" 3>&1 1>&2 2>&3)
	done

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Locality${NC}: ${green}" $SSL_LOCALITY "${NC} "
  	echo

  	#SSL_ORGANIZATION=$(whiptail --title "SSL Organization" --backtitle "$WT_BACKTITLE" \
    	#  --inputbox "SSL Configuration - Organization (ex. Company L.t.d.)" --nocancel 10 60 3>&1 1>&2 2>&3)
  	#if [[ -z $SSL_ORGANIZATION ]]; then
    	#  SSL_ORGANIZATION="$CFG_HOSTNAME_FQDN"
  	#fi
        while [[ ! "$SSL_ORGANIZATION" =~ $RE ]]
        do
		SSL_ORGANIZATION=$(whiptail --title "SSL Organization" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization (ex. Company L.t.d.)" --nocancel 10 60 "Wolftronics L.t.d" 3>&1 1>&2 2>&3)
	done

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Organization${NC}: ${green}" $SSL_ORGANIZATION "${NC} "
  	echo

  	#SSL_ORGUNIT=$(whiptail --title "SSL Organization Unit" --backtitle "$WT_BACKTITLE" \
    	#  --inputbox "SSL Configuration - Organization Unit (ex. IT)" --nocancel 10 60 "IT" 3>&1 1>&2 2>&3)
  	#if [[ -z $SSL_ORGUNIT ]]; then
    	#  SSL_ORGUNIT="IT"
  	#fi
        while [[ ! "$SSL_ORGUNIT" =~ $RE ]]
        do
		SSL_ORGUNIT=$(whiptail --title "SSL Organization Unit" --backtitle "$WT_BACKTITLE" --inputbox "SSL Configuration - Organization Unit (ex. IT)" --nocancel 10 60 "IT" 3>&1 1>&2 2>&3)
	done

  	echo -n -e "$IDENTATION_LVL_2 ${BBlack}Unit${NC}: ${green}" $SSL_ORGUNIT "${NC} "
  	echo

  	MeasureTimeDuration $START_TIME
}
