#---------------------------------------------------------------------
# Function: PreInstallCheck
#    Do some pre-install checks
#---------------------------------------------------------------------
PreInstallCheck() {
  # Check if user is root
  if [ $(id -u) != "0" ]; then
    echo -n "Error: You must be root to run this script, please use the root user to install the software."
    exit 1
  fi

  # Check connectivity
  echo -n "Checking internet connection... "
  ping -q -c 3 www.ispconfig.org > /dev/null 2>&1

  if [ ! "$?" -eq 0 ]; then
        echo -e "${red}ERROR: Couldn't reach www.ispconfig.org, please check your internet connection${NC}"
        exit 1;
  fi

  echo -n "Preparing to install... "
  DIPGRA="no"
  # Comprobando conectividad 

  #echo -n "Comprobando conexion a internet fuera de Diputacion... "
  #ping -q -c 3 www.google.es > /dev/null 2>&1

  #if [ ! "$?" -eq 0 ]; then
  #      echo -e "\n${red}No hemos podido hacer ping a www.google.es${NC}\n"
  #      echo -n "\n${red}Comprobando ping al repositorio de Diputacion... ${NC}\n"
  #      ping -q -c 3 10.1.1.91 > /dev/null 2>&1
  #      if [ ! "$?" -eq 0 ]; then
  #          echo -e "\n${red}ERROR: No hemos podido hacer ping al repositorio interno ni a internet${NC}\n"
  #          echo -e "\n${red}ERROR: No tenemos conexion ni dentro ni fuera de la Diputacion, comprueba la conexion${NC}\n"
  #          echo -e "\n${red}ERROR: Es necesario tener conexion a internet para instalar ISPConfig en su sistema${NC}\n"
  #          exit 1
  #      else 
  #          echo -e "\n${green}Añadiendo el repositorio de Diputacion en su sistema${NC}\n"
  #          DIPGRA="si"
  #          echo 'Acquire::http::proxy "http://incidencias.dipgra.es:8080/";' >> /etc/apt/apt.conf.d/00proxy
  #          echo 'Acquire::http::proxy::incidencias.dipgra.es "DIRECT";' >> /etc/apt/apt.conf.d/00proxy
  #      fi
  #fi

  # Check for already installed ispconfig version
  if [ -f /usr/local/ispconfig/interface/lib/config.inc.php ]; then
    echo "${red}ISPConfig is already installed, can't go on.${NC}"
	exit 1
  fi
  
  # Check source.list ubuntu 18.04 not support i386 packages
  apt-get purge ".*:i386"
  dpkg --remove-architecture i386

  if [ -f /etc/apt/sources.list ]; then
    echo "\n${red}The file has been moved /etc/apt/source.list a /etc/apt/source.list.old${NC}\n"
    mv /etc/apt/sources.list /etc/apt/sources.list.old
  fi

    echo "deb http://archive.ubuntu.com/ubuntu/ bionic main universe restricted multiverse" >> /etc/apt/sources.list
    echo "deb http://archive.ubuntu.com/ubuntu/ bionic-updates main universe restricted multiverse" >> /etc/apt/sources.list
    echo "deb http://archive.ubuntu.com/ubuntu/ bionic-backports main restricted universe multiverse" >> /etc/apt/sources.list
    echo "deb http://security.ubuntu.com/ubuntu bionic-security main universe restricted multiverse" >> /etc/apt/sources.list
    
  echo -e "${green} OK${NC}\n"
}


