#---------------------------------------------------------------------
# Function: PreInstallCheck
#   Perform pre-installation checks
#---------------------------------------------------------------------
PreInstallCheck() {
    START_TIME=$SECONDS

    echo -e "$IDENTATION_LVL_0 ${BWhite}Performing pre-installation checks...${NC}\n"

    # Check if no arguments are passed
    if [[ "$#" -ne 0 ]]; then
    	echo -e "Usage: sudo $0" >&2
	exit 1
    fi
  
    # Check if the current user is root
    echo -n -e "$IDENTATION_LVL_1 Checking if the current user is root... "
    if [[ $(id -u) -ne 0 ]]; then
	echo -e " [${red}ERROR${NC}: You must be root to run this script. Please use the root user or sudo.]"
	exit 1
    fi
	echo -e "[${green}OK${NC}]"

    # Check if the operating system is Linux
    echo -n -e "$IDENTATION_LVL_1 Checking if the OS is Linux... "
    if ! echo "$OSTYPE" | grep -iq "linux"; then
	echo -e "[${red}ERROR${NC}: This script must be run on Linux.]"
	exit 1
    fi
    echo -e "[${green}OK${NC}]"

    # Check available RAM memory
    echo -n -e "$IDENTATION_LVL_1 Checking available RAM memory... "
    TOTAL_PHYSICAL_MEM=$(awk '/^MemTotal:/ {print $2}' /proc/meminfo)
    TOTAL_SWAP=$(awk '/^SwapTotal:/ {print $2}' /proc/meminfo)  # Added swap memory check
    TOTAL_MEMORY=$((TOTAL_PHYSICAL_MEM + TOTAL_SWAP))  # Combine RAM and swap for total memory

    if [ "$TOTAL_MEMORY" -lt 524288 ]; then
	echo -e " [ ${red}ERROR${NC}: This machine has $(($TOTAL_PHYSICAL_MEM / 1024)) MiB RAM and $(($TOTAL_SWAP / 1024)) MiB swap. ISPConfig requires at least 512 MiB (1 GiB recommended) of total memory. ]"
	exit 1
    fi
    echo -e "[${green}OK${NC}]"
  
    # Check internet connectivity by pinging ISPConfig servers
    echo -n -e "$IDENTATION_LVL_1 Checking internet connectivity... "
    if ! ping -q -c 3 www.ispconfig.org >>$PROGRAMS_INSTALL_LOG_FILES 2>&1; then
	echo -e "[${red}ERROR${NC}: Could not reach www.ispconfig.org. Please check your internet connection and run this script again.]"
	exit 1
    fi
    echo -e "[${green}OK${NC}]"
  
    # Check if a previous version of ISPConfig is installed
    echo -n -e "$IDENTATION_LVL_1 Checking for previous ISPConfig installations... "
    if [ -f /usr/local/ispconfig/interface/lib/config.inc.php ]; then
	echo -e "[${red}ERROR${NC}: ISPConfig is already installed. Aborting.]"
	exit 1
    fi
    echo -e "[${green}OK${NC}]"
  
    # Update /etc/apt/sources.list to include contrib and non-free repositories
    echo -n -e "$IDENTATION_LVL_1 Updating /etc/apt/sources.list... "
    contrib=$(grep 'contrib' /etc/apt/sources.list | grep -v "cdrom")
    nonfree=$(grep -E 'non-free([^-]|$)' /etc/apt/sources.list | grep -v "cdrom")
    if [ -z "$contrib" ]; then
	if [ -z "$nonfree" ]; then
	    sed -i 's/main/main contrib non-free/' /etc/apt/sources.list
	else
	    sed -i 's/main/main contrib/' /etc/apt/sources.list
	fi
    elif [ -z "$nonfree" ]; then
	sed -i 's/main/main non-free/' /etc/apt/sources.list
    fi
    echo -e "[${green}DONE${NC}]"

    MeasureTimeDuration $START_TIME
}
