#---------------------------------------------------------------------
# Function: InstallJailkit
#    Install Jailkit
#---------------------------------------------------------------------

# Program Version
JAILKIT_VERSION="2.23"  #Jailkit Version
SUM="c7018645430248613c6241bf529d95ef"

InstallJailkit() {
  START_TIME=$SECONDS

  echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing JailKit${NC}\n"

  # Detect current version
  echo -n -e "$IDENTATION_LVL_1 Detecting current version ... "
  DETECTED_VERSION=$(wget -q -O - http://olivier.sessink.nl/jailkit/ | grep -m 1 'jailkit-.*\.tar\.gz' | sed -r 's/.*jailkit\-([0-9.]*)\..*/\1/g')
  if [ -z "$DETECTED_VERSION" ]; then
    echo -e "${red}Failed to detect version${NC}"
    exit 1
  fi
  echo -n -e "${red} $DETECTED_VERSION ${NC}"
  echo -e " [ ${green}DONE${NC} ]"

  # Use the latest version
  if [ $JAILKIT_VERSION \< $DETECTED_VER ]; then
    JAILKIT_VERSION=$DETECTED_VER
  fi

  echo -n -e "$IDENTATION_LVL_1 Installing version $JAILKIT_VERSION\n"
  
  # Install required tools
  echo -n -e "$IDENTATION_LVL_1 Installing required tools ... "
  package_install build-essential autoconf automake libtool flex bison debhelper binutils python3 python-is-python3 >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  echo -e " [ ${green}DONE${NC} ] "

  # Download and build JailKit
  echo -n -e "$IDENTATION_LVL_1 Downloading and building JailKit version: $JAILKIT_VERSION ... "

  cd /tmp || exit 1
  if ! wget -q "https://olivier.sessink.nl/jailkit/jailkit-$JAILKIT_VERSION.tar.gz"; then
    echo -e "\n${red}Error: Failed to download JailKit${NC}" >&2
    exit 1
  fi
  
  # Verify MD5 checksum
  if [[ "$(md5sum "jailkit-$JAILKIT_VERSION.tar.gz" | head -c 32)" != "$JAILKIT_MD5SUM" ]]; then
    echo -e "\n${red}Error: MD5 checksum does not match${NC}" >&2
    exit 1
  fi

  # Extract and build
  if ! tar xfz "jailkit-$JAILKIT_VERSION.tar.gz"; then
    echo -e "\n${red}Error: Failed to extract JailKit${NC}" >&2
    exit 1
  fi

  cd "jailkit-$JAILKIT_VERSION" || exit 1
  echo 5 > debian/compat
  if ! ./debian/rules binary >> "$PROGRAMS_INSTALL_LOG_FILES" 2>&1; then
    echo -e "\n${red}Error: Failed to build JailKit${NC}" >&2
    exit 1
  fi
  echo -e " [ ${green}DONE${NC} ]"
  
  # Install JailKit
  echo -n -e "$IDENTATION_LVL_1 Installing JailKit ... "
  cd .. || exit 1
  if ! dpkg -i "jailkit_$JAILKIT_VERSION-1_"*.deb >> "$PROGRAMS_INSTALL_LOG_FILES" 2>&1; then
    echo -e "\n${red}Error: Failed to install JailKit${NC}" >&2
    exit 1
  fi
  echo -e " [ ${green}DONE${NC} ]"

  # Cleanup
  echo -n -e "$IDENTATION_LVL_1 Cleaning up ... "
  rm -rf "jailkit-$JAILKIT_VERSION"
  rm -f "/tmp/jailkit-$JAILKIT_VERSION.tar.gz"
  rm -rf "/tmp/jailkit-$JAILKIT_VERSION"
  rm -f "/tmp/jailkit_$JAILKIT_VERSION-1_"*.deb
  echo -e " [ ${green}DONE${NC} ]"

  MeasureTimeDuration $START_TIME
}
