#---------------------------------------------------------------------
# Function: Install Gitlab-ce
#    Install and configure of Gitlab-ce
#---------------------------------------------------------------------

InstallGitlabCE() {
#GitLab package is packaged with mysql support for Enterprise Edition only.
#If you are using Community Edition, package contains only Postgresql.

echo -n "Installed Gitlab-ce packages... "

apt_install curl openssh-server ca-certificates postfix
cd /tmp
curl -sS https://packages.gitlab.com/install/repositories/gitlab/gitlab-ce/script.deb.sh | sudo bash
apt_install gitlab-ce

#gitlab-ctl reconfigure

# Unbundle nginx from Omnibus GitLab
#sed -i "s/'http:\/\/gitlab.example.com'/'http:\/\/gitlab.wolftronics.hu'/g" /etc/gitlab/gitlab.rb
sed -i "s/'http:\/\/gitlab.example.com'/'https:\/\/gitlab.wolftronics.hu'/g" /etc/gitlab/gitlab.rb
#Bunded nginx options
#sed -i "s/# nginx\['redirect_http_to_https'\] = false/nginx\['redirect_http_to_https'\] = true/g" /etc/gitlab/gitlab.rb
#sed -i "s/# nginx\['ssl_certificate'\] = .*/nginx['ssl_certificate'] = \"\/etc\/letsencrypt\/live\/gitlab.wolftronics.hu\/fullchain.pem\"/g" /etc/gitlab/gitlab.rb
#sed -i "s/# nginx\['ssl_certificate_key'\] = .*/nginx['ssl_certificate_key'] = \"\/etc\/letsencrypt\/live\/gitlab.wolftronics.hu\/privkey.pem\"/g" /etc/gitlab/gitlab.rb
#sed -i "s/# nginx\['ssl_dhparam'\] = .*/nginx['ssl_dhparam'] = \"\/etc\/gitlab\/ssl\/dhparams.pem\"/g" /etc/gitlab/gitlab.rb

#External nginx options
sed -i "s/# nginx\['enable'\] = true/nginx\['enable'\] = false/g" /etc/gitlab/gitlab.rb
sed -i "s/# web_server\['external_users'\] = \[\]/web_server\['external_users'\] = \['www-data'\]/g" /etc/gitlab/gitlab.rb

#certbot certonly --agree-tos --non-interactive --renew-by-default --standalone --email wolftronics@wolftronics.hu -d gitlab.wolftronics.hu

mkdir -p /etc/gitlab/ssl/
openssl dhparam -out /etc/gitlab/ssl/dhparams.pem 2048

gitlab-ctl reconfigure

#apt_install ruby
#gem install rubygems-update
#gem pristine rake
#update_rubygems

#Phusion Passenger
#apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 561F9B9CAC40B2F7
#echo "deb https://oss-binaries.phusionpassenger.com/apt/passenger xenial main" > /etc/apt/sources.list.d/passenger.list
#sudo sed -i 's/http:\/\/lt\./http:\/\//g' /etc/apt/sources.list.d/passenger.list
#hide_output apt-get update
#deleted etc/nginx!!!!! backup!!!!!
#apt-get purge nginx nginx-full nginx-light nginx-naxsi nginx-common
#apt_install nginx-extras passenger
#sed -i "s|^\(http {\).*$|\1\\ninclude \/etc\/nginx\/passenger.conf;|" /etc/nginx/nginx.conf

#restart_service nginx

case $CFG_WEBSERVER in
    "apache")
#vi /etc/gitlab/gitlab.rb
#web_server['username'] = 'apache'
#web_server['group'] = 'apache'

cat > /etc/nginx/sites-available/gitlab.wolftronics.hu <<EOF
<VirtualHost *:80>
  ServerName gitlab.wolftronics.hu
  DocumentRoot /opt/gitlab/embedded/service/gitlab-rails/public
  
  ProxyPreserveHost On
  AllowEncodedSlashes Off
  
  <Location />
    Order deny,allow
    Allow from all
    ProxyPassReverse http://127.0.0.1:8080
    ProxyPassReverse http://gitlab.wolftronics.hu/
  </Location>
  
  RewriteEngine on
  RewriteCond %{DOCUMENT_ROOT}/%{REQUEST_FILENAME} !-f
  RewriteRule .* http://127.0.0.1:8080%{REQUEST_URI} [P,QSA]
</VirtualHost>
EOF

AllowEncodedSlashes NoDecode
service httpd reload
    ;;
    "nginx")

cat > /etc/nginx/sites-available/gitlab.wolftronics.hu.vhost <<EOF
#upstream gitlab {
#        server unix:/var/opt/gitlab/gitlab-rails/sockets/gitlab.socket;
#}

upstream gitlab-workhorse {
   server unix:/var/opt/gitlab/gitlab-workhorse/socket;
}

server {
  listen 80;
  server_name   gitlab.wolftronics.hu;
  rewrite       ^ https://\$server_name\$request_uri? permanent;
}

server {
#    listen 80;
    listen        443 ssl http2;
    server_name gitlab.wolftronics.hu;
    server_tokens off; # don't show the version number, a security best practice
    root /opt/gitlab/embedded/service/gitlab-rails/public;

    ssl                   on;
    #ssl_certificate       /etc/letsencrypt/live/git.wolftronics.hu.vhost/fullchain.pem;
    #ssl_certificate_key   /etc/letsencrypt/live/git.wolftronics.hu.vhost/privkey.pem;
    #ssl_certificate       /root/.acme.sh/gitlab.wolftronics.hu/fullchain.cer;
    #ssl_certificate_key   /root/.acme.sh/gitlab.wolftronics.hu/gitlab.wolftronics.hu.key;

    ssl_certificate       /home/administrator/.acme.sh/gitlab.wolftronics.hu/fullchain.cer;
    ssl_certificate_key   /home/administrator/.acme.sh/gitlab.wolftronics.hu/gitlab.wolftronics.hu.key;
    ssl_prefer_server_ciphers on;
    ssl_protocols         TLSv1.2 TLSv1.3;
    ssl_ciphers           ALL:!aNULL:!ADH:!eNULL:!LOW:!EXP:RC4+RSA:+HIGH:+MEDIUM;
    ssl_dhparam           /etc/gitlab/ssl/dhparams.pem;

    # Increase this if you want to upload large attachments
    # Or if you want to accept large git objects over http
    client_max_body_size 250m;

    # individual nginx logs for this gitlab vhost
    access_log  /var/log/nginx/gitlab_access.log;
    error_log   /var/log/nginx/gitlab_error.log;

#    location / {
#        proxy_redirect off;
#        proxy_set_header Host \$http_host;
#        proxy_set_header X-Forwarded-For \$proxy_add_x_forwarded_for;
#        proxy_set_header X-Real-IP \$remote_addr;
#        proxy_pass http://gitlab;
#    }

#  location / {
#    try_files \$uri \$uri/index.html \$uri.html @gitlab;
#  }

#  location @gitlab {
#    proxy_read_timeout 300; # https://github.com/gitlabhq/gitlabhq/issues/694
#    proxy_connect_timeout 300; # https://github.com/gitlabhq/gitlabhq/issues/694
#    proxy_redirect     off;

#    proxy_set_header   X-Forwarded-Proto \$scheme;
#    proxy_set_header   Host              \$http_host;
#    proxy_set_header   X-Real-IP         \$remote_addr;
#    proxy_set_header   X-Forwarded-For   \$proxy_add_x_forwarded_for;

#    proxy_pass http://gitlab;
#  }

  location / {
     client_max_body_size 0;
     gzip off;
     ## https://github.com/gitlabhq/gitlabhq/issues/694
     ## Some requests take more than 30 seconds.
     proxy_read_timeout      300;
     proxy_connect_timeout   300;
     proxy_redirect          off;
     proxy_http_version 1.1;
     proxy_set_header    Host                \$http_host;
     proxy_set_header    X-Real-IP           \$remote_addr;
     proxy_set_header    X-Forwarded-For     \$proxy_add_x_forwarded_for;
     proxy_set_header    X-Forwarded-Proto   \$scheme;
     proxy_pass http://gitlab-workhorse;
   }

  ## Enable gzip compression as per rails guide:
  ## http://guides.rubyonrails.org/asset_pipeline.html#gzip-compression
  ## WARNING: If you are using relative urls remove the block below
  ## See config/application.rb under "Relative url support" for the list of
  ## other files that need to be changed for relative url support
  location ~ ^/(assets)/ {
    root /opt/gitlab/embedded/service/gitlab-rails/public;
    gzip_static on; # to serve pre-gzipped version
    expires max;
    add_header Cache-Control public;
  }

  error_page 502 /502.html;
}

EOF

    ln -s /etc/nginx/sites-available/gitlab.wolftronics.hu.vhost /etc/nginx/sites-enabled/gitlab.wolftronics.hu.vhost
#restart_service nginx
    ;;
esac

usermod -aG gitlab-www www-data

#ssl cert generated
service nginx stop
  if [ "$CFG_SSL_NEW" == "yes" ]; then
    sh /home/administrator/.acme.sh/acme.sh --issue --standalone -d gitlab.wolftronics.hu --force
  else
    cp -av /home/administrator/wtlinux_server_setup/acme_ssl/wolftronics/gitlab.wolftronics.hu /home/administrator/.acme.sh/
  fi

restart_service nginx

echo -e "[${green}DONE${NC}]\n"
}
