#--------------------------------------------------------------------
# Function: InstallWebServer
#    Install and configure Apache2, Nginx, PHP + modules, and security
#--------------------------------------------------------------------
InstallWebServer() {
    echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing Web server...${NC}\n"
    if [ "$CFG_WEBSERVER" == "apache" ]; then
	CFG_NGINX=n
	CFG_APACHE=y
	echo -n -e "$IDENTATION_LVL_1 Installing Web server (Apache) and modules... "
	echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect apache2" | debconf-set-selections
	# - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
	echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
	# apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libapache2-mod-passenger libapache2-mod-python libexpat1 ssl-cert libruby
	apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libruby libapache2-mod-python libapache2-mod-passenger libapache2-reload-perl
	echo -e "[${green}DONE${NC}]"
	
	echo -n -e "$IDENTATION_LVL_1 Installing PHP and Modules... "
	#apt_install php7.3 php8.2-common php-bcmath php8.2-gd php8.2-mysql php8.2-imap php8.2-cli php8.2-cgi php-pear mcrypt imagemagick libruby php8.2-curl php8.2-intl php8.2-pspell php8.2-recode php8.2-sqlite3 php8.2-tidy php8.2-xmlrpc php8.2-xsl memcached php-memcache php-imagick php-gettext php8.2-zip php8.2-mbstring php8.2-soap php8.2-fpm php8.2-opcache php-apcu
	apt_install php8.2 php8.2-common php-bcmath php8.2-gd php8.2-mysql php8.2-imap php8.2-cli php8.2-cgi php-pear imagemagick libruby php8.2-curl php8.2-intl php8.2-pspell php8.2-sqlite3 php8.2-tidy php8.2-xmlrpc php8.2-xsl memcached php8.2-memcache php8.2-memcached php8.2-imagick php-php-gettext php8.2-zip php8.2-mbstring php8.2-soap php8.2-fpm php8.2-opcache php-apcu mcrypt php8.2-mcrypt
	#apt-get_install php8.2-intl php8.2-pspell php8.2-recode php8.2-sqlite3 php8.2-tidy php8.2-xmlrpc php8.2-xsl memcached php-memcache php-imagick php-gettext php8.2-zip php8.2-mbstring php-soap php8.2-soap memcached imagemagick libruby php-pear mcrypt php8.2-pdo-odbc php8.2-imagick php8.2-redis php8.2-bz2 php8.2-mongodb php8.2-common php8.2-cgi php8.2-cli php8.2-dba php8.2-smbclient php8.2-dom php8.2-bcmath php8.2-oauth php8.2-memcached php8.2-pinba php8.2-fpm php8.2-ftp php8.2-igbinary php8.2-gmp php8.2-mysql php8.2-memcache php8.2-uuid php8.2-sockets  php8.2-mailparse php7.3 php8.2-sysvmsg php8.2-wddx  php8.2-pdo-pgsql php8.2-calendar php8.2-fileinfo php8.2-pdo php8.2-xmlwriter php8.2-json php8.2-opcache php8.2-mysqli php8.2-sass php8.2-sysvsem php8.2-sysvshm php8.2-phar php8.2-rrd php8.2-sybase php8.2-curl php8.2-stomp php8.2-msgpack php8.2-ldap php8.2-gearman php8.2-raphf php8.2-phpdbg php8.2-xmlreader php8.2-imap php8.2-gnupg php8.2-radius php8.2-uploadprogress php8.2-posix php8.2-iconv php8.2-xml   php8.2-zip php8.2-tokenizer php8.2-zmq php8.2-odbc php8.2-mbstring php8.2-readline php8.2-ds php8.2-gd php8.2-ps php8.2-interbase php8.2-yaml php8.2-snmp php8.2-pdo-mysql php8.2-mysqlnd  php8.2-soap php8.2-solr php8.2-simplexml php8.2-ssh2 php8.2-pdo-sqlite php8.2-pdo-dblib  php8.2-amqp php8.2-gmagick php8.2-pgsql php8.2-enchant  php8.2-tideways php8.2-shmop php8.2-libsodium php8.2-propro php8.2-gettext php8.2-pdo-firebird php8.2-exif php8.2-ctype php8.2-http php8.2-geoip php8.2-xdebug php8.2-common php8.2-mysql php8.2-odbc php8.2-pgsql  php8.2-xml php-amqp php-ds php-gearman php-geoip php-gmagick php-gnupg php-http php-igbinary php-imagick php-libsodium php-mailparse php-memcache php-memcached php-mongodb php-msgpack php-oauth php-pinba php-propro php-ps php-radius php-raphf php-redis php-rrd php-sass php-smbclient php-solr php-ssh2 php-stomp php-tideways php-uploadprogress php-uuid php-xdebug php-yac php-yaml php-zmq php8.2-interbase php8.2-sybase > /dev/null 2>&1
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Configuring PHP settings... "
	#php.ini settings roundcube and other
	sed -i "s/;extension=php_mbstring.dll/extension=php_mbstring.dll/" /etc/php/8.2/apache2/php.ini
	sed -i "s/;extension=php_xmlrpc.dll/extension=php_xmlrpc.dll/" /etc/php/8.2/apache2/php.ini
	sed -i "s/;extension=php_xsl.dll/;extension=php_xsl.dll\\`echo -e '\n\r'`extension=dom.so/" /etc/php/8.2/apache2/php.ini
	sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/8.2/apache2/php.ini
	sed -i "s/post_max_size =.*/post_max_size = 18M/g" /etc/php/8.2/apache2/php.ini
	sed -i "s/upload_max_filesize =.*/upload_max_filesize = 12M/g" /etc/php/8.2/apache2/php.ini
	sed -i "s/;mbstring.func_overload = 0/mbstring.func_overload = 0/" /etc/php/8.2/apache2/php.ini
	systemctl reload php8.2-fpm
	systemctl restart apache2
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Configuring PHP OPcache... "
	sed -i "s/;opcache.enable=0/opcache.enable=1/" /etc/php/8.2/apache2/php.ini
	sed -i "s/;opcache.memory_consumption=64/opcache.memory_consumption=128/" /etc/php/8.2/apache2/php.ini
	sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=4000/" /etc/php/8.2/apache2/php.ini
	sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=240/" /etc/php/8.2/apache2/php.ini
	phpenmod opcache
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Installing PHP-FPM... "
	apt_install php8.1-fpm
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Installing additional programs for PHP and Apache... "
        apt_install mcrypt imagemagick memcached curl tidy snmp redis-server
	echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Configuring Apache modules... "
        # https://www.howtoforge.com/tutorial/httpoxy-protect-your-server/
	echo "<IfModule mod_headers.c>
    RequestHeader unset Proxy early
	</IfModule>" | tee /etc/apache2/conf-available/httpoxy.conf > /dev/null 2>&1
	a2enconf httpoxy > /dev/null 2>&1
        echo -e "[${green}DONE${NC}]\n"
        
	if [ "$CFG_PHPMYADMIN" == "yes" ]; then
	    source $APWD/distros/debian12/install_phpmyadmin.sh
            echo -n -e "$IDENTATION_LVL_1 Installing phpMyAdmin... "
	    InstallphpMyAdmin
	    echo -e "[${green}DONE${NC}]"
	fi

	echo -n -e "$IDENTATION_LVL_1 Activating Apache modules... "
	a2enmod suexec > /dev/null 2>&1
	a2enmod rewrite > /dev/null 2>&1
	a2enmod ssl > /dev/null 2>&1
	a2enmod actions > /dev/null 2>&1
	a2enmod include > /dev/null 2>&1
	a2enmod cgi > /dev/null 2>&1
	a2enmod dav_fs > /dev/null 2>&1
	a2enmod dav > /dev/null 2>&1
	a2enmod auth_digest > /dev/null 2>&1
	a2enmod headers > /dev/null 2>&1
	a2enmod fastcgi > /dev/null 2>&1
	a2enmod proxy_fcgi > /dev/null 2>&1
	a2enmod alias > /dev/null 2>&1
	# a2enmod fcgid > /dev/null 2>&1

	echo -n "Block Exploits, SQL Injections, File Injections, Spam, User Agents, Etc. Apache2 Modules... "
	# This mitigation has been assigned the identifier CVE-2016-5387
	# Please refer to:
	# https://httpoxy.org/#fix-now
	# https://www.nginx.com/blog/mitigating-the-httpoxy-vulnerability-with-nginx/
	echo -n "Removing the HTTP Proxy Header with Apache2..."
	sed -i '$ a\\nRequestHeader unset Proxy early' /etc/apache2/apache2.conf
	systemctl restart apache2 > /dev/null 2>&1
	
    elif [ "$CFG_WEBSERVER" == "nginx" ]; then
	CFG_NGINX=y
	CFG_APACHE=n
	echo -n -e "$IDENTATION_LVL_1 Installing Web server (nginx mainline) and modules... "
	systemctl stop apache2 > /dev/null 2>&1
	systemctl disable apache2 > /dev/null 2>&1
  
	#echo "deb http://nginx.org/packages/mainline/debian/ bookworm nginx" >> /etc/apt/sources.list
	#curl -O https://nginx.org/keys/nginx_signing.key && apt-key add ./nginx_signing.key
	curl -fsSL https://nginx.org/keys/nginx_signing.key | gpg --dearmor -o /usr/share/keyrings/nginx-archive-keyring.gpg
	echo "deb [signed-by=/usr/share/keyrings/nginx-archive-keyring.gpg] http://nginx.org/packages/mainline/debian/ bookworm nginx" | sudo tee /etc/apt/sources.list.d/nginx.list > /dev/null
	apt_update
	
	#curl -sSL https://packages.sury.org/nginx-mainline/README.txt | sudo bash -x >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	#apt_update
	#apt_install nginx-full nginx-module-geoip nginx-module-image-filter
	#itt más csomag nevek vannak
	
	apt_install nginx nginx-module-geoip nginx-module-image-filter	
	systemctl start nginx
	systemctl enable nginx

	#apt_install nginx-core nginx nginx-common nginx-module-geoip nginx-module-image-filter nginx-module-njs nginx-module-perl nginx-module-xslt
	
	
        mkdir -p /etc/nginx/sites-available /etc/nginx/sites-enabled
	rm /etc/nginx/conf.d/default.conf
	mv /etc/nginx/nginx.conf /etc/nginx/nginx.conf_old
	cp -rp $PWD/distros/debian10/nginx_conf/* /etc/nginx
        echo -e "[${green}DONE${NC}]"
        
	## jelesek kellenek a stabil nem mainline-hoz
	##sed -i -e"s/keepalive_timeout\s*65/keepalive_timeout 2/" /etc/nginx/nginx.conf
	##sed -i -e"s/keepalive_timeout 2/keepalive_timeout 2;\n\tclient_max_body_size 18m/" /etc/nginx/nginx.conf
	#sed -i 's/client_max_body_size *[0-9]\+[kKmM]\?/client_max_body_size '"${POST_MAX_SIZE}"'/' /etc/nginx/conf.d/default.conf
	#wordpress
	#sed -i 's/upload_max_filesize *= *[0-9]\+[kKmMgG]\?/upload_max_filesize='"64m"'/' /etc/nginx/global/wordpress.conf
	#sed -i 's/post_max_size *= *[0-9]\+[kKmMgG]\?/post_max_size='"64m"'/' /etc/nginx/global/wordpress.conf
	#sed -i 's/fastcgi_pass .*;/fastcgi_pass '"$(escape_sed "wordpress")"':9000;/' /etc/nginx/global/wordpress.conf
	
        echo -n -e "$IDENTATION_LVL_1 Configuring Nginx security settings... "
	# This mitigation has been assigned the identifier CVE-2016-5387
	# Please refer to:
	# https://httpoxy.org/#fix-now
	# https://www.nginx.com/blog/mitigating-the-httpoxy-vulnerability-with-nginx/
	sed -i '/SERVER_NAME/ a\\nfastcgi_param HTTP_PROXY \"\";' /etc/nginx/fastcgi_params
	##sed -i '/types_hash_max_size/ a\ proxy_set_header Proxy \"\";' /etc/nginx/nginx.conf
	#Block Exploits, SQL Injections & attacks with Nginx
	#Include it in your vhost configuration with :
	#include /etc/nginx/common/protect.conf;
	mkdir -p /etc/nginx/common
	cat << "EOF" > /etc/nginx/common/protect.conf
    location ~* "(eval\()"  { deny all; }
    location ~* "(127\.0\.0\.1)"  { deny all; }
    location ~* "([a-z0-9]{2000})"  { deny all; }
    location ~* "(javascript\:)(.*)(\;)"  { deny all; }
    location ~* "(base64_encode)(.*)(\()"  { deny all; }
    location ~* "(GLOBALS|REQUEST)(=|\[|%)"  { deny all; }
    location ~* "(<|%3C).*script.*(>|%3)" { deny all; }
    location ~ "(\\|\.\.\.|\.\./|~|`|<|>|\|)" { deny all; }
    location ~* "(boot\.ini|etc/passwd|self/environ)" { deny all; }
    location ~* "(thumbs?(_editor|open)?|tim(thumb)?)\.php" { deny all; }
    location ~* "(\'|\")(.*)(drop|insert|md5|select|union)" { deny all; }
    location ~* "(https?|ftp|php):/" { deny all; }
    location ~* "(=\\\'|=\\%27|/\\\'/?)\." { deny all; }
    location ~* "/(\$(\&)?|\*|\"|\.|,|&|&?)/?$" { deny all; }
    location ~ "(\{0\}|\(/\(|\.\.\.|\+\+\+|\\\"\\\")" { deny all; }
    location ~ "(~|`|<|>|:|;|%|\\|\s|\{|\}|\[|\]|\|)" { deny all; }
    location ~* "/(=|\$&|_mm|(wp-)?config\.|cgi-|etc/passwd|muieblack)" { deny all; }
    location ~* "(&pws=0|_vti_|\(null\)|\{\$itemURL\}|echo(.*)kae|etc/passwd|eval\(|self/environ)" { deny all; }
    location ~* "\.(aspx?|bash|bak?|cfg|cgi|dll|exe|git|hg|ini|jsp|log|mdb|out|sql|svn|swp|tar|rdf)$" { deny all; }
    location ~* "/(^$|mobiquo|phpinfo|shell|sqlpatch|thumb|thumb_editor|thumbopen|timthumb|webshell)\.php" { deny all; }
EOF

	#echo -e "Nginx Bad Bot Blocker 223 (and growing) Nginx rules to block bad bots...\n"
	# Block bad bots V1	
	#git clone https://github.com/mariusv/nginx-badbot-blocker.git /etc/nginx
	#sed -i "s|^\(\$config\['default_host'\] =\).*$|\1 \ array(\n##\n# Nginx Bad Bot Blocker\n##\ninclude nginx-badbot-blocker/blacklist.conf;\ninclude nginx-badbot-blocker/blockips.conf;\n\);|" /usr/share/roundcube/config/config.inc.php

	# Block bad bots V2
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/conf.d/blacklist.conf -O /etc/nginx/conf.d/blacklist.conf
	#mkdir /etc/nginx/bots.d
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/blockbots.conf -O /etc/nginx/bots.d/blockbots.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/ddos.conf -O /etc/nginx/bots.d/ddos.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/whitelist-domains.conf -O /etc/nginx/bots.d/whitelist-domains.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/whitelist-ips.conf -O /etc/nginx/bots.d/whitelist-ips.conf

	#mcedit /etc/nginx/nginx.conf
	#####Add the following settings and rate limiting zones near the top of your nginx.conf file. This is both for the Anti DDOS rate limiting filter and for allowing Nginx to load this very large set of domain names into memory.
	#server_names_hash_bucket_size 64;
	#server_names_hash_max_size 4096;
	#limit_req_zone $binary_remote_addr zone=flood:50m rate=90r/s;
	#limit_conn_zone $binary_remote_addr zone=addr:50m;

	#Make sure that your nginx.conf file contains the following include directive. If it's commented out make sure to uncomment it.
	#include /etc/nginx/conf.d/*

	#VHOST
	#These includes MUST be added within a server {} block of a vhost otherwise you will get EMERG errors from Nginx.
	#include /etc/nginx/bots.d/blockbots.conf;
	#include /etc/nginx/bots.d/ddos.conf;
	#sudo nginx -t
	#sudo systemctl reload nginx

	#curl -A "googlebot" http://wolftronics.hu
	#Should respond with 200 OK
	#curl -A "80legs" http://wolftronics.hu
	#curl -A "masscan" http://wolftronics.hu
	#Should respond with: curl: (52) Empty reply from server
	#curl -I http://yourdomain.com -e http://100dollars-seo.com
	#curl -I http://wolftronics.hu -e http://zx6.ru
	#Should respond with: curl: (52) Empty reply from server
	#The Nginx BadBot Blocker is now working and protecting your web sites !!!

	#UPDATING THE NGINX BADBOT BLOCKER
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/conf.d/blacklist.conf -O /etc/nginx/conf.d/blacklist.conf
	#sudo nginx -t
	#sudo systemctl reload nginx

	#AUTO UPDATING:
	#https://raw.githubusercontent.com/mariusv/nginx-badbot-blocker/master/VERSION_2/updatenginxblocker.sh

        echo -n -e "$IDENTATION_LVL_1 Installing and configuring Nginx Bad Bot Blocker... "
	#https://github.com/mitchellkrogza/nginx-ultimate-bad-bot-blocker
	wget https://raw.githubusercontent.com/mitchellkrogza/nginx-ultimate-bad-bot-blocker/master/install-ngxblocker -O /usr/local/sbin/install-ngxblocker
	chmod +x /usr/local/sbin/install-ngxblocker
	/usr/local/sbin/install-ngxblocker
	/usr/local/sbin/install-ngxblocker -x
	chmod +x /usr/local/sbin/setup-ngxblocker
	chmod +x /usr/local/sbin/update-ngxblocker
	##sh /usr/local/sbin/setup-ngxblocker
	#sh /usr/local/sbin/setup-ngxblocker -x -e conf

	#00 22 * * * sudo /usr/sbin/update-ngxblocker -e yourname@youremail.com
	#This will update the blocker every night for you at 10 PM.
	#If you want it to update more frequently (as sometimes I push out 3-4 updates a day) you can set it as follows to run the cron every 8 hours, although just once a day is more than enough.
	#00 */8 * * * sudo /usr/sbin/update-ngxblocker -e yourname@youremail.com
	#If you don't want any email notification after an update (not advisable in case Nginx ever has an EMERG when reloading), then simply run your cron as follows.
	#00 */8 * * * sudo /usr/sbin/update-ngxblocker -n
	echo "00 */8 * * * sudo /usr/sbin/update-ngxblocker -n" >> /etc/crontab
	
	systemctl start nginx
	#sudo nginx -t
	echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Installing PHP and modules... "
	# apt_install php8.2-mcrypt mcrypt # már nem ajánlatos használni, max a régi php-éknál
	apt_install php8.2 php8.2-common php8.2-dev php8.2-bcmath php8.2-exif php8.2-gd php8.2-mysql php8.2-imap php8.2-cli php8.2-cgi php-pear libruby php8.2-curl php8.2-intl php8.2-pspell php8.2-sqlite3 php8.2-tidy php8.2-xmlrpc php8.2-xsl memcached php-memcache php8.2-memcached imagemagick php8.2-imagick php-php-gettext php8.2-zip php8.2-mbstring php8.2-soap php8.2-snmp php8.2-xml php8.2-pdo php8.2-pdo-mysql php8.2-pdo-sqlite php8.2-pdo-pgsql php8.2-pgsql php8.2-jsonphp8.2-ssh2 php8.2-xdebug php8.2-mysqlnd php8.2-mysqli php8.2-posix php8.2-simplexml php8.2-ftp php8.2-fpm php8.2-opcache php-apcu

	#apt_install php-auth-sasl php8.2-amqp php8.2-bz2 php8.2-calendar php8.2-ctype php8.2-dba php8.2-dom php8.2-ds php8.2-enchant php8.2-exif php8.2-fileinfo php8.2-gearman php8.2-geoip php8.2-gettext php8.2-gmagick php8.2-gmp php8.2-gnupg php8.2-http php8.2-iconv php8.2-igbinary php8.2-interbase php8.2-ldap php8.2-libsodium php8.2-mailparse php8.2-mongodb php8.2-msgpack php8.2-oauth php8.2-odbc php8.2-pdo-dblib php8.2-pdo-firebird php8.2-pdo-odbc php8.2-phar php8.2-phpdbg php8.2-pinba php8.2-propro php8.2-ps php8.2-radius php8.2-raphf php8.2-readline php8.2-redis php8.2-rrd php8.2-sass php8.2-shmop php8.2-smbclient php8.2-sockets php8.2-solr php8.2-stomp php8.2-sybase php8.2-sysvmsg php8.2-sysvsem php8.2-sysvshm php8.2-tideways php8.2-tokenizer php8.2-uploadprogress php8.2-uuid php8.2-wddx php8.2-xmlreader php8.2-xmlwriter php8.2-yac php8.2-yaml php8.2-zmq > /dev/null 2>&1

	echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Configuring PHP settings... "
	sed -i "s/;cgi.fix_pathinfo=1/cgi.fix_pathinfo=0/" /etc/php/8.2/fpm/php.ini
	TIME_ZONE=$(echo "$TIME_ZONE" | sed -n 's/ (.*)$//p')
	sed -i "s/;date.timezone =/date.timezone=\"${TIME_ZONE//\//\\/}\"/" /etc/php/8.2/fpm/php.ini
	#sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/8.2/fpm/php.ini
	sed -i "s/post_max_size =.*/post_max_size = 1100M/g" /etc/php/8.2/fpm/php.ini
	#sed -i "s/upload_max_filesize =.*/upload_max_filesize = 12M/g" /etc/php/8.2/fpm/php.ini
	sed -i "s/upload_max_filesize =.*/upload_max_filesize = 1024M/g" /etc/php/8.2/fpm/php.ini
	sed -i "s/;mbstring.func_overload = 0/mbstring.func_overload = 0/" /etc/php/8.2/fpm/php.ini
	sed -i -e "s/;daemonize\s*=\s*yes/daemonize = no/g" /etc/php/8.2/fpm/php-fpm.conf
	sed -i -e "s/;catch_workers_output\s*=\s*yes/catch_workers_output = yes/g" /etc/php/8.2/fpm/pool.d/www.conf
	find /etc/php/8.2/cli/conf.d/ -name "*.ini" -exec sed -i -re 's/^(\s*)#(.*)/\1;\2/g' {} \;
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Configuring PHP OPcache... "
	sed -i "s/;opcache.enable=0/opcache.enable=1/" /etc/php/8.2/fpm/php.ini
	sed -i "s/;opcache.memory_consumption=64/opcache.memory_consumption=1024/" /etc/php/8.2/fpm/php.ini
	#sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=4000/" /etc/php/8.2/fpm/php.ini
	sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=100000/" /etc/php/8.2/fpm/php.ini
	#sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=60/" /etc/php/8.2/fpm/php.ini
	sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=240/" /etc/php/8.2/fpm/php.ini
	sed -i "s/max_execution_time =.*/max_execution_time = 3600/g" /etc/php/8.2/fpm/php.ini
	sed -i "s/max_input_time =.*/max_input_time = 3600/g" /etc/php/8.2/fpm/php.ini
	#phpenmod opcache
	# Set worker_processes = num cpu cores
	#procs=$(cat /proc/cpuinfo |grep processor | wc -l)
	#if [[ "$procs" > "${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES}" ]]; then
	    # number of available processor cores exceeds the maximum permitted, limit to maximum
	#    echo " * nginx:  Using max ${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES} of $procs available cores"
	#    procs=${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES}
	#fi
	#echo " * nginx:  worker_processes = $procs"
	#sed -i -r "s/worker_processes\s+[0-9]+/worker_processes $procs/" /etc/nginx/nginx.conf
	#sed -i -e '/worker_processes/c\worker_processes  5;' /etc/nginx/nginx.conf
        echo -e "[${green}DONE${NC}]"

        echo -n -e "$IDENTATION_LVL_1 Reloading PHP-FPM and Nginx... "
	hide_output systemctl reload php8.2-fpm
	systemctl restart nginx
	echo -e "[${green}DONE${NC}]"
	
	echo -n -e "$IDENTATION_LVL_1 Installing fcgiwrap... "
	apt_install fcgiwrap
	echo -e "[${green}DONE${NC}]"

	if [ "$CFG_PHPMYADMIN" == "yes" ]; then
	    source $APWD/distros/debian12/install_phpmyadmin.sh
            echo -n -e "$IDENTATION_LVL_1 Installing phpMyAdmin... "
	    InstallphpMyAdmin
	    echo -e "[${green}DONE${NC}]"
	fi

	echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing extra PHP and Modules...${NC}"
	if [[ "$CFG_PHP_VERSION" == *"php5.5"* ]]; then
	    InstallPhp55
	fi

	if [[ "$CFG_PHP_VERSION" == *"php5.6"* ]]; then
	    InstallPhp56
	fi

	if [[ "$CFG_PHP_VERSION" == *"php7.0"* ]]; then
	    InstallPhp70
	fi

	if [[ "$CFG_PHP_VERSION" == *"php7.1"* ]]; then
	    InstallPhp71
	fi

	if [[ "$CFG_PHP_VERSION" == *"php7.2"* ]]; then
	    InstallPhp72
	fi

	if [[ "$CFG_PHP_VERSION" == *"php7.3"* ]]; then
	    InstallPhp73
	fi

	if [[ "$CFG_PHP_VERSION" == *"php7.4"* ]]; then
	    InstallPhp74
	fi

	if [[ "$CFG_PHP_VERSION" == *"php8.0"* ]]; then
	    InstallPhp80
	fi

	if [[ "$CFG_PHP_VERSION" == *"php8.1"* ]]; then
	    InstallPhp81
	fi

	if [[ "$CFG_PHP_VERSION" == *"php8.2"* ]]; then
	    InstallPhp82
	fi

	if [[ "$CFG_PHP_VERSION" == *"php8.3"* ]]; then
	    InstallPhp83
	fi

	if [[ "$CFG_PHP_VERSION" == *"php8.4"* ]]; then
	    InstallPhp84
	fi

	if [[ "$CFG_PHP_VERSION" == *"none"* ]]; then
	    echo -e "No PHP version selected for installation."
	fi
    fi

    echo -n -e "$IDENTATION_LVL_1 Installing additional programs for PHP and Nginx... "
    #apt_install mcrypt imagemagick memcached curl tidy snmp redis-server
    apt_install imagemagick memcached curl tidy snmp redis-server
    #apt_install gcc make autoconf libc-dev pkg-config
    #apt_install libmcrypt-dev
    #pecl install mcrypt-1.0.1
    #echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/8.2/cli/conf.d/mcrypt.ini
    #echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/8.2/mods-available/mcrypt.ini
    ######echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/8.2/apache2/conf.d/mcrypt.ini

    #phpenmod mcrypt
    phpenmod mbstring
    echo -e "[${green}DONE${NC}]"

    if [ "$CFG_CERTBOT_VERSION" != "none" ]; then
	InstallLetsEncrypt
    fi    
}
