#---------------------------------------------------------------------
# Function: InstallWebmail
#    Install the chosen webmail client. Roundcube
#---------------------------------------------------------------------
InstallWebmail() {
VERSION=1.3.9
HASH=02850972b416bbfa1c13580f16d06fd7ae2774aa
PERSISTENT_LOGIN_VERSION=dc5ca3d3f4415cc41edb2fde533c8a8628a94c76
HTML5_NOTIFIER_VERSION=c8df6719c39a422657fe3091872ebc50c8cbd32c
FILTERS_VERSION=4d6822e93048f1ee50a85c1d7a70e0bb2e9b6c16
LOGINSEC_VERSION=5db3d4808477557260fcf0af9e30741379920759
RCM_RECAPTCHA=f1d89d0a3fc954ba595081494b7c664eb6dc1ea7
CARDDAV_VERSION=3.0.3
CARDDAV_HASH=d1e3b0d851ffa2c6bd42bf0c04f70d0e1d0d78f8

UPDATE_KEY=$VERSION:$PERSISTENT_LOGIN_VERSION:$HTML5_NOTIFIER_VERSION:$FILTERS_VERSION:$RCM_RECAPTCHA:$CARDDAV_VERSION

  echo -n "Installing Webmail client ($CFG_WEBMAIL)... "
  case $CFG_WEBMAIL in
	"roundcube")
	  #if [ "$CFG_MULTISERVER" == "no" ] && [ "$CFG_MIRRORSERVER" == "no" ]; then
	    # Generate a safe 24-character secret key of safe characters.
	    CFG_ROUNDCUBE_PWD=$(dd if=/dev/urandom bs=1 count=18 2>/dev/null | base64 | fold -w 24 | head -n 1)
	    #CFG_ROUNDCUBE_PWD=$(< /dev/urandom tr -dc A-Z-a-z-0-9 | head -c12)
	    #deskey=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9-_#&!*%?' | fold -w 24 | head -n 1)
	    CFG_ROUNDCUBE_DB="roundcube"
	    CFG_ROUNDCUBE_USR="roundcube"
	  #fi

	    CFG_ROUNDCUBE_PRODUCTNAME="Wolftronics Webmail"

	  hide_output apt-get update
	  #apt_install dbconfig-common \
	  #    javascript-common libjs-jquery-mousewheel php-net-sieve tinymce php-pear php7.0-intl php7.0-mcrypt \
	  #    php7.0-cli php7.0-sqlite php7.0-json php7.0-common php-auth php-net-smtp php-net-socket php-mail-mime \
	  #    php-crypt-gpg php7.0-gd php7.0-pspell libjs-jquery libmagic1 php7.0-mbstring
	  #apt_install dbconfig-common \
	  #    javascript-common libjs-jquery-mousewheel php-net-sieve tinymce php-pear php7.2-intl \
	  #    php7.2-cli php7.2-sqlite3 php7.2-json php7.2-common php-net-smtp php-net-socket php-mail-mime \
	  #    php7.2-gd php7.2-pspell libjs-jquery libmagic1 php7.2-mbstring

	  apt_install php7.2 php7.2-gd php-mysql php7.2-curl php7.2-zip php7.2-ldap php7.2-mbstring php-imagick php7.2-intl php7.2-xml unzip wget curl javascript-common libjs-jquery-mousewheel libjs-jquery libmagic1 tinymce
	  #phpenmod intl mcrypt
	
	  #apt_get_quiet remove php-mail-mimedecode # no longer needed since Roundcube 1.1.3
	  pear channel-update pear.php.net
	  pear install Mail_Mime
	  #pepear install "channel://pear.php.net/Net_IDNA2-0.2.0"
	  #php pyrus.phar install pear/Net_IDNA2
	
	  # We used to install Roundcube from Ubuntu, without triggering the dependencies #NODOC
	  # on Apache and MySQL, by downloading the debs and installing them manually. #NODOC
	  # Now that we're beyond that, get rid of those debs before installing from source. #NODOC
	  apt-get purge -qq -y roundcube* #NODOC

	  # paths that are often reused.
	  RCM_DIR=/usr/share/roundcube
	  RCM_PLUGIN_DIR=${RCM_DIR}/plugins
	  RCM_CONFIG=${RCM_DIR}/config/config.inc.php
	
	  needs_update=0 #NODOC
	  if [ ! -f /usr/local/lib/roundcubemail/version ]; then
	      # not installed yet #NODOC
	      needs_update=1 #NODOC
	  elif [[ "$UPDATE_KEY" != `cat /usr/local/lib/roundcubemail/version` ]]; then
	      # checks if the version is what we want
	      needs_update=1 #NODOC
	  fi
	  if [ $needs_update == 1 ]; then
	      # install roundcube
	      wget_verify \
		  https://github.com/roundcube/roundcubemail/releases/download/$VERSION/roundcubemail-$VERSION-complete.tar.gz \
		  $HASH \
		  /tmp/roundcube.tgz
	      tar -C /usr/local/lib --no-same-owner -zxf /tmp/roundcube.tgz
	      rm -rf /usr/local/lib/roundcubemail
	      mv /usr/local/lib/roundcubemail-$VERSION/ $RCM_DIR
	      rm -f /tmp/roundcube.tgz
	
	  #mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "CREATE DATABASE $CFG_ROUNDCUBE_DB;" > /dev/null 2>&1
	  #mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "GRANT ALL PRIVILEGES ON $CFG_ROUNDCUBE_DB.* TO $CFG_ROUNDCUBE_USR@localhost IDENTIFIED BY $CFG_ROUNDCUBE_PWD;" > /dev/null 2>&1
	  #mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "flush privileges;" > /dev/null 2>&1
	  #mysql -u root -p$CFG_MYSQL_ROOT_PWD $CFG_ROUNDCUBE_DB < /usr/share/roundcube/SQL/mysql.initial.sql
	  mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "CREATE DATABASE roundcube" > /dev/null 2>&1
	  mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "GRANT ALL PRIVILEGES ON roundcube.* TO roundcube@localhost IDENTIFIED BY '$CFG_ROUNDCUBE_PWD'" > /dev/null 2>&1
	  mysql -uroot -p$CFG_MYSQL_ROOT_PWD -e "flush privileges;" > /dev/null 2>&1
	  mysql -uroot -p"$CFG_MYSQL_ROOT_PWD" 'roundcube' < /usr/share/roundcube/SQL/mysql.initial.sql
	  cp -pf /usr/share/roundcube/config/config.inc.php.sample /usr/share/roundcube/config/config.inc.php
	
	  # Create writable directories.
	  mkdir -p /var/log/roundcubemail /tmp/roundcubemail
	  chown -R www-data.www-data /var/log/roundcubemail /tmp/roundcubemail
	
	  # Ensure the log file monitored by fail2ban exists, or else fail2ban can't start.
	  sudo -u www-data touch /var/log/roundcubemail/errors
	
	  # Password changing plugin settings
	  # The config comes empty by default, so we need the settings
	  # we're not planning to change in config.inc.dist...
	  #cp ${RCM_PLUGIN_DIR}/password/config.inc.php.dist \
	  #     ${RCM_PLUGIN_DIR}/password/config.inc.php
	
	  #roundcube extra plugins
	  git clone https://github.com/sjinks/roundcube_recaptcha
	  cp -r /tmp/roundcube_recaptcha /usr/share/roundcube/plugins/

	  # install roundcube persistent_login plugin
	  git_clone https://github.com/mfreiholz/Roundcube-Persistent-Login-Plugin.git $PERSISTENT_LOGIN_VERSION '' ${RCM_PLUGIN_DIR}/persistent_login
	  # install roundcube html5_notifier plugin
	  git_clone https://github.com/kitist/html5_notifier.git $HTML5_NOTIFIER_VERSION '' ${RCM_PLUGIN_DIR}/html5_notifier
	  # install roundcube filters plugin
	  git_clone https://github.com/6ec123321/filters.git $FILTERS_VERSION '' ${RCM_PLUGIN_DIR}/filters
	  # install roundcube Login Security for Roundcube Webmail. TOTP + Brute Force + CAPTCHA
	  git_clone https://github.com/dapphp/Roundcube-Plugin-login_security $LOGINSEC_VERSION '' ${RCM_PLUGIN_DIR}/login_security
	  # install roundcube reCAPTCHA plugin
	  git_clone https://github.com/sjinks/roundcube_recaptcha $RCM_RECAPTCHA '' ${RCM_PLUGIN_DIR}/roundcube_recaptcha
	  # download and verify the full release of the carddav plugin
	  wget_verify \
	      https://github.com/blind-coder/rcmcarddav/releases/download/v${CARDDAV_VERSION}/carddav-${CARDDAV_VERSION}.zip \
	      $CARDDAV_HASH \
	      /tmp/carddav.zip

	  # unzip and cleanup
	  unzip -q /tmp/carddav.zip -d ${RCM_PLUGIN_DIR}
	  rm -f /tmp/carddav.zip
	  # Configure CardDav
	  cat << "EOF" > ${RCM_PLUGIN_DIR}/carddav/config.inc.php
<?php
/* Do not edit. Written by Wolftronics. Regenerated on updates. */
\$prefs['_GLOBAL']['hide_preferences'] = true;
\$prefs['_GLOBAL']['suppress_version_warning'] = true;
\$prefs['ownCloud'] = array(
	'name'         =>  'ownCloud',
	'username'     =>  '%u', // login username
	'password'     =>  '%p', // login password
	'url'          =>  'https://cloud.wolftronics/cloud/remote.php/carddav/addressbooks/%u/contacts',
	'active'       =>  true,
	'readonly'     =>  false,
	'refresh_time' => '02:00:00',
	'fixed'        =>  array('username','password'),
	'preemptive_auth' => '1',
	'hide'        =>  false,
	);
EOF
	  # record the version we've installed
	  echo $UPDATE_KEY > ${RCM_DIR}/version
	  fi
	
	  ln -s /usr/share/roundcube /var/lib/roundcube
	  if [ $CFG_WEBSERVER == "apache" ]; then
		mv /etc/roundcube/apache.conf /etc/roundcube/apache.conf.default
		cat << "EOF" > /etc/roundcube/apache.conf
<VirtualHost *:80>
	# Those aliases do not work properly with several hosts on your apache server
	# Uncomment them to use it or adapt them to your configuration
	#    Alias /roundcube /var/lib/roundcube
	Alias /webmail /var/lib/roundcube

	<Directory /var/lib/roundcube/>
	  Options +FollowSymLinks
	  # This is needed to parse /var/lib/roundcube/.htaccess. See its
	  # content before setting AllowOverride to None.
	  AllowOverride All
	  <IfVersion >= 2.3>
		Require all granted
	  </IfVersion>
	  <IfVersion < 2.3>
		Order allow,deny
		Allow from all
	  </IfVersion>
	</Directory>

	# Protecting basic directories:
	<Directory /var/lib/roundcube/config>
			Options -FollowSymLinks
			AllowOverride None
	</Directory>

	<Directory /var/lib/roundcube/temp>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>

	<Directory /var/lib/roundcube/logs>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>
</VirtualHost>

<IfModule mod_ssl.c>
<VirtualHost *:443>
	# Those aliases do not work properly with several hosts on your apache server
	# Uncomment them to use it or adapt them to your configuration
	#    Alias /roundcube /var/lib/roundcube
	Alias /webmail /var/lib/roundcube

	<Directory /var/lib/roundcube/>
	  Options +FollowSymLinks
	  # This is needed to parse /var/lib/roundcube/.htaccess. See its
	  # content before setting AllowOverride to None.
	  AllowOverride All
	  <IfVersion >= 2.3>
		Require all granted
	  </IfVersion>
	  <IfVersion < 2.3>
		Order allow,deny
		Allow from all
	  </IfVersion>
	</Directory>

	# Protecting basic directories:
	<Directory /var/lib/roundcube/config>
			Options -FollowSymLinks
			AllowOverride None
	</Directory>

	<Directory /var/lib/roundcube/temp>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>

	<Directory /var/lib/roundcube/logs>
			Options -FollowSymLinks
			AllowOverride None
			<IfVersion >= 2.3>
			  Require all denied
			</IfVersion>
			<IfVersion < 2.3>
			  Order allow,deny
			  Deny from all
			</IfVersion>
	</Directory>

	# SSL Configuration
	SSLEngine On
	SSLProtocol All -SSLv2 -SSLv3
	#SSLCertificateFile    /usr/local/ispconfig/interface/ssl/ispserver.crt
	#SSLCertificateKeyFile /usr/local/ispconfig/interface/ssl/ispserver.key
	SSLCertificateFile     /home/administrator/.acme.sh/webmail.wolftronics.hu/fullchain.cer
	SSLCertificateKeyFile  /home/administrator/.acme.sh/webmail.wolftronics.hu/webmail.wolftronics.hu.key
	#SSLCACertificateFile  /usr/local/ispconfig/interface/ssl/ispserver.bundle
</VirtualHost>
</IfModule>
EOF
	  else
	#mkdir -p /etc/nginx/sites-available
        cat << "EOF" > /etc/nginx/sites-available/roundcube.vhost
server {
      listen 80 http2;
      # SSL configuration
      listen 443 ssl http2;
      ssl on;
      ssl_protocols TLSv1.2 TLSv1.3;
      #ssl_certificate       /usr/local/ispconfig/interface/ssl/ispserver.crt;
      #ssl_certificate_key   /usr/local/ispconfig/interface/ssl/ispserver.key;
      #ssl_certificate       /etc/letsencrypt/live/webmail.wolftronics.hu/fullchain.pem;
      #ssl_certificate_key   /etc/letsencrypt/live/webmail.wolftronics.hu/privkey.pem;
      ssl_certificate        /home/administrator/.acme.sh/webmail.wolftronics.hu/fullchain.cer;
      ssl_certificate_key    /home/administrator/.acme.sh/webmail.wolftronics.hu/webmail.wolftronics.hu.key;

      server_name webmail.*;
      index index.php index.html;
      root /var/lib/roundcube;
      location ~ ^/favicon.ico$ {
        root /var/lib/roundcube/skins/default/images;
        log_not_found off;
        access_log off;
        expires max;
      }
      location = /robots.txt {
          allow all;
          log_not_found off;
          access_log off;
      }
      location ~ ^/(README|INSTALL|LICENSE|CHANGELOG|UPGRADING)$ {
          deny all;
      }
      location ~ ^/(bin|SQL)/ {
          deny all;
      }
      location ~ /\. {
          deny all;
          access_log off;
          log_not_found off;
      }
      location ~ \.php$ {
          try_files $uri =404;
          include /etc/nginx/fastcgi_params;
          fastcgi_pass unix:/var/run/php/php7.2-fpm.sock;
          fastcgi_index index.php;
          fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
          fastcgi_buffer_size 128k;
          fastcgi_buffers 256 4k;
          fastcgi_busy_buffers_size 256k;
          fastcgi_temp_file_write_size 256k;
      }
}
EOF
		#mkdir -p /etc/nginx/sites-enabled
		ln -s /etc/nginx/sites-available/roundcube.vhost /etc/nginx/sites-enabled/roundcube.vhost
	  fi
	  # ISPConfig integration
	  cd /tmp
	  wget -q --no-check-certificate -O ispconfig3_roundcube.tgz https://github.com/w2c/ispconfig3_roundcube/tarball/master
	  tar xzf ispconfig3_roundcube.tgz
	  cp -r /tmp/*ispconfig3_roundcube*/ispconfig3_* /usr/share/roundcube/plugins/
	  ln -s /usr/share/roundcube/plugins/ispconfig3_account /var/lib/roundcube/plugins/ispconfig3_account
	  ln -s /usr/share/roundcube/plugins/ispconfig3_autoreply /var/lib/roundcube/plugins/ispconfig3_autoreply
	  ln -s /usr/share/roundcube/plugins/ispconfig3_autoselect /var/lib/roundcube/plugins/ispconfig3_autoselect
	  ln -s /usr/share/roundcube/plugins/ispconfig3_fetchmail /var/lib/roundcube/plugins/ispconfig3_fetchmail
	  ln -s /usr/share/roundcube/plugins/ispconfig3_filter /var/lib/roundcube/plugins/ispconfig3_filter
	  ln -s /usr/share/roundcube/plugins/ispconfig3_forward /var/lib/roundcube/plugins/ispconfig3_forward
	  ln -s /usr/share/roundcube/plugins/ispconfig3_pass /var/lib/roundcube/plugins/ispconfig3_pass
	  ln -s /usr/share/roundcube/plugins/ispconfig3_spam /var/lib/roundcube/plugins/ispconfig3_spam
	  ln -s /usr/share/roundcube/plugins/ispconfig3_wblist /var/lib/roundcube/plugins/ispconfig3_wblist
	  # Create a configuration file.
	  #
	  # For security, temp and log files are not stored in the default locations
	  # which are inside the roundcube sources directory. We put them instead
	  # in normal places.
	  sed -i "s|^\(\$config\['default_host'\] =\).*$|\1 \ array(\n'mail.wolftronics.hu' => 'Default Server',\n'webmail.wolftronics.hu' => 'Webmail Server',\n'ssl://mail.wolftronics.hu:993' => 'Secure Webmail Server'\n\);|" /usr/share/roundcube/config/config.inc.php
	  sed -i "s|^\(\$config\['db_dsnw'\] =\).*$|\1 \'mysqli://${CFG_ROUNDCUBE_DB}:${CFG_ROUNDCUBE_PWD}@localhost/${CFG_ROUNDCUBE_DB}\';|" /usr/share/roundcube/config/config.inc.php
	  sed -i "s|^\(\$config\['smtp_server'\] =\).*$|\1 \'%h\';|" /usr/share/roundcube/config/config.inc.php
	  sed -i "s|^\(\$config\['smtp_port'\] =\).*$|\1 \'587\';|" /usr/share/roundcube/config/config.inc.php
	  sed -i "s|^\(\$config\['smtp_user'\] =\).*$|\1 \'%u\';|" /usr/share/roundcube/config/config.inc.php
	  sed -i "s|^\(\$config\['smtp_pass'\] =\).*$|\1 \'%p\';|" /usr/share/roundcube/config/config.inc.php
	  sed -i "s|^\(\$config\['product_name'\] =\).*$|\1 \'${roundcubeproductname}\';|" /usr/share/roundcube/config/config.inc.php
	  #sed -i "s|^\(\$config\['support_url'\] =\).*$|\1 \'mailto:${E}\';|" /usr/share/roundcube/config/config.inc.php
	  #sed -i "s|^\(\$config\['des_key'\] =\).*$|\1 \'${deskey}\';|" /usr/share/roundcube/config/config.inc.php
	  sed -i "/'zipdownload',/a 'jqueryui',\n'filters',\n'html5_notifier',\n'persistent_login',\n'managesieve',\n'emoticons',\n'ispconfig3_account',\n'ispconfig3_autoreply',\n'ispconfig3_autoselect',\n'ispconfig3_pass',\n'ispconfig3_spam',\n'ispconfig3_fetchmail',\n'ispconfig3_filter',\n'ispconfig3_forward',\n'ispconfig3_wblist'," /usr/share/roundcube/config/config.inc.php
	  echo "\$config['login_autocomplete'] = 2;" >> /usr/share/roundcube/config/config.inc.php
	  echo "\$config['password_charset'] = 'UTF-8';" >> /usr/share/roundcube/config/config.inc.php
	  echo "\$config['junk_mbox'] = 'Spam';" >> /usr/share/roundcube/config/config.inc.php
	  echo "\$config['log_dir'] = '/var/log/roundcubemail/';" >> /usr/share/roundcube/config/config.inc.php
	  echo "\$config['temp_dir'] = '/tmp/roundcubemail/';" >> /usr/share/roundcube/config/config.inc.php
	
	  mv /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php.dist /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	  sed -i "s/\$rcmail_config\['remote_soap_pass'\] = '.*';/\$rcmail_config\['remote_soap_pass'\] = '$CFG_ROUNDCUBE_PWD';/" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	  sed -i "s/\$rcmail_config\['soap_url'\] = '.*';/\$rcmail_config['soap_url'] = 'https\:\/\/$CFG_HOSTNAME_FQDN\:8888\/remote\/';/" /usr/share/roundcube/plugins/ispconfig3_account/config/config.inc.php
	  mv /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php.dist /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php
	  sed -i "s/\$rcmail_config\['password_min_length'\] = 6;/\$rcmail_config\['password_min_length'\] = 8;/" /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php
	  sed -i "s/\$rcmail_config\['password_check_symbol'\] = TRUE;/\$rcmail_config\['password_check_symbol'\] = FALSE;/" /usr/share/roundcube/plugins/ispconfig3_pass/config/config.inc.php
	  rm -rf /usr/share/roundcube/installer
	
	  # Fix Carddav permissions:
	  chown -f -R root.www-data ${RCM_PLUGIN_DIR}/carddav
	  # root.www-data need all permissions, others only read
	  chmod -R 774 ${RCM_PLUGIN_DIR}/carddav
	
	  # Run Roundcube database migration script (database is created if it does not exist)
	  ${RCM_DIR}/bin/updatedb.sh --dir ${RCM_DIR}/SQL --package roundcube
    ;;
	"squirrelmail")
	  if [ $CFG_WEBSERVER == "apache" ]; then
	    echo "dictionaries-common dictionaries-common/default-wordlist select american (American English)" | debconf-set-selections
	    apt_install squirrelmail wamerican
	    ln -s /etc/squirrelmail/apache.conf /etc/apache2/conf-available/squirrelmail.conf
	    a2enconf squirrelmail
	    sed -i 1d /etc/squirrelmail/apache.conf
	    sed -i '1iAlias /webmail /usr/share/squirrelmail' /etc/squirrelmail/apache.conf

	    case $CFG_MTA in
		  "courier")
		    sed -i 's/$imap_server_type       = "other";/$imap_server_type       = "courier";/' /etc/squirrelmail/config.php
		    sed -i 's/$optional_delimiter     = "detect";/$optional_delimiter     = ".";/' /etc/squirrelmail/config.php
		    sed -i 's/$default_folder_prefix          = "";/$default_folder_prefix          = "INBOX.";/' /etc/squirrelmail/config.php
		    sed -i 's/$trash_folder                   = "INBOX.Trash";/$trash_folder                   = "Trash";/' /etc/squirrelmail/config.php
		    sed -i 's/$sent_folder                    = "INBOX.Sent";/$sent_folder                    = "Sent";/' /etc/squirrelmail/config.php
		    sed -i 's/$draft_folder                   = "INBOX.Drafts";/$draft_folder                   = "Drafts";/' /etc/squirrelmail/config.php
		    sed -i 's/$default_sub_of_inbox           = true;/$default_sub_of_inbox           = false;/' /etc/squirrelmail/config.php
		    sed -i 's/$delete_folder                  = false;/$delete_folder                  = true;/' /etc/squirrelmail/config.php
		  ;;
		  "dovecot")
		    sed -i 's/$imap_server_type       = "other";/$imap_server_type       = "dovecot";/' /etc/squirrelmail/config.php
		    sed -i 's/$trash_folder                   = "INBOX.Trash";/$trash_folder                   = "Trash";/' /etc/squirrelmail/config.php
		    sed -i 's/$sent_folder                    = "INBOX.Sent";/$sent_folder                    = "Sent";/' /etc/squirrelmail/config.php
		    sed -i 's/$draft_folder                   = "INBOX.Drafts";/$draft_folder                   = "Drafts";/' /etc/squirrelmail/config.php
		    sed -i 's/$default_sub_of_inbox           = true;/$default_sub_of_inbox           = false;/' /etc/squirrelmail/config.php
		    sed -i 's/$delete_folder                  = false;/$delete_folder                  = true;/' /etc/squirrelmail/config.php
		  ;;
	    esac
	  fi	
	;;
  esac

  # Enable PHP modules.
  #phpenmod -v php7.2 mcrypt imap
  phpenmod -v php7.2 imap
  restart_service php7.2-fpm

  #ssl cert generated
  service nginx stop

  if [ "$CFG_SSL_NEW" == "yes" ]; then
    sh /home/administrator/.acme.sh/acme.sh --issue --standalone -d webmail.wolftronics.hu --force
  else
    cp -av /home/administrator/wtlinux_server_setup/acme_ssl/wolftronics/webmail.wolftronics.hu /home/administrator/.acme.sh/
  fi

  if [ $CFG_WEBSERVER == "apache" ]; then
      #acme.sh --install-cert -d webmail.wolftronics.hu \
      #--cert-file      /path/to/certfile/in/apache/cert.pem  \
      #--key-file       /path/to/keyfile/in/apache/key.pem  \
      #--fullchain-file /path/to/fullchain/certfile/apache/fullchain.pem \
      #--reloadcmd     "service apache2 force-reload"
      restart_service apache2
  else
      #acme.sh --install-cert -d webmail.wolftronics.hu \
      #--key-file       /path/to/keyfile/in/nginx/key.pem  \
      #--fullchain-file /path/to/fullchain/nginx/cert.pem \
      #--reloadcmd     "service nginx force-reload"
      restart_service nginx
  fi

cat >> /root/wtserver_configuration.txt <<EOF
# roundcube Store the passwords
Database type		: mysql
Database name		: $CFG_ROUNDCUBE_DB
Database user		: $CFG_ROUNDCUBE_USR
Database password	: $CFG_ROUNDCUBE_PWD

EOF

  echo -e "[${green}DONE${NC}]\n"
}
