#---------------------------------------------------------------------
# Function: InstallBasics
#    Install basic packages
#---------------------------------------------------------------------
InstallBasics() {
  echo -n "Updating package list and upgrading installed packages... "
  hide_output apt-get update && hide_output apt-get -y full-upgrade && hide_output apt-get -y autoremove
  if [ $? -eq 0 ]; then
    echo -e "[${green}DONE${NC}]"
  else
    echo -e "[${red}FAILED${NC}]"
    exit 1
  fi

  echo -n "Checking and updating PATH if necessary... "
  # List of directories to check
  required_paths=("/usr/local/sbin" "/usr/local/bin" "/usr/sbin" "/usr/bin" "/sbin" "/bin")

  # Initialize a variable to track if PATH was modified
  path_modified=false

  # Loop through each required path
  for path in "${required_paths[@]}"; do
    # Check if the path is not in the PATH variable
    if [[ ":$PATH:" != *":$path:"* ]]; then
      # Add the missing path to the PATH
      export PATH="$path:$PATH"
      path_modified=true
    fi
  done

  # Print appropriate message based on whether PATH was modified
  if [ "$path_modified" = true ]; then
    echo -e "[${green}UPDATED${NC}]"
  else
    echo -e "[${green}OK${NC}]"
  fi

  echo -n "Installing basic packages (OpenSSH server, NTP, binutils, Rootkit detection (rkhunter) etc.)... "
  apt_install patch ssh openssh-server nano vim-nox ntp debconf-utils binutils sudo git lsb-release e2fsprogs curl rkhunter unzip wget htop nano zip
  if [ $? -eq 0 ]; then
    echo -e "[${green}DONE${NC}]"
  else
    echo -e "[${red}FAILED${NC}]"
    exit 1
  fi

  if [ "$(ls -l /bin/sh | awk '{print $NF}')" = "dash" ]; then
    echo -n "Changing the default shell from dash to bash... "
    echo "dash dash/sh boolean false" | debconf-set-selections
    dpkg-reconfigure -f noninteractive dash > /dev/null 2>&1
    if [ $? -eq 0 ]; then
      echo -e "[${green}DONE${NC}]"
    else
      echo -e "[${red}FAILED${NC}]"
      exit 1
    fi
  fi
}
