#---------------------------------------------------------------------
# Function: InstallSQLServer
#    Install and configure SQL Server
#---------------------------------------------------------------------
InstallSQLServer() {
  if [ "$CFG_SQLSERVER" == "MySQL" ]; then
    echo -n "Installing Database server (MySQL)... "
    echo "mysql-server-5.5 mysql-server/root_password password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    echo "mysql-server-5.5 mysql-server/root_password_again password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    apt_install mysql-client mysql-server
    sed -i 's/bind-address		= 127.0.0.1/#bind-address		= 127.0.0.1/' /etc/mysql/mysql.conf.d/mysqld.cnf
    echo "sql-mode=\"NO_ENGINE_SUBSTITUTION\"" >> /etc/mysql/mysql.conf.d/mysqld.cnf
    echo -e "[${green}DONE${NC}]\n"
    echo -n "Restarting MySQL... "
    restart_service mysql
    echo -e "[${green}DONE${NC}]\n"
  
  elif [ "$CFG_SQLSERVER" == "MariaDB" ]; then
  
    echo -n "Installing Database server (MariaDB 10.3)... "
    apt_install software-properties-common
    apt-key adv --recv-keys --keyserver hkp://keyserver.ubuntu.com:80 0xF1656F24C74CD1D8
    #Mariadb 10.1
    #add-apt-repository -y 'deb [arch=amd64,i386,ppc64el] http://ftp.bme.hu/pub/mirrors/mariadb/repo/10.1/ubuntu xenial main'
    #echo "maria-db-10.1 mysql-server/root_password password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    #echo "maria-db-10.1 mysql-server/root_password_again password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    #Mariadb 10.2
    #add-apt-repository -y 'deb [arch=amd64,i386,ppc64el] http://ftp.bme.hu/pub/mirrors/mariadb/repo/10.2/ubuntu xenial main'
    #add-apt-repository -y 'deb [arch=amd64,i386,ppc64el] http://mariadb.cu.be/repo/10.2/ubuntu  xenial main'
    #echo "maria-server-10.2 mysql-server/root_password password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    #echo "maria-server-10.2 mysql-server/root_password_again password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    add-apt-repository -y 'deb [arch=amd64,i386,ppc64el] http://ftp.bme.hu/pub/mirrors/mariadb/repo/10.3/ubuntu  xenial main'
    echo "maria-server-10.3 mysql-server/root_password password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    echo "maria-server-10.3 mysql-server/root_password_again password $CFG_MYSQL_ROOT_PWD" | debconf-set-selections
    hide_output apt-get update
    apt_install mariadb-client mariadb-server
    #sed -i 's/bind-address		= 127.0.0.1/#bind-address		= 127.0.0.1/' /etc/mysql/mariadb.conf.d/50-server.cnf
    sed -i 's/bind-address		= 127.0.0.1/#bind-address		= 127.0.0.1/' /etc/mysql/my.cnf
    #Enable Binary Logging in MariaDB
    #log_error=/var/log/mariadb.log
    #touch /var/log/mariadb.log
    #chown mysql:mysql /var/log/mariadb.log
#    cat << "EOF" > /etc/mysql/mariadb.conf.d/50-server.cnf
#[mysqld]
#log-bin        = /var/log/mysql/mariadb-bin
#log-bin-index  = /var/log/mysql/mariadb-bin.index
#binlog_format  = mixed
#EOF

    #echo "update mysql.user set plugin = 'mysql_native_password' where user='root';" | mysql -u root
    #sed -i 's/password =/password = '$CFG_MYSQL_ROOT_PWD'/' /etc/mysql/debian.cnf
    #mysql -e "UPDATE mysql.user SET Password = PASSWORD('$CFG_MYSQL_ROOT_PWD') WHERE User = 'root'"
    # Make our changes take effect
    #mysql -e "FLUSH PRIVILEGES"
    # Prepare for Nextcloud installation
    # https://blog.v-gar.de/2017/02/en-solved-error-1698-28000-in-mysqlmariadb/
    #mysql -u root mysql -p"$CFG_MYSQL_ROOT_PWD" -e "UPDATE user SET plugin='' WHERE user='root';"
    #mysql -u root mysql -p"$CFG_MYSQL_ROOT_PWD" -e "UPDATE user SET password=PASSWORD('$CFG_MYSQL_ROOT_PWD') WHERE user='root';"
    #mysql -u root -p"$CFG_MYSQL_ROOT_PWD" -e "flush privileges;"
    echo "[mysqld]" >> /etc/mysql/my.cnf
    echo "sql-mode="NO_ENGINE_SUBSTITUTION"" >> /etc/mysql/my.cnf
    # mysql_secure_installation
    apt_install expect
    SECURE_MYSQL=$(expect -c "
	set timeout 10
	spawn mysql_secure_installation
	expect \"Enter current password for root (enter for none):\"
	send \"$CFG_MYSQL_ROOT_PWD\r\"
	expect \"Change the root password?\"
	send \"n\r\"
	expect \"Remove anonymous users?\"
	send \"y\r\"
	expect \"Disallow root login remotely?\"
	send \"y\r\"
	expect \"Remove test database and access to it?\"
	send \"y\r\"
	expect \"Reload privilege tables now?\"
	send \"y\r\"
	expect eof
    ")
#    echo "$SECURE_MYSQL"
    echo "$SECURE_MYSQL" > /dev/null 2>&1
    hide_output apt-get -y purge expect
    echo -e "[${green}DONE${NC}]\n"
    echo -n "Restarting MariaDB... "
    restart_service mysql	
    echo -e "[${green}DONE${NC}]\n"
  fi
}
