#---------------------------------------------------------------------
# Function: Install Postfix
#    Install and configure postfix
#---------------------------------------------------------------------
InstallPostfix() {
  local START_TIME=$SECONDS

  echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing Postfix${NC}\n"

  echo -n -e "$IDENTATION_LVL_1 Checking and disabling Sendmail... "
  if [ -f /etc/init.d/sendmail ]; then
    service sendmail stop >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
    update-rc.d -f sendmail remove >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
    apt_remove sendmail
  fi
  echo -e "[${green}DONE${NC}]"

  echo -n -e "$IDENTATION_LVL_1 Preconfigure SMTP Mail server (Postfix)... "
  echo "postfix postfix/main_mailer_type select Internet Site" | debconf-set-selections
  echo "postfix postfix/mailname string $CFG_HOSTNAME_FQDN" | debconf-set-selections
  echo -e "[${green}DONE${NC}]"

  echo -n -e "$IDENTATION_LVL_1 Install SMTP Mail server (Postfix)... "
  apt_install postfix postfix-mysql postfix-doc postfix-pcre ca-certificates
  echo -e "[${green}DONE${NC}] "

  echo -n -e "$IDENTATION_LVL_1 Configure SMTP Mail server (Postfix)... "
  cp /etc/postfix/master.cf /etc/postfix/master.cf.backup
  sed -i "s/#submission inet n       -       -       -       -       smtpd/submission inet n       -       -       -       -       smtpd/" /etc/postfix/master.cf
  sed -i "s/#  -o syslog_name=postfix\/submission/  -o syslog_name=postfix\/submission/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_tls_security_level=encrypt/  -o smtpd_tls_security_level=encrypt/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_sasl_auth_enable=yes/  -o smtpd_sasl_auth_enable=yes\\$(echo -e '\n\r')  -o smtpd_client_restrictions=permit_sasl_authenticated,reject/" /etc/postfix/master.cf
  sed -i "s/#smtps     inet  n       -       -       -       -       smtpd/smtps     inet  n       -       -       -       -       smtpd/" /etc/postfix/master.cf
  sed -i "s/#  -o syslog_name=postfix\/smtps/  -o syslog_name=postfix\/smtps/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_tls_wrappermode=yes/  -o smtpd_tls_wrappermode=yes/" /etc/postfix/master.cf
  sed -i "s/#  -o smtpd_sasl_auth_enable=yes/  -o smtpd_sasl_auth_enable=yes\\$(echo -e '\n\r')  -o smtpd_client_restrictions=permit_sasl_authenticated,reject/" /etc/postfix/master.cf
  sed -i "s/#tlsproxy  unix  -       -       y       -       0       tlsproxy/tlsproxy  unix  -       -       y       -       0       tlsproxy/" /etc/postfix/master.cf
  echo -e "[${green}DONE${NC}]"

  echo "" >> /etc/jailkit/jk_init.ini

  # https://gist.github.com/rvalitov/5e2fae28aa5bc81402ab6d4acb9d986f
  # https://www.faqforge.com/linux/add-php-in-ssh-jail-ispconfig-3/
  cat <<EOL >> /etc/jailkit/jk_init.ini
[php]
comment = the php interpreter and libraries
executables = /usr/bin/php, /usr/bin/php5.6, /usr/bin/php7.0, /usr/bin/php7.1, /usr/bin/php7.2, /usr/bin/php7.3, /usr/bin/php7.4, /usr/bin/php8.0, /usr/bin/php8.1, /usr/bin/php8.2, /usr/bin/php8.3, /usr/bin/php8.4
directories = /usr/lib/php, /usr/share/php, /usr/share/php*, /etc/php, /usr/share/php-geshi, /usr/share/zoneinfo, /usr/share/ca-certificates, /etc/ssl/certs, /usr/lib/ssl/certs
includesections = env, netbasics

[env]
comment = environment variables
executables = /usr/bin/env
EOL

  echo -n -e "$IDENTATION_LVL_1 Restart SMTP Mail server (Postfix)... "
  service postfix restart >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
  echo -e "[${green}DONE${NC}]"

  MeasureTimeDuration $START_TIME
}
