# ISP Config Installer Skript

# TCP Ports #
                20      - FTP
                21      - FTP
                22      - SSH/SFTP
                25      - Mail (SMTP)
                53      - DNS
                80      - Web (HTTP)
                110     - Mail (POP3)
                143     - Mail (IMAP)
                443     - Web (HTTPS)
                465     - Mail (SMTPS)
                587     - Mail (SMTP)
                993     - Mail (IMAPS)
                995     - Mail (POP3S)
                3306    - Database
                5222    - Chat (XMPP)
                8080    - ISPConfig
                8081    - ISPConfig
                10000   - ISPConfig


Wie Sie vielleicht wissen, ist ISPConfig eines der besten kostenlosen Open-Source-Hosting-Control-Panels zur Verwaltung von Linux-Hosting-Servern in Single- und Multi-Server-Umgebungen.

Heute werden Sie sehen, wie Sie diese erstaunliche Systemsteuerung mit ispconfig_setup-Skript bereitstellen und installieren. Dieses Skript ist kostenlos auf GitHub unter https://github.com/PageSpeed-Ninjas/ispconfig_setup verfügbar und wird von Servisys mit Hilfe der Community kostenlos entwickelt und gewartet.

Raspbian 9 Strech
Debian 9 Strech
Debian 8 Jessie
Debian 7 Wheezy
Ubuntu 14.04 Trusty ([Wolftronics VPS](https://www.wolftronics.hu/), VmWare Esxi, Amazon AWS, Virtualbox, OVH VPS, Hetzner, Digital Ocean)
Ubuntu 15.10 Willy ([Wolftronics VPS](https://www.wolftronics.hu/), VmWare Esxi, Amazon AWS, Virtualbox, OVH VPS, Hetzner, Digital Ocean)
Ubuntu 16.04 Xenial Xerus ( [Wolftronics VPS](https://www.wolftronics.hu/), VmWare Esxi, Amazon AWS, Virtualbox, OVH VPS, Hetzner, Digital Ocean)
Centos 7

### What is this repository for? ###
-
-This repository contains some scripts for the automation
-
-of installation of ISPConfig 3 control panel.
-
-Before start be sure to configure your server following the following guides:
-
-- Debian 9: https://www.howtoforge.com/tutorial/debian-minimal-server/
-- Debian 8: https://www.howtoforge.com/tutorial/debian-8-jessie-minimal-server/
-- Debian 7: https://www.howtoforge.com/perfect-server-debian-wheezy-apache2-bind-dovecot-ispconfig-3
-- Ubuntu 14.10: https://www.howtoforge.com/tutorial/ubuntu-minimal-server-install/
-- Ubuntu 15.10: https://www.howtoforge.com/tutorial/ubuntu-minimal-server-install/
-- Ubuntu 16.04: https://www.howtoforge.com/tutorial/ubuntu-minimal-server-install/
-- Centos 7: http://www.howtoforge.com/centos-7-server
-
-You can Choose during install:
-- Apache / Nginx
-- Dovecot or Courier
-- Quota On/Off
-- Jailkit On/Off
-- Squirrelmail / Roundcube
-- ISPConfig 3 Standard / Expert mode
-- ISPConfig 3 Multiserver Setup (* Debian 8 only for now)

### _Inhaltsverzeichnis:_

* [1. Minimal Basis Installation aktualisiern](#minimal-basis-installation-aktualisiern)
* [2. Non-Root-User mit sudo Privilegien erstellen](#non-root-user-mit-sudo-privilegien-erstellen)
* [3. Hostnamen setzten](#hostnamen-setzten)
  * [3.1. Interner Hostname](#interner-hostname)
  * [3.2. Externer Hostname](#externer-hostname)
  * [3.3. Kontrolle](#kontrolle)
* [4. Grundlegende Tools installieren](#grundlegende-tools-installieren)
* [5. Install Skript starten](#install-skript-starten)
  * [5.1. Kontrolle des Installskripts](#kontrolle-des-installskripts)

### Minimal Basis Installation aktualisiern

```bash
apt-get update && apt-get -y upgrade && apt-get -y dist-upgrade && apt-get -y autoremove && apt-get -y autoclean
echo -e "${green} Installation aktualisiern${NC}\n"
```

### Non-Root-User mit sudo Privilegien erstellen

```bash
adduser isp
usermod -a -G sudo isp
# Verhindert direkte SSH Logins von root
sed -i 's/PermitRootLogin yes/PermitRootLogin without-password/' /etc/ssh/sshd_config
# Erlaubt SSH Logins via Passwort
sed -i 's/PasswordAuthentication no/PasswordAuthentication yes/' /etc/ssh/sshd_config
/etc/init.d/ssh restart
# Passwort für root setzten - Kann kurz sein, da nur eingeloggte User mit sudo Privilegien zu root werden können.
passwd root
```

### Hostnamen setzten

#### Interner Hostname

```bash
# nano /etc/hostname
echo "dev" >> /etc/hostname
```

##### Inhalt von `/etc/hostname`**

`dev`

#### Externer Hostname 

```bash
nano /etc/hosts
```

##### Inhalt von `/etc/hosts`

```bash
127.0.0.1 localhost.localdomain localhost
127.0.1.1 localhost.localdomain localhost
10.0.0.1 dev
165.227.174.198 dev.ispconf.cf dev
```

Nun muss ist ein `reboot` erforderlich. Dannach die Hostnamen mit: 

#### Kontrolle

```bash
hostname # = dev.ispconf.cf
hostname -f # = dev
```

## Grundlegende Tools installieren

```bash
apt-get -y install dnsutils zoo unzip bzip2 arj nomarch lzop cabextract locate apt-listchanges libnet-ldap-perl libauthen-sasl-perl libio-string-perl libio-socket-ssl-perl libnet-ident-perl zip libnet-dns-perl libdbd-mysql-perl apt-transport-https software-properties-common lsb-release ca-certificates ssh openssh-server ntp ntpdate debconf-utils binutils sudo lsb-release haveged e2fsprogs curl ssh openssh-server openssl ssl-cert mcrypt nano sudo curl git rsync certbot rkhunter ufw fail2ban binutils
```

## Install Skript starten

```bash
cd /home/isp
git clone https://gitlab.wolftronics.hu/wolftronics-linux/wtlinux_server_setup.git
cd ispconfig_setup
chmod +x install.sh
bash install.sh
```

## Kontrolle des Installskripts

Nachdem alles installiert ist, können Sie mit dem Befehl nach Fehlern oder seltsamen Dingen suchen

```bash
cat /var/log/ispconfig_setup.log
```
