#---------------------------------------------------------------------
# Function: InstallWebServer Ubuntu 18.04
#    Install and configure Apache2, php + modules
#---------------------------------------------------------------------
InstallWebServer() {
PHPMYADMINVERSION=4.8.5
PHPMYADMINHASH=3eb8d49578ac9d4a984330b1be6e903e01540012
  if [ "$CFG_WEBSERVER" == "apache" ]; then
	CFG_NGINX=n
	CFG_APACHE=y
	echo -n "Installing Web server (Apache) and modules... "
	echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect apache2" | debconf-set-selections
	# - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
	echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
	# apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libapache2-mod-passenger libapache2-mod-python libexpat1 ssl-cert libruby
	apt_install apache2 apache2-doc apache2-utils libapache2-mod-php libapache2-mod-fcgid apache2-suexec-pristine libruby libapache2-mod-python
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP and Modules... "
	apt_install php7.2 php7.2-common php7.2-gd php7.2-mysql php7.2-imap php7.2-cli php7.2-cgi php-pear mcrypt imagemagick libruby php7.2-curl php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl memcached php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php7.2-fpm php7.2-opcache php-apcu
	#apt-get_install php7.2 php7.2-common php7.2-gd php7.2-mysql php7.2-imap php7.2-cli php7.2-cgi php-pear php7.2-curl php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php-soap php7.2-soap php7.2-bz2 php-redis php7.2-snmp php7.2-xml > /dev/null 2>&1

	#apt-get_install php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl memcached php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php-soap php7.2-soap memcached imagemagick libruby php-pear mcrypt php7.2-pdo-odbc php7.2-imagick php7.2-redis php7.2-bz2 php7.2-mongodb php7.2-common php7.2-cgi php7.2-cli php7.2-dba php7.2-smbclient php7.2-dom php7.2-bcmath php7.2-oauth php7.2-memcached php7.2-pinba php7.2-fpm php7.2-ftp php7.2-igbinary php7.2-gmp php7.2-mysql php7.2-memcache php7.2-uuid php7.2-sockets  php7.2-mailparse php7.2 php7.2-sysvmsg php7.2-wddx  php7.2-pdo-pgsql php7.2-calendar php7.2-fileinfo php7.2-pdo php7.2-xmlwriter php7.2-json php7.2-opcache php7.2-mysqli php7.2-sass php7.2-sysvsem php7.2-sysvshm php7.2-phar php7.2-rrd php7.2-sybase php7.2-curl php7.2-stomp php7.2-msgpack php7.2-ldap php7.2-gearman php7.2-raphf php7.2-phpdbg php7.2-xmlreader php7.2-imap php7.2-gnupg php7.2-radius php7.2-uploadprogress php7.2-posix php7.2-iconv php7.2-xml   php7.2-zip php7.2-tokenizer php7.2-zmq php7.2-odbc php7.2-mbstring php7.2-readline php7.2-ds php7.2-gd php7.2-ps php7.2-interbase php7.2-yaml php7.2-snmp php7.2-pdo-mysql php7.2-mysqlnd  php7.2-soap php7.2-solr php7.2-simplexml php7.2-ssh2 php7.2-pdo-sqlite php7.2-pdo-dblib  php7.2-amqp php7.2-gmagick php7.2-pgsql php7.2-enchant  php7.2-tideways php7.2-shmop php7.2-libsodium php7.2-propro php7.2-gettext php7.2-pdo-firebird php7.2-exif php7.2-ctype php7.2-http php7.2-geoip php7.2-xdebug php7.2-common php7.2-mysql php7.2-odbc php7.2-pgsql  php7.2-xml php-amqp php-ds php-gearman php-geoip php-gmagick php-gnupg php-http php-igbinary php-imagick php-libsodium php-mailparse php-memcache php-memcached php-mongodb php-msgpack php-oauth php-pinba php-propro php-ps php-radius php-raphf php-redis php-rrd php-sass php-smbclient php-solr php-ssh2 php-stomp php-tideways php-uploadprogress php-uuid php-xdebug php-yac php-yaml php-zmq php7.2-interbase php7.2-sybase > /dev/null 2>&1

	#php.ini settings roundcube and other
	sed -i "s/;extension=php_mbstring.dll/extension=php_mbstring.dll/" /etc/php/7.2/apache2/php.ini
	sed -i "s/;extension=php_xmlrpc.dll/extension=php_xmlrpc.dll/" /etc/php/7.2/apache2/php.ini
	sed -i "s/;extension=php_xsl.dll/;extension=php_xsl.dll\\`echo -e '\n\r'`extension=dom.so/" /etc/php/7.2/apache2/php.ini
	sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/7.2/apache2/php.ini
	sed -i "s/post_max_size =.*/post_max_size = 18M/g" /etc/php/7.2/apache2/php.ini
	sed -i "s/upload_max_filesize =.*/upload_max_filesize = 12M/g" /etc/php/7.2/apache2/php.ini
	sed -i "s/;mbstring.func_overload = 0/mbstring.func_overload = 0/" /etc/php/7.2/apache2/php.ini
	service php7.2-fpm reload
	restart_service apache2
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing Opcache and APCu... "
	apt_install php7.2-opcache php-apcu
	#PHP OPcache
	echo -n "Enabled and Configuration PHP OPcache..."
	sed -i "s/;opcache.enable=0/opcache.enable=1/" /etc/php/7.0/apache2/php.ini
	sed -i "s/;opcache.memory_consumption=64/opcache.memory_consumption=128/" /etc/php/7.0/apache2/php.ini
	sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=4000/" /etc/php/7.0/apache2/php.ini
	sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=240/" /etc/php/7.0/apache2/php.ini
	phpenmod opcache
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP-FPM... "
	apt_install php7.2-fpm
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing needed programs for PHP and Apache (mcrypt, etc.)... "
	apt_install mcrypt imagemagick memcached curl tidy snmp
	echo -e "[${green}DONE${NC}]\n"

  	echo "<IfModule mod_headers.c>
    RequestHeader unset Proxy early
	</IfModule>" | tee /etc/apache2/conf-available/httpoxy.conf > /dev/null 2>&1
	
	if [ "$CFG_PHPMYADMIN" == "yes" ]; then
		#echo "==========================================================================================="
		#echo "Attention: When asked 'Configure database for phpmyadmin with dbconfig-common?' select 'NO'"
		#echo "Due to a bug in dbconfig-common, this can't be automated."
		#echo "==========================================================================================="
		#echo "Press ENTER to continue... "
		#read DUMMY
		echo -n "Installing phpMyAdmin... "
		hide_output add-apt-repository -y ppa:nijel/phpmyadmin
		hide_output apt-get update
		debconf-set-selections <<< "phpmyadmin phpmyadmin/dbconfig-install boolean false"
		apt-get -y install phpmyadmin
		#pma db error?
		apt-mark hold phpmyadmin
		rm -rf /usr/share/phpmyadmin/*
		wget_verify \
		    https://files.phpmyadmin.net/phpMyAdmin/$PHPMYADMINVERSION/phpMyAdmin-$PHPMYADMINVERSION-all-languages.tar.gz \
		    $PHPMYADMINHASH \
		    /tmp/phpmyadmin.tgz
		tar -C /tmp --no-same-owner -zxf /tmp/phpmyadmin.tgz
		mv /tmp/phpMyAdmin-$PHPMYADMINVERSION-all-languages/* /usr/share/phpmyadmin/
		cp /etc/phpmyadmin/config.inc.php /usr/share/phpmyadmin
		rm -f /tmp/phpmyadmin.tgz
		echo -e "[${green}DONE${NC}]\n"
	fi
	
	# if [ "$CFG_XCACHE" == "yes" ]; then
		# echo -n "Installing XCache... "
		# apt_install php7-xcache
		# echo -e "[${green}DONE${NC}]\n"
	# fi

	echo -n "Activating Apache modules... "
	a2enmod suexec > /dev/null 2>&1
	a2enmod rewrite > /dev/null 2>&1
	a2enmod ssl > /dev/null 2>&1
	a2enmod actions > /dev/null 2>&1
	a2enmod include > /dev/null 2>&1
	a2enmod cgi > /dev/null 2>&1
	a2enmod dav_fs > /dev/null 2>&1
	a2enmod dav > /dev/null 2>&1
	a2enmod auth_digest > /dev/null 2>&1
	a2enmod headers > /dev/null 2>&1
	a2enmod fastcgi > /dev/null 2>&1
	a2enmod proxy_fcgi > /dev/null 2>&1
	a2enmod alias > /dev/null 2>&1
	# a2enmod fcgid > /dev/null 2>&1
	a2enconf httpoxy > /dev/null 2>&1
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Restarting Apache... "
	service apache2 restart
	echo -e "[${green}DONE${NC}]\n"

	echo -n "Installing needed programs for PHP and Apache (mcrypt, etc.)... "
	apt_install mcrypt imagemagick memcached curl tidy snmp redis-server
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Block Exploits, SQL Injections, File Injections, Spam, User Agents, Etc. Apache2 Modules... "
	# This mitigation has been assigned the identifier CVE-2016-5387
	# Please refer to:
	# https://httpoxy.org/#fix-now
	# https://www.nginx.com/blog/mitigating-the-httpoxy-vulnerability-with-nginx/
	echo -n "Removing the HTTP Proxy Header with Apache2..."
	sed -i '$ a\\nRequestHeader unset Proxy early' /etc/apache2/apache2.conf
	service apache2 restart > /dev/null 2>&1
	
  elif [ "$CFG_WEBSERVER" == "nginx" ]; then
	CFG_NGINX=y
	CFG_APACHE=n
	echo -n "Installing Web server (nginx) and modules... "
	service apache2 stop > /dev/null 2>&1
	hide_output update-rc.d -f apache2 remove
	#orig nginx repo error nginx.conf ppa to copy
	#curl -O https://nginx.org/keys/nginx_signing.key && apt-key add ./nginx_signing.key
	#orig nginx repo develop
	#echo "deb http://nginx.org/packages/mainline/ubuntu/ xenial nginx" >> /etc/apt/sources.list.d/nginx-xenial.list
	#echo "deb-src http://nginx.org/packages/mainline/ubuntu/ xenial nginx" >>/etc/apt/sources.list.d/nginx-xenial.list
	#orig nginx repo stable
	#echo "deb http://nginx.org/packages/ubuntu/ xenial nginx" >> /etc/apt/sources.list.d/nginx-xenial.list
	#echo "deb-src http://nginx.org/packages/ubuntu/ xenial nginx" >>/etc/apt/sources.list.d/nginx-xenial.list
	#nginx 1.12.1
	hide_output add-apt-repository ppa:nginx/stable -y
	#nginx stable 1.12.2 and pfusion
	#apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 561F9B9CAC40B2F7
	#echo "deb https://oss-binaries.phusionpassenger.com/apt/passenger xenial main" > /etc/apt/sources.list.d/passenger.list
	#sudo sed -i 's/http:\/\/lt\./http:\/\//g' /etc/apt/sources.list.d/passenger.list
	#apt_get_quiet remove nginx nginx-common nginx-full nginx-core
	hide_output apt-get update
	apt_install nginx
	#mkdir -p /etc/nginx/sites-available
	#this orig nginx repo stable
	#mkdir -p /etc/nginx/sites-enabled
	sed -i -e"s/keepalive_timeout\s*65/keepalive_timeout 2/" /etc/nginx/nginx.conf
	sed -i -e"s/keepalive_timeout 2/keepalive_timeout 2;\n\tclient_max_body_size 18m/" /etc/nginx/nginx.conf
	#sed -i 's/client_max_body_size *[0-9]\+[kKmM]\?/client_max_body_size '"${POST_MAX_SIZE}"'/' /etc/nginx/conf.d/default.conf
	#wordpress
	#sed -i 's/upload_max_filesize *= *[0-9]\+[kKmMgG]\?/upload_max_filesize='"64m"'/' /etc/nginx/global/wordpress.conf
	#sed -i 's/post_max_size *= *[0-9]\+[kKmMgG]\?/post_max_size='"64m"'/' /etc/nginx/global/wordpress.conf
	#sed -i 's/fastcgi_pass .*;/fastcgi_pass '"$(escape_sed "wordpress")"':9000;/' /etc/nginx/global/wordpress.conf
	
	echo -e "Block Exploits, SQL Injections, File Injections, Spam, User Agents, Etc. Apache2 Modules...\n"
	# This mitigation has been assigned the identifier CVE-2016-5387
	# Please refer to:
	# https://httpoxy.org/#fix-now
	# https://www.nginx.com/blog/mitigating-the-httpoxy-vulnerability-with-nginx/
	echo -e "Removing the HTTP Proxy Header with Nginx...\n"
	sed -i '/SERVER_NAME/ a\\nfastcgi_param HTTP_PROXY \"\";' /etc/nginx/fastcgi_params
	sed -i '/types_hash_max_size/ a\ proxy_set_header Proxy \"\";' /etc/nginx/nginx.conf
	#Block Exploits, SQL Injections & attacks with Nginx
	#Include it in your vhost configuration with :
	#include /etc/nginx/common/protect.conf;
	mkdir -p /etc/nginx/common
	cat << "EOF" > /etc/nginx/common/protect.conf
    location ~* "(eval\()"  { deny all; }
    location ~* "(127\.0\.0\.1)"  { deny all; }
    location ~* "([a-z0-9]{2000})"  { deny all; }
    location ~* "(javascript\:)(.*)(\;)"  { deny all; }
    location ~* "(base64_encode)(.*)(\()"  { deny all; }
    location ~* "(GLOBALS|REQUEST)(=|\[|%)"  { deny all; }
    location ~* "(<|%3C).*script.*(>|%3)" { deny all; }
    location ~ "(\\|\.\.\.|\.\./|~|`|<|>|\|)" { deny all; }
    location ~* "(boot\.ini|etc/passwd|self/environ)" { deny all; }
    location ~* "(thumbs?(_editor|open)?|tim(thumb)?)\.php" { deny all; }
    location ~* "(\'|\")(.*)(drop|insert|md5|select|union)" { deny all; }
    location ~* "(https?|ftp|php):/" { deny all; }
    location ~* "(=\\\'|=\\%27|/\\\'/?)\." { deny all; }
    location ~* "/(\$(\&)?|\*|\"|\.|,|&|&?)/?$" { deny all; }
    location ~ "(\{0\}|\(/\(|\.\.\.|\+\+\+|\\\"\\\")" { deny all; }
    location ~ "(~|`|<|>|:|;|%|\\|\s|\{|\}|\[|\]|\|)" { deny all; }
    location ~* "/(=|\$&|_mm|(wp-)?config\.|cgi-|etc/passwd|muieblack)" { deny all; }
    location ~* "(&pws=0|_vti_|\(null\)|\{\$itemURL\}|echo(.*)kae|etc/passwd|eval\(|self/environ)" { deny all; }
    location ~* "\.(aspx?|bash|bak?|cfg|cgi|dll|exe|git|hg|ini|jsp|log|mdb|out|sql|svn|swp|tar|rdf)$" { deny all; }
    location ~* "/(^$|mobiquo|phpinfo|shell|sqlpatch|thumb|thumb_editor|thumbopen|timthumb|webshell)\.php" { deny all; }
EOF

    	echo -e "Nginx Bad Bot Blocker 223 (and growing) Nginx rules to block bad bots...\n"
    	# Block bad bots V1	
    	#git clone https://github.com/mariusv/nginx-badbot-blocker.git /etc/nginx
    	#sed -i "s|^\(\$config\['default_host'\] =\).*$|\1 \ array(\n##\n# Nginx Bad Bot Blocker\n##\ninclude nginx-badbot-blocker/blacklist.conf;\ninclude nginx-badbot-blocker/blockips.conf;\n\);|" /usr/share/roundcube/config/config.inc.php

    	# Block bad bots V2
    	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/conf.d/blacklist.conf -O /etc/nginx/conf.d/blacklist.conf
	#mkdir /etc/nginx/bots.d
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/blockbots.conf -O /etc/nginx/bots.d/blockbots.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/ddos.conf -O /etc/nginx/bots.d/ddos.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/whitelist-domains.conf -O /etc/nginx/bots.d/whitelist-domains.conf
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/bots.d/whitelist-ips.conf -O /etc/nginx/bots.d/whitelist-ips.conf

    	#mcedit /etc/nginx/nginx.conf
	#####Add the following settings and rate limiting zones near the top of your nginx.conf file. This is both for the Anti DDOS rate limiting filter and for allowing Nginx to load this very large set of domain names into memory.
    	#server_names_hash_bucket_size 64;
    	#server_names_hash_max_size 4096;
    	#limit_req_zone $binary_remote_addr zone=flood:50m rate=90r/s;
    	#limit_conn_zone $binary_remote_addr zone=addr:50m;

    	#Make sure that your nginx.conf file contains the following include directive. If it's commented out make sure to uncomment it.
    	#include /etc/nginx/conf.d/*

	#VHOST
	#These includes MUST be added within a server {} block of a vhost otherwise you will get EMERG errors from Nginx.
    	#include /etc/nginx/bots.d/blockbots.conf;
    	#include /etc/nginx/bots.d/ddos.conf;
	#sudo nginx -t
	#sudo service nginx reload

	#curl -A "googlebot" http://wolftronics.hu
	#Should respond with 200 OK
	#curl -A "80legs" http://wolftronics.hu
	#curl -A "masscan" http://wolftronics.hu
	#Should respond with: curl: (52) Empty reply from server
	#curl -I http://yourdomain.com -e http://100dollars-seo.com
	#curl -I http://wolftronics.hu -e http://zx6.ru
	#Should respond with: curl: (52) Empty reply from server
	#The Nginx BadBot Blocker is now working and protecting your web sites !!!

	#UPDATING THE NGINX BADBOT BLOCKER
	#wget https://github.com/mariusv/nginx-badbot-blocker/raw/master/VERSION_2/conf.d/blacklist.conf -O /etc/nginx/conf.d/blacklist.conf
	#sudo nginx -t
	#sudo service nginx reload

	#AUTO UPDATING:
	#https://raw.githubusercontent.com/mariusv/nginx-badbot-blocker/master/VERSION_2/updatenginxblocker.sh


	#nginx-ultimate-bad-bot-blocker
	#wget https://raw.githubusercontent.com/mitchellkrogza/nginx-ultimate-bad-bot-blocker/master/install-ngxblocker -O /usr/local/sbin/install-ngxblocker
	#chmod +x /usr/local/sbin/install-ngxblocker
	#sh /usr/local/sbin/install-ngxblocker
	#sh /usr/local/sbin/install-ngxblocker -x

	##chmod +x /usr/local/sbin/setup-ngxblocker
	##chmod +x /usr/local/sbin/update-ngxblocker
	##sh /usr/local/sbin/setup-ngxblocker
	
	#sh /usr/local/sbin/setup-ngxblocker -x -e conf
	hide_output service nginx start
	#sudo nginx -t
	echo -e "[${green}DONE${NC}]\n"

	#00 22 * * * sudo /usr/sbin/update-ngxblocker -e yourname@youremail.com
	#This will update the blocker every night for you at 10 PM.
	#If you want it to update more frequently (as sometimes I push out 3-4 updates a day) you can set it as follows to run the cron every 8 hours, although just once a day is more than enough.
	#00 */8 * * * sudo /usr/sbin/update-ngxblocker -e yourname@youremail.com
	#If you don't want any email notification after an update (not advisable in case Nginx ever has an EMERG when reloading), then simply run your cron as follows.
	#00 */8 * * * sudo /usr/sbin/update-ngxblocker -n
	echo "00 */8 * * * sudo /usr/sbin/update-ngxblocker -n" >> /etc/crontab

	# apt_install php7.2 php7.2-common php7.2-gd php7.2-mysql php7.2-imap php7.2-cli php7.2-cgi php-pear php-auth php7.2-mcrypt mcrypt imagemagick libruby php7.2-curl php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl memcached php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php7.2-fpm php7.2-opcache php-apcu
	#apt_install php7.2 php7.2-common php7.2-gd php7.2-mysql php7.2-imap php7.2-cli php7.2-cgi php-pear mcrypt imagemagick libruby php7.2-curl php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl memcached php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php-soap php7.2-soap

  	hide_output add-apt-repository -y ppa:ondrej/php
  	#apt_add_repository_to_unattended_upgrades LP-PPA-ondrej-php:trusty
  	hide_output apt-get update
	echo -n "Installing PHP-FPM... "
	apt_install php7.2-fpm
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing PHP and modules... "
	apt_install php7.2 php7.2-common php7.2-dev php7.2-gd php7.2-mysql php7.2-imap php7.2-cli php7.2-cgi php-pear mcrypt libruby php7.2-curl php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl memcached php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php-soap php7.2-soap php7.2-snmp php7.2-xml > /dev/null 2>&1

	#apt_install php7.2-intl php7.2-pspell php7.2-recode php7.2-sqlite3 php7.2-tidy php7.2-xmlrpc php7.2-xsl memcached php-memcache php-imagick php-gettext php7.2-zip php7.2-mbstring php-soap php7.2-soap memcached imagemagick libruby php-pear mcrypt php7.2-pdo-odbc php7.2-imagick php7.2-redis php7.2-bz2 php7.2-mongodb php7.2-common php7.2-cgi php7.2-cli php7.2-dba php7.2-smbclient php7.2-dom php7.2-bcmath php7.2-oauth php7.2-memcached php7.2-pinba php7.2-fpm php7.2-ftp php7.2-igbinary php7.2-gmp php7.2-mysql php7.2-memcache php7.2-uuid php7.2-sockets  php7.2-mailparse php7.2 php7.2-sysvmsg php7.2-wddx  php7.2-pdo-pgsql php7.2-calendar php7.2-fileinfo php7.2-pdo php7.2-xmlwriter php7.2-json php7.2-opcache php7.2-mysqli php7.2-sass php7.2-sysvsem php7.2-sysvshm php7.2-phar php7.2-rrd php7.2-sybase php7.2-curl php7.2-stomp php7.2-msgpack php7.2-ldap php7.2-gearman php7.2-raphf php7.2-phpdbg php7.2-xmlreader php7.2-imap php7.2-gnupg php7.2-radius php7.2-uploadprogress php7.2-posix php7.2-iconv php7.2-xml   php7.2-zip php7.2-tokenizer php7.2-zmq php7.2-odbc php7.2-mbstring php7.2-readline php7.2-ds php7.2-gd php7.2-ps php7.2-interbase php7.2-yaml php7.2-snmp php7.2-pdo-mysql php7.2-mysqlnd  php7.2-soap php7.2-solr php7.2-simplexml php7.2-ssh2 php7.2-pdo-sqlite php7.2-pdo-dblib  php7.2-amqp php7.2-gmagick php7.2-pgsql php7.2-enchant  php7.2-tideways php7.2-shmop php7.2-libsodium php7.2-propro php7.2-gettext php7.2-pdo-firebird php7.2-exif php7.2-ctype php7.2-http php7.2-geoip php7.2-xdebug php7.2-common php7.2-mysql php7.2-odbc php7.2-pgsql  php7.2-xml php-amqp php-ds php-gearman php-geoip php-gmagick php-gnupg php-http php-igbinary php-imagick php-libsodium php-mailparse php-memcache php-memcached php-mongodb php-msgpack php-oauth php-pinba php-propro php-ps php-radius php-raphf php-redis php-rrd php-sass php-smbclient php-solr php-ssh2 php-stomp php-tideways php-uploadprogress php-uuid php-xdebug php-yac php-yaml php-zmq php7.2-interbase php7.2-sybase  > /dev/null 2>&1

	echo -e "[${green}DONE${NC}]\n"
	echo -n "Installing Opcache and APCu... "
	apt_install php7.2-opcache php-apcu

	sed -i "s/;cgi.fix_pathinfo=1/cgi.fix_pathinfo=0/" /etc/php/7.2/fpm/php.ini
	TIME_ZONE=$(echo "$TIME_ZONE" | sed -n 's/ (.*)$//p')
	sed -i "s/;date.timezone =/date.timezone=\"${TIME_ZONE//\//\\/}\"/" /etc/php/7.2/fpm/php.ini
	#sed -i "s/;date.timezone =/date.timezone=\"Europe\/Budapest\"/" /etc/php/7.2/fpm/php.ini
	sed -i "s/post_max_size =.*/post_max_size = 18M/g" /etc/php/7.2/fpm/php.ini
	sed -i "s/upload_max_filesize =.*/upload_max_filesize = 12M/g" /etc/php/7.2/fpm/php.ini
	sed -i "s/;mbstring.func_overload = 0/mbstring.func_overload = 0/" /etc/php/7.2/fpm/php.ini
	sed -i -e "s/;daemonize\s*=\s*yes/daemonize = no/g" /etc/php/7.2/fpm/php-fpm.conf
	sed -i -e "s/;catch_workers_output\s*=\s*yes/catch_workers_output = yes/g" /etc/php/7.2/fpm/pool.d/www.conf
	find /etc/php/7.2/cli/conf.d/ -name "*.ini" -exec sed -i -re 's/^(\s*)#(.*)/\1;\2/g' {} \;
	#PHP OPcache
	echo -e "Enabled and Configuration PHP OPcache...\n"
	sed -i "s/;opcache.enable=0/opcache.enable=1/" /etc/php/7.2/fpm/php.ini
	sed -i "s/;opcache.memory_consumption=64/opcache.memory_consumption=128/" /etc/php/7.2/fpm/php.ini
	sed -i "s/;opcache.max_accelerated_files=2000/opcache.max_accelerated_files=4000/" /etc/php/7.2/fpm/php.ini
	sed -i "s/;opcache.revalidate_freq=2/opcache.revalidate_freq=240/" /etc/php/7.2/fpm/php.ini
	#phpenmod opcache
	# Set worker_processes = num cpu cores
	#procs=$(cat /proc/cpuinfo |grep processor | wc -l)
	#if [[ "$procs" > "${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES}" ]]; then
	    # number of available processor cores exceeds the maximum permitted, limit to maximum
	#    echo " * nginx:  Using max ${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES} of $procs available cores"
	#    procs=${NGINX_MAX_WORKER_PROCESSES:-$DEFAULT_NGINX_MAX_WORKER_PROCESSES}
	#fi
	#echo " * nginx:  worker_processes = $procs"
	#sed -i -r "s/worker_processes\s+[0-9]+/worker_processes $procs/" /etc/nginx/nginx.conf
	#sed -i -e '/worker_processes/c\worker_processes  5;' /etc/nginx/nginx.conf
	echo -e "[${green}DONE${NC}]\n"
	echo -n "Reloading PHP-FPM... "
	#service php7-fpm reload
	hide_output service php7.2-fpm reload
	restart_service nginx

	#echo -n "Installing 5.5.38 and 5.6.31 PHP and Modules... "
	#InstallPhp55
	#InstallPhp56
	#InstallPhp70
	#InstallPhp71
	#InstallPhp73
	echo -e "[${green}DONE${NC}]\n"

	echo -n "Installing fcgiwrap... "
	apt_install fcgiwrap
	echo -e "[${green}DONE${NC}]\n"
	echo "phpmyadmin phpmyadmin/reconfigure-webserver multiselect none" | debconf-set-selections
        # - DISABLED DUE TO A BUG IN DBCONFIG - echo "phpmyadmin phpmyadmin/dbconfig-install boolean false" | debconf-set-selections
    	#echo "dbconfig-common dbconfig-common/dbconfig-install boolean false" | debconf-set-selections
	if [ "$CFG_PHPMYADMIN" == "yes" ]; then
		#echo "==========================================================================================="
		#echo "Attention: When asked 'Configure database for phpmyadmin with dbconfig-common?' select 'NO'"
		#echo "Due to a bug in dbconfig-common, this can't be automated."
		#echo "==========================================================================================="
		#echo "Press ENTER to continue... "
		#read DUMMY
		echo -n "Installing phpMyAdmin... "
		#hide_output add-apt-repository ppa:nijel/phpmyadmin -y
		#hide_output apt-get update
		#debconf-set-selections <<< "phpmyadmin phpmyadmin/dbconfig-common boolean false"
		apt_install phpmyadmin
		#pma db error?
		apt-mark hold phpmyadmin
		rm -rf /usr/share/phpmyadmin/*
		wget_verify \
		    https://files.phpmyadmin.net/phpMyAdmin/$PHPMYADMINVERSION/phpMyAdmin-$PHPMYADMINVERSION-all-languages.tar.gz \
		    $PHPMYADMINHASH \
		    /tmp/phpmyadmin.tgz
		tar -C /tmp --no-same-owner -zxf /tmp/phpmyadmin.tgz
		mv /tmp/phpMyAdmin-$PHPMYADMINVERSION-all-languages/* /usr/share/phpmyadmin/
		cp /etc/phpmyadmin/config.inc.php /usr/share/phpmyadmin
		rm -f /tmp/phpmyadmin.tgz
		echo "With nginx phpMyAdmin is accessibile at  http://$CFG_HOSTNAME_FQDN:8081/phpmyadmin or http://${IP_ADDRESS[0]}:8081/phpmyadmin"
		echo -e "[${green}DONE${NC}]\n"
	fi
	
  fi

	if [ "$CFG_XCACHE" == "yes" ]; then  
		echo -n "Installing XCache not work ubuntu 16.04 and php 7... "
		#apt_install php7-xcache
		echo -e "[${green}DONE${NC}]\n"
	fi

	echo -n "Installing needed programs for PHP and nginx (mcrypt, etc.)... "
	  #apt_install mcrypt imagemagick memcached curl tidy snmp redis-server
	  apt_install imagemagick memcached curl tidy snmp redis-server
	  #apt_install gcc make autoconf libc-dev pkg-config
	  #apt_install libmcrypt-dev
	  #pecl install mcrypt-1.0.1
	  #echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/7.2/cli/conf.d/mcrypt.ini
	  #echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/7.2/mods-available/mcrypt.ini
	  ######echo extension=/usr/lib/php/20170718/mcrypt.so > /etc/php/7.2/apache2/conf.d/mcrypt.ini
	  echo -e "[${green}DONE${NC}]\n"
	
	#phpenmod mcrypt
	phpenmod mbstring

	echo -n "Installing Lets Encrypt... "
	hide_output add-apt-repository ppa:certbot/certbot -y
	hide_output apt-get update
	if [ "$CFG_WEBSERVER" == "apache" ]; then
		#apt_install certbot python3-certbot-apache
		apt_install certbot
		#certbot register
	else
		#apt_install certbot python3-certbot-nginx
		apt_install certbot
		#certbot register
	fi

#Advanced installation
#git clone https://github.com/Neilpang/acme.sh.git
#cd acme.sh
#./acme.sh --install  \
#--home ~/myacme \
#--config-home ~/myacme/data \
#--certhome  ~/mycerts \
#--accountemail  "hi@acme.sh" \
#--accountkey  ~/myaccount.key \
#--accountconf ~/myaccount.conf \
#--useragent  "this is my client."

wget -O -  https://raw.githubusercontent.com/Neilpang/acme.sh/master/acme.sh | INSTALLONLINE=1  sh

#cron-d
#0 0 * * * "/home/user/.acme.sh"/acme.sh --cron --home "/home/user/.acme.sh" > /dev/null
#echo "0 0 * * * "/home/administrator/.acme.sh"/acme.sh --cron --home "/home/administrator/.acme.sh" > /dev/null" >> /etc/crontab

  echo -e "[${green}DONE${NC}]\n"
}
