#---------------------------------------------------------------------
# Function: InstallQuota
#    Install and configure disk quota
#---------------------------------------------------------------------
InstallQuota() {
  local START_TIME=$SECONDS

  echo -e "$IDENTATION_LVL_0 ${BWhite}Installing Disk Quota${NC}"

  # Install necessary packages
  if ! apt_install quota quotatool >>$PROGRAMS_INSTALL_LOG_FILES 2>&1; then
    echo -e "$IDENTATION_LVL_1 ${red}Failed to install Quota packages. Check the log file for details.${NC}"
    return 1
  fi

  hide_output quotaoff -a
  echo -n -e "$IDENTATION_LVL_1 Initializing disk quotas (this may take a while)... "

  # Check if Quota is supported
  if ! grep -q 'quota' /proc/filesystems; then
    echo -e "[${red}NOT SUPPORTED${NC}]"
    echo -e "$IDENTATION_LVL_1 ${red}Quota is not supported on this system.${NC}"
    return 1
  fi

  # Configure Quota in /etc/fstab if not already configured
  if [ "$(grep -c ',usrjquota=quota.user,grpjquota=quota.group,jqfmt=vfsv0' /etc/fstab)" -eq 0 ]; then
    sed -i '/\/[[:space:]]\+/ {/tmpfs/!s/\(defaults\|errors=remount-ro\)/\1,usrjquota=quota.user,grpjquota=quota.group,jqfmt=vfsv0/}' /etc/fstab
  fi

  # Remount filesystem and initialize Quota
  mount -o remount /
  if quotacheck -avugm >>$PROGRAMS_INSTALL_LOG_FILES 2>&1; then
    quotaon -avug >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
    echo -e "[${green}DONE${NC}]"
  else
    echo -e "[${red}FAILED${NC}]"
    echo -e "$IDENTATION_LVL_1 ${red}Failed to initialize disk quotas. Check the log file for details.${NC}"
    return 1
  fi

  MeasureTimeDuration $START_TIME
}
