#-----------------------------------------------------------------------------
# Function:  Mirror server Unison sync severs
#    mirror sync unison setup
#-----------------------------------------------------------------------------

InstallUnison() {
echo "Installing Unison is used to sync the /var/www directory between server1 and server2... "

if [ "$CFG_MIRRORSERVER" == "yes" ] && [ "$CFG_SETUP_MASTER" == "y" ]; then
	apt_install unison

	mkdir -p /root/.unison
	cat > /root/.unison/web.prf <<EOF
# Roots of the synchronization
root = /var/www
root = ssh://192.168.0.106//var/www
 
# Paths to synchronize
#path = www
#path = vmail
 
# Some regexps specifying names and paths to ignore
#ignore = Path stats    ## ignores /var/www/stats
#ignore = Path stats/*  ## ignores /var/www/stats/*
#ignore = Path */stats  ## ignores /var/www/somedir/stats, but not /var/www/a/b/c/stats
#ignore = Name *stats   ## ignores all files/directories that end with \"stats\"
#ignore = Name stats*   ## ignores all files/directories that begin with \"stats\"
#ignore = Name *.tmp    ## ignores all files with the extension .tmp
ignore = Name sess_*
ignore = Name *access.log*
ignore = Name error.log
ignore = Name webalizer.conf
   
#          When set to true, this flag causes the user interface to skip
#          asking for confirmations on non-conflicting changes. (More
#          precisely, when the user interface is done setting the
#          propagation direction for one entry and is about to move to the
#          next, it will skip over all non-conflicting entries and go
#          directly to the next conflict.)
auto=true
   
#          When this is set to true, the user interface will ask no
#          questions at all. Non-conflicting changes will be propagated;
#          conflicts will be skipped.
batch=true
   
#          !When this is set to true, Unison will request an extra
#          confirmation if it appears that the entire replica has been
#          deleted, before propagating the change. If the batch flag is
#          also set, synchronization will[<32;19;9M be aborted. When the path
#          preference is used, the same confirmation will be requested for
#          top-level paths. (At the moment, this flag only affects the
#          text user interface.) See also the mountpoint preference.
confirmbigdel=true
   
#          When this preference is set to true, Unison will use the
#          modification time and length of a file as a \`pseudo inode
#          number\' when scanning replicas for updates, instead of reading
#          the full contents of every file. Under Windows, this may cause
#          Unison to miss propagating an update if the modification time
#          and length of the file are both unchanged by the update.
#          However, Unison will never overwrite such an update with a
#          change from the other replica, since it always does a safe
#          check for updates just before propagating a change. Thus, it is
#          reasonable to use this switch under Windows most of the time
#          and occasionally run Unison once with fastcheck set to false,
#          if you are worried that Unison may have overlooked an update.
#          The default value of the preference is auto, which causes
#          Unison to use fast checking on Unix replicas (where it is safe)
#          and slow checking on Windows replicas. For backward
#          compatibility, yes, no, and default can be used in place of
#          true, false, and auto. See the section \"Fast Checking\" for more
#          information.
fastcheck=true

#          When this flag is set to true, the group attributes of the
#          files are synchronized. Whether the group names or the group
#          identifiers are synchronizeddepends on the preference numerids.
group=true

#          When this flag is set to true, the owner attributes of the
#          files are synchronized. Whether the owner names or the owner
#          identifiers are synchronizeddepends on the preference
#          extttnumerids.
owner=true

#          Including the preference -prefer root causes Unison always to
#          resolve conflicts in favor of root, rather than asking for
#          guidance from the user. (The syntax of root is the same as for
#          the root preference, plus the special values newer and older.)
#          This preference is overridden by the preferpartial preference.
#          This preference should be used only if you are sure you know
#          what you are doing!
prefer=newer

#          When this preference is set to true, the textual user interface
#          will print nothing at all, except in the case of errors.
#          Setting silent to true automatically sets the batch preference
#          to true.
silent=true

#          When this flag is set to true, file modification times (but not
#          directory modtimes) are propagated.
times=false

#          When this flag is set, Unison will log all changes to the filesystems on a file.
log=false

#          When this flag is set to true, groups and users are synchronized numerically, rather than by name.
#          The special uid 0 and the special group 0 are never mapped via user/group names even if this
#          preference is not set.
numericids=true

    EOF

	mkdir -p /root/scripts
	cat > /root/scripts/unison.sh <<EOF
#!/bin/sh
lockdir=/tmp
UNISON=/usr/bin/unison
LOGGER=/usr/bin/logger

if [ ! -f /\$lockdir/unison ]; then
        touch \$lockdir/unison

        \$UNISON -testserver web
        rc=\$?
        if [[ \$rc != 0 ]] ; then
                echo "error"
                \$LOGGER -d -t unison "web - error connecting remote"
        else
                \$UNISON web
        fi

        rm \$lockdir/unison
else
        \$LOGGER -d -t unison "unison already running"
fi

    EOF

	chmod 700 /root/scripts/unison.sh
	#/root/scripts/unison.sh
	#crontab -e
	# unison
	#*  * * * *  /root/scripts/unison.sh > /dev/null
	echo "*  * * * *  /root/scripts/unison.sh > /dev/null" >> /etc/crontab

fi

if [ "$CFG_MIRRORSERVER" == "yes" ] && [ "$CFG_SETUP_MASTER" == "n" ]; then
    	#Next we install Unison. Unison is used to sync the /var/www directory between server1 and server2.
    	apt_install unison
fi
echo -e "[${green}DONE${NC}]\n"

}

InstallGlusterfs() {
#https://www.howtoforge.com/tutorial/high-availability-storage-with-glusterfs-on-debian-8-with-two-nodes/
echo "Installing GlusterFS is used to sync the /var/www directory between server1 and server2... "

if [ "$CFG_MIRRORSERVER" == "yes" ] && [ "$CFG_SETUP_MASTER" == "y" ]; then
    apt_install software-properties-common
    add-apt-repository -y ppa:gluster/glusterfs-3.12
    hide_output apt-get update
    apt_install glusterfs-server
    mkdir /data
    #stage 2 installed other server?
    gluster peer probe server2.wolftronics.hu
    gluster volume create testvol replica 2 transport tcp server1.example.com:/data/testvol server2.wolftronics.hu:/data/testvol force
    gluster volume start testvol
    netstat -tap | grep glusterfsd
    gluster volume info
    #By default, all clients can connect to the volume. If you want to grant access to client1.wolftronics.hu (= 192.168.0.107) only, run:
    gluster volume set testvol auth.allow 192.168.0.107
    gluster volume info

    #client server example not in server1....
    #apt_install software-properties-common
    #add-apt-repository -y ppa:gluster/glusterfs-3.12
    #hide_output apt-get update
    #apt_install glusterfs-client
    #mkdir /mnt/glusterfs
    #mount.glusterfs server1.wolftronics.hu:/testvol /mnt/glusterfs
    #mount
    #df -h
    #mcedit /etc/fstab add next line
    #server1.example.com:/testvol /mnt/glusterfs glusterfs defaults,_netdev 0 0
    #reboot
fi

if [ "$CFG_MIRRORSERVER" == "yes" ] && [ "$CFG_SETUP_MASTER" == "n" ]; then
    apt_install software-properties-common
    add-apt-repository -y ppa:gluster/glusterfs-3.12
    hide_output apt-get update
    apt_install glusterfs-server
    mkdir /data
    netstat -tap | grep glusterfsd
    restart_service glusterfs-server

fi

echo -e "[${green}DONE${NC}]\n"
}

InstallRsync() {
#https://www.howtoforge.com/mirroring_with_rsync
echo "Installing Rsync is used to sync the /var/www directory between server1 and server2... "
rsyncuser="someuser"
rsyncpassword="someuser"

if [ "$CFG_MIRRORSERVER" == "yes" ] && [ "$CFG_SETUP_MASTER" == "y" ]; then
    apt_install rsync
    #Create An Unprivileged User On server1
    useradd -d /home/$rsyncuser -m -s /bin/bash $rsyncuser
    #passwd someuser
    echo $rsyncpassword | passwd --stdin $rsyncuser
    ls -la /var/www 

    mkdir ~/.ssh
    chmod 700 ~/.ssh
    mv ~/mirror-rsync-key.pub ~/.ssh/
    cd ~/.ssh
    touch authorized_keys
    chmod 600 authorized_keys
    cat mirror-rsync-key.pub >> authorized_keys

    #vi /home/$rsyncuser/.ssh/authorized_keys
    #command="/home/$rsyncuser/rsync/checkrsync",from="mirror.wolftronics.hu",no-port-forwarding,no-X11-forwarding,no-pty ssh-dss          AAAAB3NzaC1kc3MAAA[...]lSUom root@
#mirror

    mkdir ~/rsync
    cat > ~/rsync/checkrsync <<EOF
#!/bin/sh

case "\$SSH_ORIGINAL_COMMAND" in
        *\&*)
                echo "Rejected"
                ;;
        *\(*)
                echo "Rejected"
                ;;
        *\{*)
                echo "Rejected"
                ;;
        *\;*)
                echo "Rejected"
                ;;
        *\<*)
                echo "Rejected"
                ;;
        *\`*)
                echo "Rejected"
                ;;
        rsync\ --server*)
                \$SSH_ORIGINAL_COMMAND
                ;;
        *)
                echo "Rejected"
                ;;
esac
EOF

    chmod 700 ~/rsync/checkrsync

fi

if [ "$CFG_MIRRORSERVER" == "yes" ] && [ "$CFG_SETUP_MASTER" == "n" ]; then
    apt_install rsync
    rsync -avz -e ssh $rsyncuser@server1.wolftronics.hu:/var/www/ /var/www/ 
    ls -la /var/www
    mkdir /root/rsync
    #ssh-keygen -t dsa -b 1024 -f /root/rsync/mirror-rsync-key
    ssh-keygen -t dsa -b 1024 -f /root/rsync/mirror-rsync-key -q -P ""
    scp /root/rsync/mirror-rsync-key.pub $rsyncuser@server1.wolftronics.hu:/home/$rsyncuser/

    echo "*/5 * * * * /usr/bin/rsync -azq --delete --exclude=**/stats --exclude=**/error --exclude=**/files/pictures -e "ssh -i /root/rsync/mirror-rsync-key" $rsyncuser@server1.wolftronics.hu:/var/www/ /var/www/" >> /etc/crontab
    which rsync  
fi

echo -e "[${green}DONE${NC}]\n"
}


