#---------------------------------------------------------------------
# Function: InstallBasics
#    Install basic packages
#---------------------------------------------------------------------
InstallBasics() {
  echo -n "Updating apt package database and upgrading currently installed packages... "
  #hide_output add-apt-repository -y ppa:ondrej/php
  #apt_add_repository_to_unattended_upgrades LP-PPA-ondrej-php:trusty
  hide_output apt-get update
  apt_get_quiet upgrade
  #hide_output apt-get -y dist-upgrade
  hide_output apt-get -y autoremove
  echo -e "[${green}DONE${NC}]\n"

  echo -n "Installing basic packages (OpenSSH server, NTP, binutils, etc.)... "
  # apt_install ssh openssh-server vim-nox php7.2-cli ntp ntpdate debconf-utils binutils sudo git lsb-release
  # apt_install ssh openssh-server vim-nox php7.2-cli ntp debconf-utils binutils sudo git lsb-release
  apt_install ssh openssh-server vim-nox php7.2-cli ntp ntpdate debconf-utils binutils python3 python3-dev \
      python3-pip netcat-openbsd sudo zip unzip git lsb-release update-inetd composer wget curl \
      coreutils bc pollinate unattended-upgrades
  echo -e "[${green}DONE${NC}]\n"
  echo -n "Stopping AppArmor... "
  service apparmor stop 
  echo -e "[${green}DONE${NC}]\n"
  echo -n "Disabling AppArmor... "
  hide_output update-rc.d -f apparmor remove 
  echo -e "[${green}DONE${NC}]\n"
  echo -n "Removing AppArmor... "
  apt_remove apparmor apparmor-utils
  echo -e "[${green}DONE${NC}]\n"

  if [ /bin/sh -ef /bin/dash ]; then
    echo -n "Changing the default shell from dash to bash... "
    echo "dash dash/sh boolean false" | debconf-set-selections
    dpkg-reconfigure -f noninteractive dash > /dev/null 2>&1
    echo -e "[${green}DONE${NC}]\n"
  fi
  # ### Suppress Upgrade Prompts
  # Since Mail-in-a-Box might jump straight to 18.04 LTS, there's no need
  # to be reminded about 16.04 on every login.
#  if [ -f /etc/update-manager/release-upgrades ]; then
#      tools/editconf.py /etc/update-manager/release-upgrades Prompt=never
#      rm -f /var/lib/ubuntu-release-upgrader/release-upgrade-available
#  fi
}

InstallLastKernel() {
  echo -n "Updating linux kernel packages... "
  mkdir -p ~/4.11.2
  cd ~/4.11.2
  wget http://kernel.ubuntu.com/~kernel-ppa/mainline/v4.11.2/linux-headers-4.11.2-041102_4.11.2-041102.201705201036_all.deb
  wget http://kernel.ubuntu.com/~kernel-ppa/mainline/v4.11.2/linux-headers-4.11.2-041102-generic_4.11.2-041102.201705201036_amd64.deb
  wget http://kernel.ubuntu.com/~kernel-ppa/mainline/v4.11.2/linux-image-4.11.2-041102-generic_4.11.2-041102.201705201036_amd64.deb
  dpkg -i *.deb
  update-grub
  echo -n "Reconfigure grub... "
  echo -e "[${green}DONE${NC}]\n"
}