#---------------------------------------------------------------------
# Function: Install Weblate
#    Install and configure of Weblate
#---------------------------------------------------------------------
#https://github.com/TraduSquare/weblate-customization


InstallWeblate() {
  START_TIME=$SECONDS

  # Home directory
  #ENV HOME=/home/weblate
  HOME_DIR=/home/weblate
  # Use Docker specific settings
  #ENV DJANGO_SETTINGS_MODULE=weblate.settings_docker
  #DJANGO_SETTINGS_MODULE=weblate.settings_docker

  git_clone https://github.com/WeblateOrg/docker $PROGRAMS_INSTALL_DOWNLOAD/weblate_docker/
  mkdir -p /usr/src/weblate/ >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  cp $PROGRAMS_INSTALL_DOWNLOAD/weblate_docker/requirements.txt /usr/src/weblate/requirements.txt >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  cp -rp $PROGRAMS_INSTALL_DOWNLOAD/weblate_docker/patches/* /usr/src/weblate/ >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  wget -q -O $PROGRAMS_INSTALL_DOWNLOAD/requirements.txt https://github.com/WeblateOrg/docker/blob/master/requirements.txt >>$PROGRAMS_INSTALL_LOG_FILES 2>&1

  echo -n -e "$IDENTATION_LVL_0 ${BWhite}Installing Weblate${NC}\n"

  echo -n -e "$IDENTATION_LVL_1 Create user and fix python data-test..."	
  useradd --shell /bin/sh --user-group weblate --groups root,tty \
  && mkdir -p /home/weblate/.ssh \
  && touch /home/weblate/.ssh/authorized_keys \
  && chown -R weblate:weblate /home/weblate \
  && chmod 700 /home/weblate/.ssh \
  && install -d -o weblate -g weblate -m 755 /usr/local/lib/python3.7/dist-packages/data-test /usr/local/lib/python3.7/dist-packages/test-images \
  && install -d -o weblate -g weblate -m 755 /app/data >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  echo -e "[${green}DONE${NC}]\n"

  echo -n -e "$IDENTATION_LVL_1 Installing packages..."
  package_install libxml2-dev libxslt1-dev libfreetype6-dev libjpeg-dev zlib1g-dev libyaml-dev libcairo2-dev gir1.2-pango-1.0 libgirepository1.0-dev libacl1-dev libssl-dev build-essential python3-gdbm python3-dev python3-pip python3-virtualenv virtualenv git >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

# pycairo setup is a bit flaky, workarounds:
# https://github.com/pygobject/pycairo/issues/60: sudo apt install pkg-config
# https://github.com/pygobject/pycairo/issues/39: sudo apt install python-dev libcairo2-dev libjpeg-dev libgif-dev

  #package_install pkg-config python-dev libcairo2-dev libjpeg-dev libgif-dev >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  package_install pkg-config libgif-dev >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  package_install sudo uwsgi uwsgi-plugin-python3 nginx openssh-client ca-certificates curl \
    gir1.2-pango-1.0 \
    libxmlsec1-openssl \
    libjpeg62-turbo \
    python3-gi \
    python3-gi-cairo \
    python3-cairo \
    python3-pip \
    python3-setuptools \
    python3-wheel \
    python3-gdbm \
    gettext \
    git \
    git-svn \
    gnupg \
    subversion \
    pkg-config \
    python3-dev \
    file \
    make \
    libxml2-dev \
    libacl1-dev \
    libmariadb-dev \
    libxmlsec1-dev \
    libleptonica-dev \
    libtesseract-dev \
    libsasl2-dev \
    libldap2-dev \
    libssl-dev \
    libffi-dev \
    libpq-dev \
    libz-dev \
    libjpeg62-turbo-dev \
    libenchant1c2a \
    gcc \
    g++ \
    tesseract-ocr \
    patch \
  && sh -c 'echo "deb http://apt.postgresql.org/pub/repos/apt $(lsb_release -cs)-pgdg main" > /etc/apt/sources.list.d/pgdg.list' \
  # Import the repository signing key:
  && wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | sudo apt-key add - \
  && hide_output apt-get update \
  && if apt-cache show postgresql-client-13 > /dev/null 2>&1 ; then \
        apt-get install --no-install-recommends -y postgresql-client-13 ; \
    else \
        apt-get install --no-install-recommends -y postgresql-client ; \
    fi \
  && python3 -m pip install --no-cache-dir --upgrade pip wheel \
  && python3 -m pip install --no-cache-dir --upgrade pip wheel \
  && git_clone https://github.com/translate/translate >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
  && git_clone https://github.com/WeblateOrg/weblate >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
  && sed -Ei '/^(translate-toolkit|aeidon)/D' /usr/src/weblate/requirements.txt; \
  && python3 -m pip install --upgrade pip >>$PROGRAMS_INSTALL_LOG_FILES 2>&1 \
  && rm -rf /usr/lib/python3/dist-packages/yaml >>$PROGRAMS_INSTALL_LOG_FILES 2>&1 \
  && rm -rf /usr/lib/python3/dist-packages/PyYAML-* >>$PROGRAMS_INSTALL_LOG_FILES 2>&1 \
  && python3 -m pip install \ 
        --no-cache-dir \ 
        --use-feature=2020-resolver \
        -r /usr/src/weblate/requirements.txt \
        "https://github.com/translate/translate/archive/master.zip" \
        "https://github.com/WeblateOrg/language-data/archive/master.zip" \
        "https://github.com/WeblateOrg/translation-finder/archive/master.zip" \
        "https://github.com/WeblateOrg/weblate/archive/master.zip#egg=Weblate[all,MySQL]"\
  && python3 -c 'from phply.phpparse import make_parser; make_parser()' \
  && ln -s /usr/local/share/weblate/examples/ /app/ \
  && apt-get -y autoremove \
  && apt-get clean \
  && rm -rf /root/.cache /tmp/* /var/lib/apt/lists/* >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  find /usr/src/weblate -name '*.patch' -print0 | sort -z | \
  xargs -n1 -0 -r patch -p0 -d /usr/local/lib/python3.7/dist-packages/ -i >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  cp -rp $PROGRAMS_INSTALL_DOWNLOAD/weblate_docker/etc/* /etc/ >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

# Fix permissions and adjust files to be able to edit them as user on start
# - localtime/timezone is needed for setting system timezone based on environment
# - we generate nginx configuration based on environment
# - autorize passwd edition so we can fix weblate uid on startup
# - log, run and home directories
# - disable su for non root to avoid privilege escapation by chaging /etc/passwd
  #rm -f /etc/localtime && cp /usr/share/zoneinfo/Etc/UTC /etc/localtime \
  #&& chgrp -R 0 /etc/nginx/sites-available/ /var/log/nginx/ /var/lib/nginx /app/data /run /home/weblate /etc/timezone /etc/localtime \
  chgrp -R 0 /etc/nginx/sites-available/ /var/log/nginx/ /var/lib/nginx /app/data /run /home/weblate /etc/timezone /etc/localtime \
  && chmod -R 770 /etc/nginx/sites-available/ /var/log/nginx/ /var/lib/nginx /app/data /run /home /home/weblate /etc/timezone /etc/localtime \
  && chmod 664 /etc/passwd /etc/group \
  && sed -i '/pam_rootok.so/a auth requisite pam_deny.so' /etc/pam.d/su >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

# Search path for custom modules
  mkdir -p /app/data/python >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  echo "/app/data/python" > /usr/local/lib/python3.7/dist-packages/weblate-docker.pth >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  mkdir -p /app/bin >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  cp $PROGRAMS_INSTALL_DOWNLOAD/weblate_docker/start /app/bin/start >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  cp $PROGRAMS_INSTALL_DOWNLOAD/weblate_docker/health_check /app/bin/health_check >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  chmod a+rx /app/bin/start >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  #sh /app/bin/start >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  git_clone https://github.com/WeblateOrg/wlc $PROGRAMS_INSTALL_DOWNLOAD/weblate_wlc/
  pip3 install -r $PROGRAMS_INSTALL_DOWNLOAD/weblate_wlc/requirements-lint.txt
  pip3 install -r $PROGRAMS_INSTALL_DOWNLOAD/weblate_wlc/requirements.txt
  cd $PROGRAMS_INSTALL_DOWNLOAD/weblate_wlc
  python3 setup.py sdist
  #pip3 install $PROGRAMS_INSTALL_DOWNLOAD/weblate_wlc/dist/wlc-1.10.tar.gz 
  pip3 install $PROGRAMS_INSTALL_DOWNLOAD/weblate_wlc/dist/wlc-*.tar.gz

  echo -e "[${green}DONE${NC}]\n"

  echo -n -e "$IDENTATION_LVL_1 Installing redis server..."
  package_install redis-server >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  # They do not enable continuous liveness pings back to your supervisor.
  sed -i "s/supervised no/supervised systemd/" /etc/redis/redis.conf
  #sed -i "s/bind 127.0.0.1 ::1/bind 127.0.0.1/" /etc/redis/redis.conf

  #service redis restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  #sudo systemctl status redis
  #sudo netstat -lnp | grep redis

  #openssl rand 60 | openssl base64 -A
  #Output
  #RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE

  sed -i "s/# requirepass foobared/# requirepass foobared\nrequirepass RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE/" /etc/redis/redis.conf

  # fix redis start pid file service error ubuntu 18.04 and debian 10
  #sed -i "s/Type=forking/Type=forking\nExecStartPost\=\/bin\/sh\/ -c \"echo \$MAINPID \> \/var\/run\/redis\/redis.pid\"/" /etc/systemd/system/redis.service
  sed -i "s/Type=forking/Type=forking\nExecStartPost\=\/bin\/sh -c \"echo \$MAINPID \> \/var\/run\/redis\/redis.pid\"/" /usr/lib/systemd/system/redis-server.service

  systemctl daemon-reload >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  service redis restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  redis-cli set key1 10 >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  #That won't work because you didn’t authenticate, so Redis returns an error:
  #Output
  #(error) NOAUTH Authentication required.
  #The next command authenticates with the password specified in the Redis configuration file:

  #auth your_redis_password
  redis-cli auth RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  redis-cli -a RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE set key1 10 >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
  redis-cli -a RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE get key1 >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  #Renaming Dangerous Commands
  #o disable a command, simply rename it to an empty string (signified by a pair of quotation marks with no characters between them), as shown below:
  # It is also possible to completely kill a command by renaming it into
  # an empty string:
  sed -i "s/replicas may cause problems./replicas may cause problems.\nrename-command FLUSHDB \"\"\nrename-command FLUSHALL \"\"\nrename-command DEBUG \"\"/" /etc/redis/redis.conf
  #To rename a command, give it another name as shown in the examples below. Renamed commands should be difficult for others to guess, but easy for you to remember:
  sed -i "s/rename-command DEBUG \"\"/rename-command DEBUG \"\"\nrename-command SHUTDOWN SHUTDOWN_MENOT\nrename-command CONFIG ASC12_CONFIG/" /etc/redis/redis.conf

  service redis restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  package_install postgresql postgresql-contrib >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  # If PostgreSQL was not installed before, set the master password
  #sudo -u postgres psql postgres -c "\password postgres"
  #pass: xDGhzH2reZ9DFeay5st4XJ
  sudo -u postgres psql -c "ALTER USER postgres WITH PASSWORD 'xDGhzH2reZ9DFeay5st4XJ';" >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  # Create a database user called "weblate"
  # sudo -u postgres createuser -D -P weblate
  #sudo -u postgres createuser -D -P w4t_trans
  sudo -i -u postgres psql -c "CREATE USER w4t_trans WITH PASSWORD 'wolf9653';" >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  # Create the database "weblate" owned by "weblate"
  # sudo -u postgres createdb -O weblate weblate
  sudo -u postgres createdb -O w4t_trans w4t_trans_db >> $PROGRAMS_INSTALL_LOG_FILES 2>&1

  cp /usr/local/lib/python3.7/dist-packages/weblate/settings_example.py /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/SITE_DOMAIN = \"\"/SITE_DOMAIN = \"translate.arbajnok.hu\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/# (\"Your Name\", \"your_email@example.com\"),/(\"W4T_admin\", \"farkasg.zoltan@gmail.com\"),/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/\"NAME\": \"weblate\",/\"NAME\": \"w4t_trans_db\",/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/\"USER\": \"weblate\",/\"USER\": \"w4t_trans\",/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/\"PASSWORD\": \"\",/\"PASSWORD\": \"wolf9653\",/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/DATA_DIR = os.path.join(BASE_DIR, \"data\")/DATA_DIR = os.environ.get(\"WEBLATE_DATA_DIR\", \"/app/data\")/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/TIME_ZONE = \"UTC\"/TIME_ZONE = \"Europe/Budapest\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/LANGUAGE_CODE = \"en-us\"/LANGUAGE_CODE = \"hu\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/SECRET_KEY = \"\"/SECRET_KEY = \"jm8fqjlg+5\!#xu%e-oh#7\!$aa7\!6avf7ud*_v=chdrb9qdco6(\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/REGISTRATION_OPEN = True/REGISTRATION_OPEN = False/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/REQUIRE_LOGIN = False/REQUIRE_LOGIN = True/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/#     \"weblate.machinery.microsoft.MicrosoftCognitiveTranslation\",/\"weblate.machinery.microsoft.MicrosoftCognitiveTranslation\",/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/#     \"weblate.machinery.yandex.YandexTranslation\",/\"weblate.machinery.yandex.YandexTranslation\",/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/MT_MICROSOFT_COGNITIVE_KEY = None/MT_MICROSOFT_COGNITIVE_KEY = \"966f1527503540eb85bdec518bfa5028\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/MT_YANDEX_KEY = None/MT_YANDEX_KEY = \"966f1527503540eb85bdec518bfa5028\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/SITE_TITLE = \"Weblate\"/SITE_TITLE = \"W4T\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/ENABLE_HTTPS = False/ENABLE_HTTPS = True/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/SERVER_EMAIL = \"noreply@example.com\"/SERVER_EMAIL = \"w4t.trans@gmail.com\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/DEFAULT_FROM_EMAIL = \"noreply@example.com\"/DEFAULT_FROM_EMAIL = \"w4t.trans@gmail.com\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/\"PASSWORD\": None,/\"PASSWORD\": \"RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE\",/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  sed -i "s/CELERY_BROKER_URL = \"redis:\/\/localhost:6379\"/CELERY_BROKER_URL = \"redis:\/\/:RBOJ8cCNoGCKhlEBwQLHri1g+atWgn5Xn4HwNVbtzOVxAYxkiYBi7aufl8MILv1nxBqR4L9NNzI0X6cE@localhost:6379\/1\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py
  #sed -i "s/\"admin.E408\"/# Ignore known warnings from Weblate server\n    # weblate.I028 is to configure backups but we do manuals which include more things\n    # security.W005 is SECURE_HSTS_INCLUDE_SUBDOMAINS which is set by Weblate to False for now (fixed after 4.1.1)\n    \"admin.E408,weblate.I028\"/g" /usr/local/lib/python3.7/dist-packages/weblate/settings.py


	cat > /etc/nginx/sites-available/weblate.vhost <<EOF;
#server {
#    listen 8080 default_server;
#    server_tokens off;
#    return 301 https://$host$request_uri;
#}

server {
#    listen 8080 default_server;
     listen 80;
     server_name translate.arbajnok.hu;
#    listen 4443 ssl;

#    ssl_certificate /app/data/ssl/fullchain.pem;
#    ssl_certificate_key /app/data/ssl/privkey.pem;

#    ssl_session_timeout 1d;
#    ssl_session_cache shared:MozSSL:10m;  # about 40000 sessions
#    ssl_session_tickets off;

    # intermediate configuration from https://ssl-config.mozilla.org/
#    ssl_protocols TLSv1.2 TLSv1.3;
#    ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384;
#    ssl_prefer_server_ciphers off;

#    ssl_dhparam /etc/nginx/ffdhe2048.pem;

    root /app/data/static;
    client_max_body_size 100M;
    server_tokens off;
    location ~ ^/favicon.ico$ {
        # DATA_DIR/static/favicon.ico
        alias /app/data/static/favicon.ico;
        expires 30d;
    }

    location ~ ^/robots.txt$ {
        # DATA_DIR/static/robots.txt
        alias /app/data/static/robots.txt;
        expires 30d;
    }

    location ${WEBLATE_URL_PREFIX}/static/ {
        # DATA_DIR/static/
        alias /app/data/static/;
        expires 30d;
    }

    location ${WEBLATE_URL_PREFIX}/media/ {
        # DATA_DIR/media/
        alias /app/data/media/;
        expires 30d;
    }

    location / {
        include uwsgi_params;
        # Needed for long running operations in admin interface
        uwsgi_read_timeout 3600;
        # Adjust based to uwsgi configuration:
        uwsgi_pass unix:///run/uwsgi/app/weblate/socket;
    }
}
EOF

  mkdir -p /etc/nginx/sites-enabled
  ln -s /etc/nginx/sites-available/weblate.vhost /etc/nginx/sites-enabled/weblate.vhost


  weblate migrate
  weblate createadmin --password acqEYDw#$GqGL --username admin
  #weblate createadmin --password acqEYDw#$GqGL --username admin --update
  weblate collectstatic
  weblate compress


  #python2 telepítve lett majd javítani kell!!!
  #sed -i "s/python -m.*/python3 -m celery multi \$1 \\\/g" /usr/local/lib/python3.7/dist-packages/weblate/examples/celery
  sed -i "s/python -m celery multi \$1 \\\/python3 -m celery multi \$1 \\\/g" /usr/local/lib/python3.7/dist-packages/weblate/examples/celery

	cat > /etc/systemd/system/celery-weblate.service <<EOF;
[Unit]
Description=Celery Service (Weblate)
After=network.target

[Service]
Type=forking
User=weblate
Group=weblate
EnvironmentFile=/etc/default/celery-weblate
#WorkingDirectory=/home/weblate
WorkingDirectory=/usr/local/lib/python3.7/dist-packages/weblate
RuntimeDirectory=celery
RuntimeDirectoryPreserve=restart
LogsDirectory=celery
ExecStart=/bin/sh -c '\${CELERY_BIN} multi start \${CELERYD_NODES} \
  -A \${CELERY_APP} --pidfile=\${CELERYD_PID_FILE} \
  --logfile=\${CELERYD_LOG_FILE} --loglevel=\${CELERYD_LOG_LEVEL} \${CELERYD_OPTS}'
ExecStop=/bin/sh -c '\${CELERY_BIN} multi stopwait \${CELERYD_NODES} \
  --pidfile=${CELERYD_PID_FILE}'
ExecReload=/bin/sh -c '\${CELERY_BIN} multi restart \${CELERYD_NODES} \
  -A \${CELERY_APP} --pidfile=\${CELERYD_PID_FILE} \
  --logfile=\${CELERYD_LOG_FILE} --loglevel=\${CEYD_LOG_LEVEL} \${CELERYD_OPTS}'

[Install]
WantedBy=multi-user.target
EOF

	cat > /etc/default/celery-weblate <<EOF;
# Name of nodes to start
CELERYD_NODES="celery notify memory backup translate"

# Absolute or relative path to the 'celery' command:
#CELERY_BIN="/home/weblate/weblate-env/bin/celery"
CELERY_BIN="/usr/local/lib/python3.7/dist-packages/weblate/examples/celery"

# App instance to use
# comment out this line if you don't use an app
CELERY_APP="weblate.utils"

# Extra command-line arguments to the worker,
# increase concurency if you get weblate.E019
CELERYD_OPTS="--beat:celery --queues:celery=celery --prefetch-multiplier:celery=4 \
    --queues:notify=notify --prefetch-multiplier:notify=10 \
    --queues:memory=memory --prefetch-multiplier:memory=10 \
    --queues:translate=translate --prefetch-multiplier:translate=4 \
    --concurrency:backup=1 --queues:backup=backup  --prefetch-multiplier:backup=2"

# Logging configuration
# - %n will be replaced with the first part of the nodename.
# - %I will be replaced with the current child process index
#   and is important when using the prefork pool to avoid race conditions.
CELERYD_PID_FILE="/run/celery/weblate-%n.pid"
CELERYD_LOG_FILE="/var/log/celery/weblate-%n%I.log"
CELERYD_LOG_LEVEL="INFO"

# Internal Weblate variable to indicate we're running inside Celery
CELERY_WORKER_RUNNING="1"
EOF

	cat > /etc/default/celery-weblate <<EOF;
/var/log/celery/*.log {
        weekly
        missingok
        rotate 12
        compress
        notifempty
}
EOF


  /usr/local/lib/python3.7/dist-packages/weblate/examples/celery start


  echo -e "[${green}DONE${NC}]\n"





  if [ "$CFG_WEBLATE_VERSION" == "Git master" ]; then
	echo -n -e "$IDENTATION_LVL_1 Download weblate git source..."
	git_clone https://github.com/WeblateOrg/weblate $PROGRAMS_INSTALL_DOWNLOAD/weblate
	cd $PROGRAMS_INSTALL_DOWNLOAD/weblate 
	git submodule update --init --recursive
  else
	echo -n -e "$IDENTATION_LVL_1 Download weblate offical stable source..."
	  && python3 -m pip install --upgrade pip \
  	  && python3 -m pip install "Weblate[all,MySQL]==$VERSION" -r /usr/src/weblate/requirements.txt \
	  && python3 -c 'from phply.phpparse import make_parser; make_parser()' \
  	  && ln -s /usr/local/share/weblate/examples/ /app/ \
  	  && apt-get -y purge
  fi

  echo -n -e "$IDENTATION_LVL_1 Installing packages..."
# Apply hotfixes on Weblate
#RUN find /usr/src/weblate -name '*.patch' -print0 | sort -z | \
#  xargs -n1 -0 -r patch -p1 -d /usr/local/lib/python3.7/dist-packages/ -i
  echo -e "[${green}DONE${NC}]\n"

  MeasureTimeDuration $START_TIME
}
