# Function: fixPhpIniOpenSslCa
#   Fix OpenSSL CA configuration in all PHP ini files
fixPhpIniOpenSslCa() {
    for INI in /etc/php/*/*/php.ini; do
        sed -i 's,;openssl.cafile=,openssl.cafile=/etc/ssl/certs/ca-certificates.crt,' "${INI}"
    done
}

# Function: configureApacheForRoundcube
#   Add Roundcube directory configuration to Apache
configureApacheForRoundcube() {
    echo "
<Directory /var/lib/roundcube>
    Require all granted
</Directory>
" >> /etc/apache2/sites-available/ispconfig.conf
}

# Function: InstallFix
#   Perform post-installation fixes
InstallFix() {
    # Fix Amavis configuration if antispam is enabled
    if [ "$CFG_ANTISPAM" == "amavisd" ]; then
	echo -n -e "$IDENTATION_LVL_1 Fix Amavis configuration if antispam is enabled... "
        MYNET=$(grep "mynetworks =" /etc/postfix/main.cf | sed 's/mynetworks = //')
        echo "@mynetworks = qw( $MYNET );" >> /etc/amavis/conf.d/20-debian_defaults

        # Restart Amavis service
        if systemctl is-active --quiet amavisd-new; then
            echo -n "Restarting Amavisd-new... "
            systemctl restart amavisd-new
        else
            echo -n "Restarting Amavis... "
            systemctl restart amavis
        fi
        echo -e "[${green}DONE${NC}]"
    fi
  
    # Configure Roundcube if webmail is enabled
    if [ "$CFG_WEBMAIL" == "roundcube" ]; then
	echo -n -e "$IDENTATION_LVL_1 Configure Roundcube if webmail is enabled... "
	if [ "$CFG_SQLSERVER" == "MariaDB" ]; then
	    SQL_COMMAND="mariadb"
	else
	    SQL_COMMAND="mysql"
	fi
		
	# Insert Roundcube remote user into ISPConfig database
	$SQL_COMMAND -uroot -p$CFG_MYSQL_ROOT_PWD dbispconfig -e "INSERT INTO remote_user (remote_userid, sys_userid, sys_groupid, sys_perm_user, sys_perm_group, sys_perm_other, remote_username, remote_password, remote_functions) VALUES (1, 1, 1, 'riud', 'riud', '', 'roundcube', MD5('$CFG_ROUNDCUBE_PWD'), 'server_get,get_function_list,client_templates_get_all,server_get_serverid_by_ip,server_ip_get,server_ip_add,server_ip_update,server_ip_delete;client_get_all,client_get,client_add,client_update,client_delete,client_get_sites_by_user,client_get_by_username,client_change_password,client_get_id,client_delete_everything;mail_user_get,mail_user_add,mail_user_update,mail_user_delete;mail_alias_get,mail_alias_add,mail_alias_update,mail_alias_delete;mail_spamfilter_user_get,mail_spamfilter_user_add,mail_spamfilter_user_update,mail_spamfilter_user_delete;mail_policy_get,mail_policy_add,mail_policy_update,mail_policy_delete;mail_fetchmail_get,mail_fetchmail_add,mail_fetchmail_update,mail_fetchmail_delete;mail_spamfilter_whitelist_get,mail_spamfilter_whitelist_add,mail_spamfilter_whitelist_update,mail_spamfilter_whitelist_delete;mail_spamfilter_blacklist_get,mail_spamfilter_blacklist_add,mail_spamfilter_blacklist_update,mail_spamfilter_blacklist_delete;mail_user_filter_get,mail_user_filter_add,mail_user_filter_update,mail_user_filter_delete');"
	
        # Link ISPConfig SSL certificate and update CA certificates
        ln -s /usr/local/ispconfig/interface/ssl/ispserver.crt /usr/local/share/ca-certificates/ispserver.crt
        update-ca-certificates > /dev/null 2>&1

        # Fix OpenSSL CA configuration in PHP ini files
        fixPhpIniOpenSslCa	
	
        # Reload web server and PHP-FPM based on the configured web server
        if [ "$CFG_WEBSERVER" == "apache" ]; then
            sed -i 's/;openssl.cafile=/openssl.cafile=\/etc\/ssl\/certs\/ca-certificates.crt/' /etc/php/8.2/apache2/php.ini
            configureApacheForRoundcube
            systemctl reload apache2
            systemctl reload php8.2-fpm
        elif [ "$CFG_WEBSERVER" == "nginx" ]; then
            sed -i 's/;openssl.cafile=/openssl.cafile=\/etc\/ssl\/certs\/ca-certificates.crt/' /etc/php/8.2/fpm/php.ini
            systemctl reload nginx
            systemctl reload php8.2-fpm
        fi
        echo -e "[${green}DONE${NC}]"
    fi
}
