#---------------------------------------------------------------------
# Function: InstallISPConfig
#    Start the ISPConfig3 installation script
#---------------------------------------------------------------------
InstallISPConfig() {
    local START_TIME=$SECONDS
    echo -e "$IDENTATION_LVL_0 ${BWhite}Installing ISPConfig${NC}"

    if [ "$CFG_ISPCVERSION" == "Git stable" ]; then
  	echo -n -e "$IDENTATION_LVL_1 Downloading Latest ISPConfig Git Stable (3.2 branch)... "
	wget -q -O $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-stable-git.tar.gz https://ispconfig.org/downloads/ISPConfig-3.2.12p1.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo -e "[${green}DONE${NC}]"
	# Extract the downloaded packagE
	echo -n -e "$IDENTATION_LVL_1 Extracting the downloaded package... "
	cd $PROGRAMS_INSTALL_DOWNLOAD
	tar xfz $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-*.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	AUTO_INSTALL_INI_LOCATION=$PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_install/install
	cd $AUTO_INSTALL_INI_LOCATION
	echo -e "[${green}DONE${NC}]"
    else
	echo -n -e "$IDENTATION_LVL_1 Download Latest ISPConfig git... "
	wget -q -O $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-develop-git.tar.gz https://git.ispconfig.org/ispconfig/ispconfig3/-/archive/develop/ispconfig3-develop.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	echo -e "[${green}DONE${NC}]"
        # Extract the downloaded package
        echo -n -e "$IDENTATION_LVL_1 Extracting the downloaded package... "
	cd $PROGRAMS_INSTALL_DOWNLOAD
	tar xfz $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-*.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
	AUTO_INSTALL_INI_LOCATION=$PROGRAMS_INSTALL_DOWNLOAD/ispconfig3-develop/install
	cd $AUTO_INSTALL_INI_LOCATION
	echo -e "[${green}DONE${NC}]"
    fi

    # Extract the downloaded package
    echo -n -e "$IDENTATION_LVL_1 Extracting the downloaded package... "
    cd $PROGRAMS_INSTALL_DOWNLOAD
    tar xfz $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-*.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
    AUTO_INSTALL_INI_LOCATION=$PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_install/install
    cd $AUTO_INSTALL_INI_LOCATION
    echo -e "[${green}DONE${NC}]"    # Extract the downloaded package
    echo -n -e "$IDENTATION_LVL_1 Extracting the downloaded package... "
    cd $PROGRAMS_INSTALL_DOWNLOAD
    tar xfz $PROGRAMS_INSTALL_DOWNLOAD/ISPConfig-*.tar.gz >>$PROGRAMS_INSTALL_LOG_FILES 2>&1
    AUTO_INSTALL_INI_LOCATION=$PROGRAMS_INSTALL_DOWNLOAD/ispconfig3_install/install
    cd $AUTO_INSTALL_INI_LOCATION
    echo -e "[${green}DONE${NC}]"

    CFG_MYSQL_ISPCONFIG_PWD=$(tr </dev/urandom -dc 'A-Za-z0-9' | head -c${1:-29})

    if [ "$CFG_SQLSERVER" == "MariaDB" ]; then
	SQL_COMMAND="mariadb"
    else
	SQL_COMMAND="mysql"
    fi
    $SQL_COMMAND -uroot -p"$CFG_MYSQL_ROOT_PWD" -e "CREATE USER 'ispconfig'@'localhost' IDENTIFIED BY '$CFG_MYSQL_ISPCONFIG_PWD';"
    $SQL_COMMAND -uroot -p"$CFG_MYSQL_ROOT_PWD" -e "GRANT ALL PRIVILEGES ON *.* TO 'ispconfig'@'localhost' WITH GRANT OPTION;"
    $SQL_COMMAND -uroot -p"$CFG_MYSQL_ROOT_PWD" -e "ALTER USER 'ispconfig'@'localhost' IDENTIFIED VIA mysql_native_password USING PASSWORD($CFG_MYSQL_ISPCONFIG_PWD);"
    $SQL_COMMAND -uroot -p"$CFG_MYSQL_ROOT_PWD" -e "flush privileges;"

    if [ "$CFG_ISPC" == "standard" ]; then
	echo -n -e "$IDENTATION_LVL_1 Creating autoinstall configuration file... "
	cat <<EOF > $AUTO_INSTALL_INI_LOCATION/autoinstall.ini
[install]
language=en
install_mode=$CFG_ISPC
hostname=$CFG_HOSTNAME_FQDN
mysql_hostname=localhost
mysql_root_user=root
mysql_root_password=$CFG_MYSQL_ROOT_PWD
mysql_database=dbispconfig
mysql_port=3306
mysql_charset=utf8
http_server=$CFG_WEBSERVER
ispconfig_port=$CFG_ISPONCFIG_PORT
ispconfig_use_ssl=n
ispconfig_admin_password=$CFG_ISPONCFIG_ADMIN_PASS

[ssl_cert]
ssl_cert_country=$SSL_COUNTRY
ssl_cert_state=$SSL_STATE
ssl_cert_locality=$SSL_LOCALITY
ssl_cert_organisation=$SSL_ORGANIZATION
ssl_cert_organisation_unit=$SSL_ORGUNIT
ssl_cert_common_name=$CFG_HOSTNAME_FQDN

[expert]
mysql_ispconfig_user=ispconfig
mysql_ispconfig_password=afStEratXBsgatRtsa42CadwhQ
join_multiserver_setup=$MULTISERVER
mysql_master_hostname=$CFG_MASTER_FQDN
mysql_master_root_user=root
mysql_master_root_password=$CFG_MYSQL_ROOT_PWD
mysql_master_database=dbispconfig
configure_mail=$CFG_SETUP_MAIL
configure_jailkit=$([ "$CFG_SETUP_WEB" == "yes" ] && echo "$CFG_JKIT" || echo "n")
configure_ftp=$CFG_SETUP_WEB
configure_dns=$CFG_SETUP_NS
configure_apache=$CFG_APACHE
configure_nginx=$CFG_NGINX
configure_firewall=y
install_ispconfig_web_interface=$CFG_SETUP_MASTER

[update]
do_backup=yes
mysql_root_password=$CFG_MYSQL_ROOT_PWD
mysql_master_hostname=$CFG_MASTER_FQDN
mysql_master_root_user=root
mysql_master_root_password=$CFG_MYSQL_ROOT_PWD
mysql_master_database=dbispconfig
reconfigure_permissions_in_master_database=no
reconfigure_services=yes
ispconfig_port=$CFG_ISPONCFIG_PORT
create_new_ispconfig_ssl_cert=no
reconfigure_crontab=yes
EOF

	echo -n -e "$IDENTATION_LVL_1 Starting ISPConfig installation..."
	php8.2 -q install.php --autoinstall=autoinstall.ini
    else
	php8.2 -q install.php
    fi

    # Update Nginx configuration
    if [ "$CFG_WEBSERVER" == "nginx" ]; then
	echo -e "$IDENTATION_LVL_1 Updating Nginx configuration..."
	sed -i "s/listen 8081 ;/listen $CFG_ISPONCFIG_APPS_PORT;/g" /etc/nginx/sites-available/apps.vhost
	sed -i "s/listen \[::\]:8081 ipv6only=on;/listen \[::\]:$CFG_ISPONCFIG_APPS_PORT ipv6only=on;/g" /etc/nginx/sites-available/apps.vhost
	sed -i "s/listen $CFG_ISPONCFIG_PORT;/listen $CFG_ISPONCFIG_PORT ssl http2;/g" /etc/nginx/sites-available/ispconfig.vhost
	sed -i "s/listen \[::\]:$CFG_ISPONCFIG_PORT ipv6only=on;/listen \[::\]:$CFG_ISPONCFIG_PORT ssl ipv6only=on http2;/g" /etc/nginx/sites-available/ispconfig.vhost
	sed "/ssl on;/d" /etc/nginx/sites-available/ispconfig.vhost
    fi

    # Log ISPConfig configuration
    echo -e "$IDENTATION_LVL_1 Logging ISPConfig configuration..."
    cat >> /home/$SUDO_USER/wtlinux_server_setup/wtserver_configuration.txt <<EOF
# Ispconfig3 config
#------------------------------
Ispconfig3 Admin   		: admin
Ispconfig3 Password   		: $CFG_ISPONCFIG_ADMIN_PASS

Ispconfig3 database user	: ispconfig
Ispconfig3 database user passw	: $CFG_MYSQL_ISPCONFIG_PWD
Ispconfig3 ip			: $IP_ADDRESS
Ispconfig3 port			: $CFG_ISPONCFIG_PORT
Ispconfig3 app_port		: $CFG_ISPONCFIG_APPS_PORT
#------------------------------
EOF

    systemctl stop nginx

    if [ "$CFG_SSL_NEW" == "yes" ]; then
	sh /root/.acme.sh/acme.sh --issue --standalone -d server1.$CFG_HOSTNAME_DOMAIN --force >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    else
	cp -av /home/$SUDO_USER/wtlinux_server_setup/acme_ssl/$CFG_HOSTNAME_DOMAIN/server1.$CFG_HOSTNAME_DOMAIN /home/$SUDO_USER/.acme.sh/ >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
    fi

    ln -sf /home/$SUDO_USER/.acme.sh/server1.$CFG_HOSTNAME_DOMAIN/server1.$CFG_HOSTNAME_DOMAIN.cer /usr/local/ispconfig/interface/ssl/ispserver.crt
    ln -sf /home/$SUDO_USER/.acme.sh/server1.$CFG_HOSTNAME_DOMAIN/server1.$CFG_HOSTNAME_DOMAIN.key /usr/local/ispconfig/interface/ssl/ispserver.key

    if [ $CFG_SETUP_WEB == "yes" ]; then
	if [ "$CFG_WEBSERVER" == "nginx" ]; then
            echo -n "Restarting nginx... "
	    service nginx restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	elif [ "$CFG_WEBSERVER" == "apache" ]; then
            echo -n "Restarting Apache... "
	    service apache2 restart >> $PROGRAMS_INSTALL_LOG_FILES 2>&1
	fi
	echo -e "[${green}DONE${NC}]"
    fi
}
