#pragma once

#include "ofImage.h"
#include "ofPixels.h"
#include "ofTexture.h"
#include "BaseEngine.h"
#include "BaseTheme.h"

namespace ofxImGui
{
	class Gui
	{
	public:
		Gui();
		~Gui();

		void setup(BaseTheme* theme = nullptr, bool autoDraw = true);
		void exit();

		void begin();
		void end();

		void draw();

		void setImGuiWindowColor(ofColor & color, float alpha);
		void setInputTextFontColor(ofColor & color, float alpha);
		void setInputTextBackgroundColor(ofColor & color, float alpha);
		void pushInputTextDimension(float startCursorPosX, float fontSize, float inputTextWidth, float inputTextHeight);
		void popInputTextDimension();

		void setTheme(BaseTheme* theme);
		void setDefaultTheme();
		void openThemeColorWindow();

		GLuint loadImage(ofImage& image);
		GLuint loadImage(const std::string& imagePath);

		GLuint loadPixels(const std::string& imagePath);
		GLuint loadPixels(ofPixels& pixels);

		GLuint loadTexture(const std::string& imagePath);
		GLuint loadTexture(ofTexture& texture, const std::string& imagePath);

	private:
		BaseEngine* engine;

		float lastTime;
		bool autoDraw;

		BaseTheme* theme;

		std::vector<ofTexture*> loadedTextures;
	};
}
