#pragma once

#include "ofConstants.h"
#include "GL/glut.h"

#if !defined(TARGET_OPENGLES) && !defined(OF_TARGET_API_VULKAN) && defined(FORCE_APPGLUT)

#include "BaseEngine.h"

#include "ofAppGlutWindow.h"
#include "ofEvents.h"
#include "imgui.h"

// About GLSL version:
// The 'glsl_version' initialization parameter defaults to "#version 150" if NULL.
// Only override if your GL version doesn't handle this GLSL version. Keep NULL if unsure!+

namespace ofxImGui
{
	class EngineGLUT
		: public BaseEngine
	{
	public:
		~EngineGLUT()
		{
			exit();
		}

		// BaseEngine required
		void setup(bool autoDraw, const char* glsl_version = NULL) override;
		void exit() override;
		bool createDeviceObjects() override;
		void invalidateDeviceObjects() override;

		void draw() override;

		void onKeyReleased(ofKeyEventArgs& event) override;
		void onKeyPressed(ofKeyEventArgs& event) override;
		void onMousePressed(ofMouseEventArgs& event) override;
		void onMouseReleased(ofMouseEventArgs& event) override;

		// Custom
		static void fixedDrawData(ImDrawData * draw_data);

		static GLuint g_FontTexture;
	};
}

#endif
