#pragma once

#include "ofMain.h"
#include "ofxImGui.h"
#include "MyTheme.h"
#include "mydefines.h"
#include "imgui_user.h"

class ofApp : public ofBaseApp{
public:
    void setup();
    void update();
    void draw();
    
    void keyPressed(int key);
    void keyReleased(int key);
    void mouseMoved(int x, int y);
    void mouseDragged(int x, int y, int button);
    void mousePressed(int x, int y, int button);
    void mouseReleased(int x, int y, int button);
    void windowResized(int w, int h);
    void dragEvent(ofDragInfo dragInfo);
    void gotMessage(ofMessage msg);
    void mouseScrolled(float x, float y);

    void ShowExampleAppMainMenuBar();
    
    ofxImGui::Gui gui;
    ImVec4 backgroundColor;

    ImVec2 gMainMenuBarSize;

    ofTexture textureSource;
    GLuint myImageTextureId2;

#ifndef NO_IMGUIVARIOUSCONTROLS
    static    bool MyTreeViewNodeDrawIconCallback(ImGui::TreeViewNode* n, ImGui::TreeView& /*tv*/, void* /*userPtr*/);
    static    void MyTreeViewNodeCreationDelationCallback(ImGui::TreeViewNode* n, ImGui::TreeView&,bool delation,void* );
#endif //NO_IMGUIVARIOUSCONTROLS

#ifndef NO_IMGUILISTVIEW
    inline void MyTestListView();
#endif //NO_IMGUILISTVIEW

#ifdef YES_IMGUISQLITE3
    static void PerformCppSQLiteTest(ImGuiTextBuffer &rv, int nRowsToCreate=50000);
#endif //YES_IMGUISQLITE3

    
};
