#include "ofMain.h"
#include "ofApp.h"
//#if (OF_VERSION_MINOR != 9) && defined(TARGET_OPENGLES)
//#include "ofGLProgrammableRenderer.h"
//#endif

#define FORCE_PROGRAMMMABLE 1
//#define FORCE_APPGLFW 1
//#define FORCE_APPGLUT 1

#ifdef FORCE_PROGRAMMMABLE
#include "ofGLProgrammableRenderer.h"
#endif

#ifdef FORCE_APPGLFW
#include "ofAppGLFWWindow.h"
#endif

#ifdef FORCE_APPGLUT
#include "ofAppGlutWindow.h"
#endif

int main()
{
    ofSetLogLevel(OF_LOG_VERBOSE);
#if defined(TARGET_OPENGLES)
    #if (OF_VERSION_MINOR == 9)
        ofGLESWindowSettings settings;
        settings.currentW = 1280;
        settings.currentH = 720;
        settings.setGLESVersion(2);
        ofCreateWindow(settings);
    #else
        ofSetLogLevel("ofThread", OF_LOG_ERROR);
        ofSetCurrentRenderer(ofGLProgrammableRenderer::TYPE);
        ofSetupOpenGL(1280, 720, OF_WINDOW);
    #endif
#elif FORCE_PROGRAMMMABLE
    ofGLWindowSettings glWindowSettings;
    glWindowSettings.setSize(1280, 720);
    glWindowSettings.setGLVersion(3, 2);
    ofCreateWindow(glWindowSettings);
#elif FORCE_APPGLFW
#define USE_GLFW_CLIPBOARD
    ofGLFWWindowSettings settings;
//  #ifdef NANOVG_GL2_IMPLEMENTATION
//  	settings.setGLVersion(2, 1);  // Fixed pipeline
//  #endif
//  #ifdef NANOVG_GL3_IMPLEMENTATION
        settings.setGLVersion(3, 2);  // Programmable pipeline >> you need to define GL_VERSION_3 in you pre-processor macros!
//  #endif
        settings.stencilBits = 0;
        settings.setSize(1280, 720);
        settings.currentW = 1280;
        settings.currentH = 720;
        ofCreateWindow(settings);
#elif FORCE_APPGLUT
    ofAppGlutWindow window;
    ofSetupOpenGL(&window,1280,720,OF_WINDOW); 
#else
    ofSetLogLevel("ofThread", OF_LOG_ERROR);
    ofSetupOpenGL(1280, 720, OF_WINDOW);
#endif

    ofRunApp( new ofApp());
}
