#include "ofMain.h"
#include "ofApp.h"
#if (OF_VERSION_MINOR != 9) && defined(TARGET_OPENGLES)
#include "ofGLProgrammableRenderer.h"
#endif

//#define FORCE_PROGRAMMMABLE 1
//#define FORCE_APPGLFW 1
//#define FORCE_APPGLUT 1
#define FORCE_NOAPP 1

#ifdef FORCE_PROGRAMMMABLE
#include "ofGLProgrammableRenderer.h"
#endif

#ifdef FORCE_APPGLFW
#include "ofAppGLFWWindow.h"
#endif

#ifdef FORCE_APPGLUT
#include "ofAppGlutWindow.h"
#endif

#ifdef FORCE_NOAPP
#include "ofAppNoWindow.h"
#endif


int main()
{
    ofSetLogLevel(OF_LOG_VERBOSE);
#if defined(TARGET_OPENGLES)
    #if (OF_VERSION_MINOR == 9)
        ofGLESWindowSettings settings;
        settings.setSize(1280, 720);
        settings.setGLESVersion(2);
        ofCreateWindow(settings);
	ofRunApp( new ofApp());
    #else
        ofSetLogLevel("ofThread", OF_LOG_ERROR);
        ofSetCurrentRenderer(ofGLProgrammableRenderer::TYPE);
        ofSetupOpenGL(1280, 720, OF_WINDOW);
	ofRunApp( new ofApp());
    #endif
#elif FORCE_PROGRAMMMABLE
    ofGLWindowSettings glWindowSettings;
    glWindowSettings.setSize(1280, 720);

    glWindowSettings.setGLVersion(3, 2);
    //glWindowSettings.setGLVersion(2, 1);
    ofGLSLVersionFromGL(1,50);
    //glWindowSettings.setGLVersion(2, 1);
    ofCreateWindow(glWindowSettings);
    ofRunApp( new ofApp());
#elif FORCE_APPGLFW
#define USE_GLFW_CLIPBOARD
    ofGLFWWindowSettings settings;
//  #ifdef NANOVG_GL2_IMPLEMENTATION
//  	settings.setGLVersion(2, 1);  // Fixed pipeline
//  #endif
//  #ifdef NANOVG_GL3_IMPLEMENTATION
        settings.setGLVersion(3, 2);  // Programmable pipeline >> you need to define GL_VERSION_3 in you pre-processor macros!
        //settings.setGLVersion(2, 1);  // Programmable pipeline >> you need to define GL_VERSION_3 in you pre-processor macros!
//  #endif
        //settings.stencilBits = 0;
        settings.setSize(1280, 720);
	//settings.setPosition(ofVec2f(300,0));
	//settings.resizable = true;
	//shared_ptr<ofAppBaseWindow> mainWindow = ofCreateWindow(settings);
	//mainWindow->setVerticalSync(false);
	ofGLSLVersionFromGL(1,50);
	ofCreateWindow(settings);
	ofRunApp( new ofApp());
#elif FORCE_APPGLUT
    ofAppGlutWindow window;
    ofSetupOpenGL(&window,1280,720,OF_WINDOW);
    ofRunApp( new ofApp());
#elif FORCE_NOAPP
    auto window = make_shared<ofAppNoWindow>();
    auto app = make_shared<ofApp>();
    ofRunApp(window, app);
    ofRunMainLoop();

    //ofGLFWWindowSettings settings;
    //settings.visible = false;
    //ofCreateWindow(settings);
    // this kicks off the running of my app
    // can be OF_WINDOW or OF_FULLSCREEN
    // pass in width and height too:
    //ofAppNoWindow window;
    //ofSetupOpenGL(&window, 1024, 768, OF_WINDOW);
#else
    ofSetLogLevel("ofThread", OF_LOG_ERROR);
    ofSetupOpenGL(1280, 720, OF_WINDOW);
    ofRunApp( new ofApp());
#endif

}
