//-----------------------------------------------------------------------------
// COMPILE-TIME OPTIONS FOR DEAR IMGUI
// Runtime options (clipboard callbacks, enabling various features, etc.) can generally be set via the ImGuiIO structure.
// You can use ImGui::SetAllocatorFunctions() before calling ImGui::CreateContext() to rewire memory allocation functions.
//-----------------------------------------------------------------------------
// A) You may edit imconfig.h (and not overwrite it when updating imgui, or maintain a patch/branch with your modifications to imconfig.h)
// B) or add configuration directives in your own file and compile with #define IMGUI_USER_CONFIG "myfilename.h" 
// If you do so you need to make sure that configuration settings are defined consistently _everywhere_ dear imgui is used, which include
// the imgui*.cpp files but also _any_ of your code that uses imgui. This is because some compile-time options have an affect on data structures.
// Defining those options in imconfig.h will ensure every compilation unit gets to see the same data structure layouts.
// Call IMGUI_CHECKVERSION() from your .cpp files to verify that the data structures your files are using are matching the ones imgui.cpp is using.
//-----------------------------------------------------------------------------

#pragma once

//---- Define assertion handler. Defaults to calling assert().
//#define IM_ASSERT(_EXPR)  MyAssert(_EXPR)
//#define IM_ASSERT(_EXPR)  ((void)(_EXPR))     // Disable asserts

//---- Define attributes of all API symbols declarations, e.g. for DLL under Windows.
//#define IMGUI_API __declspec( dllexport )
//#define IMGUI_API __declspec( dllimport )

//---- Don't define obsolete functions/enums names. Consider enabling from time to time after updating to avoid using soon-to-be obsolete function/names.
//#define IMGUI_DISABLE_OBSOLETE_FUNCTIONS

//---- Don't implement demo windows functionality (ShowDemoWindow()/ShowStyleEditor()/ShowUserGuide() methods will be empty)
//---- It is very strongly recommended to NOT disable the demo windows during development. Please read the comments in imgui_demo.cpp.
//#define IMGUI_DISABLE_DEMO_WINDOWS

//---- Don't implement some functions to reduce linkage requirements.
//#define IMGUI_DISABLE_WIN32_DEFAULT_CLIPBOARD_FUNCTIONS   // [Win32] Don't implement default clipboard handler. Won't use and link with OpenClipboard/GetClipboardData/CloseClipboard etc.
//#define IMGUI_DISABLE_WIN32_DEFAULT_IME_FUNCTIONS         // [Win32] Don't implement default IME handler. Won't use and link with ImmGetContext/ImmSetCompositionWindow.
//#define IMGUI_DISABLE_FORMAT_STRING_FUNCTIONS             // Don't implement ImFormatString/ImFormatStringV so you can implement them yourself if you don't want to link with vsnprintf.      
//#define IMGUI_DISABLE_MATH_FUNCTIONS                      // Don't implement ImFabs/ImSqrt/ImPow/ImFmod/ImCos/ImSin/ImAcos/ImAtan2 wrapper so you can implement them yourself. Declare your prototypes in imconfig.h.
//#define IMGUI_DISABLE_DEFAULT_ALLOCATORS                  // Don't implement default allocators calling malloc()/free(). You will need to call ImGui::SetAllocatorFunctions().

//---- Include imgui_user.h at the end of imgui.h as a convenience
#define IMGUI_INCLUDE_IMGUI_USER_H

//---- Pack colors to BGRA8 instead of RGBA8 (if you needed to convert from one to another anyway)
//#define IMGUI_USE_BGRA_PACKED_COLOR

//---- Avoid multiple STB libraries implementations, or redefine path/filenames to prioritize another version
// By default the embedded implementations are declared static and not available outside of imgui cpp files.
//#define IMGUI_STB_TRUETYPE_FILENAME   "my_folder/stb_truetype.h"
//#define IMGUI_STB_RECT_PACK_FILENAME  "my_folder/stb_rect_pack.h"
//#define IMGUI_DISABLE_STB_TRUETYPE_IMPLEMENTATION
//#define IMGUI_DISABLE_STB_RECT_PACK_IMPLEMENTATION

//---- Define constructor and implicit cast operators to convert back<>forth from your math types and ImVec2/ImVec4.

#include "ofVectorMath.h"
#include "ofColor.h"

#if OF_VERSION_MINOR >= 10
#define IM_VEC2_CLASS_EXTRA							\
ImVec2(const ofVec2f& f) { x = f.x; y = f.y; }		\
operator ofVec2f() const { return ofVec2f(x, y); }	\
ImVec2(const glm::vec2& f) { x = f.x; y = f.y; }	\
operator glm::vec2() const { return glm::vec2(x, y); }
#else
#define IM_VEC2_CLASS_EXTRA							\
ImVec2(const ofVec2f& f) { x = f.x; y = f.y; }		\
ImVec2(ofVec2f& f) { x = f.x; y = f.y; }			\
operator ofVec2f() const { return ofVec2f(x, y); }
#endif

#if OF_VERSION_MINOR >= 10
#define IM_VEC4_CLASS_EXTRA																													\
ImVec4(const ofVec4f& f) { x = f.x; y = f.y; z = f.z; w = f.w; }																			\
operator ofVec4f() const { return ofVec4f(x,y,z,w); }																						\
ImVec4(const glm::vec4& f) { x = f.x; y = f.y; z = f.z; w = f.w; }																			\
operator glm::vec4() const { return glm::vec4(x,y,z,w); }																					\
ImVec4(const ofColor& color, float alpha) { static const float sc = 1.0f/255.0f; x = color.r*sc; y = color.g*sc; z = color.b*sc; w = alpha; }		\
ImVec4(const ofColor& f) { static const float sc = 1.0f/255.0f; x = f.r*sc; y = f.g*sc; z = f.b*sc; w = f.a*sc; }							\
operator ofColor() const { return ofColor((int) (x*255.0f+0.5f), (int) (y*255.0f+0.5f), (int) (z*255.0f+0.5f), (int) (w*255.0f+0.5f)); }	\
ImVec4(const ofFloatColor& color, float alpha) { x = color.r; y = color.g; z = color.b; w = alpha; }												\
ImVec4(const ofFloatColor& f) { x = f.r; y = f.g; z = f.b; w = f.a; }																		\
operator ofFloatColor() const { return ofFloatColor(x, y, z, w); }
#else
#define IM_VEC4_CLASS_EXTRA																													\
ImVec4(const ofVec4f& f) { x = f.x; y = f.y; z = f.z; w = f.w; }																			\
operator ofVec4f() const { return ofVec4f(x,y,z,w); }																						\
ImVec4(const ofColor& color, float alpha) { static const float sc = 1.0f/255.0f; x = color.r*sc; y = color.g*sc; z = color.b*sc; w = alpha; }		\
ImVec4(const ofColor& f) { static const float sc = 1.0f/255.0f; x = f.r*sc; y = f.g*sc; z = f.b*sc; w = f.a*sc; }							\
operator ofColor() const { return ofColor((int) (x*255.0f+0.5f), (int) (y*255.0f+0.5f), (int) (z*255.0f+0.5f), (int) (w*255.0f+0.5f)); }	\
ImVec4(const ofFloatColor& color, float alpha) { x = color.r; y = color.g; z = color.b; w = alpha; }												\
ImVec4(const ofFloatColor& f) { x = f.r; y = f.g; z = f.b; w = f.a; }																		\
operator ofFloatColor() const { return ofFloatColor(x, y, z, w); }
#endif

//---- Use 32-bit vertex indices (default is 16-bit) to allow meshes with more than 64K vertices. Render function needs to support it.
//#define ImDrawIdx unsigned int
#define ImDrawIdx ofIndexType

//---- Tip: You can add extra functions within the ImGui:: namespace, here or in your own headers files.
//---- Declare helpers or widgets implemented in imgui_user.inl or elsewhere, so end-user doesn't need to include multiple files.
//---- e.g. you can create variants of the ImGui::Value() helper for your low-level math types, or your own widgets/helpers.
/*
namespace ImGui
{
    void    Value(const char* prefix, const MyVec2& v, const char* float_format = NULL);
    void    Value(const char* prefix, const MyVec4& v, const char* float_format = NULL);
}
*/

